#version unofficial MegaPov 0.7;

#declare generate_nappe =0;
#declare use_nappe      =1;

#include "colors.inc"
#include "textures.inc"

#macro WritenappeFile(nomfile, n1, n2, nlng, ks, ht)

	#debug "\nWriting new .cth file\n"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")
	
	#local l1 = nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local st = seed(123);
	#local i=0;
	#while (i<n1)
		#local j=0;
            #while (j<n2)
              #local xr=9*sin(2*pi*j/n2);
              #local yr=9*(sin(2*pi*j/n2)+cos(2*pi*j/n2));
              #local zr=9*cos(2*pi*j/n2);
	      #local tempx = -l1/2 + i*nlng;
              #local tempz = -l2/2 + j*nlng;
              #local tempy = ht;
              #local tmp=<tempx,tempy,tempz>;
              #local tmp=vrotate(tmp,<xr,yr,zr>);
              #write(file, tmp.x, ",", tmp.y, ",", tmp.z, ", 0.0, 0.0, 0.0,\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end

#declare Table =
box{-.5,.5 scale <1,.02,.6>
 rotate 40*y
 translate .8*y
 translate .25*z
}


#if (generate_nappe)
#declare Obstacle2=
object{Table
}


WritenappeFile("i_nappe.cth", 32, 32, .0185, 60, 1.1)
simcloth {
	environment Obstacle2
	friction 0.1
	gravity -.3*y
	internal_collision off
	damping .90
	intervals .03
	iterations 200
	input "i_nappe.cth"
	output "i_nappe.cth"
	mesh_output "i_nappe.msh"
	smooth_mesh on
	uv_mesh on
}
#end

#if (use_nappe)
#declare t_nappe=
texture{
 pigment{White}
 finish{metallic}
 normal{quilted -.2}
}
texture{
 pigment{
  bozo turbulence .3
  color_map{
   [0.00 Clear]
   [0.1 Clear]
   [0.2 DarkTan filter .8]
   [0.4 Clear]
   [0.6 Clear]
   [0.7 Brown filter .8]
   [0.75 Clear]
   [1.00 Clear]
  }
 }
 normal{wrinkles}
 scale 5
}
#declare nappe = mesh {
	#include "i_nappe.msh"
	uv_mapping
	texture{t_nappe scale .02}
}
object { nappe
}
#end

// floor
difference{
 box{<-1.01,-.01,-10.01>,<1.01,6.01,10.51>}
 box{<-1,0,-10>,<1,6,10.5>}
 box{<-1.02,1,-1.2>,<-.99,2,-.2>}
 texture{
  pigment { Flesh}
  normal{granite scale .05}
  finish { ambient .3 diffuse .7 }
 }
}

object{Table
 pigment{Tan}
 translate <0.01,-.01,0.01>
}

light_source { <-450,300,-250>,
 White*.8+Gold*.2
 fade_distance 50000
 fade_power 4
}

sphere{0,1000
 pigment{SummerSky*100+White*100}
}

camera {location
 <.2,1.6,-3>
 direction 5*z
 look_at <-.1,0.9,0.02>
}

