/*

   ceil generator

   Jaime Vives Piqueres, 2000

*/

#macro f_wall(
  max_rows,     // maximun number of rows of bricks
  max_cols,     // maximum number of columns of bricks
  x_size,       // lenght of the x side (width) of the brick
  y_size,       // lenght of the y side (height) of the brick
  xy_scale      // scalinf factor for xy plane
  z_size,       // thinyness of the brick (z side)
  z_rand,       // max rand displacement in z
  brick_rand,   // brick random factor (0 to 1/none to full)
  b_tex,        // texture for the bricks
  rand_z_tex,   // randomize texture in z direction (on/off)
  rand_scale,   // randomize texture scaling (on/off)
  tex_scale,    // texture scaling factor
  rc
 )

// *** constructing the wall... a double loop:
#declare r_s=seed(rc);   // random seed for texturing and placement
#declare cnt_rows=1;            // rows counter
union{

 #while (cnt_rows<=max_rows)

  #declare cnt_cols=1;          // columns counter
  #while (cnt_cols<=max_cols+2)

   intersection{
    difference{
     cylinder{<0,-.5,0>,<0,.5,0>,.5}
     cylinder{<0,-.5,0>,<0,.5,0>,.5 scale <.8,1.1,.8>}
    }
    plane{z,0}
    texture{b_tex                       // texture randomly
     #if (rand_scale=1)
      scale -tex_scale*.5+tex_scale*rand(r_s)
     #end
     translate max_cols*rand(r_s)*x
     translate max_rows*rand(r_s)*y
     #if (rand_z_tex)
      translate z_size*tex_scale*rand(r_s)*z
     #end
    }
    rotate 5*x
    translate <(cnt_cols-1),(cnt_rows-1),z_rand*rand(r_s)>   // place the brick in the wall
   }

   #if (cnt_cols<max_cols+2)
   intersection{
    difference{
     cylinder{<0,-.5,0>,<0,.5,0>,.5}
     cylinder{<0,-.5,0>,<0,.5,0>,.5 scale <.8,1.1,.8>}
    }
    plane{z,0 inverse}
    texture{b_tex                       // texture randomly
     #if (rand_scale=1)
      scale -tex_scale*.5+tex_scale*rand(r_s)
     #end
     translate max_cols*rand(r_s)*x
     translate max_rows*rand(r_s)*y
     #if (rand_z_tex)
      translate z_size*tex_scale*rand(r_s)*z
     #end
    }
    rotate 5*x
    translate <(cnt_cols-1)+.5,(cnt_rows-1),z_rand*rand(r_s)>   // place the brick in the wall
   }
   #end

   #declare cnt_cols=cnt_cols+1;              // update counters
  #end
  #declare cnt_rows=cnt_rows+1;
 #end
 translate <-((max_cols+2)*.5)+.5,-(max_rows*.5)+.5,0> // center at <0,0,0>
 scale <x_size,y_size,z_size>           // scale properly
}

#end // end of macro f_wall()
