// house ceil
// declare tile texture
#declare t_wall=
texture{
 pigment{
  gradient z
  color_map{
   [0.0 Tan*.5+Firebrick*.5]
   [0.5 Flesh]
   [1.0 Tan*.5+Firebrick*.5]
  }
 }
 normal{granite 1 scale .1}
}
texture{
 pigment{
  bozo
  turbulence 0.5
  color_map{
   [0.0 Clear]
   [0.5 DarkBrown*.1 filter 0.5]
   [1.0 DkGreenCopper*.2 filter 0.5]
  }
 }
 normal{granite 1 scale .1}
 scale .5
}

// create the macro f_wall()
#include "i_ceil.inc"

// all ready... make the wall!
#declare rc=seed(136);
#declare max_rows=12;
#declare max_cols=28;
#declare x_size=500/28;
#declare y_size=25;
#declare house_ceil=
object{
f_wall(      // MACRO from wall.inc, parameters are:
  max_rows,  //  + maximun number of rows of bricks
  max_cols,  //  + maximum number of columns of bricks
  x_size,    //  + lenght of the x side (width) of the brick
  y_size,    //  + lenght of the y side (height) of the brick
  1.01       //  + scaling factor for x and y sizes
  10,         //  + thinyness of the brick (z side)
  .2,        //  + max rand displacement in z
  .0,        //  + brick random factor (0 to 1/none to full)
  t_wall,    //  + texture for the bricks
  on,        //  + randomize texture in z direction (on/off)
  on,        //  + randomize texture scaling (on/off)
  8,         //  + texture scaling factor
  rc          //  + rand seed
)
}

#declare ceil_basement=
union{
  box{-.5,.5 scale <10,10,300>
   texture{T_Wood1}
   translate 150*z
   rotate -30*x
   translate <255,250,-5>
  }
  box{-.5,.5 scale <10,10,300>
   texture{T_Wood1}
   translate 150*z
   rotate -30*x
   translate <-255,250,-5>
  }
  box{-.5,.5 scale <10,10,300>
   texture{T_Wood1}
   translate -150*z
   rotate 30*x
   translate <255,250,505>
  }
  box{-.5,.5 scale <10,10,300>
   texture{T_Wood1}
   translate -150*z
   rotate 30*x
   translate <-255,250,505>
  }
  box{-.5,.5 scale <510,10,10>
   texture{T_Wood1}
   translate <0,250,0>
  }
  box{-.5,.5 scale <510,10,10>
   texture{T_Wood1}
   translate <0,250,500>
  }
  cylinder{<-255,400,250>,<255,400,250>,8
   texture{T_Wood17}
  }
}

