#version unofficial megapov 0.7;

// *** LAB ROOM ***
// dimensions: height=250cm, width=400cm, depth=800cm
#if (use_room>0)

// hf wall
#declare p1=
pigment{brick color White*.7 color Black rotate 90*x scale .05}
/*
pigment{
  granite
  turbulence .5
  lambda 3
  color_map{
   [0.00 Gray10]
   [1.00 White*.5]
  }
  scale 1
}
*/
#declare p2=
pigment{
  granite
  turbulence .2
  color_map{
   [0.00 White*.8]
   [1.00 White]
  }
  scale 1
}
#declare wall_hf_base=
height_field {
 pattern
  #if (use_room=2)
    200,125{
  #else
    800,500{
  #end
  hf_gray_16
  wrinkles
  turbulence .4
  lambda 3
  pigment_map{
   [0.00 p1]
   [0.50 p2]
   [1.00 p2]
  }
  warp{reset_children}
  scale 4
  scale <1/8,1,1/3>
  scale <.1,1,.1>
  translate 23
 }
 translate -.5
 rotate -90*x
}
#declare wall_hf=
object{wall_hf_base
 scale <400,250,4>
}
#declare stone_wall=
/*
intersection{
 object{wall_hf}
 plane{z,13.9}
 translate -8*z
}
*/
difference{
 box{-.5,.5 scale <400,250,20>}
 object{wall_hf rotate 180*y translate -11*z}
}
#declare comecantos=
height_field {
 pattern
  50,200{
  hf_gray_16
  wrinkles
  turbulence .2
  color_map{
   [0.00 Black]
   [0.10 Black]
   [1.00 White]
  }
  scale 4
  scale <1/8,1,1/3>
  scale <.1,1,.1>
  translate 23
 }
 translate -.5
 rotate -90*x
}


#declare f1=
pigment{
  granite
  turbulence .5
  color_map{
   [0.00 White]
   [0.30 White]
   [0.50 White*.7]
   [1.00 White*.8]
  }
  scale 2
}
#declare f2=
pigment{
  granite
  turbulence .2
  color_map{
   [0.00 White]
   [0.30 White]
   [0.50 White*.8]
   [1.00 White*.9]
  }
  scale 2
  translate 100
}
#declare floor_hf=
difference{
union{
// height_field{ png "hf_sidew"
 height_field {
  pattern
   #if (use_room=2)
     100,200{
   #else
     480,960{
   #end
   hf_gray_16
   cells turbulence .01
   pigment_map{
    [0.00 f1]
    [1.00 f2]
   }
   frequency 4
//   rotate 90*x
   scale <.05,1,.025>
  }
  translate -.5
  scale <400,4,800>
 }
 box{-.5,.5
  scale <400,10,800>
  translate -5*y
 }
}
union{
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1>}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -20*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -40*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -60*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -80*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -100*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -120*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -140*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -160*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate -180*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate 20*x}
 cylinder{<0,0,-400>,<0,0,400>,1 scale <.5,2,1> translate 40*x}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 0*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 20*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 40*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 60*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 80*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 100*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 120*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 140*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 160*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 180*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 200*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 220*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 240*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 260*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate 280*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate -20*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate -40*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate -60*z}
 cylinder{<-200,0,0>,<200,0,0>,1 scale <1,2,.5> translate -80*z}
 translate 3.6*y
}
}

// --- chimey ---
#declare chimey=
union{
 height_field{
  png "hf_chimey.png"
  water_level .1
  translate -.5
  rotate -90*x
  texture{
   material_map{
    png "mm_chimey"
    texture{t_wall}
    texture{pigment{Firebrick*.4+Tan*.2+White*.3} normal{granite scale 3}}
    texture{pigment{Firebrick*.3+Tan*.4+White*.2} normal{granite scale 2}}
    texture{pigment{Firebrick*.3+Tan*.2+White*.4} normal{granite scale 3.5}}
    texture{pigment{Firebrick*.3+Tan*.3+White*.3} normal{granite scale 2.5}}
   }
   translate -.5
  }
  scale <88,68,4>
  translate <0,-6,-39>
 }
 union{
  difference{
  #if (use_room=2)
   box{-.5,.5 scale <100,70,80>}
  #else
   superellipsoid{<.03,.03> rotate 90*x scale .5 scale <100,70,80>}
  #end
   object{comecantos scale <20,71,4> rotate 180*y rotate 45*y translate <-49,0,-39.5>}
   object{comecantos scale <20,71,4> rotate 180*y rotate -45*y translate <49,0,-39.5>}
   object{comecantos rotate -90*x scale <20,4,81> rotate 45*z translate <-49,34,0>}
   object{comecantos rotate -90*x scale <20,4,81> rotate -45*z translate <49,34,0>}
   object{comecantos rotate -90*x scale <101,4,20> rotate -45*x translate <0,34,-39.5>}
   object{wall_hf rotate 180*y translate -41.2*z}
   object{wall_hf rotate 90*y translate 51.2*x}
   object{wall_hf rotate -90*y translate -51.2*x}
   object{wall_hf rotate -90*x translate 36.2*y}
   cylinder{<0,0,-81>,<0,0,79>,18 scale <1.9,.6,1> translate 9*y}
   box{-.5,.5 scale <70,50,80> translate <0,-16,-1>}
   hollow
   bounded_by{box{<-51,-36,-41>,<51,36,41>}}
  }
  difference{
   box{-.5,.5 scale <90,70,20>}
   object{wall_hf rotate 180*y translate -11.2*z}
   translate <0,35+35,44.5>
  }
  difference{
   box{-.5,.5
    scale <100,70,40>
   }
   object{wall_hf rotate -90*y translate 20*z translate -51.2*x}
   box{-.5,.5 scale <100,70,40> scale <.9,1,.9>}
   box{-.5,.5 scale <101,71,40> scale <.9,1,.9> translate -5*z}
   box{-.5,.5 scale <101,50,20> translate <0,-16,-20> }
   cylinder{<-101,0,0>,<101,0,0>,10 translate <0,10,-20>}
   hollow
   bounded_by{box{<-51,-36,-41>,<51,36,41>}}
   translate <0,35+35,40-10>
  }
  difference{
   #if (use_room=2)
   box{-.5,.5 scale <105,4,45>}
   #else
   superellipsoid{<.03,.03> rotate 90*x scale .5 scale <105,4,45>}
   #end
   box{-.5,.5  scale <99,5,39>}
   translate <0,35+70,30>
  }
  difference{
  #if (use_room=2)
   box{-.5,.5 scale <100,50,40>}
  #else
   superellipsoid{<.03,.03> rotate 90*x scale .5 scale <100,50,40>}
  #end
   box{-.5,.5 scale <90,50,30> translate -1*y}
   object{comecantos scale <20,51,4> rotate 180*y rotate 45*y translate <-49.5,0,-19.75>}
   object{comecantos scale <20,51,4> rotate 180*y rotate -45*y translate <49.5,0,-19.75>}
   object{wall_hf rotate 180*y translate -21.2*z}
   object{wall_hf rotate -90*y translate <-51.2,-30,0>}
   bounded_by{box{<-51,-26,-21>,<51,26,21>}}
   rotate 6*x translate <0,35+70+25,34>
  }
  difference{
  #if (use_room=2)
   box{-.5,.5 scale <100,60,40>}
  #else
   superellipsoid{<.03,.03> rotate 90*x scale .5 scale <100,60,40>}
  #end
   object{comecantos scale <20,61,4> rotate 180*y rotate 45*y translate <-49.5,0,-19.75>}
   object{comecantos scale <20,61,4> rotate 180*y rotate -45*y translate <49.5,0,-19.75>}
   object{wall_hf rotate 180*y translate -21.2*z}
   object{wall_hf rotate -90*y translate <-51.2,-20,0>}
   rotate 28*x translate <0,35+70+30+25+13.5,48.6>
  }
  texture{t_wall translate 70*y}
  texture{
   pigment{
    spherical
    turbulence .1 lambda 3
    color_map{
    [0 Clear]
    [1 Gray10]
    }
    scale <100,100,60> translate <-10,35,35>
   }
  }
 }
 difference{
  superellipsoid{<.1,.1> scale .5 rotate 90*x}
  height_field{
   png "hf_wood1"
   translate -.5
   scale <1,.05,1>
   rotate 90*x
   translate -.4*z
  }
  scale <100,8,3> rotate 5*x translate <0,35+70+4,12>
  texture{T_Wood7 scale 8 rotate 90*y}
 }
}

#macro shelf(rs)
union{
 difference{
  superellipsoid{<.1,.1> scale .5 rotate 90*x}
  height_field{
   png "hf_wood1"
   translate -.5
   scale <1,.1,1>
   rotate 180*x
   translate .4*y
  }
  height_field{
   png "hf_wood1"
   translate -.5
   scale <1,.05,1>
   rotate 90*z
   translate .51*x
  }
  scale <21,3.5,150>
  texture{T_Wood23 scale 53 translate 1000*rand(rs)*z}
  translate 1*y
 }
 union{
  box{-.5,.5 scale <1,18,4> translate <-9.5,-10.25,60>}
  box{-.5,.5 scale <1,18,4> translate <-9.5,-10.25,-60>}
  texture{T_Wood23 rotate 90*x scale 13 translate 1000*rand(rs)*y}
 }
 union{
  box{-.5,.5 scale <20,1,4> translate <0,-1.25,60>}
  box{-.5,.5 scale <20,1,4> translate <0,-1.25,-60>}
  texture{T_Wood23 rotate 90*y scale 13 translate 1000*rand(rs)*x}
 }
 union{
  box{-.5,.5 scale <20,1,4> translate <0,-1.25,60>}
  box{-.5,.5 scale <20,1,4> translate <0,-1.25,-60>}
  texture{T_Wood23 rotate 90*y scale 13 translate 1000*rand(rs)*x}
  translate 10*x
  rotate 45*z
  translate -10*x
  translate -15*y
 }
 translate -1.5*y
}
#end


// --- room ---
#declare r_shelf=seed(7682);
#declare t_wood_win=
texture{
 T_Wood7
 normal{granite 2 scale <.1,1,.1>}
 scale 4
}
#declare lab_room=
union{
 // walls
 union{
  // left wall, with window, shelves and chimey (visible)
  object{stone_wall rotate -90*y
   hollow
   translate <-200,0,0>
  }
  difference{
   object{stone_wall rotate -90*y}
   box{-.5,.5 scale <20,60,60> translate <9,-10,130>}
   cylinder{<-10,0,0>,<10,0,0>,30 translate <9,20,130>}
   box{-.5,.5 scale <22,56,50> translate <0,-10,130>}
   cylinder{<-11,0,0>,<11,0,0>,25 translate <0,20,130>}
   object{comecantos rotate 90*y scale <24,63,63> translate <10.1,-10,130>}
   hollow
   bounded_by{box{<-11,-126,-201>,<11,126,201>}}
   translate <-200,0,-400>
  }
/*  intersection{
   difference{
    sphere{0,.5}
    sphere{0,.49}
   }
   plane{x,0}
   scale 200
   translate <-200,0,-400+130>
  }*/
  // background wall, more shelves and hanging tools (dark, but visible)
  difference{
   object{stone_wall}
   box{-.5,.5 scale <100,70,10> translate <-100+40,-125+35,-1>}
   hollow
   translate <0,0,200>
  }
  // other walls (faked, not visible)
  box{-.5,.5
   scale <20,250,400>
   translate <200,0,0>
  }
  box{-.5,.5
   scale <20,250,400>
   translate <200,0,-400>
  }
  box{-.5,.5
   scale <400,250,20>
   translate <0,0,-600>
  }
  texture{t_wall}
 }
 // ceil
 difference{
  box{-.5,.5 scale <400,40,800>}
  cylinder{<0,0,-391>,<0,0,391>,30 translate <-149,-20,0>}
  cylinder{<0,0,-391>,<0,0,391>,30 translate <-149+80*1,-20,0>}
  cylinder{<0,0,-391>,<0,0,391>,30 translate <-149+80*2,-20,0>}
  cylinder{<0,0,-391>,<0,0,391>,30 translate <-149+80*3,-20,0>}
  bounded_by{box{<-201,-21,-401>,<201,21,401>}}
  scale <1,.8,1>
  translate <10,135+6,-200>
  texture{t_wall}
 }
 union{
  box{-.5,.5 scale <20,20,800> translate <-189,-17,0>}
  box{-.5,.5 scale <20,20,800> translate <-189+80*1,-17,0>}
  box{-.5,.5 scale <20,20,800> translate <-189+80*2,-17,0>}
  box{-.5,.5 scale <20,20,800> translate <-189+80*3,-17,0>}
  box{-.5,.5 scale <20,20,800> translate <-189+80*4,-17,0>}
  texture{T_Wood7 scale 8}
  translate <10,135+6,-200>
 }
 // rough floor (visible)
 object{floor_hf
  texture{t_floor scale <1,.25,1> translate .1*y}
  translate <0,-125-1,-200>
 }
 // chimey
 object{chimey
  rotate -90*y
  translate <-195+40,-125+35,-150>
 }
 // left shelf
 object{shelf(r_shelf)
  translate <-190+10,-125+70,-274>
 }
 object{shelf(r_shelf)
  translate <-190+10,-125+30,-274>
 }
 object{shelf(r_shelf)
  translate <-190+10,-125+70,-276+150+100>
 }
 object{shelf(r_shelf)
  translate <-190+10,-125+110,-276+150+100>
 }
 object{shelf(r_shelf)
  translate <-190+10,-125+150,-276+150+100>
 }
 object{shelf(r_shelf)
  rotate 90*y
  scale <.5,1,1>
  translate <-150,-125+110,180>
 }
 object{shelf(r_shelf)
  rotate 90*y
  scale <.5,1,1>
  translate <-150,-125+150,180>
 }
 // background scenery
 union{
  difference{
  #if (use_room=2)
  box{-.5,.5 scale <100,60,80>}
  #else
   superellipsoid{<.03,.03> rotate 90*x scale .5 scale <100,60,80>}
  #end
   object{wall_hf rotate 180*y translate 50*x translate -41.2*z}
   object{wall_hf rotate -90*x translate 31.2*y}
   translate <-150,-125+30,200-40>
  }
  difference{
  #if (use_room=2)
  box{-.5,.5 scale <40,50,100>}
  #else
   superellipsoid{<.03,.03> rotate 90*x scale .5 scale <40,50,100>}
  #end
   object{comecantos scale <20,51,4> rotate 180*y rotate -45*y translate <19,0,-49.5>}
   object{comecantos rotate -90*x scale <41,4,20> rotate -45*x translate <0,24,-49.5>}
   object{wall_hf rotate 180*y translate -50*x translate -51.2*z}
   object{wall_hf rotate -90*x translate 26.2*y}
   translate <10,-125+25,200-50>
  }
  texture{t_wall}
 }
 // background chimey
 object{chimey
  translate <-100+40,-125+35,200-50>
 }
 // window grille
 union{
  box{-.5,.5 scale <2,90,2> rotate 45*y translate <0,0,0>}
  box{-.5,.5 scale <2,90,2> rotate 45*y translate <0,0,-10>}
  box{-.5,.5 scale <2,90,2> rotate 45*y translate <0,0,10>}
  box{-.5,.5 scale <2,90,2> rotate 45*y translate <0,0,-20>}
  box{-.5,.5 scale <2,90,2> rotate 45*y translate <0,0,20>}
  box{-.5,.5 scale <2,2,60> rotate 45*z translate <0,0,0>}
  box{-.5,.5 scale <2,2,60> rotate 45*z translate <0,20,0>}
  box{-.5,.5 scale <2,2,60> rotate 45*z translate <0,-20,0>}
  texture{t_old_metal scale 2}
  translate <-205,0,-270>
 }
 // window wood
 union{
  difference{
   union{
    box{-.5,.5 scale <3,57,56> translate <0,-10,0>}
    cylinder{<-1.5,0,0>,<1.5,0,0>,28 translate <0,20,0>}
   }
   box{-.5,.5 scale <4,88,1> translate <0,3,0>}
   box{-.5,.5 scale <4,88,1> translate <0,3,-15>}
   box{-.5,.5 scale <4,88,1> translate <0,3,15>}
   texture{t_wood_win rotate 90*x}
  }
  box{-.5,.5 scale <2,6,48>
   texture{t_wood_win}
   rotate 1*x
   translate <2.5,-7,0>
  }
  box{-.5,.5 scale <2,6,48>
   texture{t_wood_win translate 100}
   rotate -2*x
   translate <2.5,17,0>
  }
  box{-.5,.5 scale <2,6,48>
   texture{t_wood_win translate 200}
   translate <2.5,-30,0>
  }
  // open it
  translate 25*z rotate 155*y translate -25*z
  translate <-190.5,0,-400+130+.5>
 }
 // tricky object to stop faked lighting on the window interior
 #if (use_faked_amb)
 union{
  box{-.5,.5 scale <.1,60,60> translate <0,-10,0>}
  cylinder{<-.05,0,0>,<.05,0,0>,30 translate <0,20,0>}
  pigment{White}
  no_image
  no_reflection
  translate <-190.4,0,-270>
 }
 #end
 // faked scenery not visible
 box{-.5,.5 scale <1,190,100>
  pigment{DarkTan}
  translate <190,-125+190*.5,0>
 }
 box{-.5,.5 scale <30,200,120>
  texture{T_Wood10 scale 10}
  translate <170,-125+190*.5,-300>
 }
 cylinder{
  <0,0,0>,<0,100,0>,30
  texture{pigment{Gold}}
  translate <170,-125,-90>
 }
 cylinder{
  <0,0,0>,<0,70,0>,20
  texture{pigment{SteelBlue}}
  translate <170,-125,-140>
 }
}
#end