//glass commented out due to spped-up reasons
#declare ap=array[12]
#declare ap[0]=<0.0,-0.5,0>;
#declare ap[1]=<0.6, 0.0,0>;
#declare ap[2]=<0.6, 0.2,0>;
#declare ap[3]=<1.0, 0.4,0>;
#declare ap[4]=<0.5, 0.7,0>;
#declare ap[5]=<0.4, 1.0,0>;
#declare ap[6]=<0.35,1.0,0>;
#declare ap[7]=<0.45,0.7,0>;
#declare ap[8]=<0.95,0.4,0>;
#declare ap[9]=<0.55,0.2,0>;
#declare ap[10]=<0.55,0,0>;
#declare ap[11]=<0,0,0>;
#declare glass_tube=
object{meshlathe(ap,.4,9)}


#declare protec=
union{
 cylinder{<1.5,0.3,0>,<2.7,.25,0>,.2}
 sphere{<2.7,.25,0>,.2}
 cylinder{<2.7,.25,0>,<3.2,1,0>,.2}
 sphere{<3.2,1,0>,.2}
 cylinder{<3.2,1,0>,<2.7,7,0>,.2}
 sphere{<2.7,7,0>,.2}
 cylinder{<2.7,7,0>,<2.2,7.5,0>,.2}
 sphere{<2.2,7.5,0>,.2}
 cylinder{<2.2,7.5,0>,<1.5,8,0>,.2}
}

// *** LAMP ***
#macro oil_lamp(r_lamp,light_on)
#include "glass.inc"

#local fd=140;

union{
 union{
  object{protec}
  object{protec rotate 45*y}
  object{protec rotate 90*y}
  object{protec rotate (90+45)*y}
  object{protec rotate 180*y}
  object{protec rotate (180+45)*y}
  object{protec rotate 270*y}
  object{protec rotate (270+45)*y}
  torus{3,0.2 translate 2*y}
  torus{2.6,0.2 translate 6*y}
  torus{2.3,0.4 translate -.8*y}
  torus{2.4,0.3 translate -.4*y}
  torus{2,0.2 }
  torus{1.7,0.2 translate .4*y}
  torus{1.5,0.2 translate .8*y}
  difference{
   cylinder{<0,-.1,0>,<0,.1,0>,2}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 0*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 45*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 90*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 135*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 180*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 225*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 270*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 315*y}
  }
  torus{1.2,0.2 translate 7.2*y}
  torus{1.5,0.2 translate 7.6*y}
  torus{1.7,0.2 translate 8*y}
  torus{1.5,0.2 translate 8.4*y}
  difference{
   union{
    intersection{
     difference{
      sphere{0,1}
      sphere{0,.95}
     }
     plane{y,0 inverse}
     scale <1.5,2,1.5>
    }
    cylinder{<0,-.1,0>,<0,.1,0>,1.5}
   }
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 0*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 45*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 90*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 135*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 180*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 225*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 270*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 315*y}
   translate 8*y
  }
  torus{1,0.2 rotate 90*x translate 11*y}
  texture{Copper_Metal}
  texture{
   pigment{
    gradient y turbulence .2
    color_map{
     [0 Clear]
     [1 DarkBrown filter 0.5]
    }
   }
   normal{granite scale 1}
   finish{Shiny}
   scale <1,20,1>
  }
  translate -4*y
 }
 #if (light_on=0)
 object{glass_tube
  hollow
  texture{t_cristal_tubo}
  translate -.5*y
  scale <2.5,8,2.5>
 }
 #end
 #if (light_on)
 light_source{
  0
  White*.3+Gold*.2+Orange*.1
  #if (use_arealight)
  area_light <9,0,0>,<0,0,9>,4,4 jitter adaptive 1
  #end
  fade_distance 400
  fade_power 2
  translate 0*y
 }
 #end
 scale 1.3
 rotate 360*rand(r_lamp)*y
}
#end