#version unofficial MegaPOV 0.7;

#declare LStart = vrotate(<0,-2,0>,x*5)+<0,-3,0>;
#declare LStart = vrotate(LStart,<30,0,90>)+<1.5,1.2,0>;
#declare LStart = vrotate(LStart,<0,60,0>)+<0,9,15>;

#declare LEnd = vrotate(<0,-2,-2>,<45,0,0>)+<0,-3,0>;
#declare LEnd = vrotate(LEnd,<60,0,-45>)+<-1.5,1.2,0>;
#declare LEnd = vrotate(LEnd,<0,175,0>)+<0,6,-20>;
#declare LEnd = LEnd*<-1,1,1>-2*y;

#declare L1 = vrotate(<0,6,0>,<-90,0,0>)+<0,-3,-3>;
#declare L1 = vrotate(L1,<45,0,0>)+<0,-3,0>;
#declare L1 = vrotate(L1,<60,0,-45>)+<-1.5,1.2,0>;
#declare L1 = vrotate(L1,<0,175,0>)+<0,6,-20>;
#declare L1 = L1*<-1,1,1>-2*y;

#declare L2 = vrotate(<0,-6,0>,<-90,0,0>)+<0,-3,-3>;
#declare L2 = vrotate(L2,<45,0,0>)+<0,-3,0>;
#declare L2 = vrotate(L2,<60,0,-45>)+<-1.5,1.2,0>;
#declare L2 = vrotate(L2,<0,175,0>)+<0,6,-20>;
#declare L2 = L2*<-1,1,1>-2*y;

// Define a macro that does the same as 
// John VanSickle's Reorient macro.
// (But with a slightly different method.)

#macro Reorient(vAxis1, vAxis2)

  #local v1 = vnormalize(vAxis1);
  #local v2 = vnormalize(vAxis2);
  #local vU = vcross(v1, v2);
  #local Dot = vdot(v1, v2);
  #local v0 = vnormalize(vU);
  #local vW = (1 - Dot)*v0;

  matrix <
    v0.x*vW.x + Dot,  v0.x*vW.y + vU.z, v0.x*vW.z - vU.y,
    v0.y*vW.x - vU.z, v0.y*vW.y + Dot,  v0.y*vW.z + vU.x,
    v0.z*vW.x + vU.y, v0.z*vW.y - vU.x, v0.z*vW.z + Dot,
    0,                0,                0
  >
  
#end // macro ReorientMatrix

// Calculate a normal vector for the plane
#declare vNormal = vnormalize(vcross(L2-LEnd, LStart - LEnd));

#declare Length = vlength(LEnd-LStart);

#declare White = density {
	crackle
	color_map {
		[0.00 rgb <2,2,2>]
		[0.03 rgb <0,0,0>]
		[1.00 rgb 0]
	}
	scale 3
	turbulence .4
}

#declare Blue = density {
	crackle
	color_map {
		[0.00 rgb <0,0,2>]
		[0.03 rgb <0,0,0>]
		[1.00 rgb 0]
	}
	scale 3.5
	turbulence .45
}

merge {
	#declare TCount = 2;
	#while (TCount < Length-2)
		torus {TCount/5,1 rotate x*90 translate -z*TCount}
	#declare TCount = TCount + 1;
	#end
	Reorient(y,vNormal)
	translate LStart

	#if (Textures = 0)
		pigment {color rgb 1}
	#else
		texture {
			pigment {color transmit 1}
		}
		interior {
			media {
				emission 1
				samples 5,50
				density {
					average
					density_map {
						[1 White]
						[1 Blue]
					}
				}
			}
		}
		hollow
	#end
}
