#version unofficial MegaPov 0.7;

#include "Blade1.inc"

#declare Blade = union {
	object {blade1}
	object {blade1 scale <-1/8,1,1/8>}
	#if (Textures = 0)
		pigment {color green 1}
	#else
		pigment {color rgbt <0,1,0,.5>}
	#end
	finish {specular 1}
	rotate y*90
	scale 1/2
}

#declare GSeed = seed(987);

#declare PosScale = .2;
#declare TurbScale = 10;
#declare GStep = 1/3;

#if (Grass = 2)
	#fopen Grassy "grass2.inc" write

	#macro Place(XXX,YYY,ZZZ)
		#declare Turb = vturbulence(1.5,.5,5,<XXX,YYY,ZZZ>*PosScale);
		#declare Noise = noise3d(<XXX,YYY,ZZZ>);
		#declare Rand = rand(GSeed);
	//	#debug concat(str(Noise,0,4),"    ",str(Rand,0,4),"\n")
	//	#if (Rand > (1 - sqr(Noise)))
	//	#if (Rand > sqrt(Noise))
		#declare Placement = false;
		#if (Noise > .9) #declare Placement = true; #end
		#if (Noise > .75) #if (Rand > .7) #declare Placement = true; #end #end
		#if (Noise > .5) #if (Rand > .8) #declare Placement = true; #end #end
		#if (Noise > .25) #if (Rand > .9) #declare Placement = true; #end #end
		#if (Placement = true)
			#write (Grassy, "object {Blade scale <1,",Noise,",1> rotate ",Turb*TurbScale," translate ",<XXX,YYY,ZZZ>,"}\n")
		#end
	#end

	#declare XX = -20;
	#while (XX <= 450)
		#if (XX < 0) #if (XX >= -8) #declare XX = 8+GStep; #end #end
		#debug concat(str((XX+20),4,1),"/470","\n")
		#declare ZZ = -75;
		#while (ZZ <= 75)
			#declare Norm1 = <0,0,0>; #declare Norm2 = <0,0,0>;
			#declare WalInt = true; #declare WatInt = true;
			#declare IWat = trace(WaterObj, <XX,50,ZZ>+vturbulence(1.5,.5,5,<XX,50,ZZ>), -y, Norm1);
			#declare Inter = trace(WallObj, <XX,50,ZZ>+vturbulence(1.5,.5,5,<XX,50,ZZ>), -y, Norm2);
			#if (Norm2.x = 0) #if (Norm2.y = 0) #if (Norm2.z = 0)
				#declare WalInt = false;
			#end #end #end
			#if (Norm1.x = 0) #if (Norm1.y = 0) #if (Norm1.z = 0)
				#declare WatInt = false;
			#end #end #end
			#if (WalInt = true)
				#declare Placement = true;
				#if (WatInt = true)
					#if (Inter.y < IWat.y)
						#declare Placement = false;
					#end
				#end
				#if (Placement = true)
					Place(Inter.x,Inter.y,Inter.z)
				#end
			#end
		#declare ZZ = ZZ + GStep;
		#end
	#declare XX = XX + GStep;
	#end
	
	#fclose Grassy
#end

#include "grass2.inc"