#version unofficial MegaPov 0.7;

#declare Thickness = 0.15;

#declare WalkTex1 = texture {
	pigment {color rgb 1}
	finish {specular 1}
}

#declare WalkTex2 = texture {
	pigment {color rgb <.4,.15,.15>}
	finish {specular 0}
}
/*
#declare Cable = union {
	sphere_sweep {
		linear_sphere_sweep, 61
		#declare Line = 0;
		#while (Line < 20)
			,<8,cosh(Line/10)*30-25,sinh(Line/10)*30>,.25
		#declare Line = Line + 1/3;
		#end
	}
	#declare Count = 1/2;
	#while (Count < 20)
		cylinder {<8,0,sinh(Count/10)*30>,<8,cosh(Count/10)*30-25,sinh(Count/10)*30>,.1}
	#declare Count = Count + 1/2;
	#end
	pigment {color rgb <.3,.25,.25>}
	finish {specular .5}
}
*/

#declare Cable = union {
	union {
		#declare Line = 0;
		#while (Line < 20)
			sphere_sweep {
				linear_sphere_sweep, 10,
					<8, cosh(Line/10)*30-25, sinh(Line/10)*30>,.25,
					<8, cosh((Line+1/3)/10)*30-25, sinh((Line+1/3)/10)*30>,.25,
					<8, cosh((Line+2/3)/10)*30-25, sinh((Line+2/3)/10)*30>,.25,
					<8, cosh((Line+3/3)/10)*30-25, sinh((Line+3/3)/10)*30>,.25
					<8, cosh((Line+4/3)/10)*30-25, sinh((Line+4/3)/10)*30>,.25,
					<8, cosh((Line+5/3)/10)*30-25, sinh((Line+5/3)/10)*30>,.25,
					<8, cosh((Line+6/3)/10)*30-25, sinh((Line+6/3)/10)*30>,.25
					<8, cosh((Line+7/3)/10)*30-25, sinh((Line+7/3)/10)*30>,.25,
					<8, cosh((Line+8/3)/10)*30-25, sinh((Line+8/3)/10)*30>,.25,
					<8, cosh((Line+9/3)/10)*30-25, sinh((Line+9/3)/10)*30>,.25
			}
		#declare Line = Line + 3;
		#end
	}
	union {
		#declare Count = 1/2;
		#while (Count < 20)
			cylinder {<8,0,sinh(Count/10)*30>,<8,cosh(Count/10)*30-25,sinh(Count/10)*30>,.1}
		#declare Count = Count + 1/2;
		#end
	}
	pigment {color rgb <.3,.25,.25>}
	finish {specular .5}
}

union {
	cylinder {<-8,0,-35>,<-8,0,35>,Thickness}
	cylinder {<8,0,-35>,<8,0,35>,Thickness}

	object {Cable}
	object {Cable scale <1,1,-1>}
	object {Cable scale <-1,1,1>}
	object {Cable scale <-1,1,-1>}

	#declare Count = -30;
	#while (Count < 30)
		cylinder {<-8,0,Count>,<8,0,Count>,.1}
	#declare Count = Count + 1/2;
//	#declare Count = Count + 1;
	#end

	#if (Textures = 0)
		pigment {color rgb 1}
	#else
		texture {
			bozo
			texture_map {
				[0 WalkTex1]
				[1 WalkTex2]
			}
			scale 2
		}
	#end
}