#version unofficial MegaPov 0.7;

#declare BadWTex = texture {
	pigment {color rgb <.25,.25,.75>}
	finish {specular 1 reflection .75}
}

#declare GoodWTex = texture {
	pigment {color rgbf <.7,.8,.9,.9>}
	finish {specular 1 reflection .05}
}

#declare WaterI = interior {
//	ior 4/3
	media {
		absorption rgb <1,1,.25>/35
	}
}

#if (Water = 1)
#declare WaterObj=plane {
		y,-2
	}
#end

#if (Water = 2)
#declare WaterObj=isosurface {
		function {(5*sqr(sin(x/pi))+sqr(sin(z/pi))+noise3d(x,y,z))/6-y}
		contained_by {box {<-500,-5,-75>,<500,1,75>}}
		sign -1
		translate y*-5
	}
#end

#if (Water = 3)
#declare WaterObj = height_field {
		tga "e:\images\water.tga"
		smooth on
		translate -.5
		rotate y*90
		scale <700,1.5,75>
		translate -y*3
	}
#end

object {
	WaterObj
	#if (Textures = 0)
		texture {BadWTex}
	#else
		texture {GoodWTex}
		interior {WaterI}
		hollow
	#end
}