//********************************************************
// Persistence Of Vision raytracer version 3.1g
// Japanese clock defnition type 0.1a010702a include File
// By S.Nishimura
//********************************************************


//**********************************************************************************
#include "J_zodiac.txt.inc"
//----------------------------------------------------------------------------------
#local Lw=1;
#local J_zodiac =
union {
 torus { 130,Lw }
 torus {  91,Lw }
 disc  { 0 y, 130, 91 }
 #local Ei=12; #local Si=0; #while(Si<Ei)
  cylinder { 91*x,130*x,Lw rotate (360*Si/Ei+360/Ei/2)*y }
 #local Si=Si+1; #end
 object { J_ne   scale <13,1,13> translate <0,0,130-(130-91)/2> }
 object { J_usi  scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*1/Ei*y }
 object { J_tora scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*2/Ei*y }
 object { J_u    scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*3/Ei*y }
 object { J_tatu scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*4/Ei*y }
 object { J_mi   scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*5/Ei*y }
 object { J_uma  scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*6/Ei*y }
 object { J_hituji scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*7/Ei*y }
 object { J_saru scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*8/Ei*y }
 object { J_tori scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*9/Ei*y }
 object { J_inu  scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*10/Ei*y }
 object { J_i    scale <13,1,13> translate <0,0,130-(130-91)/2> rotate 360*11/Ei*y }
 torus {  78,Lw }
 #local Ei=12*4; #local Si=0; #while(Si<Ei)
  cylinder { 78*x,91*x,Lw rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 torus { 39,Lw }
 #local Ei=12; #local Si=0; #while(Si<Ei)
  cylinder { 39*x,78*x,Lw rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
}
//**********************************************************************************
#local Lw=20;
#local Cogwheel_a =
union {
 difference {
  cylinder { 0,y,Lw }
  #local Ei=pi*Lw/2.6; #local Si=0; #while(Si<Ei)
   sphere { 0,2 scale < 2,1,1 > translate Lw*x rotate 360*Si/Ei*y }
  #local Si=Si+1; #end
  cylinder { -0.01*y,(1+0.01)*y,Lw-8 }
 }
 #local Ei=5; #local Si=0; #while(Si<Ei)
  box { < Lw/2-8/2,0,-2 >,< Lw-8/2,1,2 > rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 cylinder {0,y,Lw/2 }
 cylinder { -1*y,2*y,Lw/2-5 }
 cylinder { -4*y,5*y,Lw/8 }
}
#local Lw=60;
#local Cogwheel_l =
union {
 difference {
  cylinder { 0,y,Lw }
  #local Ei=pi*Lw/2.59; #local Si=0; #while(Si<Ei)
   sphere { 0,2 scale < 2,1,1 > translate Lw*x rotate 360*Si/Ei*y }
  #local Si=Si+1; #end
  cylinder { -0.01*y,(1+0.01)*y,Lw-10 }
 }
 #local Ei=5; #local Si=0; #while(Si<Ei)
  box { < Lw/2-5,0,-5 >,< Lw-5,1,5 > rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 cylinder {0,y,Lw/2 }
 difference {
  cylinder { -1*y,3*y,(Lw/2-10) }
  #local Ei=pi*(Lw/2-10)/2.6; #local Si=0; #while(Si<Ei)
   sphere { y,3 scale < 2,1,1 > translate (Lw/2-8)*x rotate (360*Si/Ei+20)*y }
  #local Si=Si+1; #end
 }
 cylinder { -5*y,6*y,Lw/8 }
}
#local Lw=40;
#local Cogwheel_m =
union {
 difference {
  cylinder { 0,y,Lw }
  #local Ei=pi*Lw/2.6; #local Si=0; #while(Si<Ei)
   sphere { 0,2 scale < 2,1,1 > translate Lw*x rotate 360*Si/Ei*y }
  #local Si=Si+1; #end
  cylinder { -0.01*y,(1+0.01)*y,Lw-10 }
 }
 #local Ei=5; #local Si=0; #while(Si<Ei)
  box { < Lw/2-5,0,-5 >,< Lw-5,1,5 > rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 cylinder {0,y,Lw/2 }
 cylinder { -1*y,2*y,Lw/2-10 }
 cylinder { -5*y,6*y,Lw/8 }
}
#local Lw=20;
#local Cogwheel_s =
union {
 difference {
  cylinder { 0,y,Lw }
  #local Ei=pi*Lw/2.6; #local Si=0; #while(Si<Ei)
   sphere { 0,2 scale < 2,1,1 > translate Lw*x rotate 360*Si/Ei*y }
  #local Si=Si+1; #end
  cylinder { -0.01*y,(1+0.01)*y,Lw-8 }
 }
 #local Ei=5; #local Si=0; #while(Si<Ei)
  box { < Lw/2-8/2,0,-2 >,< Lw-8/2,1,2 > rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 cylinder {0,y,Lw/2 }
 cylinder { -1*y,2*y,Lw/2-4 }
 cylinder { -5*y,6*y,Lw/2-6 }
 cylinder { -10*y,11*y,Lw/2-8 }
}
#local Lsec=110;
#local Sec_hand = 
plane { y, 0
 clipped_by { 
 union {
  sphere { 0,1.5 scale < 8,1,1 > }
  sphere { 0,3 }
  cone { 0,1.5, Lsec*x,2 }
  cone { Lsec*x,2,(Lsec+10.5)*x,0 }
  } }
 translate 6*y
}
#local Lmin=109;
#local Minute_hand = 
plane { y, 0
 clipped_by { 
 union {
  sphere { 0,2 scale < 6,1,1 > }
  sphere { 0,5 }
  cone { 0,2, Lmin*x,2.5 }
  cone { Lmin*x,2.5,(Lmin+10)*x,0 }
  } }
 translate 4*y
}
#local Lh=60;
#local Hour_hand = 
plane { y, 0
 clipped_by { 
 union {
  sphere { 0,2.5 scale < 5,1,1 > }
  sphere { 0,7 }
  cone { 0,2.5, Lh*x,3 }
  cone { Lh*x,3,(Lh+12)*x,0 }
  } }
 translate 2*y
}
//
#local Cm_x=-30; #local Cm_z=sqrt(pow(-45,2)-pow(Cm_x,2));
#local Cl_x= 35; #local Cl_z=sqrt(pow(-60,2)-pow(Cl_x,2))+Cm_z; #local Cl_x=Cl_x+Cm_x;
#local Ca_x=-42; #local Ca_z=sqrt(pow(-45,2)-pow(Ca_x,2))+Cm_z; #local Ca_x=Ca_x+Cm_x;
#local Gear_seg =
union {
 object { Cogwheel_a translate < Ca_x,-4.0,-Ca_z > }
 object { Cogwheel_l translate < Cl_x,-4.0,-Cl_z > }
 object { Cogwheel_m translate < Cm_x,-2.5,-Cm_z > }
 object { Cogwheel_s }
 object { Sec_hand rotate 100*y }
 object { Minute_hand rotate -30*y }
 object { Hour_hand rotate -120*y }
}
//**********************************************************************************
#declare Japanese_clock =
union {
 object { J_zodiac }
 object { Gear_seg }
 #local Ei=4; #local Si=0; #while(Si<Ei)
 object { Sec_hand
  pigment { color rgbt < R1, G1, B1, (0.2+0.2*Si) > }
  finish { metallic ambient 0.1 diffuse 0.4 reflection 0.25 specular 1 }
  rotate (95-5*Si)*y }
 #local Si=Si+1; #end
}
//**********************************************************************************
//object { Japanese_clock texture { T_gold } rotate 30*y translate 40*y }
//**********************************************************************************