// ClothRay example: nappe.pov
// Christophe Bouffartigue (tofbouf@free.fr)

#version unofficial MegaPov 0.7;

//#include "clothutil.inc"

#macro WriteClothFile(nomfile, n1, n2, nlng, ks, ht)

	#debug "\nWriting new .cth file\n"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l1 = .95*nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = i*nlng*.95;
			#local tempy = (j*nlng)+20;
            #local tempz = ht + nlng*0.1*cos((i+2)*pi/8);
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0,\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#fclose file
#end



/* write initial file */
#macro WriteInitialRideau()
WriteClothFile("ridcab3.cth", 61, 100, 160/100, 10, 0)

	#fopen file "ridcab3.cth" append

	#write(file, 2*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 10*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 18*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 26*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 34*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 42*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 50*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 58*100+97, ", 0.0, 0.0, 0.0,\n")

	#fclose file

#end


/* pull the curtain */
#macro DecaleRideau(dx, mindx)

#debug "\nPulling the curtain\n"

#declare Points[58][97] = Points[58][97] + dx*x;

#if (Points[58][97].x < (Points[2][97].x + 7*mindx))
	#declare Points[58][97] = Points[2][97] + 7*mindx*x;
#end
#local i = 50;
#while (i > 9)
	#if (Points[i][97].x > (Points[i+8][97].x - mindx))
		#debug "\nMoving other points\n"
		#declare Points[i][97] = Points[i+8][97] - mindx*x;
	#end
	#local i=i-8;
#end

#end

#macro DecaleUnPointDuRideau(dx, index)

#debug "\nPulling the curtain\n"

#declare Points[2+index*8][97] = Points[2+index*8][97] + dx*x;

#end


/* save changes */
#macro ReWriteRideau(namefile)

	#debug "\nRe-Writing .cth file\n"

	#fopen file namefile write
	#write(file, 61, ",", 100, ",", 160/100, ",", 10, ",\n")

	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = Points[i][j].x;
			#local tempy = Points[i][j].y;
            #local tempz = Points[i][j].z;
			#local vx = Vel[i][j].x;
			#local vy = Vel[i][j].y;
            #local vz = Vel[i][j].z;
			#write(file, tempx, ",", tempy, ",", tempz, ", ", vx, ",", vy, ",", vz, ",\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#write(file, 2*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 10*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 18*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 26*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 34*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 42*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 50*100+97, ", 0.0, 0.0, 0.0,\n")
	#write(file, 58*100+97, ", 0.0, 0.0, 0.0,\n")

	#fclose file
#end


#macro ReadAllClothFile(nomfile)

	#debug "Reading ALL cloth file...\n"

	#fopen file nomfile read
	#declare n1=0;
	#declare n2=0;
	#local temp=0;
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#read(file, n1, n2, temp, temp)

	#declare Points = array[n1][n2]
	#declare Vel = array[n1][n2]

	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#read(file, tempx, tempy, tempz, vx, vy, vz)
			#declare Points[i][j] = <tempx, tempy, tempz>;
			#declare Vel[i][j] = <vx, vy, vz>;
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


#declare Cloison = box { <-2.7, 0, -2>, <-0.2, 200, 100> }

//WriteInitialRideau()

//ReadAllClothFile("ridcab2.cth")
//DecaleRideau(-1.5, 4.5)
//DecaleUnPointDuRideau(0.3, 2)
//DecaleUnPointDuRideau(-.3, 3)
//#declare Points[6+2*8][97] = Points[6+2*8][97]-.8*z;
//DecaleUnPointDuRideau(-.5, 4)
//DecaleUnPointDuRideau(-.5, 1)
//DecaleUnPointDuRideau(-1, 2)

//ReWriteRideau("ridcab2.cth")


simcloth {
	environment Cloison
	friction    1.0

	gravity     -0.2*y

	neighbors   1
	internal_collision off
	damping     0.87
	intervals   0.06
	iterations  10000

	input       "ridcab2.cth"
	output      "ridcab2.cth"
	mesh_output "ridcab2_s.msh"
	smooth_mesh on
	uv_mesh     on
}



#declare Rideau = mesh {
	#include "ridcab2_s.msh"
	uv_mapping
	texture {
		pigment {
			checker
			color rgb <1,.5, .2>, color rgb <.9, .85, .4>
		}
		scale <.1, .1, 1>
	}
}

camera {location <-20, 230, -300> angle 40 look_at 50*x+120*y }

light_source { <-10, 100, -100>*10, color rgb .5 shadowless }

light_source { <50, 150, -100>*30, color rgb 1.2
	spotlight
	radius 50
	falloff 60
	tightness 2
	point_at 30*y+50*x
}


object { Rideau }

union {
	object { Cloison }
	object { Cloison translate 110*x }
	pigment { rgb <.97, .96, .9> }
}
plane { -z, -100 pigment { rgb .85 } }

// floor
plane { y, 0
	pigment { color rgb .8 }
	finish { ambient .3 diffuse .7 }
}


