// IRTC 08/01
// Fantasy & Mystic
// comptoir.inc

#version unofficial megapov 0.7;

#declare test_comptoir_inc = off;

#declare Clg1 = 100;
#declare Clg2 = 50;
#declare Cln1 = 200;
#declare Cln2 = 50;

#declare Cht1 = 106;
#declare Cht2 = 70;
#declare Cep1 = 10;
#declare Cep2 = 2;
#declare Cep3 = .3;
#declare Cep4 = 10;

#declare P_Cpt1 = pigment {
	wood
	turbulence <.2, .02, .2> octaves 2
	scale 10
	color_map {
		[ .1 rgb <.9, .7, .4>*1.1]
		[ .3 rgb <.9, .7, .4>*.9]
		[ .5 rgb <.9, .7, .4>*1.2]
		[ .7 rgb <.9, .7, .4>*.7]
		[ .9 rgb <.9, .7, .4>*1.0]
	}
}
#declare P_Cpt2 = pigment {
	wood
	turbulence <.2, .08, .2> octaves 2
	scale 10
	color_map {
		[ .1 rgb <.9, .7, .4>*1.1]
		[ .3 rgb <.9, .7, .4>*.9]
		[ .5 rgb <.9, .7, .4>*1.2]
		[ .7 rgb <.9, .7, .4>*.7]
		[ .9 rgb <.9, .7, .4>*1.0]
	}
}


#declare Cpt1 = union {
	box {<0, Cht1-Cep1, 0>, <Clg2, Cht1, -Cln1>}
	box {<0, Cht1-Cep1, -Cln1+Cln2>, <Clg1, Cht1, -Cln1>}
	pigment { P_Cpt1 scale <1, .3, 1> translate <20, (Cht1+10), 0> }
}

#declare Cpt2 = union {
	union {
		box {<Cep2, Cht1-Cep1, -Cep2>, <Clg2-Cep2, Cht2, -Cln1+Cep2>
			pigment { rgb .1}
			normal { bumps 0.5 poly_wave .90 scale <12, 8, 12>*.3 }
			finish { reflection_min 0 reflection_max .3 reflection_falloff 3 phong .3 phong_size 10 specular .5 roughness.01 }
		}
		box {<Cep2+Cep3, 0, -Cep2-Cep3>, <Clg2-Cep2-Cep3, Cht2, -Cln1+Cep2+Cep3> }
		translate -(Cht1-Cep1)*y
		matrix < 1, 0, 0,
				-Cep4/(Cht1-Cep1), 1, 0,
				 0, 0, 1,
				 0, 0, 0>
		translate  (Cht1-Cep1)*y
	}
	union {
		box {<Clg2-Cep2, Cht1-Cep1, -Cln1+Cln2-Cep2>, <Clg1-Cep2, Cht2, -Cln1+Cep2>
			pigment { rgb .1}
			normal { bumps 0.5 poly_wave .90 scale <12, 8, 12>*.3 }
			finish { reflection_min 0 reflection_max .3 reflection_falloff 3 phong .3 phong_size 10 specular .5 roughness.01 }
		}
		box {<Clg2-Cep2, 0, -Cln1+Cln2-Cep2-Cep3>, <Clg1-Cep2-Cep3, Cht2, -Cln1+Cep2+Cep3> }
	}
}

#declare Cpt3 = union {
	intersection {
		object {Cpt2}
		box {<0, 0, 0>, <Clg1, Cht1, -Cln1/2>}
	}
	intersection {
		object { Cpt2 }
		box {<0, 0, -Cln1/2>, <Clg1, Cht1, -Cln1>}
		translate -(Cht1-Cep1)*y
		matrix < 1, 0, 0,
				 0, 1, -Cep4/(Cht1-Cep1),
				 0, 0, 1,
				 0, 0, 0>
		translate  (Cht1-Cep1)*y
	}
	pigment { P_Cpt2 scale <1, 0.3, 1> translate <50, (Cht1+10), 30> }
	normal { bumps .05 scale 20 turbulence 0.1 octaves 2 }
	finish { specular .7 roughness .1 }
}

#undef Cpt2

#declare Comptoir = union {
	object { Cpt3 }
	object { Cpt1 }
}

#undef Cpt1
#undef Cpt3



#if (test_comptoir_inc)

camera {
	location <-190, 130, -350>
	angle 40
	look_at <-50, 70, -50>
}


light_source { <-300, 200, -250> rgb 1.2 }

union {
	plane { y, 0 }
	plane { -y, -251 }
	plane { -z, 0 }
	plane { -x, 0 }
	plane { x, -600 }
	plane { z, -400 }
	pigment { rgb 1 }
}

object {Comptoir translate -150*x }

#end

