#version unofficial MegaPOV 0.7;

#declare use_povman = on;

#declare OBJuvPOVmaxX =  .119285;
#declare OBJuvPOVminX = -.180539;
#declare OBJuvPOVmaxY =  .720274;
#declare OBJuvPOVminY = -.00349504;
#declare OBJuvPOVmaxZ =  .123043;
#declare OBJuvPOVminZ = -.171206;

/*
camera {
    location <-.430627, .35838948,-1.47161958>
    angle 40
    look_at <-.030627, .35838948,-.0240815>
}
light_source { <-.902695, 1.60137,-.85603>*10 rgb<1,1,1>}
light_source { < .596425, 0.60137,-.85603>*10 rgb<1,1,1>}
background {rgb<0.5,0.5,0.5>}
*/

#declare P_Pigment_Body = pigment {
	image_map { png "V2BodyMed" once }
}
#declare P_Pigment_Head = pigment {
	image_map { png "V2HeadMed" once }
}

#declare P_Trans_Head = pigment {
	image_map { tga "LongLashTRANS" once }
}

#declare OBJuvPOV_Texture = texture
{
    pigment { P_Pigment_Head }
#if (use_povman = off)
	finish { phong .2 phong_size 20 }
}
#else
}
texture {
	pigment { 
		shader {
			shader_file "skin.slp"
			"As"  <1,1,1>*0.3
			"skinColor"  <236, 180, 150>/255
			"sheenColor"  <236, 180, 150>/255
		}
	}
	finish { 
		ambient 1 
		diffuse 0
	}
}
#end

#declare OBJuvPOV_Texture_B = texture
{
    pigment { P_Pigment_Body }
#if (use_povman = off)
	finish { phong .2 phong_size 20 }
}
#else
}
texture {
	pigment { 
		shader {
			shader_file "skin.slp"
			"As"  <1,1,1>*0.3
			"skinColor"  <236, 180, 150>/255
			"sheenColor"  <236, 180, 150>/255
		}
	}
	finish { 
		ambient 1 
		diffuse 0
	}
}
#end


#declare OBJuvPOV_Texture_H2 = texture
{
	pigment {
		pigment_pattern { P_Trans_Head }
		pigment_map {
			[0 rgbt <0,0,0,1> ]
			[1 P_Pigment_Body ]
		}
	}
}

#declare OBJuvPOV_Texture_Leather = texture
{
	pigment {
		bozo turbulence .2 lambda 5
		scale .1
		color_map {
			[0 color rgb <0.302,0.157,0.102>*.7 ]
			[1 color rgb <0.404,0.212,0.137>*.7 ]
		}
	}
	normal { wrinkles poly_wave 2 scale .1 }
	finish { brilliance 1.1 specular 1.0 roughness .1 metallic }
}

#declare OBJuvPOV_Texture_Metal = texture {
	pigment {
		bozo scale 5
		warp { turbulence 1 octaves 2 lambda 5 }
		scale .5/5
		warp { turbulence 1 octaves 2 lambda 5 }
		scale .01/.5
		color_map {
			[.3 color rgb <0.576,0.624,0.620>]
			[.4 color rgb <0.431,0.478,0.475>]
			[.6 color rgb <0.431,0.478,0.475>]
			[.7 color rgb <0.729,0.796,0.765>]
		}
	}
	normal { facets size .06 turbulence .1 }
	finish { phong .2 phong_size 20 specular .4 roughness .01 }
}


#declare OBJuvPOV_Texture_Metal2 = texture
{
	pigment { color rgb <0.965,0.893,0.722> }
	finish { specular 1.0 roughness .01 metallic }
}

#declare OBJuvPOV_Texture_Spike = texture
{
	pigment { color rgb <0.765,0.733,0.722> }
	finish { specular 1.0 roughness .01 }
}


#declare OBJuvPOV_Texture_OBJuvPOVwood = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVmetal = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVmetal2 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVPlate = texture {OBJuvPOV_Texture_Metal2}
#declare OBJuvPOV_Texture_OBJuvPOVPlate2 = texture {OBJuvPOV_Texture_Metal2}

#declare OBJuvPOV_Texture_OBJuvPOVSkinBody1 = texture {OBJuvPOV_Texture_B}
#declare OBJuvPOV_Texture_OBJuvPOVSkinHead1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVEyebrows1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVLips1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVLacrimal1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVEyelashes1 = texture {OBJuvPOV_Texture_H2}
#declare OBJuvPOV_Texture_OBJuvPOVInnerMouth1 = texture {OBJuvPOV_Texture_B}
#declare OBJuvPOV_Texture_OBJuvPOVNostrils1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVTongue1 = texture {OBJuvPOV_Texture_B}
#declare OBJuvPOV_Texture_OBJuvPOVUpperEyebrows1 = texture {pigment {rgbt <0,0,0,1>}}
#declare OBJuvPOV_Texture_OBJuvPOVTeeth1 = texture {OBJuvPOV_Texture_B}
#declare OBJuvPOV_Texture_OBJuvPOVEyeballs1 = texture {pigment {rgbt <0,0,0,1.01>}}
#declare OBJuvPOV_Texture_OBJuvPOVPupils1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVEyewhites1 = texture {OBJuvPOV_Texture finish {specular .3}}
#declare OBJuvPOV_Texture_OBJuvPOVIrises1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVNipples1 = texture {OBJuvPOV_Texture_B}
#declare OBJuvPOV_Texture_OBJuvPOVFingernails1 = texture {OBJuvPOV_Texture_B}
#declare OBJuvPOV_Texture_OBJuvPOVToenails1 = texture {OBJuvPOV_Texture_B}

#declare OBJuvPOV_Texture_OBJuvPOVPlate1 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVleather1 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVStuds1 = texture {OBJuvPOV_Texture_Metal2}
#declare OBJuvPOV_Texture_OBJuvPOVtrim1 = texture {OBJuvPOV_Texture_Metal2}
#declare OBJuvPOV_Texture_OBJuvPOVstrap1 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVLeather21 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVStudds1 = texture {OBJuvPOV_Texture_Metal2}
#declare OBJuvPOV_Texture_OBJuvPOVNose1 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVLeather31 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVMetal1 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVSpike1 = texture {OBJuvPOV_Texture_Spike}
#declare OBJuvPOV_Texture_OBJuvPOVSideStrap11 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVSideStrap21 = texture {OBJuvPOV_Texture_Leather}

#declare OBJuvPOV_Texture_OBJuvPOVLeather2 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVBelt2 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVTrim2 = texture {OBJuvPOV_Texture_Metal2}
#declare OBJuvPOV_Texture_OBJuvPOVStuds2 = texture {OBJuvPOV_Texture_Metal2}

#declare OBJuvPOV_Texture_OBJuvPOVTrim3 = texture {OBJuvPOV_Texture_Metal2}
#declare OBJuvPOV_Texture_OBJuvPOVStuds3 = texture {OBJuvPOV_Texture_Metal2}
#declare OBJuvPOV_Texture_OBJuvPOVMetal3 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVBuckle3 = texture {OBJuvPOV_Texture_Leather}

#declare OBJuvPOV_Texture_OBJuvPOVBow4 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVRStrap4 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVLStrap4 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVSole4 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVFootstrap4 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVAnklestrap4 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVLoops4 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVToestrap4 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVBow5 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVRStrap5 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVLStrap5 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVSole5 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVFootstrap5 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVAnklestrap5 = texture {OBJuvPOV_Texture_Leather}
#declare OBJuvPOV_Texture_OBJuvPOVLoops5 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVToestrap5 = texture {OBJuvPOV_Texture_Leather}

#declare OBJuvPOV_Texture_OBJuvPOVCloth6 = texture {OBJuvPOV_Texture_Metal}
#declare OBJuvPOV_Texture_OBJuvPOVLeather6 = texture {OBJuvPOV_Texture_Leather}

#declare VGladiator = object
{
    #include "VGladiator.msh"
    translate -OBJuvPOVminZ*z
    scale 175/OBJuvPOVmaxY
}

//object {VGladiator}
