#version unofficial MegaPOV 0.7;

#declare OBJuvPOVmaxX =  .126404;
#declare OBJuvPOVminX = -.127113;
#declare OBJuvPOVmaxY =  .652868;
#declare OBJuvPOVminY =  0;
#declare OBJuvPOVmaxZ =  .0480896;
#declare OBJuvPOVminZ = -.0312323;

/*
camera {
    location <300, 160, -400>
    angle 25
    look_at <0, 120, 0>
}

light_source { <500, 600, -400>*5 rgb<1,1,1> }
light_source { <600, 200, -100>*5 rgb<1,1,1>*.6 }

background {rgb<0.5,0.5,0.5>}
*/

#include "wizardrobe2.msh"

#include "cintre.inc"
/*
#declare T_trim = texture {pigment { color rgb <1, .99, .9> }}
#declare T_coat = texture {pigment { color rgb <.9, .95, 1> }}


#declare WizardRobe1 = union
{
	#include "wrobe.inc"
	translate -OBJuvPOVmaxY*y
	scale 150/OBJuvPOVmaxY
}
*/



/*
union {
	object { WizardRobe1 scale <-1, 1, 1>}
	object { Cintre1 translate <0, 1, 3.3> }
	translate 150*y
}
*/


#macro WizardRobe(pig1, pig2, rnd)

#declare T_coat = texture {pigment { pig1 } normal {granite .3 scale .02} finish {specular .2 roughness .1} translate (-1+2*rand(rnd))*x }
#declare T_trim = texture {pigment { pig2 } finish {specular .5 roughness .05} }

#declare WizardRobe_tmp = union
{
	#include "wrobe.inc"
	translate -OBJuvPOVmaxY*y
	scale 150/OBJuvPOVmaxY
	#if (rand(rnd)>.5)
	scale <1, (1+.1*rand(rnd))/(1+.1*rand(rnd)), 1>
	#else
	scale <-1, (1+.1*rand(rnd))/(1+.1*rand(rnd)), 1>
	#end
}

union {
	object { WizardRobe_tmp }
	object { Cintre1 translate <0, 1, 3.3> }
}

#end


//===================================
//	TEXTURE ETOILES ET LUNES
//===================================
// etoile
#declare obj1 = union {
	intersection {
		box { -.4, .4 translate .2*y }
		box { -.4, .4 translate .2*y rotate z*120 }
		box { -.4, .4 translate .2*y rotate -z*120 }
	}
	intersection {
		box { -.4, .4 translate -.2*y }
		box { -.4, .4 translate -.2*y rotate z*120 }
		box { -.4, .4 translate -.2*y rotate -z*120 }
	}
	scale .5
}
// lune
#declare obj2 = difference {
	cylinder { <0,0,-10>, <0,0,10>, 2 translate 3.5*x }
	cylinder { <0,0,-10>, <0,0,10>, 2.5 translate 5.0*x }
	scale .1
}

#macro Pig2(rot)
#local stl = seed(12*rot);
#local obj = object {
	#if (rand(stl) > .4)
		obj1
	#else
		obj2
	#end
	rotate  z*rot
	translate (-.2+.4*rand(stl))*x
	rotate  z*rot
}
	// definition du pigment
	object {
		obj
		color rgb 0, color rgb 1
	}
	translate .5*x + .5*y
	warp { repeat x }
	warp { repeat y }
#end

#declare st_p = seed(352);
#declare PigEtoiles = pigment {
	pigment_pattern {
		cells
		translate -z*.5 + 100*y + 100*x
	}
	pigment_map {
		#local rot = 360*rand(st_p);
		[0.05 Pig2(rot)]
	#local i=0.05;
	#while (i<.95)
		#local rot = 360*rand(st_p);
		[i Pig2(rot)]
		#local i=i+.05;
		[i Pig2(rot)]
	#end
		#local rot = 360*rand(st_p);
		[0.95 Pig2(rot)]
	}
	scale <1, 1, 2000>
}


#declare T_Etoiles = texture {
	pigment { PigEtoiles scale <1/20*pi,1,1> warp { cylindrical dist_exp 1} }
//	pigment { checker color rgb 0, color rgb 1 scale <1/10*pi,1,1> warp { cylindrical dist_exp 1} }
	normal { dents .4 scale 3 }
	finish { specular .3 roughness .01 metallic reflection .2 reflect_metallic }
}


#declare WRpigcoat = array[7]
#declare WRpigtrim = array[7]

#declare WRpigcoat[0] = pigment { pigment_pattern {PigEtoiles scale .08 translate 1*x } color_map {[.1 rgb <0,196,197>/255][.9 rgb <176, 68, 157>/255]} }
#declare WRpigtrim[0] = pigment { color rgb <176, 68, 157>/255 }
#declare WRpigcoat[1] = pigment { pigment_pattern {PigEtoiles scale .08 translate 2*x } color_map {[.1 rgb <196,132, 74>/255][.9 rgb <109,145, 100>/255]} }
#declare WRpigtrim[1] = pigment { color rgb <109,145, 100>/255 }
#declare WRpigcoat[2] = pigment { pigment_pattern {PigEtoiles scale .08 translate 3*x } color_map {[.1 rgb <0, 0, 0>/255][.9 rgb <227,218,43>/255]} }
#declare WRpigtrim[2] = pigment { color rgb <227,218,43>/255 }
#declare WRpigcoat[3] = pigment { pigment_pattern {PigEtoiles scale .08 translate 4*x } color_map {[.1 rgb <18,6,159>/255][.9 rgb <44,235,10>/255]} }
#declare WRpigtrim[3] = pigment { color rgb <44,235,10>/255 }
#declare WRpigcoat[4] = pigment { pigment_pattern {PigEtoiles scale .08 translate 5*x } color_map {[.1 rgb <207,54,37>/255][.9 rgb <255,255,66>/255]} }
#declare WRpigtrim[4] = pigment { color rgb <255,255,66>/255 }
#declare WRpigcoat[5] = pigment { pigment_pattern {PigEtoiles scale .08 translate 6*x } color_map {[.1 rgb <109,37,37>/255][.9 rgb <26,77,64>/255]} }
#declare WRpigtrim[5] = pigment { color rgb <26,77,64>/255 }
#declare WRpigcoat[6] = pigment { pigment_pattern {PigEtoiles scale .08 translate 7*x } color_map {[.1 rgb <54,81,50>/255][.9 rgb <142,83,54>/255]} }
#declare WRpigtrim[6] = pigment { color rgb <142,83,54>/255 }


#declare wr_seed = seed(4321);

#declare WR1 = union {

object {
	WizardRobe(WRpigcoat[0], WRpigtrim[0], wr_seed)
	translate -12*y
	rotate (-.5+rand(wr_seed))*15*z
	translate 12*y
	translate 150*y
}

object {
	WizardRobe(WRpigcoat[0], WRpigtrim[1], wr_seed)
	translate -12*y
	rotate (-.5+rand(wr_seed))*15*z
	translate 12*y
	translate 150*y +11*z
}

object {
	WizardRobe(WRpigcoat[1], WRpigtrim[0], wr_seed)
	translate -12*y
	rotate (-.5+rand(wr_seed))*15*z
	translate 12*y
	translate 150*y+23*z
}

object {
	WizardRobe(WRpigcoat[1], WRpigtrim[1], wr_seed)
	translate -12*y
	rotate (-.5+rand(wr_seed))*15*z
	translate 12*y
	translate 150*y+33*z
}

cylinder { <0, 161, -10>, <0, 161, 40>, 1 pigment {rgb .7} }

}

