             /* 
#include "colors.inc"
#include "metals.inc"
#include "skies.inc"
#include "textures.inc"   
camera {location <0,30,0> look_at<0,0,0>}
light_source {<95,600,-35> color White*.8 shadowless}
//light_source {<-400,600,-150> color White*.8 shadowless}
sky_sphere{S_Cloud2}
               */ 
#declare basin =
        union {  
                difference {
                        torus {9,1}
                        box {<-12,-12,-12>,<12,0,12>}
                        }
                difference {
                        sphere {<0,0,0>,8.2}
                        box {<-12,0,-12>,<12,12,12>}
                        sphere {<0,0,0>,8}
                        }
                //pigment {color White} finish {reflection 0 phong 1}
                texture {
                        crackle 
                                texture_map { 
                                [ 0.0 pigment {color White *.9} ] 
                                [ 0.01 pigment {color White *.75} ] 
                                [ 0.04 pigment {color White}  ]
                                [ 0.9 pigment {color White}  ]
                                }
                        scale .4
                        }
                //finish {specular .1 roughness .2}
          } 
                
//water surface 
#declare water =
plane {y, -.7
        texture {
                pigment {
                        spotted
                        color_map {
                                [0.0 rgbf <.85, 0, 0, .9>]
                                [0.01 rgbf <.9, 0, 0, 1>] 
                                [0.2 rgbf <.95, 0, 0, 1>]
                                [0.6 rgbf <1.0, 1.0, 1.0, 1.0>]
                                }
                turbulence 1
                omega .6
                octaves 30
                scale 30
                }
  
        finish {phong 1 phong_size 90 diffuse 0 reflection .2} 
        normal {ripples scale 2000 frequency 2000}
        }    
        interior { 
                ior 1.33
                media {
                        absorption <.1, .05, .05>
                        samples 2, 2
                        }
                }
                
        texture {
                pigment {
                        spotted
                                color_map {
                                        [0.0 rgbf <1,1,1,0>]
                                        [0.05 rgbf <1,1,1,.2>]
                                        [0.075 rgbf <1,1,1,.3>]
                                        [0.15 rgbf <1,1,1,1>] 
                                        [1.0 rgbf <1,1,1,1>]  
                                        }
                        rotate 90*y
                        translate 1*y
                        turbulence 1 
                        omega .6
                        octaves 100
                        frequency 1
                        scale 20
                        }
                }            
        hollow
        clipped_by{sphere {<0,0,0>,8}}
        }
        
#declare Cream =
union {
        blob {
                threshold 0.6
                sphere { < 0,   0,    0>, 1,1}
                sphere { <.1,  0.1, 0>, 1,1 scale 2*z}
                sphere { <0, 0, -.3>, 1,1 scale .5*z}
                sphere {<0,0,0>,1,.6 scale <.5,1,1.5> } 
                pigment {color White}
                finish {phong 1} 
                scale <1,.6,1.2>
                translate <-.2,-1.05,.3>
                }
        blob {
                threshold 0.6
                sphere { < 0,   0,    0>, 1,1}
                sphere { <.1,  0.1, 0>, 1,1 scale 2*z}
                sphere { <0, 0, -.3>, 1,1 scale .5*z}
                sphere {<0,0,0>,1,.6 scale <.5,1,1.5> } 
                sphere { <0,0,0>, 1,1 scale <.8,1.5,10>}
                rotate 5*y
                pigment {color White}
                finish {phong 1} 
                scale <5,.6,1.2>
                translate <-2,-1,-8>
                rotate 25*y
                }
        clipped_by{plane {y, .7} rotate 180*x}
        clipped_by{sphere {<0,0,0>,8}}         
        }         

#declare sink = 
  union {
        object {basin}
        object {water}
        object {Cream}
        }  
        
//object {sink scale <1.5,1,1.5> rotate -110*y}            
                
               