// Persistence of Vision Ray Tracer Scene Description File
// File: DragonTex.inc
// Vers: 3.1
// Desc: Textures for the dragon cave
// Date: 14 August 2001
// Auth: Gail Shaw

#version unofficial MegaPov 0.7;  

#include "kolors.inc"   
#include "stones1.inc"
#include "metals.inc"

#declare F_Noise=function {noise3d(x*2,y*2,z*2)}

#macro m_strata(freq,amnt)  // by Samuel T Benge 
 function{noise3d(y*freq+noise3d(y+noise3d(x*4,y*4,z*4),z,x)*amnt,0,0)}
#end

#declare T_Dirt=
 texture {
  pigment {
   function {F_Noise(x/1.5,0,z/1.5)} 
   turbulence 0.05
   pigment_map {
    [0.3  bozo   
          scale 0.25
          color_map {
           [0.0 rgb <0.419,0.242,0.168>]
           [1.0 rgb <0.46,0.281,0.218>]
          }
    ]
    [1.0  bozo  
          turbulence 0.4
          scale 0.5
          color_map {
           [0.0 rgb <0.489,0.315,0.247>]
           [1.0 rgb <0.5598,0.408,0.30>]
          }
    ]           
   }
   warp { reset_children } 
  }
  finish {ambient 0.075 diffuse 0.7}
  normal {
   bozo    
   scale 0.25
   turbulence 0.5
   normal_map {
    [0.0 bumps 0.35 scale 0.075]
    [0.5 bumps 0.4 scale 0.05]
    [1.0 bumps 0.5 scale 0.1]
   } 
  }
 }
 texture {
  pigment {
   bozo     
   scale 0.005
   color_map {
    [0.0 rgbt 1]
    [1.0 rgbt <0.7,0.5,0.4,0.5>]
   }
  }
 }

#declare Jewel= 
 //material {
  texture {
   pigment {
    rgbf<0,0,0.5,0.5>
   }
   finish {
    specular 0.8
    roughness 0.001
    diffuse 0.6
    ambient 0.25
    reflection 0.2
   }
  }
  //interior {ior 1.77}
 //}

#declare T_Burnt=
 texture {
  pigment {
   wrinkles
   color_map {
    [0.0 rgbt<0.1,0.1,0.1,0.1>]
    [0.2 rgbt<0.2,0.2,0.2,0.2>]
    [0.4 rgbt<0.3,0.3,0.3,0.4>]
    [0.5 rgbt<0.5,0.5,0.5,0.8>]
    [0.65 rgbt<1,1,1,1>]
    [1.0 rgbt<1,1,1,1>]
   }       
   turbulence 0.2
   scale <0.5,1,0.5>
   rotate z*35
   translate x*5  
  }
 }
 
#declare T_Burnt2=
 texture {
  pigment {
   wrinkles
   color_map {
    [0.0 rgbt<0.1,0.1,0.1,0>]
    [0.2 rgbt<0.2,0.2,0.2,0>]
    [0.4 rgbt<0.3,0.3,0.3,0.2>]
    [0.6 rgbt<0.5,0.5,0.5,0.4>]
    [0.75 rgbt<1,1,1,1>]
    [1.0 rgbt<1,1,1,1>]
   }       
   turbulence 0.2
   scale <0.5,1,0.5>
   rotate z*35
   translate x*5  
  }
 } 

#declare T_Bone=
 texture {
  pigment {rgb <1,1,0.9>}
 }

#declare T_Pebbles1=  // based on T_Stone11
 texture{pigment{color Black}}
 texture{
  pigment {
   granite
   turbulence 0.6
   color_map {
     [0.000, 0.154   color rgbf <0.996, 0.824, 0.780, 0.412>
                     color rgbf <0.996, 0.698, 0.624, 0.412>]
     [0.154, 0.308   color rgbf <0.996, 0.698, 0.624, 0.412>
                     color rgbf <0.906, 0.675, 0.553, 0.616>]
     [0.308, 0.444   color rgbf <0.906, 0.675, 0.553, 0.616>
                     color rgbf <0.996, 0.682, 0.604, 0.412>]
     [0.444, 0.615   color rgbf <0.996, 0.682, 0.604, 0.412>
                     color rgbf <0.996, 0.824, 0.780, 0.412>]
     [0.615, 0.812   color rgbf <0.996, 0.824, 0.780, 0.412>
                     color rgbf <0.973, 0.627, 0.627, 0.600>]
     [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.600>
                     color rgbf <0.996, 0.824, 0.780, 0.412>]
    }
  }
  scale <1.2, 3, 1.5> rotate <70, 0, 30>   
 }
 texture{
  pigment {
   granite
   turbulence 0.6
   color_map {
    [0.000, 0.144   color rgbf <0.863, 0.757, 0.596, 0.596>
                    color rgbf <0.925, 0.792, 0.714, 0.349>]
    [0.144, 0.288   color rgbf <0.925, 0.792, 0.714, 0.349>
                    color rgbf <0.871, 0.702, 0.659, 0.784>]
    [0.288, 0.644   color rgbf <0.871, 0.702, 0.659, 0.784>
                    color rgbf <0.992, 0.922, 0.659, 0.498>]
    [0.644, 0.983   color rgbf <0.992, 0.922, 0.659, 0.498>
                    color rgbf <0.902, 0.812, 0.714, 0.722>]
    [0.983, 1.001   color rgbf <0.902, 0.812, 0.714, 0.722>
                    color rgbf <0.863, 0.757, 0.596, 0.596>]
   }
  } 
  scale <3, 3, 4> rotate <0, 0, 40>
 }
 texture {
  pigment {
  marble
  turbulence 0.85
  color_map {
    [0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color Scarlet filter 0.80 color DimGray filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
  } 
  scale <1, 2, 1.4> rotate <10, 0, -20>
 } 
 
#declare T_Pebbles2=  // based on T_Stone11
 texture{pigment{color VeryDarkBrown}}
 texture{
  pigment {
   granite
   turbulence 0.6
   color_map {
     [0.000, 0.154   color rgbf <0.996, 0.824, 0.780, 0.412>
                     color rgbf <0.996, 0.698, 0.624, 0.412>]
     [0.154, 0.308   color rgbf <0.996, 0.698, 0.624, 0.412>
                     color rgbf <0.906, 0.675, 0.553, 0.616>]
     [0.308, 0.444   color rgbf <0.906, 0.675, 0.553, 0.616>
                     color rgbf <0.996, 0.682, 0.604, 0.412>]
     [0.444, 0.615   color rgbf <0.996, 0.682, 0.604, 0.412>
                     color rgbf <0.996, 0.824, 0.780, 0.412>]
     [0.615, 0.812   color rgbf <0.996, 0.824, 0.780, 0.412>
                     color rgbf <0.973, 0.627, 0.627, 0.600>]
     [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.600>
                     color rgbf <0.996, 0.824, 0.780, 0.412>]
    }
  }
  scale <1.2, 3, 1.5> rotate <70, 0, 30>   
 }
 texture {
  pigment {
   granite
   turbulence 0.6
   color_map {
    [0.000, 0.216   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.745, 0.843, 0.835, 0.847>]
    [0.216, 0.241   color rgbf <0.745, 0.843, 0.835, 0.847>
                    color rgbf <0.404, 0.337, 0.337, 0.463>]
    [0.241, 0.267   color rgbf <0.404, 0.337, 0.337, 0.463>
                    color rgbf <0.773, 0.729, 0.745, 0.622>]
    [0.267, 0.759   color rgbf <0.773, 0.729, 0.745, 0.622>
                    color rgbf <0.914, 0.843, 0.725, 0.651>]
    [0.759, 0.784   color rgbf <0.914, 0.843, 0.725, 0.651>
                    color rgbf <0.153, 0.133, 0.208, 0.437>]
    [0.784, 0.810   color rgbf <0.153, 0.133, 0.208, 0.437>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
    [0.810, 1.001   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
   }
  } 
  scale <3, 3, 4> rotate <0, 0, 40>
 }
 texture {
  pigment {
  granite
  turbulence 0.8
  color_map
   {[0.0, 0.5   color Clear color Clear]
    [0.5, 0.54   color Clear color Black]
    [0.54, 1.0 color Clear color Clear]
   }
 } 
  scale <1, 2, 1.4> rotate <10, 0, -20>
 } 
 
