// Persistence of Vision Ray Tracer Scene Description File
// File: Dragons.inc
// Vers: 3.1
// Desc: Objects for the dragon cave
// Date: 14 August 2001
// Auth: Gail Shaw

#version unofficial MegaPov 0.7;  

#include "DragonTex.inc"
#include "swords.inc"
#if (ShowDragon=1)
 #include "dragon.inc"
#end
#if (ShowPerson=1)
 #include "adventurer.inc"
#end

#declare rnd=seed(7281);
#declare rndPos=seed(8382);  //seed(8381); 
//#declare F_RMF=function {"ridgedmf", <0.1, 3.0, 7, 0.7, 0.7>}
//#declare F_Path=function {pigment {image_map {tga "pathsmoothbig.tga" interpolate 2} rotate x*90 scale <26,1,30> translate <-9.9,0,-10>}}
/* height_field {tga "path.tga" smooth scale <26,0.5,30> translate <-9.7,-0.1,-10> pigment {Yellow}}
 sphere {<-4,0,1.45>,1 pigment {Red}}
 sphere {<2,0,-4>,1 pigment {Red}}
 sphere {<-3.6,0,1.1>,1 pigment {Red}}
 sphere {<-5.5,0,1>,1 pigment {Red}}
*/
#declare F_Para= function {-y^2-x+1}
#declare F_Para2= function {-y^2-x-0.2}


#if (IsoFloor=1) 
 #declare Soil=
  isosurface {
   function {
    (if(z-16,
     y-0.75*cos(0.5*(z-16))+0.75,
     y
    )
    -F_Noise(x/5-1,0,z/5)*0.15-F_Noise(x/1.5,0,z/1.5)*0.2-F_Wrinkles(x*5,y*5,z*5)*0.05+F_Path(x,0,z)*0.4 + 0.075)*
    (
     ((0.55*(x+4))^2+(0.6*y)^2+(0.55*(z-1.5))^2-0.1) |
     ((0.5*(x-2))^2+(0.7*y)^2+(0.5*(z+4))^2-0.1) |
     ((0.5*(x+4))^2+(0.7*y)^2+(0.5*(z-14))^2-0.125) |
     ((0.5*(x+3.6))^2+(0.7*y)^2+(0.5*(z-1.1))^2-0.075) |
     ((0.5*(x+5.5))^2+(0.7*y)^2+(0.5*(z-1))^2-0.075)
    )-1/50 
   }
   method 2
   max_gradient 100  
   //eval              
   //method 1
   contained_by {box {<-13,-1,-8>,<13,1,18>}}
   //texture {T_Dirt scale 0.5 }
   texture {
    pigment {
     planar
     color_map {[0.0 rgb 1][1.0 rgb 0]}
     translate y*-0.4
     scale 1.25
    }
    finish {ambient 1}
   }
  }
  
#else
 #if ((ShowRemains=1) | (ShowFloor=1) | (ShowPebbles=1))
  #declare Soil=
   height_field {
    tga "dragonheightsmooth.tga"     
    water_level 0.01        
    smooth        
    double_illuminate 
    hierarchy on
    scale <26,1.25,26>
    translate <-13,-0.4,-8>
    texture {T_Dirt scale 0.5 }
   }
 #end
#end

#declare Rock=
 isosurface {
  function {if(z-16,y-0.75*cos(0.5*(z-16))+0.75,y)-F_Wrinkles(x*1.5,0,z*1.5)*0.2}
  method 2
  eval
  contained_by {box {<-12,-1,-8>,<12,1,18>}}
  pigment {                                      
   m_strata(5,1.5)
   color_map {
     [0.0 color rgb <0.6, 0.2, 0.2>]
     [0.2 color rgb <0.4, 0.15, 0.15>]
     [0.8 color rgb <0.75, 0.45, 0.2>]
     [1.0 color rgb <0.6, 0.3, 0.15>]
   }
   scale 0.25
  }
 } 

#if ((ShowRemains=1)  | (ShowPebbles=1))
 #declare Land=
  //union {
  object {
   Soil 
   translate <12,-0.02,8>
  }
#end


#declare Walls=
 isosurface {
  function {(0.8*x)^2+(2*y)^2+(0.18*z)^2 - 350 + noise3d(x/10,y/10,z/10)*20 + noise3d(x/7,0,z/9)*10 +noise3d(x/3,0,z/3)*5 + noise3d(y+noise3d(x*4,y*4,z*4),z,x)*4 - F_Wrinkles(x*1.5,y*1.5,z*1.5)*0.2}
  sign -1                         
  contained_by {sphere {0,150}}
  texture {
   pigment {                                      
    m_strata(4,1.5)
    color_map {
     [0.0 color rgb <0.6, 0.2, 0.2>]
     [0.2 color rgb <0.5, 0.175, 0.15>]
     [0.8 color rgb <0.75, 0.45, 0.2>]
     [1.0 color rgb <0.6, 0.3, 0.15>]
    }
    scale 0.5
   }
   finish {diffuse 0.8}
   normal {granite scale 1.5}
  }
  texture {
   pigment {                                    
    m_strata(4,1.5)
    turbulence 0.2  
    color_map {
     [0.0 color rgbt <0.6, 0.2, 0.2,0.4>]
     [0.2 color rgbt <0.5, 0.175, 0.15,0.9>]
     [0.8 color rgbt <0.75, 0.45, 0.2,0.5>]
     [1.0 color rgbt <0.6, 0.3, 0.15,1>]
    }
    scale 5
   }
  }
 }

/*#declare Walls= 
 //union {
  isosurface {
   #if (SimplifiedFunc=0)
     function {x - sin(z/10) -z*0.2 -noise3d(0,y,z) - noise3d(0,y/4,z/4)*1.5 - F_Wrinkles(x*1.5,0,z*1.5)*0.2 + 25}
   #else
     function {x - sin(z/7.5) -z*0.2 + 25}
   #end     
   contained_by {box {<-30,-2,-10>,<-20,30,100>  }}
   pigment {                                      
    m_strata(4,1.5)
    color_map {
     [0.0 color rgb <0.6, 0.2, 0.2>]
     [0.2 color rgb <0.5, 0.175, 0.15>]
     [0.8 color rgb <0.75, 0.45, 0.2>]
     [1.0 color rgb <0.6, 0.3, 0.15>]
    }
    scale 0.5
   }
   finish {diffuse 0.75 ambient 0.5}
  }*/
 
#macro Pebble(Scaling)
 #local rnd=seed(3275);
 #local Pos=<RndRange(rnd,5,-5),100,RndRange(rnd,5,-5)>;       
 #local TransX=(rand(rnd)-0.5)*10;
 #local TransY=(rand(rnd)-0.5)*10;
 #local TransZ=(rand(rnd)-0.5)*10;
 isosurface {
  function {x^2+y^2+z^2-1 -noise3d(x*1.5+TransX,y*1.6+TransY,z*1.55+TransZ)*2 + noise3d(x*3+TransX/2,y*3+TransY/3,z*3+TransZ/1.5)*0.25}
  method 2
  max_gradient 50
  contained_by {sphere {0,2.5}} 
  #local YScale=RndRange(rnd,0.25,1.25);
  scale Scaling*<RndRange(rnd,0.5,2),YScale,RndRange(rnd,0.5,2)>
  rotate <RndRange(rnd,-30,30),0,RndRange(rnd,-30,30)>
  rotate y*RndRange(rnd,0,360)
  translate y*Scaling*YScale
 }
 //sphere {0,0.0375}
#end

#declare Coin=
 union {
  cylinder {
   <0,-0.05,0>,<0,0.05,0>,0.5
  } 
  height_field {
   png "CoinBump.png"
   water_level 0.01
   scale <0.975,0.01,0.975>
   translate <-0.47,0.049,-0.49>
  }
  difference {
   cylinder {
    <0,-0.06,0>,<0,0.06,0>,0.52
   }
   cylinder {
    <0,-0.07,0>,<0,0.07,0>,0.495
   }
  }
  scale 0.025 
 }
 
#macro Column(Height)
 isosurface {
  // function {F_Para(sqrt(x^2+z^2),0.125*y,z)-noise3d(x*2,y*5,z*2)*0.2 + noise3d(x,y,z)*0.4 +noise3d(x/1.5,y/1.5,z/1.5)*0.3}
  #if (SimplifiedFunc=0)
    function {F_Para(sqrt(x^2+z^2),Height*y,z)-noise3d(y*1+noise3d(y+noise3d(x*4,y*4,z*4),z,x),0,0)*0.4 + noise3d(x,y,z)*0.6 +noise3d(x/1.5,y/1.5,z/1.5)*0.3-noise3d(x*4,y*4,z*4)*0.075+noise3d(x*8,y*8,z*8)*0.035}
  #else
    function {F_Para(sqrt(x^2+z^2),Height*y,z)}
  #end    
  method 1
  sign -1
  contained_by {box {<-2,-1/Height,-2>,<2,1/Height,2>}}
  pigment {                                      
   m_strata(1,1)
   /*color_map {
    [0.0 color rgb <0.6, 0.2, 0.2>]
    [0.2 color rgb <0.4, 0.15, 0.15>]
    [0.8 color rgb <0.75, 0.45, 0.2>]
    [1.0 color rgb <0.6, 0.3, 0.15>]
   }*/
   color_map {
    [0.0 color rgb <0.6, 0.2, 0.2>]
    [0.2 color rgb <0.5, 0.175, 0.175>]
    [0.8 color rgb <0.7, 0.35, 0.2>]
    [1.0 color rgb <0.5, 0.25, 0.175>]
   }
   scale 0.25
  }
  finish {diffuse 0.55 brilliance 1.2 }//specular 0.05 roughness 0.02}
  normal {granite 0.1 scale 0.1} 
 }
#end

#declare Column2=
 isosurface {
  #if (SimplifiedFunc=0)
   function {F_Para2(sqrt(x^2+z^2),0.13*y,z)-noise3d(y*1.5+noise3d(y+noise3d(x*4,y*4,z*4),z,x),0,0)*0.2 + noise3d(x,y,z)*0.8 +noise3d(x/1.5,y/1.5,z/1.5)*0.5-noise3d(x*4,y*4,z*4)*0.075+noise3d(x*8,y*8,z*8)*0.035}
  #else
   function {F_Para2(sqrt(x^2+z^2),0.13*y,z)}
  #end
  method 1
  sign -1
  contained_by {box {<-2,0.5,-2>,<2,8,2>}}
  pigment {                                      
   m_strata(1.5,1)
   color_map {
    [0.0 color rgb <0.6, 0.2, 0.2>]
    [0.2 color rgb <0.5, 0.175, 0.175>]
    [0.8 color rgb <0.7, 0.35, 0.2>]
    [1.0 color rgb <0.5, 0.25, 0.175>]
   }
   scale 0.25
  }
  normal {granite 0.1 scale 0.1}
 }

#declare Sword=
 union {
  object {SwordBlade scale <1.5,1,0.8>}
  object {Hilt3 scale <1.1,1,0.8> pigment {Brown*1.1}}
  object {Guard6 scale <1,1.1,1> texture {T_Gold_4D} }
  object {Pommel4 scale <1.1,1,1.21> translate y*0.02 texture {T_Gold_4D}}
  texture {BladeTex} texture {T_Burnt scale 0.4}
 }

#declare KiteShieldBase=
 difference {  
  intersection {
   cylinder {
    <0,-3.1,0>,<0,3.1,0>,4
   }
   cylinder {
    <2.88,0,-5>,<2.88,0,5>,4.2
   }
   cylinder {
    <-2.88,0,-5>,<-2.88,0,5>,4.2
   }    
  }          
  union {
   cylinder {
    <0,-3.6,0>,<0,3.6,0>,3.9 
    //texture {T_Chrome_1B}
   }
   cylinder {
    <-1.8,2.2,-5>,<-1.8,2.2,5>,2
   } 
   cylinder {
    <1.8,2.2,-5>,<1.8,2.2,5>,2
   }                       
   box {
    <-10,-10,0>,<10,10,10>
   }
  }
 }
 
#declare KiteShield= 
 union {
  object {
   KiteShieldBase
   texture {T_Silver_3B normal {dents 0.25 scale 0.2}}
   texture {T_Burnt}
  }
  object {
   KiteShieldBase
   translate z*-0.01
   //texture {T_Silver_3B normal {dents 0.25 scale 0.2}}
   pigment {
    image_map {png "eagle1.png" transmit 255,1 once} 
    translate <-0.5,-0.5,0> 
    rotate z*2 
    translate <0.005,-0.1,0> 
    scale 8
   }
  }
  intersection {
   object {KiteShieldBase scale 1.008}
   union {
    cylinder {
     <2.88,0,-5>,<2.88,0,5>,4.0
     inverse
    }
    cylinder {
     <-2.88,0,-5>,<-2.88,0,5>,4.0
     inverse
    }
    cylinder {
     <-1.8,2.2,-5>,<-1.8,2.2,5>,2.2
    } 
    cylinder {
     <1.8,2.2,-5>,<1.8,2.2,5>,2.2
    }
   }
   texture {T_Gold_3D}
   texture {T_Burnt}   
  }
  union {
   sphere {
    <0,1.05,-4>,0.07
   }                
   sphere {
    <0,-2.9,-4>,0.07
   }
   sphere {
    <-1.22,0.14,-3.81>,0.07
   }
   sphere {
    <1.22,0.14,-3.81>,0.07
   }                
   sphere {
    <0.9,0.3,-3.9>,0.07
   } 
   sphere {
    <-0.9,0.3,-3.9>,0.07
   }
   sphere {
    <0.59,0.48,-3.95>,0.07
   }
   sphere {
    <-0.59,0.48,-3.95>,0.07
   }
   sphere {
    <0.28,0.72,-3.99>,0.07
   }
   sphere {
    <-0.28,0.72,-3.99>,0.07
   }
   sphere {
    <-1.2,-0.2,-3.81>,0.07
   }
   sphere {
    <1.2,-0.2,-3.81>,0.07
   }
   sphere {
    <1.17,-0.55,-3.82>,0.07
   }
   sphere {
    <-1.17,-0.55,-3.82>,0.07
   }
   sphere {
    <1.12,-0.9,-3.84>,0.07
   }
   sphere {
    <-1.12,-0.9,-3.84>,0.07
   }
   sphere {
    <-1.04,-1.25,-3.86>,0.07
   }
   sphere {
    <1.04,-1.25,-3.86>,0.07
   }
   sphere {
    <0.93,-1.55,-3.88>,0.07
   }
   sphere {
    <-0.93,-1.55,-3.88>,0.07
   }
   sphere {
    <-0.8,-1.85,-3.9>,0.07
   }
   sphere {
    <0.8,-1.85,-3.9>,0.07
   }
   sphere {
    <-0.64,-2.15,-3.93>,0.07
   }
   sphere {
    <0.64,-2.15,-3.93>,0.07
   }	  
   sphere {
    <0.42,-2.41,-3.97>,0.07
   }
   sphere {
    <-0.42,-2.41,-3.97>,0.07
   }
   sphere {
    <0.22,-2.66,-3.98>,0.07
   }
   sphere {
    <-0.22,-2.66,-3.98>,0.07
   }
   texture {T_Chrome_2A} 
   texture {T_Burnt}
  }
  translate <0,0.95,4>
  scale 0.18
 }
 
#declare Torch=
 union {
  cone {
   <0,0,0>,0.005,<0,0.2,0>,0.01
   texture {
    granite
    scale 0.01
    texture_map {
     [0.0 T_Chrome_1A]
     [1.0 T_Chrome_3D]
    }
   }
  }
  cylinder {
   <0,0.2,0>,<0,0.25,0>,0.02
  } 
  #declare i=0;
  #while (i<20)
   torus {
    0.02,0.0025
    rotate <RndRange(rnd,10,-10),0,RndRange(rnd,10,-10)>
    rotate y*RndRange(rnd,180,-180)
    translate y*RndRange(rnd,0.2025,0.2495)
   }
   #declare i=i+1;
  #end
  sphere {
   <0,0,0>,0.02
   scale <1,0.5,1>
   translate y*0.2
  }
  sphere {
   <0,0,0>,0.02
   scale <1,0.5,1>
   translate y*0.25
  }
  cylinder {
  <0,-0.5,0>,<0,1.25,0>,0.4
  hollow
  pigment {rgbf 1}
  interior {
   media {    
    emission <1,0.75,0.5>*6
    absorption <0.5,0.25,1>*8
    method 3
    samples 1,1 
    intervals 5
    density { 
     spherical
     scallop_wave
     turbulence 0.35
     color_map  {
       [0.0 color rgb <0, 0, 0>]
       [0.25 color rgb <1,0.5,0.2>*1.75]
       [0.5 color rgb <1,0.6,0>*2]
       [0.5 color rgb <1,0.25,0>*2]
       [1.0 color rgb <1,0.85,0.7>*3]
     }
     scale <0.21,0.8,0.21>
    }
   }
  }
  scale 0.1
  translate y*0.26
  no_shadow
 }
}