// Persistence of Vision Ray Tracer Scene Description File
// File: Dragons.pov
// Vers: unofficial megapov 0.7
// Desc: Here there be dragons
// Date: 7 July 2001
// Auth: Gail Shaw

#version unofficial MegaPov 0.7;   

#declare SimplifiedFunc=0;
#declare IsoFloor=0;
#declare ShowColumns=0;
#declare ShowPebbles=0;
#declare ShowWalls=1;    
#declare ShowDragon=1;
#declare ShowFloor=1;
#declare ShowRemains=1;
#declare ShowPerson=0;
#declare Final=1;

#if (Final=1)
 #declare SimplifiedFunc=0;
 #declare ShowColumns=1;
 #declare ShowPebbles=1;
 #declare ShowWalls=1;    
 #declare ShowDragon=1;
 #declare ShowFloor=1;
 #declare ShowRemains=1;
 #declare ShowPerson=0;
#end

#include "macros.inc"
#include "macros\reorient.mcr"      // by John VanSickle
#include "clutter\clutter.mcr"      // by Jonathan Rafael Ghiglia
#include "pcm\pcm.mcr"              // by Chris Colefax
#include "Dragons.inc"  

#declare SceneCamera=
 camera {
  location <0.3,0.5,-7.45> // was y=0.8, z=-7.5 x=0.2
  look_at <-0.3,1.2,0>  // was y=1 x=-0.2
 }
 
#declare HighCamera=
 camera {
  location <0,2,-7.5>
  look_at <0,1,0>
 }

#declare HelmCamera=
 camera {
  location <1.25,0.75,-5.5>
  look_at <1.6,0.4,-3.5>
  angle 35
 }

#declare DragonCamera=
 camera {
  location <5.5,6,3.5> 
  look_at <2,5,5.5>
 }

#declare TopCamera=
 camera {
  location <0,28,5>
  look_at <0,0,5>
  sky z
  up z
  right x
  orthographic
 }
 
camera {
 SceneCamera
} 
 
global_settings {
 //ini_option "Height=2000"
 //ini_option "Width=2000"
 //hf_gray_16
 max_trace_level 20
 ambient_light 0.25
 /*radiosity{
    pretrace_start 0.08
    pretrace_end   0.04
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1.8      // CHANGE - range from 1 to 3
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/1.2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }*/
}
 
light_source {
 <-0.2,0.41,-6.3>
 rgb <0.969,0.914,0.91>*0.55
 #if (Final=1)
  area_light <0.2,0,0>,<0,0.2,0>,3,3
  orient
 #end
 fade_distance 8
 fade_power 2 
}
 
light_source {
 <-2,1.75,-7>
 rgb <0.969,0.914,0.91>*0.45
 #if (Final=1)
  area_light <0.2,0,0>,<0,0.2,0>,3,3
  orient
 #end
 fade_distance 9
 fade_power 2 
 groups "SecondLight"
} 

light_source {
 <0.825,4.775,4.3>
 rgb <0.9,0.7,0.5>*0.7
 fade_distance 2
 fade_power 2
 groups "Flame"
}


// testing       

#if (Final=0)
/*light_source {
 <0,8,0>
 White*0.75
 shadowless
}*/            
#end

#if (ShowColumns=1) 
 object {Column(0.13) scale <0.75,1,0.75>*0.5 translate <-4,3,1.5>}
 object {Column(0.13) scale <0.75,1,0.75>*0.5 rotate y*154 translate <2,3,-4>}
 object {Column(0.075) scale <0.9,-1,0.9>*0.5 translate <-4,4,14>}
 object {Column2 scale <0.85,-1,0.85>*0.5 translate <-3.6,4.2,1.1>}
 object {Column2 scale <0.7,-1,0.7>*0.5 translate <-5.5,3,1>}
 object {Column2 scale <0.7,1,0.7>*0.5 translate <-5.75,4,1.5>}
#end

#if (ShowFloor=1)
 object {Soil light_group "!lava" no_shadow "lava"} 
 box {
  <-25,-30,0>,<25,-0.5,60>
  texture { // lava
   pigment {Red}
   finish {ambient 1.2 diffuse 0}
  }
  no_shadow
 }

 light_source {
  <0,-0.2,30>
  rgb <0.6,0.1,0.1>*0.4
  #if (Final=1)
   area_light <4,0,0>,<0,0,4>,3,3
   jitter
   orient
  #end
  groups "lava"
  fade_distance 20
  fade_power 2   
 }                       
  
#else
 plane {
  y,0                         
  texture {T_Dirt scale 0.5}
 }
#end

#if (ShowWalls=1)
 object {Walls}
#end

#if (ShowPebbles=1)
 #declare ob_ar=array[3]
 #declare ob_ar[0]=object {Pebble(0.03)}
 #declare ob_ar[1]=object {Pebble(0.01) translate y*0.0125}
 #declare ob_ar[2]=object {Coin translate y*0.02}

 #declare ob_rel_ar=array[3][2]
 #declare ob_rel_ar[0][0]=350;
 #declare ob_rel_ar[0][1]=0.045;
 #declare ob_rel_ar[1][0]=600;
 #declare ob_rel_ar[1][1]=0.02;
 #declare ob_rel_ar[2][0]=80;
 #declare ob_rel_ar[2][1]=0.025;

 #declare obstacle_ar=array[3][2]
 #declare obstacle_ar[0][0]=<8,2,9.5>;//<-4,2,1.5>;  <12,0,8>
 #declare obstacle_ar[0][1]=<3,0,0>;
 #declare obstacle_ar[1][0]=<14,2,4>; //<2,2,-4>;
 #declare obstacle_ar[1][1]=<2,0,0>;
 #declare obstacle_ar[2][0]=<13.5,0.525,3.5>; //<1.5,0.525,-4.5>;
 #declare obstacle_ar[2][1]=<0.3,0,0>;

 #declare p=array[3][2]
 #declare p[0][0]=0;
 #declare p[0][1]=1;
 #declare p[1][0]=0;
 #declare p[1][1]=1;
 #declare p[2][0]=0;
 #declare p[2][1]=1;
 
 #declare map =array[3]
 #declare map[0]= pigment {function {F_Noise(x/1.5,0,z/1.5)} color_map {[0 rgb 0.25][1 rgb 1]}} //follow the terrain. More rocks in low parts
 #declare map[1]= pigment {function {F_Noise(x/1.5,0,z/1.5)} color_map {[0 rgb 1][1 rgb 0.25]}} //follow the terrain. More rocks in low parts
 #declare map[2]= pigment {spherical color_map {[0.0 rgb 0] [1.0 rgb 1]} scale <1.5,1.5,1.75> translate <13,0.5,2.5> }

 #declare tex_ar=array[3][2]
 #declare tex_ar[0][0]= texture {T_Pebbles1 scale 0.15}
 #declare tex_ar[0][1]= texture {T_Pebbles2 scale 0.15}
 #declare tex_ar[1][0]= texture {T_Pebbles2 scale 0.1}
 #declare tex_ar[1][1]= texture {T_Pebbles1 scale 0.1}
 #declare tex_ar[2][0]= texture {T_Gold_2C}
 #declare tex_ar[2][1]= texture {T_Gold_3D}

 #declare map_tex=array[3]
 #declare map_tex[0]=pigment {bozo turbulence 0.25 scale 0.1 color_map {[0 rgb 0][1 rgb 1]}}
 #declare map_tex[1]=pigment {bozo turbulence 0.5 scale 0.1 color_map {[0 rgb 0][1 rgb 1]}}
 #declare map_tex[2]=pigment {bozo scale 0.05 color_map {[0 rgb 0][1 rgb 1]}}

 object {
  clutter (ob_ar,ob_rel_ar,obstacle_ar,24,20,p,map,true,tex_ar,map_tex,Land,true,360,rndPos,0,"")
  translate <-12,0,-8>
 }
 
 isosurface {
  function {x^4+(3*y)^2+z^4 -1 - noise3d(x*1.5,y*1.5,z*1.5)*2 - noise3d(x*2,y*2,z*2)*1 + noise3d(x*4,y*4,z*4)*0.5-noise3d(x*8,y*8,z*8)*0.2-noise3d(x*12-0.25,y*12+0.8,z*12-0.28)*0.2}
  method 2
  max_gradient 500
  //eval
  contained_by {sphere {0,5}}
  texture {T_Pebbles2 scale 0.25}
  //pigment {Red} finish {ambient 1}
  scale 0.25
  translate <-1.3,0,-3.6>
 }
#end

#if (ShowDragon=1)
// max = <   1.061,    1.028,    0.869>, min = <  -1.104,   -0.015,   -0.789>

object {
  Dragon 
  rotate y*180
  scale <-1,1,1>*6
  //rotate y*10
  translate <2.5,0.65,10> // was 3,0.25,16
  no_shadow "Flame"
}       

cylinder {
  <0,-1.75,0>,<0,1,0>,2
  pigment {Clear}
  interior {
   media {
    emission <1,0.75,0>*3
    absorption <0,0.25,1>*8
    method 3
    samples 1,1 
    intervals 3
    density {
     spherical
     scallop_wave
     turbulence <0.75,0.5,0.75>
     color_map  {
       [0.0 color rgb <0, 0, 0>]
       [0.25 color rgb <1,0.7,0.4>*1.5]
       [0.5 color rgb <1,0.5,0>*1.75]
       [0.75 color rgb <1,0.8,0.4>*2]
       [1.0 color rgb <1,1,0.7>*2.5]
     }
     //scale 2
    }
   }
  }                                              
  no_shadow
  hollow
  scale <0.1,-1.75,0.125>
  translate y*0.5
  Reorient(y,<-0.65,-0.9,-1.2>)
  translate <1.15,5.1,5.5>  //was <1.64,2.8,10.2>
 } 

#end

#if (ShowRemains=1)
 
union {
 union {
  read_mesh ("Skull.pcm") 
  scale 0.95  
  texture {T_Bone}
 }    
 #declare mesh_textures = 
  array[6] {
   texture {T_Silver_3B} texture {T_Burnt2 scale 4}, 
   texture {T_Silver_3B} texture {T_Burnt2 scale 4}, 
   texture {T_Gold_2B} texture {T_Burnt2 scale 4}, 
   texture {T_Silver_3B} texture {T_Burnt2 scale 4}, 
   texture {T_Gold_2B} texture {T_Burnt2 scale 4}, 
   texture {T_Gold_2B} texture {T_Burnt2 scale 4} 
  }
 union {
  read_mesh ("Helm.pcm") 
 }
 rotate y*-70
 rotate z*-20
 rotate x*-35
 rotate y*-50
 scale 0.0175
 translate <1.5,0.52,-4.55>
}

#declare apply_mesh_textures = false;  

#declare declare_only = true;
 read_mesh ("arm.pcm") 

#declare rndBones=seed(102);
#declare rndBones2=seed(200);
union {                 
 #declare i=0;
 #while (i<29)                            
  #declare TransX=RndRange(rndBones,0.25,-0.25);
  #declare TransZ=RndRange(rndBones,0.3,-0.3);
  #declare Pos=trace(Land,vrotate(<TransX,4,TransZ>,<0,90,0>)+<0.45,0,-6.3>+<12,0,8>,-y)-<12,-0.0175,8>;
  #declare Rot=<RndRange(rndBones2,20,-20),RndRange(rndBones2,360,0),RndRange(rndBones2,20,-20)>;
  //WriteNumber("Random in X",TransX)
  //WriteNumber("Random in Z",TransZ)
  //WriteVector("Final Position",Pos)
  object {Mesh[i] scale 0.02  rotate Rot texture {T_Bone} texture {T_Burnt2 scale 0.075} translate Pos}
  #declare i=i+1;
 #end
}                               
object {Sword scale 0.5 rotate y*30 rotate <90,-45,10> translate <0.25,0.2,-6.5>}

intersection {
 object {KiteShield translate z*-0.0625 }
 height_field {
  tga "ShieldHeight.tga"
  smooth 
  translate <-0.5,0,-0.5> 
  scale <1.1,0.1,1.1> 
  rotate x*-90 
  texture {T_Chrome_4D}
 }
 rotate x*90
 scale 0.4
 rotate y*80
 rotate x*-35
 rotate z*40
 translate <0,0.075,-6.4>
}

#end

#if (ShowPerson=1)
 union {
  object {Adventurer}
  object {Shirt}
  object {Trousers}
  object {Hair}
  scale <-1,1,1>*1.5
  rotate y*35
  translate <-0.5,-0.4,-6.6>
  no_shadow "SecondLight"
 }
 
 object {
  Torch 
  pigment {VeryDarkBrown*0.5}
  translate <-0.15,0.35,0.475>
  rotate y*35
  translate <-0.5,0,-6.6>
  no_shadow "SecondLight"
 }

#end