// Persistence of Vision Ray Tracer Scene Description File
// File: Swords.inc
// Vers: unofficial megapov 0.7
// Desc: A Collection of swords 
// Date: 9 Aug 2001
// Auth: Gail Shaw

#version unofficial MegaPov 0.6;  
  
#include "macros.inc"
#include "blade.inc"
#include "WaveBlade.inc"
#include "LeafBlade.inc"

#declare BladeTex = 
 texture {
  pigment {
    bozo
    turbulence 1.0 omega 1.0
    color_map {
      [0.00 color rgb<0.598, 0.598, 0.598>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    scale <1.0, 50.0, 1.0>*0.1
  }
  finish {
    ambient 0.15
    diffuse 0.65
    brilliance 1.5
    specular 0.7 roughness 0.06
    reflection 0.15
    metallic    
    reflect_metallic
  }
}

#declare Leather = 
 texture {
  pigment {rgb <0.85,0.53,0.10>*0.6}
  finish {
   ambient < 0.200, 0.200, 0.200 >
   diffuse 0.50
   brilliance 1.00
   phong 0.20
   phong_size 50.00
   crand 0.100
  }
 }                                   

#declare Leather2 = 
 texture {
  pigment {rgb <0.3500, 0.1600,0.1400>*0.6}
  finish {
   ambient 0.2
   diffuse 0.50
   brilliance 1.00
   phong 0
   phong_size 50.00
   crand 0.500
  }
  normal {
   bumps 0.1
   scale 0.1
  }
 }

#declare Pyramid = 
 intersection {
  plane { x, 1  rotate <  0, 0,  40>}
  plane { -x, 1  rotate <  0, 0, -40>}
  plane { z, 1  rotate <-40, 0,   0>}
  plane { -z, 1  rotate < 40, 0,   0>}
  plane { -y, 0 }
  //translate <0 ,0, 0>
 }
#declare rnd=seed(7836);

#declare Guard1=
 union {
  cylinder {
   <-0.1,0,0>,<0.1,0,0>,0.03
  }
  sphere {
   <-0.1,0,0>,0.03
  }
  sphere {
   <0.1,0,0>,0.03
  }
  scale <1,0.5,1>
 }
 
#declare Guard2=
 union {
  difference {
   box {
    <-0.12,-0.04,-0.015>,<0.12,0.012,0.015>
   }
   cylinder {
    <-0.12,-0.17,-0.1>,<-0.12,-0.17,0.1>,0.167
   }
   cylinder {
    <0.12,-0.17,-0.1>,<0.12,-0.17,0.1>,0.167
   }
  }
  cylinder {
   <0,-0.03,-0.015>,<0,-0.03,0.015>,0.018
  }
  cylinder {
   <-0.12,0.0045,-0.015>,<-0.12,0.0045,0.015>,0.0075
  }
  cylinder {
   <0.12,0.0045,-0.015>,<0.12,0.0045,0.015>,0.0075
  }
  cylinder {
   <-0.04,0,-0.015>,<0.04,0,-0.015>,0.003
  }
  sphere {            
   <-0.04,0,-0.015>,0.003
  }   
  sphere {            
   <0.04,0,-0.015>,0.003
  }
  cylinder {
   <-0.04,0,0.015>,<0.04,0,0.015>,0.003
  }
  sphere {            
   <-0.04,0,0.015>,0.003
  }   
  sphere {            
   <0.04,0,0.015>,0.003
  }
 }

#declare Guard3=
 union {
  difference {
   box {
    <-0.12,-0.04,-0.015>,<0.12,0.012,0.015>
   }
   cylinder {
    <-0.12,-0.17,-0.1>,<-0.12,-0.17,0.1>,0.167
   }
   cylinder {
    <0.12,-0.17,-0.1>,<0.12,-0.17,0.1>,0.167
   }
  }
  cylinder {
   <0,-0.03,-0.015>,<0,-0.03,0.015>,0.018
  }
  cylinder {
   <-0.12,0.0045,-0.015>,<-0.12,0.0045,0.015>,0.0075
  }
  cylinder {
   <0.12,0.0045,-0.015>,<0.12,0.0045,0.015>,0.0075
  }
  sphere_sweep {           
   b_spline_sphere_sweep,
   9,                      
   <-0.023,-0.0165,0>,0.005
   <-0.023,-0.0265,0>,0.005
   <-0.024,-0.0365,0>,0.005
   <-0.024,-0.05,0>,0.005
   <-0.024,-0.09,0>,0.005
   <-0.028,-0.12,0>,0.005
   <-0.033,-0.15,0>,0.005
   <-0.038,-0.16,0>,0.005
   <-0.042,-0.17,0>,0.005
  }   
  sphere_sweep {           
   b_spline_sphere_sweep,
   9,                      
   <0.023,-0.0165,0>,0.005
   <0.023,-0.0265,0>,0.005
   <0.024,-0.0365,0>,0.005
   <0.024,-0.05,0>,0.005
   <0.024,-0.09,0>,0.005
   <0.028,-0.12,0>,0.005
   <0.033,-0.15,0>,0.005
   <0.038,-0.16,0>,0.005
   <0.042,-0.17,0>,0.005
  }
 }
 
#declare Guard4=
 union {
  difference {
   box {
    <-0.12,-0.04,-0.015>,<0.12,0.012,0.015>
   }
   cylinder {
    <-0.2,-0.23,-0.1>,<-0.2,-0.23,0.1>,0.26
   }
   cylinder {
    <0.2,-0.23,-0.1>,<0.2,-0.23,0.1>,0.26
   } 
  }
  cylinder {
   <0,-0.03,-0.015>,<0,-0.03,0.015>,0.02
   scale <1.2,1,1>
  } 
  sphere {
   <0,0,0>,0.025
   scale <0.6,1,0.3>
   translate <0,-0.025,-0.01>
   texture {
    pigment {rgb 1}
    finish {ambient 0.4 specular 0.8 roughness 0.001}
   }
  }
  sphere_sweep {
   b_spline_sphere_sweep
   9,
   <-0.01,-0.028,0>,0.01
   <-0.024,-0.03,0>,0.0095
   <-0.032,-0.033,0>,0.0085
   <-0.04,-0.043,0>,0.0075
   <-0.045,-0.053,0>,0.0065
   <-0.045,-0.065,0>,0.0055
   <-0.04,-0.075,0>,0.0045
   <-0.03,-0.08,0>,0.0035
   <-0.02,-0.075,0>,0.0025
  }   
  sphere_sweep {
   b_spline_sphere_sweep
   9,
   <0.01,-0.028,0>,0.01
   <0.024,-0.03,0>,0.0095
   <0.032,-0.033,0>,0.0085
   <0.04,-0.043,0>,0.0075
   <0.045,-0.053,0>,0.0065
   <0.045,-0.065,0>,0.0055
   <0.04,-0.075,0>,0.0045
   <0.03,-0.08,0>,0.0035
   <0.02,-0.075,0>,0.0025
  }
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <-0.06,0,0>,0.0086
   <-0.07,-0.01,0>,0.0075
   <-0.08,-0.02,0>,0.0064
   <-0.085,-0.03,0>,0.0053
   <-0.085,-0.04,0>,0.0042
   <-0.085,-0.05,0>,0.0031
   <-0.07,-0.06,0>,0.002
  }
  sphere_sweep {
   b_spline_sphere_sweep
   7,
   <0.06,0,0>,0.0086
   <0.07,-0.01,0>,0.0075
   <0.08,-0.02,0>,0.0064
   <0.085,-0.03,0>,0.0053
   <0.085,-0.04,0>,0.0042
   <0.085,-0.05,0>,0.0031
   <0.07,-0.06,0>,0.002
  }
 } 
 
#declare Guard5=
 union {
  difference {
   sphere {
    <0,0,0>,0.08
   }
   sphere {
    <0,0,0>,0.07
   }
   box {
    <-0.2,0,-0.2>,<0.2,0.2,0.2>
   }
   scale <1,0.9,1>
  }
  torus {
   0.075,0.005
  }
  cylinder {
   <-0.15,0,0>,<0.15,0,0>,0.005
  }
  sphere {
   <-0.15,0,0>,0.012
  }
  sphere {
   <0.15,0,0>,0.012
  }
  object {
   HalfTorus(0.07,0.005)
   rotate x*-90
   scale <1,1.25,0.8>
   translate <0.04,0.08,0>
  }
  sphere {
   <0.04,0.07*1.25+0.08,0>,0.012
  }
 }

#declare Guard6=
 union {
  cylinder {
   <-0.075,0,0>,<0.075,0,0>,0.005
  }
  object {
   QuarterTorus(0.02,0.005)
   rotate x*-90
   rotate z*-180
   translate <-0.075,0.02,0>
  }
  sphere {
   <-0.095,0.02,0>,0.005
  }                 
  object {QuarterTorus(0.02,0.005)
   rotate x*-90
   translate <0.075,-0.02,0>
  }
  sphere {
   <0.095,-0.02,0>,0.005
  }
  object {
   HalfTorus(0.064,0.005)
   rotate x*-90
   scale <1,1.25,0.8>
   translate <0.04,0.08,0>
  }
  sphere {
   <0.04,0.064*1.25+0.08,0>,0.012
  }
 }
      
 
#declare Hilt1=
 union {
  cylinder {
   <0,0,0>,<0,0.22,0>,0.015
   pigment {rgb <0.6470, 0.1640, 0.1640>}
  }
  #declare i=0;
  #while (i<0.2)
   torus {
    0.015,0.001
    scale <1,5,1>
    matrix <
     1.0,0.5,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >
    translate y*i
   }
   torus {
    0.015,0.001
    scale <1,5,1>
    matrix <
     1.0,-0.5,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >
    translate y*i  
   }             
   #declare i=i+0.02;
  #end        
 } 
 
#declare Hilt2=
 union {
  cylinder {
   <0,0,0>,<0,0.22,0>,0.015
   pigment {rgb <0.6470, 0.1640, 0.1640>}
  }
  #declare i=0;
  #while (i<0.2)
   torus {
    0.015,0.001
    scale <1,5,1>
    matrix <
     1.0,-0.5,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >
    translate y*i
   }
   #declare i=i+0.015;
   torus {
    0.016,0.001
    scale <1,2,1>
    matrix <
     1.0,1.0,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >       
    translate y*0.05
   }
   torus {
    0.016,0.001
    scale <1,2,1>
    matrix <
     1.0,1.0,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >       
    translate y*0.11
   }                
   torus {
    0.016,0.001
    scale <1,2,1>
    matrix <
     1.0,1.0,0.0,
     0.0,1.0,0.0,
     0.0,0.0,1.0,
     0.0,0.0,0.0
    >       
    translate y*0.17
   }
  #end        
 } 

#declare Hilt3=
 union {
  #declare i=0;
  #while (i<0.22)
   torus {
    0.013,0.003
    translate y*i
    //pigment {rgb <i*5,0,0>}
   }
   #declare i=i+0.006;
  #end
 }
 
#declare Pommel1=
 union {
  cylinder {
   <0,-0.05,0>,<0,-0.03,0>,0.024
  }
  cylinder {
   <0,-0.05,0>,<0,0.05,0>,0.01
  }
  cylinder {
   <-0.05,0,0>,<0.05,0,0>,0.01
  }
  sphere {
   <-0.058,0,0>,0.01
  }
  sphere {
   <0.058,0,0>,0.01
  } 
  sphere {
   <0,0.058,0>,0.01
  }
  torus {
   0.05,0.01
   rotate x*90
  }
  scale 0.8
  translate y*0.2 
 }
 
#declare Pommel2=
 union {
  torus {
   0.013,0.005
  }
  cone {
   <0,0,0>,0.018,<0,0.075,0>,0.001
  }
  sphere {
   <0,0.071,0>,0.0075
  }              
  translate y*0.2
 }
 
#declare Pommel3=
 union {
  torus {
   0.013,0.005
  }
  sphere {
   <0,0,0>,0.019
   scale <1,2,1>
   translate y*0.01
  }
  sphere {
   <0,0,0>,0.008
   scale <1,2,1>
   translate <0,0.01,-0.014>
   texture {
    pigment {rgb 1}
    finish {ambient 0.4 specular 0.6 roughness 0.001}
   }
  }
  sphere {
   <0,0,0>,0.008
   scale <1,2,1>
   translate <0,0.01,0.014>
   texture {
    pigment {rgb 1}
    finish {ambient 0.4 specular 0.6 roughness 0.001}
   }
  }              
  translate y*0.2
 } 
 
#declare Pommel4=
 union {
  sphere {
   <0,0.02,0>,0.02  
  }
  torus {
   0.02,0.01
   rotate x*90
   translate y*0.02
  }              
  translate y*0.2
 }

// examples
         
/*
#include "colors.inc"
#include "metals.inc"

plane {
 z,-20
 pigment {White}
 finish {ambient 0.6}
 hollow
 no_shadow
}

camera {
 location <0,-0.5,-7>
 look_at <0,-0.5,0>   
 angle 20
}

light_source {
 <10,50,-15>
 White
}

light_source {
 <-50,-20,-15>
 White
}

union {
 object {LeafBlade} 
 object {Hilt2 scale <1.1,1,0.85> pigment {Brown*1.1}}
 object {Guard4 texture {T_Gold_2D} }
 object {Pommel3 scale <1.1,1,0.85> translate y*0.01 texture {T_Gold_2D}} // was translate y*0.21
 texture {BladeTex}
 rotate y*10  
 translate x*-0.8
}

union {
 object {SwordBlade scale <0.8,1,0.8>} 
 object {Hilt3 scale <1.1,0.75,0.85> pigment {Brown*1.1}}    
 object {Guard5 texture {T_Gold_2D} }
 object {Pommel4 scale <1.1,1,0.85> translate y*-0.03 texture {T_Gold_2D}} 
 texture {BladeTex}
 rotate y*10  
 translate x*-0.4
}

union {
 object {WaveBlade translate y*-0.02}
 object {Hilt1 scale <1.1,0.9,0.85> texture{Leather2}translate y*0.01}
 object {Guard6 scale <1,1.1,1> texture {T_Copper_3D}}
 object {Pommel2 texture {T_Copper_3D}} 
 texture {BladeTex}
 rotate y*10  
 translate x*0
} 

union {
 object {SwordBlade scale <1.5,1,0.8>}
 object {Hilt3 scale <1.1,1,0.8> pigment {Brown*1.1}}
 object {Guard3 texture {T_Gold_4D} }
 object {Pommel4 scale <1.1,1,1.21> translate y*0.02 texture {T_Gold_4D}}
 texture {BladeTex} 
 rotate y*10  
 translate x*0.4
} 

union {
 object {LeafBlade scale <1.25,1.3,0.8>}
 object {Hilt1 scale <1.25,1.25,1> pigment {Brown*1.1}}    
 object {Guard1 texture {T_Gold_4D} }
 object {Pommel1 scale <1.1,1,0.85> translate y*0.1 texture {T_Gold_4D}} 
 texture {BladeTex} 
 rotate y*10  
 translate x*0.8
}
  */