
// Norman Helm
//**********************************************************************************************
//
// This file defines a Norman style helm. It is laying on the x-z plane, 
// centered about the y axis.  Each POV unit = 1 cm.
// It is roughly 22 cm in diameter. 
// The face guard is in the -z direction, and extends 5.5 units in the -y direction
//
//  Copyright (c) William D. Hayden 2000
//  wdh61@swbell.net
//  Permision to use and modify hereby granted.
//
//**********************************************************************************************

// Uncomment the "test" delclaration below for a test rendering
//#declare test = 1 ;



// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "metals.inc"


#local NormanHelmRadius = 11.0 ;
#local NormanHelmTop = 10.0 ;
#local NormanHelmScale = 1.5 ;
#local NormanHelmConeRadius = sqrt(NormanHelmRadius*NormanHelmRadius-NormanHelmTop*NormanHelmTop) ;
#local NormanHelm_rivet_radius = 0.5 ;


// old gilded surface
#local T_RoughGold = texture {
  pigment { colour rgb<1.0, 0.70, 0.20> }
  normal {
    ripples 0.30
    turbulence 0.60  lambda 3.00
    frequency 7
  }
  finish {
    ambient 0.35
    diffuse 0.65
    brilliance 2.00
    specular 0.20    metallic
    reflection 0.35
  }
}

// Modified copies of this base texture are used in some pieces
#local T_Steel_1 = texture {
    pigment {
        granite         // Going for a galvanized appearance
        color_map {
            [0.0 color Gray70]
            [0.3 color Gray75]
            [0.6 color Gray85]
            [1.0 color Gray70]
        }
        scale <0.25, 0.25, 0.25>
        turbulence 0.15
    }
    finish {
        ambient 0.2
        diffuse 0.6
        reflection 0.25
        brilliance 10
        specular 0.35
        roughness 0.05
        phong .2
    }
    // Fuzz the surface with tiny ripples
    normal { ripples 0.25 frequency 2000 scale <0.05, 0.05, 0.05> }
}
#local T_Steel = 
texture 
{
    pigment 
    {
       P_Chrome4
    }
   normal 
   {
      bumps 0.1 
      turbulence .5
      scale 1.5    
   }
    finish 
    {
        ambient 0.2
        diffuse 0.6
        reflection 0.35
        brilliance 10
        specular 0.35
        roughness 0.05
        phong .2
    }
}
#local steel = T_Steel



#declare NormanHelm_rivet = 
sphere
{
   <0, 0, 0> NormanHelm_rivet_radius scale <1, 1, NormanHelm_rivet_radius * 0.8> texture{T_RoughGold}
}

#declare NormanHelm =
union
{
   union
   {
      difference
      {
         union
         {
            difference
            {
               sphere {<0, 0, 0> NormanHelmRadius}
               box {<50, 0, 50> <-50, -50, -50>}
               box {<50, NormanHelmTop, 50> <-50, 50, -50>}
               scale <0, NormanHelmScale, 0> 
            }
            cone
            {
               <0, NormanHelmTop*NormanHelmScale, 0> NormanHelmConeRadius
               <0, NormanHelmRadius*1.65, 0> 0
            }
         }
         union
         {
            difference
            {
               sphere {<0, 0, 0> NormanHelmRadius-0.2}
               box {<50, -0.2, 50> <-50, -50, -50>}
               box {<50, NormanHelmTop+0.2, 50> <-50, 50, -50>}
               scale <0, NormanHelmScale, 0>
            }
            cone
            {
               <0, NormanHelmTop*NormanHelmScale, 0> NormanHelmConeRadius-0.2
               <0, NormanHelmRadius*1.65, 0> 0
            }
         }
      }
      difference
      {
         cylinder
         {
            <0, 0, 0> <0, 3, 0> NormanHelmRadius+0.2
         }
         cylinder
         {
            <0, -0.1, 0> <0, 3.1, 0> NormanHelmRadius
         }
      }
      
      intersection
      {
         difference
         {
            cylinder{<0, 0, 5.25> <0, 0, -6.5> NormanHelmRadius+0.4}
            cylinder{<0, 0, 5.25> <0, 0, -6.5> NormanHelmRadius+0.2}
            box {<-50, 0, -50> <50, -50, 50>}
         }
         prism
         {
            linear_spline
            -50, 50, 17
            <0.00, 5.25>, <0.75, 4.00>, <9.00, 0.00>, <7.00, 0.00>, <6.00, 0.15>, <5.00, 0.00>, <1.25, 1.00>, <1.25, -5>, <0.00, -5.5>, 
            <-1.25, -5>, <-1.25, 1.00>, <-5.00, 0.00>, <-6.00, 0.15>, <-7.00, 0.00>, <-9.00, 0.00>, <-0.75, 4.00>, <0.00, 5.25>

         }
         rotate <270, 0, 0>
      }
      texture {T_Steel}
      //pigment {Red}
   }
   
   object {NormanHelm_rivet translate <0, 1.5, -NormanHelmRadius - 0.4> rotate <0, 15, 0>}
   object {NormanHelm_rivet translate <0, 1.5, -NormanHelmRadius - 0.4> rotate <0, -15, 0>}

   #local i=45;
   #local n=180 ;
   #while (i<=n)
      object {NormanHelm_rivet translate <0, 1.5, -NormanHelmRadius - 0.2> rotate <0, i, 0>}
      #local i=i+30;
   #end
   
   #local i=-45 ;
   #local n=-180
   #while (n<i)
      object {NormanHelm_rivet translate <0, 1.5, -NormanHelmRadius - 0.2> rotate <0, i, 0>}
      #local i=i-30;
   #end
}

#ifdef (test)

light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <40, 80, -40> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-40, 80, -40> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <50, 0, -50>
}

camera
{
  location  <0.0, 15.0, -50.0>
  direction 1.5*z
  up        y
  right     4/3*x
  look_at   <0.0, 5.0,  0.0>
}


background {Black}

object {NormanHelm rotate <0, -15, 0> }
#end
