// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -6.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

/*
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}
*/

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

//sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} }

// flat circular FINITE (no CSG) shape, center hole cutout is optional

#declare moon_shape = 
disc
{
  <0, 0, 0>  // center position
  z,         // normal vector
  1.0,       // outer radius
  //0.2        // optional hole radius
     pigment {
      crackle
      translate <0.3,0,1.1>
      turbulence 0.3
      scale 0.04
      color_map {
         //[0.0 rgb 0.0]
         [0.2 rgb 0.5]
         [0.7 rgb 0.9]
         [1.0 rgb 1.0]
      }
     }
	//finish { reflection 1.0 }     
}


#declare moon =
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  //translate <-30, 30, -30>
  
  looks_like {moon_shape}
}


#declare moon = union
{
	object {moon_shape}

	  light_source {
	    <0, 0, -2.8>
	    color White
	    spotlight
	    radius 60
	    falloff 19.6
	    tightness 10
	    point_at <0, 0, 0>
	  }
	  
	  light_source {
	    <0, 0, -2.8>
	    color White
	    spotlight
	    radius 60
	    falloff 19.6
	    tightness 10
	    point_at <0, 0, 0>
	  }
	  
	      light_source {
	    <0, 0, -2.8>
	    color White
	    spotlight
	    radius 50
	    falloff 19.6
	    tightness 10
	    point_at <0, 0, 0>
	  } 
}	  

object {moon}

