// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version unnofficial PovMan0.71.4
// Fichier   : hellowrd.pov by Fred Grmle.

// Generated by L3P v1.3 20010120  (C) 1998-2001 Lars C. Hassing  lch@ccieurope.com
// Date: Thu Aug 1 0:43:06 2001
// Input file: fant1.dat
// LDRAWDIR: E:\LeGO\LDRAW
// LGEODIR:  E:\LeGO\LGEO
// Commandline: E:\LEGO\L3P\L3P.EXE -o -b -f -l -enp -p -lgeo fant1

/*
  Tools used
*   MLCad by Michael Lachmann        :  http://www.lm-software.com/mlcad/ 
*   L3P by Lars C. Hassing           :  http://home16.inet.tele.dk/hassing/l3p.html 
*   LDRAW by James Jessiman          :  http://www.ldraw.org/
*   Lgeo PovLibrary by Lutz Uhlmann  :  http://www.el-lutzo.de/lego/lgeo.html
*   Gforge by John Beale             :  http://www.best.com/~beale
*/

// title  : Hello_World  !
// mailto:grmlefr@yahoo.fr
//============================================================================
#version unofficial MegaPOV 0.7;
//==StaRT_File=================================================================
#declare QUAL = 3;  // Quality level, 0=BBox, 1=no refr, 2=normal, 3=studlogo

#declare SW = 0.5;  // Width of seam between two bricks

#declare STUDS = 1;  // 1=on 0=off

#declare BUMPS = 1;  // 1=on 0=off


#declare BUMPNORMAL = normal { bumps 0.01 scale 20 }
#declare AMB = 0.4;
#declare DIF = 0.4;


#declare O7071 = sqrt(0.5);

#declare L3Logo = union {
	sphere {<-59,0,-96>,6}
	cylinder {<-59,0,-96>,<59,0,-122>,6 open}
	sphere {<59,0,-122>,6}
	cylinder {<59,0,-122>,<59,0,-84>,6 open}
	sphere {<59,0,-84>,6}

	sphere {<-59,0,-36>,6}
	cylinder {<-59,0,-36>,<-59,0,1>,6 open}
	sphere {<-59,0,1>,6}
	cylinder {<0,0,-49>,<0,0,-25>,6 open}
	sphere {<0,0,-25>,6}
	sphere {<59,0,-62>,6}
	cylinder {<59,0,-62>,<59,0,-24>,6 open}
	sphere {<59,0,-24>,6}
	cylinder {<-59,0,-36>,<59,0,-62>,6 open}

	sphere {<-35.95,0,57>,6}
	torus {18.45,6 clipped_by{plane{<40,0,-9>,0}} translate<-40,0,39>}
	cylinder {<-44.05,0,21>,<35.95,0,3>,6 open}
	torus {18.45,6 clipped_by{plane{<-40,0,9>,0}} translate<40,0,21>}
	cylinder {<44.05,0,39>,<0,0,49>,6 open}
	sphere {<0,0,49>,6}
	cylinder {<0,0,49>,<0,0,34>,6 open}
	sphere {<0,0,34>,6}

	torus {18.45,6 clipped_by{plane{<40,0,-9>,0}} translate<-40,0,99>}
	cylinder {<-44.05,0,81>,<35.95,0,63>,6 open}
	torus {18.45,6 clipped_by{plane{<-40,0,9>,0}} translate<40,0,81>}
	cylinder {<44.05,0,99>,<-35.95,0,117>,6 open}

	scale 4.5/128
}


#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#include "lg_defs.inc"
#include "lg_color.inc"
#include "metals.inc"
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end

#if (QUAL > 2)
	#declare lg_knob_l3temp = union {
		object { lg_knob }
		object {
			L3Logo
			matrix <0,-LG_BRICK_WIDTH/20,0, 0,0,-LG_BRICK_HEIGHT/24, -LG_BRICK_WIDTH/20,0,0, 0,0,4*LG_BRICK_HEIGHT/24>
		}
	}
	#declare lg_knob = object { lg_knob_l3temp }
	#declare lg_knob_l3temp = merge {
		object { lg_knob_clear }
		object {
			L3Logo
			matrix <0,-LG_BRICK_WIDTH/20,0, 0,0,-LG_BRICK_HEIGHT/24, -LG_BRICK_WIDTH/20,0,0, 0,0,4*LG_BRICK_HEIGHT/24>
		}
	}
	#declare lg_knob_clear = object { lg_knob_l3temp }
#end


#ifndef (Color7)
#declare Color7 = #if (version >= 3.1) material { #end texture {
	lg_grey
} #if (version >= 3.1) } #end
#declare Color7_slope = #if (version >= 3.1) material { #end texture {
	lg_grey
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color40)
#declare Color40 = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.47451,0.47451,0.45098> #if (QUAL > 1) filter 0.9 #end }
	finish {
		ambient 0.3
		diffuse 0.6
		#if (QUAL > 1)
			reflection 0.25
			refraction 1
			ior 1.5
			phong 0.3
			phong_size 60
		#end
	}
} #if (version >= 3.1) } #end
#declare Color40_slope = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.47451,0.47451,0.45098> #if (QUAL > 1) filter 0.9 #end }
	finish {
		ambient 0.3
		diffuse 0.6
		#if (QUAL > 1)
			reflection 0.25
			refraction 1
			ior 1.5
			phong 0.3
			phong_size 60
		#end
	}
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color4)
#declare Color4 = #if (version >= 3.1) material { #end texture {
	lg_red
} #if (version >= 3.1) } #end
#declare Color4_slope = #if (version >= 3.1) material { #end texture {
	lg_red
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color15)
#declare Color15 = #if (version >= 3.1) material { #end texture {
	lg_white
} #if (version >= 3.1) } #end
#declare Color15_slope = #if (version >= 3.1) material { #end texture {
	lg_white
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color42)
#declare Color42 = #if (version >= 3.1) material { #end texture {
	lg_clear_neon_yellow
} #if (version >= 3.1) } #end
#declare Color42_slope = #if (version >= 3.1) material { #end texture {
	lg_clear_neon_yellow
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color0)
#declare Color0 = #if (version >= 3.1) material { #end texture {
	lg_black
} #if (version >= 3.1) } #end
#declare Color0_slope = #if (version >= 3.1) material { #end texture {
	lg_black
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color21)
#declare Color21 = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.878431,1,0.690196> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
} #if (version >= 3.1) } #end
#declare Color21_slope = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.878431,1,0.690196> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color10)
#declare Color10 = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.862745,1,0.0392157> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
} #if (version >= 3.1) } #end
#declare Color10_slope = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <0.862745,1,0.0392157> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#ifndef (Color12)
#declare Color12 = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <1,0.603922,0.129412> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
} #if (version >= 3.1) } #end
#declare Color12_slope = #if (version >= 3.1) material { #end texture {
	// Color not in lg_color.inc; however use same texture
	pigment { rgb <1,0.603922,0.129412> }
	finish {
		ambient 0.1
		#if (QUAL > 1)
			phong 0.3
			phong_size 20
		#end
	}
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare _4_dash_4cyli_dot_dat = object {
// Official LCad update 98-10
	mesh {
		triangle { <1,0,0>, <0.9239,0,0.3827>, <0.9239,1,0.3827> }
		triangle { <0.9239,1,0.3827>, <1,1,0>, <1,0,0> }
		triangle { <0.9239,0,0.3827>, <0.7071,0,0.7071>, <0.7071,1,0.7071> }
		triangle { <0.7071,1,0.7071>, <0.9239,1,0.3827>, <0.9239,0,0.3827> }
		triangle { <0.7071,0,0.7071>, <0.3827,0,0.9239>, <0.3827,1,0.9239> }
		triangle { <0.3827,1,0.9239>, <0.7071,1,0.7071>, <0.7071,0,0.7071> }
		triangle { <0.3827,0,0.9239>, <0,0,1>, <0,1,1> }
		triangle { <0,1,1>, <0.3827,1,0.9239>, <0.3827,0,0.9239> }
		triangle { <0,0,1>, <-0.3827,0,0.9239>, <-0.3827,1,0.9239> }
		triangle { <-0.3827,1,0.9239>, <0,1,1>, <0,0,1> }
		triangle { <-0.3827,0,0.9239>, <-0.7071,0,0.7071>, <-0.7071,1,0.7071> }
		triangle { <-0.7071,1,0.7071>, <-0.3827,1,0.9239>, <-0.3827,0,0.9239> }
		triangle { <-0.7071,0,0.7071>, <-0.9239,0,0.3827>, <-0.9239,1,0.3827> }
		triangle { <-0.9239,1,0.3827>, <-0.7071,1,0.7071>, <-0.7071,0,0.7071> }
		triangle { <-0.9239,0,0.3827>, <-1,0,0>, <-1,1,0> }
		triangle { <-1,1,0>, <-0.9239,1,0.3827>, <-0.9239,0,0.3827> }
		triangle { <-1,0,0>, <-0.9239,0,-0.3827>, <-0.9239,1,-0.3827> }
		triangle { <-0.9239,1,-0.3827>, <-1,1,0>, <-1,0,0> }
		triangle { <-0.9239,0,-0.3827>, <-0.7071,0,-0.7071>, <-0.7071,1,-0.7071> }
		triangle { <-0.7071,1,-0.7071>, <-0.9239,1,-0.3827>, <-0.9239,0,-0.3827> }
		triangle { <-0.7071,0,-0.7071>, <-0.3827,0,-0.9239>, <-0.3827,1,-0.9239> }
		triangle { <-0.3827,1,-0.9239>, <-0.7071,1,-0.7071>, <-0.7071,0,-0.7071> }
		triangle { <-0.3827,0,-0.9239>, <0,0,-1>, <0,1,-1> }
		triangle { <0,1,-1>, <-0.3827,1,-0.9239>, <-0.3827,0,-0.9239> }
		triangle { <0,0,-1>, <0.3827,0,-0.9239>, <0.3827,1,-0.9239> }
		triangle { <0.3827,1,-0.9239>, <0,1,-1>, <0,0,-1> }
		triangle { <0.3827,0,-0.9239>, <0.7071,0,-0.7071>, <0.7071,1,-0.7071> }
		triangle { <0.7071,1,-0.7071>, <0.3827,1,-0.9239>, <0.3827,0,-0.9239> }
		triangle { <0.7071,0,-0.7071>, <0.9239,0,-0.3827>, <0.9239,1,-0.3827> }
		triangle { <0.9239,1,-0.3827>, <0.7071,1,-0.7071>, <0.7071,0,-0.7071> }
		triangle { <0.9239,0,-0.3827>, <1,0,0>, <1,1,0> }
		triangle { <1,1,0>, <0.9239,1,-0.3827>, <0.9239,0,-0.3827> }
	}
}

#declare ring2_dot_dat = object {
// Official LCad update 98-10
	mesh {
		triangle { <0,0,2>, <-0.7654,0,1.8478>, <-1.1481,0,2.7717> }
		triangle { <-1.1481,0,2.7717>, <0,0,3>, <0,0,2> }
		triangle { <-0.7654,0,1.8478>, <-1.4142,0,1.4142>, <-2.1213,0,2.1213> }
		triangle { <-2.1213,0,2.1213>, <-1.1481,0,2.7717>, <-0.7654,0,1.8478> }
		triangle { <-1.4142,0,1.4142>, <-1.8478,0,0.7654>, <-2.7717,0,1.1481> }
		triangle { <-2.7717,0,1.1481>, <-2.1213,0,2.1213>, <-1.4142,0,1.4142> }
		triangle { <-1.8478,0,0.7654>, <-2,0,0>, <-3,0,0> }
		triangle { <-3,0,0>, <-2.7717,0,1.1481>, <-1.8478,0,0.7654> }
		triangle { <-2,0,0>, <-1.8478,0,-0.7654>, <-2.7717,0,-1.1481> }
		triangle { <-2.7717,0,-1.1481>, <-3,0,0>, <-2,0,0> }
		triangle { <-1.8478,0,-0.7654>, <-1.4142,0,-1.4142>, <-2.1213,0,-2.1213> }
		triangle { <-2.1213,0,-2.1213>, <-2.7717,0,-1.1481>, <-1.8478,0,-0.7654> }
		triangle { <-1.4142,0,-1.4142>, <-0.7654,0,-1.8478>, <-1.1481,0,-2.7717> }
		triangle { <-1.1481,0,-2.7717>, <-2.1213,0,-2.1213>, <-1.4142,0,-1.4142> }
		triangle { <-0.7654,0,-1.8478>, <0,0,-2>, <0,0,-3> }
		triangle { <0,0,-3>, <-1.1481,0,-2.7717>, <-0.7654,0,-1.8478> }
		triangle { <0,0,-2>, <0.7654,0,-1.8478>, <1.1481,0,-2.7717> }
		triangle { <1.1481,0,-2.7717>, <0,0,-3>, <0,0,-2> }
		triangle { <0.7654,0,-1.8478>, <1.4142,0,-1.4142>, <2.1213,0,-2.1213> }
		triangle { <2.1213,0,-2.1213>, <1.1481,0,-2.7717>, <0.7654,0,-1.8478> }
		triangle { <1.4142,0,-1.4142>, <1.8478,0,-0.7654>, <2.7717,0,-1.1481> }
		triangle { <2.7717,0,-1.1481>, <2.1213,0,-2.1213>, <1.4142,0,-1.4142> }
		triangle { <1.8478,0,-0.7654>, <2,0,0>, <3,0,0> }
		triangle { <3,0,0>, <2.7717,0,-1.1481>, <1.8478,0,-0.7654> }
		triangle { <2,0,0>, <1.8478,0,0.7654>, <2.7717,0,1.1481> }
		triangle { <2.7717,0,1.1481>, <3,0,0>, <2,0,0> }
		triangle { <1.8478,0,0.7654>, <1.4142,0,1.4142>, <2.1213,0,2.1213> }
		triangle { <2.1213,0,2.1213>, <2.7717,0,1.1481>, <1.8478,0,0.7654> }
		triangle { <1.4142,0,1.4142>, <0.7654,0,1.8478>, <1.1481,0,2.7717> }
		triangle { <1.1481,0,2.7717>, <2.1213,0,2.1213>, <1.4142,0,1.4142> }
		triangle { <0.7654,0,1.8478>, <0,0,2>, <0,0,3> }
		triangle { <0,0,3>, <1.1481,0,2.7717>, <0.7654,0,1.8478> }
	}
}

#declare stud2a_dot_dat = union {
// Stud 2A
// Name: stud2a.dat
// Author: Chris Dee
// Official LCad update 99-05
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,0,-4,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,0,-4,0> }
	object { ring2_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,-4,0> }
// 
}

#declare _4_dash_4ndis_dot_dat = object {
// Not Disc
	mesh {
		triangle { <1,0,1>, <1,0,0>, <0.9239,0,0.3827> }
		triangle { <1,0,1>, <0.9239,0,0.3827>, <0.7071,0,0.7071> }
		triangle { <1,0,1>, <0.7071,0,0.7071>, <0.3827,0,0.9239> }
		triangle { <1,0,1>, <0.3827,0,0.9239>, <0,0,1> }
		triangle { <-1,0,1>, <0,0,1>, <-0.3827,0,0.9239> }
		triangle { <-1,0,1>, <-0.3827,0,0.9239>, <-0.7071,0,0.7071> }
		triangle { <-1,0,1>, <-0.7071,0,0.7071>, <-0.9239,0,0.3827> }
		triangle { <-1,0,1>, <-0.9239,0,0.3827>, <-1,0,0> }
		triangle { <-1,0,-1>, <-1,0,0>, <-0.9239,0,-0.3827> }
		triangle { <-1,0,-1>, <-0.9239,0,-0.3827>, <-0.7071,0,-0.7071> }
		triangle { <-1,0,-1>, <-0.7071,0,-0.7071>, <-0.3827,0,-0.9239> }
		triangle { <-1,0,-1>, <-0.3827,0,-0.9239>, <0,0,-1> }
		triangle { <1,0,-1>, <0,0,-1>, <0.3827,0,-0.9239> }
		triangle { <1,0,-1>, <0.3827,0,-0.9239>, <0.7071,0,-0.7071> }
		triangle { <1,0,-1>, <0.7071,0,-0.7071>, <0.9239,0,-0.3827> }
		triangle { <1,0,-1>, <0.9239,0,-0.3827>, <1,0,0> }
	}
}

#declare axlehole_dot_dat = object {
// Axle Hole
// Name: axlehole.dat
// Author: James Jessiman
// Original LDraw Primitive 2000-01
// 2000-04-23 SEB Added conditional edges along outermost diameters
// 2 24 6    0 0    5.52 0 2.28
// 2 24 5.52 0 2.28 4.26 0 4.26
// 2 24 4.26 0 4.26 2.28 0 5.52
// 2 24 2.28 0 5.52 0    0 6
// 2 24 6    0 0    5.58 0 2
// 2 24 2    0 5.58 0    0 6
// 2 24 -6    0 0    -5.58 0 2
// 2 24 -2    0 5.58 -0    0 6
// 2 24 6    0 -0    5.58 0 -2
// 2 24 2    0 -5.58 0    0 -6
// 2 24 -6    0 -0    -5.58 0 -2
// 2 24 -2    0 -5.58 -0    0 -6
// 2 24 6    1 0    5.58 1 2
// 2 24 2    1 5.58 0    1 6
// 2 24 -6    1 0    -5.58 1 2
// 2 24 -2    1 5.58 -0    1 6
// 2 24 6    1 -0    5.58 1 -2
// 2 24 2    1 -5.58 0    1 -6
// 2 24 -6    1 -0    -5.58 1 -2
// 2 24 -2    1 -5.58 -0    1 -6
	mesh {
		triangle { <6,0,0>, <5.58,0,2>, <5.58,1,2> }
		triangle { <5.58,1,2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,2>, <2,0,2>, <2,1,2> }
		triangle { <2,1,2>, <5.58,1,2>, <5.58,0,2> }
		triangle { <2,0,2>, <2,0,5.58>, <2,1,5.58> }
		triangle { <2,1,5.58>, <2,1,2>, <2,0,2> }
		triangle { <2,0,5.58>, <0,0,6>, <0,1,6> }
		triangle { <0,1,6>, <2,1,5.58>, <2,0,5.58> }
		triangle { <-6,0,0>, <-5.58,0,2>, <-5.58,1,2> }
		triangle { <-5.58,1,2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,2>, <-2,0,2>, <-2,1,2> }
		triangle { <-2,1,2>, <-5.58,1,2>, <-5.58,0,2> }
		triangle { <-2,0,2>, <-2,0,5.58>, <-2,1,5.58> }
		triangle { <-2,1,5.58>, <-2,1,2>, <-2,0,2> }
		triangle { <-2,0,5.58>, <0,0,6>, <0,1,6> }
		triangle { <0,1,6>, <-2,1,5.58>, <-2,0,5.58> }
		triangle { <6,0,0>, <5.58,0,-2>, <5.58,1,-2> }
		triangle { <5.58,1,-2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,-2>, <2,0,-2>, <2,1,-2> }
		triangle { <2,1,-2>, <5.58,1,-2>, <5.58,0,-2> }
		triangle { <2,0,-2>, <2,0,-5.58>, <2,1,-5.58> }
		triangle { <2,1,-5.58>, <2,1,-2>, <2,0,-2> }
		triangle { <2,0,-5.58>, <0,0,-6>, <0,1,-6> }
		triangle { <0,1,-6>, <2,1,-5.58>, <2,0,-5.58> }
		triangle { <-6,0,0>, <-5.58,0,-2>, <-5.58,1,-2> }
		triangle { <-5.58,1,-2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,-2>, <-2,0,-2>, <-2,1,-2> }
		triangle { <-2,1,-2>, <-5.58,1,-2>, <-5.58,0,-2> }
		triangle { <-2,0,-2>, <-2,0,-5.58>, <-2,1,-5.58> }
		triangle { <-2,1,-5.58>, <-2,1,-2>, <-2,0,-2> }
		triangle { <-2,0,-5.58>, <0,0,-6>, <0,1,-6> }
		triangle { <0,1,-6>, <-2,1,-5.58>, <-2,0,-5.58> }
		triangle { <5.58,0,2>, <5.52,0,2.28>, <2,0,2> }
		triangle { <5.52,0,2.28>, <4.26,0,4.26>, <2,0,2> }
		triangle { <4.26,0,4.26>, <2.28,0,5.52>, <2,0,2> }
		triangle { <2.28,0,5.52>, <2,0,5.58>, <2,0,2> }
		triangle { <-5.58,0,2>, <-5.52,0,2.28>, <-2,0,2> }
		triangle { <-5.52,0,2.28>, <-4.26,0,4.26>, <-2,0,2> }
		triangle { <-4.26,0,4.26>, <-2.28,0,5.52>, <-2,0,2> }
		triangle { <-2.28,0,5.52>, <-2,0,5.58>, <-2,0,2> }
		triangle { <5.58,0,-2>, <5.52,0,-2.28>, <2,0,-2> }
		triangle { <5.52,0,-2.28>, <4.26,0,-4.26>, <2,0,-2> }
		triangle { <4.26,0,-4.26>, <2.28,0,-5.52>, <2,0,-2> }
		triangle { <2.28,0,-5.52>, <2,0,-5.58>, <2,0,-2> }
		triangle { <-5.58,0,-2>, <-5.52,0,-2.28>, <-2,0,-2> }
		triangle { <-5.52,0,-2.28>, <-4.26,0,-4.26>, <-2,0,-2> }
		triangle { <-4.26,0,-4.26>, <-2.28,0,-5.52>, <-2,0,-2> }
		triangle { <-2.28,0,-5.52>, <-2,0,-5.58>, <-2,0,-2> }
		triangle { <5.58,1,2>, <5.52,1,2.28>, <2,1,2> }
		triangle { <5.52,1,2.28>, <4.26,1,4.26>, <2,1,2> }
		triangle { <4.26,1,4.26>, <2.28,1,5.52>, <2,1,2> }
		triangle { <2.28,1,5.52>, <2,1,5.58>, <2,1,2> }
		triangle { <-5.58,1,2>, <-5.52,1,2.28>, <-2,1,2> }
		triangle { <-5.52,1,2.28>, <-4.26,1,4.26>, <-2,1,2> }
		triangle { <-4.26,1,4.26>, <-2.28,1,5.52>, <-2,1,2> }
		triangle { <-2.28,1,5.52>, <-2,1,5.58>, <-2,1,2> }
		triangle { <5.58,1,-2>, <5.52,1,-2.28>, <2,1,-2> }
		triangle { <5.52,1,-2.28>, <4.26,1,-4.26>, <2,1,-2> }
		triangle { <4.26,1,-4.26>, <2.28,1,-5.52>, <2,1,-2> }
		triangle { <2.28,1,-5.52>, <2,1,-5.58>, <2,1,-2> }
		triangle { <-5.58,1,-2>, <-5.52,1,-2.28>, <-2,1,-2> }
		triangle { <-5.52,1,-2.28>, <-4.26,1,-4.26>, <-2,1,-2> }
		triangle { <-4.26,1,-4.26>, <-2.28,1,-5.52>, <-2,1,-2> }
		triangle { <-2.28,1,-5.52>, <-2,1,-5.58>, <-2,1,-2> }
	}
}

#declare ring3_dot_dat = object {
// Official LCad update 98-10
	mesh {
		triangle { <0,0,3>, <-1.1481,0,2.7717>, <-1.5308,0,3.6956> }
		triangle { <-1.5308,0,3.6956>, <0,0,4>, <0,0,3> }
		triangle { <-1.1481,0,2.7717>, <-2.1213,0,2.1213>, <-2.8284,0,2.8284> }
		triangle { <-2.8284,0,2.8284>, <-1.5308,0,3.6956>, <-1.1481,0,2.7717> }
		triangle { <-2.1213,0,2.1213>, <-2.7717,0,1.1481>, <-3.6956,0,1.5308> }
		triangle { <-3.6956,0,1.5308>, <-2.8284,0,2.8284>, <-2.1213,0,2.1213> }
		triangle { <-2.7717,0,1.1481>, <-3,0,0>, <-4,0,0> }
		triangle { <-4,0,0>, <-3.6956,0,1.5308>, <-2.7717,0,1.1481> }
		triangle { <-3,0,0>, <-2.7717,0,-1.1481>, <-3.6956,0,-1.5308> }
		triangle { <-3.6956,0,-1.5308>, <-4,0,0>, <-3,0,0> }
		triangle { <-2.7717,0,-1.1481>, <-2.1213,0,-2.1213>, <-2.8284,0,-2.8284> }
		triangle { <-2.8284,0,-2.8284>, <-3.6956,0,-1.5308>, <-2.7717,0,-1.1481> }
		triangle { <-2.1213,0,-2.1213>, <-1.1481,0,-2.7717>, <-1.5308,0,-3.6956> }
		triangle { <-1.5308,0,-3.6956>, <-2.8284,0,-2.8284>, <-2.1213,0,-2.1213> }
		triangle { <-1.1481,0,-2.7717>, <0,0,-3>, <0,0,-4> }
		triangle { <0,0,-4>, <-1.5308,0,-3.6956>, <-1.1481,0,-2.7717> }
		triangle { <0,0,-3>, <1.1481,0,-2.7717>, <1.5308,0,-3.6956> }
		triangle { <1.5308,0,-3.6956>, <0,0,-4>, <0,0,-3> }
		triangle { <1.1481,0,-2.7717>, <2.1213,0,-2.1213>, <2.8284,0,-2.8284> }
		triangle { <2.8284,0,-2.8284>, <1.5308,0,-3.6956>, <1.1481,0,-2.7717> }
		triangle { <2.1213,0,-2.1213>, <2.7717,0,-1.1481>, <3.6956,0,-1.5308> }
		triangle { <3.6956,0,-1.5308>, <2.8284,0,-2.8284>, <2.1213,0,-2.1213> }
		triangle { <2.7717,0,-1.1481>, <3,0,0>, <4,0,0> }
		triangle { <4,0,0>, <3.6956,0,-1.5308>, <2.7717,0,-1.1481> }
		triangle { <3,0,0>, <2.7717,0,1.1481>, <3.6956,0,1.5308> }
		triangle { <3.6956,0,1.5308>, <4,0,0>, <3,0,0> }
		triangle { <2.7717,0,1.1481>, <2.1213,0,2.1213>, <2.8284,0,2.8284> }
		triangle { <2.8284,0,2.8284>, <3.6956,0,1.5308>, <2.7717,0,1.1481> }
		triangle { <2.1213,0,2.1213>, <1.1481,0,2.7717>, <1.5308,0,3.6956> }
		triangle { <1.5308,0,3.6956>, <2.8284,0,2.8284>, <2.1213,0,2.1213> }
		triangle { <1.1481,0,2.7717>, <0,0,3>, <0,0,4> }
		triangle { <0,0,4>, <1.5308,0,3.6956>, <1.1481,0,2.7717> }
	}
}

#declare ring4_dot_dat = object {
// Official LCad update 98-10
	mesh {
		triangle { <0,0,4>, <-1.5308,0,3.6956>, <-1.9135,0,4.6195> }
		triangle { <-1.9135,0,4.6195>, <0,0,5>, <0,0,4> }
		triangle { <-1.5308,0,3.6956>, <-2.8284,0,2.8284>, <-3.5355,0,3.5355> }
		triangle { <-3.5355,0,3.5355>, <-1.9135,0,4.6195>, <-1.5308,0,3.6956> }
		triangle { <-2.8284,0,2.8284>, <-3.6956,0,1.5308>, <-4.6195,0,1.9135> }
		triangle { <-4.6195,0,1.9135>, <-3.5355,0,3.5355>, <-2.8284,0,2.8284> }
		triangle { <-3.6956,0,1.5308>, <-4,0,0>, <-5,0,0> }
		triangle { <-5,0,0>, <-4.6195,0,1.9135>, <-3.6956,0,1.5308> }
		triangle { <-4,0,0>, <-3.6956,0,-1.5308>, <-4.6195,0,-1.9135> }
		triangle { <-4.6195,0,-1.9135>, <-5,0,0>, <-4,0,0> }
		triangle { <-3.6956,0,-1.5308>, <-2.8284,0,-2.8284>, <-3.5355,0,-3.5355> }
		triangle { <-3.5355,0,-3.5355>, <-4.6195,0,-1.9135>, <-3.6956,0,-1.5308> }
		triangle { <-2.8284,0,-2.8284>, <-1.5308,0,-3.6956>, <-1.9135,0,-4.6195> }
		triangle { <-1.9135,0,-4.6195>, <-3.5355,0,-3.5355>, <-2.8284,0,-2.8284> }
		triangle { <-1.5308,0,-3.6956>, <0,0,-4>, <0,0,-5> }
		triangle { <0,0,-5>, <-1.9135,0,-4.6195>, <-1.5308,0,-3.6956> }
		triangle { <0,0,-4>, <1.5308,0,-3.6956>, <1.9135,0,-4.6195> }
		triangle { <1.9135,0,-4.6195>, <0,0,-5>, <0,0,-4> }
		triangle { <1.5308,0,-3.6956>, <2.8284,0,-2.8284>, <3.5355,0,-3.5355> }
		triangle { <3.5355,0,-3.5355>, <1.9135,0,-4.6195>, <1.5308,0,-3.6956> }
		triangle { <2.8284,0,-2.8284>, <3.6956,0,-1.5308>, <4.6195,0,-1.9135> }
		triangle { <4.6195,0,-1.9135>, <3.5355,0,-3.5355>, <2.8284,0,-2.8284> }
		triangle { <3.6956,0,-1.5308>, <4,0,0>, <5,0,0> }
		triangle { <5,0,0>, <4.6195,0,-1.9135>, <3.6956,0,-1.5308> }
		triangle { <4,0,0>, <3.6956,0,1.5308>, <4.6195,0,1.9135> }
		triangle { <4.6195,0,1.9135>, <5,0,0>, <4,0,0> }
		triangle { <3.6956,0,1.5308>, <2.8284,0,2.8284>, <3.5355,0,3.5355> }
		triangle { <3.5355,0,3.5355>, <4.6195,0,1.9135>, <3.6956,0,1.5308> }
		triangle { <2.8284,0,2.8284>, <1.5308,0,3.6956>, <1.9135,0,4.6195> }
		triangle { <1.9135,0,4.6195>, <3.5355,0,3.5355>, <2.8284,0,2.8284> }
		triangle { <1.5308,0,3.6956>, <0,0,4>, <0,0,5> }
		triangle { <0,0,5>, <1.9135,0,4.6195>, <1.5308,0,3.6956> }
	}
}

#declare _6039_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,40,20> } #else union {
// Cone  2 x  2 x  1 & 2/3 Octagonal
// Name: 6039.dat
// Author: Steve Bliss, (C) 1998, blisses@worldnet.att.net
// Official LCad update 99-01
// CATEGORY Cone
// KEYWORDS aquazone, octagonal, peak, point, pipe
// not CW compliant
	mesh {
		triangle { <8.28,40,20>, <12.28,40,16>, <-12.28,40,16> }
		triangle { <-12.28,40,16>, <-8.28,40,20>, <8.28,40,20> }
		triangle { <12.28,40,16>, <12.28,36,16>, <-12.28,36,16> }
		triangle { <-12.28,36,16>, <-12.28,40,16>, <12.28,40,16> }
		triangle { <20,40,8.28>, <20,32,8.28>, <16,36,12.28> }
		triangle { <16,36,12.28>, <16,40,12.28>, <20,40,8.28> }
		triangle { <16,36,12.28>, <20,32,8.28>, <8.28,32,20> }
		triangle { <8.28,32,20>, <12.28,36,16>, <16,36,12.28> }
		triangle { <12.28,40,16>, <12.28,36,16>, <8.28,32,20> }
		triangle { <8.28,32,20>, <8.28,40,20>, <12.28,40,16> }
		triangle { <8.28,40,20>, <8.28,32,20>, <-8.28,32,20> }
		triangle { <-8.28,32,20>, <-8.28,40,20>, <8.28,40,20> }
		triangle { <16,36,6.6>, <16,36,12.28>, <12.28,36,16> }
		triangle { <12.28,36,16>, <6.6,36,16>, <16,36,6.6> }
		triangle { <-20,40,8.28>, <-16,40,12.28>, <-16,40,-12.28> }
		triangle { <-16,40,-12.28>, <-20,40,-8.28>, <-20,40,8.28> }
		triangle { <-16,40,12.28>, <-16,36,12.28>, <-16,36,-12.28> }
		triangle { <-16,36,-12.28>, <-16,40,-12.28>, <-16,40,12.28> }
		triangle { <-8.28,40,20>, <-8.28,32,20>, <-12.28,36,16> }
		triangle { <-12.28,36,16>, <-12.28,40,16>, <-8.28,40,20> }
		triangle { <-12.28,36,16>, <-8.28,32,20>, <-20,32,8.28> }
		triangle { <-20,32,8.28>, <-16,36,12.28>, <-12.28,36,16> }
		triangle { <-16,40,12.28>, <-16,36,12.28>, <-20,32,8.28> }
		triangle { <-20,32,8.28>, <-20,40,8.28>, <-16,40,12.28> }
		triangle { <-20,40,8.28>, <-20,32,8.28>, <-20,32,-8.28> }
		triangle { <-20,32,-8.28>, <-20,40,-8.28>, <-20,40,8.28> }
		triangle { <-6.6,36,16>, <-12.28,36,16>, <-16,36,12.28> }
		triangle { <-16,36,12.28>, <-16,36,6.6>, <-6.6,36,16> }
		triangle { <-8.28,40,-20>, <-12.28,40,-16>, <12.28,40,-16> }
		triangle { <12.28,40,-16>, <8.28,40,-20>, <-8.28,40,-20> }
		triangle { <-12.28,40,-16>, <-12.28,36,-16>, <12.28,36,-16> }
		triangle { <12.28,36,-16>, <12.28,40,-16>, <-12.28,40,-16> }
		triangle { <-20,40,-8.28>, <-20,32,-8.28>, <-16,36,-12.28> }
		triangle { <-16,36,-12.28>, <-16,40,-12.28>, <-20,40,-8.28> }
		triangle { <-16,36,-12.28>, <-20,32,-8.28>, <-8.28,32,-20> }
		triangle { <-8.28,32,-20>, <-12.28,36,-16>, <-16,36,-12.28> }
		triangle { <-12.28,40,-16>, <-12.28,36,-16>, <-8.28,32,-20> }
		triangle { <-8.28,32,-20>, <-8.28,40,-20>, <-12.28,40,-16> }
		triangle { <-8.28,40,-20>, <-8.28,32,-20>, <8.28,32,-20> }
		triangle { <8.28,32,-20>, <8.28,40,-20>, <-8.28,40,-20> }
		triangle { <-16,36,-6.6>, <-16,36,-12.28>, <-12.28,36,-16> }
		triangle { <-12.28,36,-16>, <-6.6,36,-16>, <-16,36,-6.6> }
		triangle { <20,40,-8.28>, <16,40,-12.28>, <16,40,12.28> }
		triangle { <16,40,12.28>, <20,40,8.28>, <20,40,-8.28> }
		triangle { <16,40,-12.28>, <16,36,-12.28>, <16,36,12.28> }
		triangle { <16,36,12.28>, <16,40,12.28>, <16,40,-12.28> }
		triangle { <8.28,40,-20>, <8.28,32,-20>, <12.28,36,-16> }
		triangle { <12.28,36,-16>, <12.28,40,-16>, <8.28,40,-20> }
		triangle { <12.28,36,-16>, <8.28,32,-20>, <20,32,-8.28> }
		triangle { <20,32,-8.28>, <16,36,-12.28>, <12.28,36,-16> }
		triangle { <16,40,-12.28>, <16,36,-12.28>, <20,32,-8.28> }
		triangle { <20,32,-8.28>, <20,40,-8.28>, <16,40,-12.28> }
		triangle { <20,40,-8.28>, <20,32,-8.28>, <20,32,8.28> }
		triangle { <20,32,8.28>, <20,40,8.28>, <20,40,-8.28> }
		triangle { <6.6,36,-16>, <12.28,36,-16>, <16,36,-12.28> }
		triangle { <16,36,-12.28>, <16,36,-6.6>, <6.6,36,-16> }
		triangle { <10,0,4.14>, <20,32,8.28>, <20,32,-8.28> }
		triangle { <20,32,-8.28>, <10,0,-4.14>, <10,0,4.14> }
		triangle { <10,0,-4.14>, <20,32,-8.28>, <8.28,32,-20> }
		triangle { <8.28,32,-20>, <4.14,0,-10>, <10,0,-4.14> }
		triangle { <4.14,0,-10>, <8.28,32,-20>, <-8.28,32,-20> }
		triangle { <-8.28,32,-20>, <-4.14,0,-10>, <4.14,0,-10> }
		triangle { <-4.14,0,-10>, <-8.28,32,-20>, <-20,32,-8.28> }
		triangle { <-20,32,-8.28>, <-10,0,-4.14>, <-4.14,0,-10> }
		triangle { <-10,0,-4.14>, <-20,32,-8.28>, <-20,32,8.28> }
		triangle { <-20,32,8.28>, <-10,0,4.14>, <-10,0,-4.14> }
		triangle { <-10,0,4.14>, <-20,32,8.28>, <-8.28,32,20> }
		triangle { <-8.28,32,20>, <-4.14,0,10>, <-10,0,4.14> }
		triangle { <-4.14,0,10>, <-8.28,32,20>, <8.28,32,20> }
		triangle { <8.28,32,20>, <4.14,0,10>, <-4.14,0,10> }
		triangle { <4.14,0,10>, <8.28,32,20>, <20,32,8.28> }
		triangle { <20,32,8.28>, <10,0,4.14>, <4.14,0,10> }
	}
	#if (STUDS)
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,0,0> }
	mesh {
		triangle { <10,0,4.14>, <10,0,-4.14>, <6,0,-6> }
		triangle { <6,0,-6>, <6,0,6>, <10,0,4.14> }
		triangle { <10,0,-4.14>, <4.14,0,-10>, <6,0,-6> }
		triangle { <4.14,0,-10>, <-4.14,0,-10>, <-6,0,-6> }
		triangle { <-6,0,-6>, <6,0,-6>, <4.14,0,-10> }
		triangle { <-4.14,0,-10>, <-10,0,-4.14>, <-6,0,-6> }
		triangle { <-10,0,-4.14>, <-10,0,4.14>, <-6,0,6> }
		triangle { <-6,0,6>, <-6,0,-6>, <-10,0,-4.14> }
		triangle { <-10,0,4.14>, <-4.14,0,10>, <-6,0,6> }
		triangle { <-4.14,0,10>, <4.14,0,10>, <6,0,6> }
		triangle { <6,0,6>, <-6,0,6>, <-4.14,0,10> }
		triangle { <4.14,0,10>, <10,0,4.14>, <6,0,6> }
	}
	object { ring2_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,16,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,16,0,0,0,4,0,0,0> }
	object { axlehole_dot_dat matrix <1,0,0,0,16,0,0,0,1,0,16,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,8,0,0,0,6,0,32,0> }
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,40,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,30,0,0,0,8,0,10,0> }
	mesh {
		triangle { <16,36,6.6>, <16,28,6.6>, <16,28,-6.6> }
		triangle { <16,28,-6.6>, <16,36,-6.6>, <16,36,6.6> }
		triangle { <16,36,-6.6>, <16,28,-6.6>, <6.6,28,-16> }
		triangle { <6.6,28,-16>, <6.6,36,-16>, <16,36,-6.6> }
		triangle { <6.6,36,-16>, <6.6,28,-16>, <-6.6,28,-16> }
		triangle { <-6.6,28,-16>, <-6.6,36,-16>, <6.6,36,-16> }
		triangle { <-6.6,36,-16>, <-6.6,28,-16>, <-16,28,-6.6> }
		triangle { <-16,28,-6.6>, <-16,36,-6.6>, <-6.6,36,-16> }
		triangle { <-16,36,-6.6>, <-16,28,-6.6>, <-16,28,6.6> }
		triangle { <-16,28,6.6>, <-16,36,6.6>, <-16,36,-6.6> }
		triangle { <-16,36,6.6>, <-16,28,6.6>, <-6.6,28,16> }
		triangle { <-6.6,28,16>, <-6.6,36,16>, <-16,36,6.6> }
		triangle { <-6.6,36,16>, <-6.6,28,16>, <6.6,28,16> }
		triangle { <6.6,28,16>, <6.6,36,16>, <-6.6,36,16> }
		triangle { <6.6,36,16>, <6.6,28,16>, <16,28,6.6> }
		triangle { <16,28,6.6>, <16,36,6.6>, <6.6,36,16> }
		triangle { <16,28,6.6>, <9.125,10,3.778>, <9.125,10,-3.778> }
		triangle { <9.125,10,-3.778>, <16,28,-6.6>, <16,28,6.6> }
		triangle { <16,28,-6.6>, <9.125,10,-3.778>, <3.778,10,-9.125> }
		triangle { <3.778,10,-9.125>, <6.6,28,-16>, <16,28,-6.6> }
		triangle { <6.6,28,-16>, <3.778,10,-9.125>, <-3.778,10,-9.125> }
		triangle { <-3.778,10,-9.125>, <-6.6,28,-16>, <6.6,28,-16> }
		triangle { <-6.6,28,-16>, <-3.778,10,-9.125>, <-9.125,10,-3.778> }
		triangle { <-9.125,10,-3.778>, <-16,28,-6.6>, <-6.6,28,-16> }
		triangle { <-16,28,-6.6>, <-9.125,10,-3.778>, <-9.125,10,3.778> }
		triangle { <-9.125,10,3.778>, <-16,28,6.6>, <-16,28,-6.6> }
		triangle { <-16,28,6.6>, <-9.125,10,3.778>, <-3.778,10,9.125> }
		triangle { <-3.778,10,9.125>, <-6.6,28,16>, <-16,28,6.6> }
		triangle { <-6.6,28,16>, <-3.778,10,9.125>, <3.778,10,9.125> }
		triangle { <3.778,10,9.125>, <6.6,28,16>, <-6.6,28,16> }
		triangle { <6.6,28,16>, <3.778,10,9.125>, <9.125,10,3.778> }
		triangle { <9.125,10,3.778>, <16,28,6.6>, <6.6,28,16> }
	}
	object { ring4_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,10,0> }
// 
}
#end

#declare peghole_dot_dat = union {
// Peg Hole End
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,2,0,0,0,8,0,0,0> }
	mesh {
		triangle { <0,2,6>, <-2.3,2,5.54>, <-3.06,2,7.39> }
		triangle { <-3.06,2,7.39>, <0,2,8>, <0,2,6> }
		triangle { <-2.3,2,5.54>, <-4.24,2,4.24>, <-5.66,2,5.66> }
		triangle { <-5.66,2,5.66>, <-3.06,2,7.39>, <-2.3,2,5.54> }
		triangle { <-4.24,2,4.24>, <-5.54,2,2.3>, <-7.39,2,3.06> }
		triangle { <-7.39,2,3.06>, <-5.66,2,5.66>, <-4.24,2,4.24> }
		triangle { <-5.54,2,2.3>, <-6,2,0>, <-8,2,0> }
		triangle { <-8,2,0>, <-7.39,2,3.06>, <-5.54,2,2.3> }
		triangle { <-6,2,0>, <-5.54,2,-2.3>, <-7.39,2,-3.06> }
		triangle { <-7.39,2,-3.06>, <-8,2,0>, <-6,2,0> }
		triangle { <-5.54,2,-2.3>, <-4.24,2,-4.24>, <-5.66,2,-5.66> }
		triangle { <-5.66,2,-5.66>, <-7.39,2,-3.06>, <-5.54,2,-2.3> }
		triangle { <-4.24,2,-4.24>, <-2.3,2,-5.54>, <-3.06,2,-7.39> }
		triangle { <-3.06,2,-7.39>, <-5.66,2,-5.66>, <-4.24,2,-4.24> }
		triangle { <-2.3,2,-5.54>, <0,2,-6>, <0,2,-8> }
		triangle { <0,2,-8>, <-3.06,2,-7.39>, <-2.3,2,-5.54> }
		triangle { <0,2,-6>, <2.3,2,-5.54>, <3.06,2,-7.39> }
		triangle { <3.06,2,-7.39>, <0,2,-8>, <0,2,-6> }
		triangle { <2.3,2,-5.54>, <4.24,2,-4.24>, <5.66,2,-5.66> }
		triangle { <5.66,2,-5.66>, <3.06,2,-7.39>, <2.3,2,-5.54> }
		triangle { <4.24,2,-4.24>, <5.54,2,-2.3>, <7.39,2,-3.06> }
		triangle { <7.39,2,-3.06>, <5.66,2,-5.66>, <4.24,2,-4.24> }
		triangle { <5.54,2,-2.3>, <6,2,0>, <8,2,0> }
		triangle { <8,2,0>, <7.39,2,-3.06>, <5.54,2,-2.3> }
		triangle { <6,2,0>, <5.54,2,2.3>, <7.39,2,3.06> }
		triangle { <7.39,2,3.06>, <8,2,0>, <6,2,0> }
		triangle { <5.54,2,2.3>, <4.24,2,4.24>, <5.66,2,5.66> }
		triangle { <5.66,2,5.66>, <7.39,2,3.06>, <5.54,2,2.3> }
		triangle { <4.24,2,4.24>, <2.3,2,5.54>, <3.06,2,7.39> }
		triangle { <3.06,2,7.39>, <5.66,2,5.66>, <4.24,2,4.24> }
		triangle { <2.3,2,5.54>, <0,2,6>, <0,2,8> }
		triangle { <0,2,8>, <3.06,2,7.39>, <2.3,2,5.54> }
	}
}

#declare _3062b_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else union {
// Brick  1 x  1 Round
	object { peghole_dot_dat matrix <1,0,0,0,2.5,0,0,0,1,0,19,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,20,0,0,0,6,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <10,0,0,0,19,0,0,0,10,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,0,0,0> }
	#if (STUDS)
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
	mesh {
		triangle { <0,19,8>, <-3.06,19,7.39>, <-3.83,19,9.24> }
		triangle { <-3.83,19,9.24>, <0,19,10>, <0,19,8> }
		triangle { <0,4,4>, <-1.53,4,3.7>, <-2.3,4,5.54> }
		triangle { <-2.3,4,5.54>, <0,4,6>, <0,4,4> }
		triangle { <0,0,6>, <-2.3,0,5.54>, <-3.83,0,9.24> }
		triangle { <-3.83,0,9.24>, <0,0,10>, <0,0,6> }
		triangle { <-3.06,19,7.39>, <-5.66,19,5.66>, <-7.07,19,7.07> }
		triangle { <-7.07,19,7.07>, <-3.83,19,9.24>, <-3.06,19,7.39> }
		triangle { <-1.53,4,3.7>, <-2.83,4,2.83>, <-4.24,4,4.24> }
		triangle { <-4.24,4,4.24>, <-2.3,4,5.54>, <-1.53,4,3.7> }
		triangle { <-2.3,0,5.54>, <-4.24,0,4.24>, <-7.07,0,7.07> }
		triangle { <-7.07,0,7.07>, <-3.83,0,9.24>, <-2.3,0,5.54> }
		triangle { <-5.66,19,5.66>, <-7.39,19,3.06>, <-9.24,19,3.83> }
		triangle { <-9.24,19,3.83>, <-7.07,19,7.07>, <-5.66,19,5.66> }
		triangle { <-2.83,4,2.83>, <-3.7,4,1.53>, <-5.54,4,2.3> }
		triangle { <-5.54,4,2.3>, <-4.24,4,4.24>, <-2.83,4,2.83> }
		triangle { <-4.24,0,4.24>, <-5.54,0,2.3>, <-9.24,0,3.83> }
		triangle { <-9.24,0,3.83>, <-7.07,0,7.07>, <-4.24,0,4.24> }
		triangle { <-7.39,19,3.06>, <-8,19,0>, <-10,19,0> }
		triangle { <-10,19,0>, <-9.24,19,3.83>, <-7.39,19,3.06> }
		triangle { <-3.7,4,1.53>, <-4,4,0>, <-6,4,0> }
		triangle { <-6,4,0>, <-5.54,4,2.3>, <-3.7,4,1.53> }
		triangle { <-5.54,0,2.3>, <-6,0,0>, <-10,0,0> }
		triangle { <-10,0,0>, <-9.24,0,3.83>, <-5.54,0,2.3> }
		triangle { <-8,19,0>, <-7.39,19,-3.06>, <-9.24,19,-3.83> }
		triangle { <-9.24,19,-3.83>, <-10,19,0>, <-8,19,0> }
		triangle { <-4,4,0>, <-3.7,4,-1.53>, <-5.54,4,-2.3> }
		triangle { <-5.54,4,-2.3>, <-6,4,0>, <-4,4,0> }
		triangle { <-6,0,0>, <-5.54,0,-2.3>, <-9.24,0,-3.83> }
		triangle { <-9.24,0,-3.83>, <-10,0,0>, <-6,0,0> }
		triangle { <-7.39,19,-3.06>, <-5.66,19,-5.66>, <-7.07,19,-7.07> }
		triangle { <-7.07,19,-7.07>, <-9.24,19,-3.83>, <-7.39,19,-3.06> }
		triangle { <-3.7,4,-1.53>, <-2.83,4,-2.83>, <-4.24,4,-4.24> }
		triangle { <-4.24,4,-4.24>, <-5.54,4,-2.3>, <-3.7,4,-1.53> }
		triangle { <-5.54,0,-2.3>, <-4.24,0,-4.24>, <-7.07,0,-7.07> }
		triangle { <-7.07,0,-7.07>, <-9.24,0,-3.83>, <-5.54,0,-2.3> }
		triangle { <-5.66,19,-5.66>, <-3.06,19,-7.39>, <-3.83,19,-9.24> }
		triangle { <-3.83,19,-9.24>, <-7.07,19,-7.07>, <-5.66,19,-5.66> }
		triangle { <-2.83,4,-2.83>, <-1.53,4,-3.7>, <-2.3,4,-5.54> }
		triangle { <-2.3,4,-5.54>, <-4.24,4,-4.24>, <-2.83,4,-2.83> }
		triangle { <-4.24,0,-4.24>, <-2.3,0,-5.54>, <-3.83,0,-9.24> }
		triangle { <-3.83,0,-9.24>, <-7.07,0,-7.07>, <-4.24,0,-4.24> }
		triangle { <-3.06,19,-7.39>, <0,19,-8>, <0,19,-10> }
		triangle { <0,19,-10>, <-3.83,19,-9.24>, <-3.06,19,-7.39> }
		triangle { <-1.53,4,-3.7>, <0,4,-4>, <0,4,-6> }
		triangle { <0,4,-6>, <-2.3,4,-5.54>, <-1.53,4,-3.7> }
		triangle { <-2.3,0,-5.54>, <0,0,-6>, <0,0,-10> }
		triangle { <0,0,-10>, <-3.83,0,-9.24>, <-2.3,0,-5.54> }
		triangle { <0,19,-8>, <3.06,19,-7.39>, <3.83,19,-9.24> }
		triangle { <3.83,19,-9.24>, <0,19,-10>, <0,19,-8> }
		triangle { <0,4,-4>, <1.53,4,-3.7>, <2.3,4,-5.54> }
		triangle { <2.3,4,-5.54>, <0,4,-6>, <0,4,-4> }
		triangle { <0,0,-6>, <2.3,0,-5.54>, <3.83,0,-9.24> }
		triangle { <3.83,0,-9.24>, <0,0,-10>, <0,0,-6> }
		triangle { <3.06,19,-7.39>, <5.66,19,-5.66>, <7.07,19,-7.07> }
		triangle { <7.07,19,-7.07>, <3.83,19,-9.24>, <3.06,19,-7.39> }
		triangle { <1.53,4,-3.7>, <2.83,4,-2.83>, <4.24,4,-4.24> }
		triangle { <4.24,4,-4.24>, <2.3,4,-5.54>, <1.53,4,-3.7> }
		triangle { <2.3,0,-5.54>, <4.24,0,-4.24>, <7.07,0,-7.07> }
		triangle { <7.07,0,-7.07>, <3.83,0,-9.24>, <2.3,0,-5.54> }
		triangle { <5.66,19,-5.66>, <7.39,19,-3.06>, <9.24,19,-3.83> }
		triangle { <9.24,19,-3.83>, <7.07,19,-7.07>, <5.66,19,-5.66> }
		triangle { <2.83,4,-2.83>, <3.7,4,-1.53>, <5.54,4,-2.3> }
		triangle { <5.54,4,-2.3>, <4.24,4,-4.24>, <2.83,4,-2.83> }
		triangle { <4.24,0,-4.24>, <5.54,0,-2.3>, <9.24,0,-3.83> }
		triangle { <9.24,0,-3.83>, <7.07,0,-7.07>, <4.24,0,-4.24> }
		triangle { <7.39,19,-3.06>, <8,19,0>, <10,19,0> }
		triangle { <10,19,0>, <9.24,19,-3.83>, <7.39,19,-3.06> }
		triangle { <3.7,4,-1.53>, <4,4,0>, <6,4,0> }
		triangle { <6,4,0>, <5.54,4,-2.3>, <3.7,4,-1.53> }
		triangle { <5.54,0,-2.3>, <6,0,0>, <10,0,0> }
		triangle { <10,0,0>, <9.24,0,-3.83>, <5.54,0,-2.3> }
		triangle { <8,19,0>, <7.39,19,3.06>, <9.24,19,3.83> }
		triangle { <9.24,19,3.83>, <10,19,0>, <8,19,0> }
		triangle { <4,4,0>, <3.7,4,1.53>, <5.54,4,2.3> }
		triangle { <5.54,4,2.3>, <6,4,0>, <4,4,0> }
		triangle { <6,0,0>, <5.54,0,2.3>, <9.24,0,3.83> }
		triangle { <9.24,0,3.83>, <10,0,0>, <6,0,0> }
		triangle { <7.39,19,3.06>, <5.66,19,5.66>, <7.07,19,7.07> }
		triangle { <7.07,19,7.07>, <9.24,19,3.83>, <7.39,19,3.06> }
		triangle { <3.7,4,1.53>, <2.83,4,2.83>, <4.24,4,4.24> }
		triangle { <4.24,4,4.24>, <5.54,4,2.3>, <3.7,4,1.53> }
		triangle { <5.54,0,2.3>, <4.24,0,4.24>, <7.07,0,7.07> }
		triangle { <7.07,0,7.07>, <9.24,0,3.83>, <5.54,0,2.3> }
		triangle { <5.66,19,5.66>, <3.06,19,7.39>, <3.83,19,9.24> }
		triangle { <3.83,19,9.24>, <7.07,19,7.07>, <5.66,19,5.66> }
		triangle { <2.83,4,2.83>, <1.53,4,3.7>, <2.3,4,5.54> }
		triangle { <2.3,4,5.54>, <4.24,4,4.24>, <2.83,4,2.83> }
		triangle { <4.24,0,4.24>, <2.3,0,5.54>, <3.83,0,9.24> }
		triangle { <3.83,0,9.24>, <7.07,0,7.07>, <4.24,0,4.24> }
		triangle { <3.06,19,7.39>, <0,19,8>, <0,19,10> }
		triangle { <0,19,10>, <3.83,19,9.24>, <3.06,19,7.39> }
		triangle { <1.53,4,3.7>, <0,4,4>, <0,4,6> }
		triangle { <0,4,6>, <2.3,4,5.54>, <1.53,4,3.7> }
		triangle { <2.3,0,5.54>, <0,0,6>, <0,0,10> }
		triangle { <0,0,10>, <3.83,0,9.24>, <2.3,0,5.54> }
	}
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_2921)
		#include "lg_2921.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _2921_dot_dat = #if (QUAL = 0) box { <-10,-4,-24>, <10,24,10> } #else object {
// Brick  1 x  1 with Handle
	lg_2921
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _2921_dot_dat_clear = #if (QUAL = 0) box { <-10,-4,-24>, <10,24,10> } #else object {
// Brick  1 x  1 with Handle
	lg_2921_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _4_dash_4con1_dot_dat = object {
// 4/4 Cone 1:2 radii
// Name: 4-4con1.dat
// Author: Steve Bliss
// Official LCad Primitive 2000-01
// 19990819 SEB Renamed 4-4con12.dat to 4-4con1.dat
// 19990819 SEB Moved all conditional lines before quads
	mesh {
		triangle { <0,1,1>, <-0.3827,1,0.9239>, <-0.7654,0,1.8478> }
		triangle { <-0.7654,0,1.8478>, <0,0,2>, <0,1,1> }
		triangle { <-0.3827,1,0.9239>, <-0.7071,1,0.7071>, <-1.4142,0,1.4142> }
		triangle { <-1.4142,0,1.4142>, <-0.7654,0,1.8478>, <-0.3827,1,0.9239> }
		triangle { <-0.7071,1,0.7071>, <-0.9239,1,0.3827>, <-1.8478,0,0.7654> }
		triangle { <-1.8478,0,0.7654>, <-1.4142,0,1.4142>, <-0.7071,1,0.7071> }
		triangle { <-0.9239,1,0.3827>, <-1,1,0>, <-2,0,0> }
		triangle { <-2,0,0>, <-1.8478,0,0.7654>, <-0.9239,1,0.3827> }
		triangle { <-1,1,0>, <-0.9239,1,-0.3827>, <-1.8478,0,-0.7654> }
		triangle { <-1.8478,0,-0.7654>, <-2,0,0>, <-1,1,0> }
		triangle { <-0.9239,1,-0.3827>, <-0.7071,1,-0.7071>, <-1.4142,0,-1.4142> }
		triangle { <-1.4142,0,-1.4142>, <-1.8478,0,-0.7654>, <-0.9239,1,-0.3827> }
		triangle { <-0.7071,1,-0.7071>, <-0.3827,1,-0.9239>, <-0.7654,0,-1.8478> }
		triangle { <-0.7654,0,-1.8478>, <-1.4142,0,-1.4142>, <-0.7071,1,-0.7071> }
		triangle { <-0.3827,1,-0.9239>, <0,1,-1>, <0,0,-2> }
		triangle { <0,0,-2>, <-0.7654,0,-1.8478>, <-0.3827,1,-0.9239> }
		triangle { <0,1,-1>, <0.3827,1,-0.9239>, <0.7654,0,-1.8478> }
		triangle { <0.7654,0,-1.8478>, <0,0,-2>, <0,1,-1> }
		triangle { <0.3827,1,-0.9239>, <0.7071,1,-0.7071>, <1.4142,0,-1.4142> }
		triangle { <1.4142,0,-1.4142>, <0.7654,0,-1.8478>, <0.3827,1,-0.9239> }
		triangle { <0.7071,1,-0.7071>, <0.9239,1,-0.3827>, <1.8478,0,-0.7654> }
		triangle { <1.8478,0,-0.7654>, <1.4142,0,-1.4142>, <0.7071,1,-0.7071> }
		triangle { <0.9239,1,-0.3827>, <1,1,0>, <2,0,0> }
		triangle { <2,0,0>, <1.8478,0,-0.7654>, <0.9239,1,-0.3827> }
		triangle { <1,1,0>, <0.9239,1,0.3827>, <1.8478,0,0.7654> }
		triangle { <1.8478,0,0.7654>, <2,0,0>, <1,1,0> }
		triangle { <0.9239,1,0.3827>, <0.7071,1,0.7071>, <1.4142,0,1.4142> }
		triangle { <1.4142,0,1.4142>, <1.8478,0,0.7654>, <0.9239,1,0.3827> }
		triangle { <0.7071,1,0.7071>, <0.3827,1,0.9239>, <0.7654,0,1.8478> }
		triangle { <0.7654,0,1.8478>, <1.4142,0,1.4142>, <0.7071,1,0.7071> }
		triangle { <0.3827,1,0.9239>, <0,1,1>, <0,0,2> }
		triangle { <0,0,2>, <0.7654,0,1.8478>, <0.3827,1,0.9239> }
	}
}

#declare _1_dash_8sphe_dot_dat = object {
// Sphere 0.125
// Name: 1-8sphe.dat
// Author: James Jessiman
// Original LDraw Primitive - 2000-02 Update
// 2000-Aug Axel Poque, Manfred Moolhuysen - fixes to resolve L3P error messages.
	mesh {
		triangle { <0,1,0>, <0.3827,0.9239,0>, <0.3827,0.8409,0.3827> }
		triangle { <0.3827,0.8409,0.3827>, <0,0.9239,0.3827>, <0,1,0> }
		triangle { <0.3827,0.9239,0>, <0.7071,0.7071,0>, <0.6533,0.6533,0.3827> }
		triangle { <0.6533,0.6533,0.3827>, <0.3827,0.8409,0.3827>, <0.3827,0.9239,0> }
		triangle { <0.7071,0.7071,0>, <0.9239,0.3827,0>, <0.8409,0.3827,0.3827> }
		triangle { <0.8409,0.3827,0.3827>, <0.6533,0.6533,0.3827>, <0.7071,0.7071,0> }
		triangle { <0.9239,0.3827,0>, <1,0,0>, <0.9239,0,0.3827> }
		triangle { <0.9239,0,0.3827>, <0.8409,0.3827,0.3827>, <0.9239,0.3827,0> }
		triangle { <0,0.9239,0.3827>, <0.3827,0.8409,0.3827>, <0.3827,0.6533,0.6533> }
		triangle { <0.3827,0.6533,0.6533>, <0,0.7071,0.7071>, <0,0.9239,0.3827> }
		triangle { <0.3827,0.8409,0.3827>, <0.3827,0.6533,0.6533>, <0.6533,0.6533,0.3827> }
		triangle { <0.6533,0.6533,0.3827>, <0.3827,0.6533,0.6533>, <0.6533,0.3827,0.6533> }
		triangle { <0.6533,0.6533,0.3827>, <0.6533,0.3827,0.6533>, <0.8409,0.3827,0.3827> }
		triangle { <0.9239,0,0.3827>, <0.8409,0.3827,0.3827>, <0.6533,0.3827,0.6533> }
		triangle { <0.6533,0.3827,0.6533>, <0.7071,0,0.7071>, <0.9239,0,0.3827> }
		triangle { <0,0.7071,0.7071>, <0.3827,0.6533,0.6533>, <0.3827,0.3827,0.8409> }
		triangle { <0.3827,0.3827,0.8409>, <0,0.3827,0.9239>, <0,0.7071,0.7071> }
		triangle { <0.3827,0.6533,0.6533>, <0.3827,0.3827,0.8409>, <0.6533,0.3827,0.6533> }
		triangle { <0.7071,0,0.7071>, <0.6533,0.3827,0.6533>, <0.3827,0.3827,0.8409> }
		triangle { <0.3827,0.3827,0.8409>, <0.3827,0,0.9239>, <0.7071,0,0.7071> }
		triangle { <0,0.3827,0.9239>, <0.3827,0.3827,0.8409>, <0.3827,0,0.9239> }
		triangle { <0.3827,0,0.9239>, <0,0,1>, <0,0.3827,0.9239> }
// 
	}
}

#declare _8_dash_8sphe_dot_dat = union {
	object { _1_dash_8sphe_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	object { _1_dash_8sphe_dot_dat matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
	object { _1_dash_8sphe_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,0,0> }
	object { _1_dash_8sphe_dot_dat matrix <1,0,0,0,-1,0,0,0,-1,0,0,0> }
	object { _1_dash_8sphe_dot_dat matrix <-1,0,0,0,1,0,0,0,1,0,0,0> }
	object { _1_dash_8sphe_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,0,0,0> }
	object { _1_dash_8sphe_dot_dat matrix <-1,0,0,0,-1,0,0,0,1,0,0,0> }
	object { _1_dash_8sphe_dot_dat matrix <-1,0,0,0,-1,0,0,0,-1,0,0,0> }
}

#declare _4_dash_4disc_dot_dat = object {
// Disc
// Official LCad update 98-10
	mesh {
		triangle { <0,0,0>, <1,0,0>, <0.9239,0,0.3827> }
		triangle { <0,0,0>, <0.9239,0,0.3827>, <0.7071,0,0.7071> }
		triangle { <0,0,0>, <0.7071,0,0.7071>, <0.3827,0,0.9239> }
		triangle { <0,0,0>, <0.3827,0,0.9239>, <0,0,1> }
		triangle { <0,0,0>, <0,0,1>, <-0.3827,0,0.9239> }
		triangle { <0,0,0>, <-0.3827,0,0.9239>, <-0.7071,0,0.7071> }
		triangle { <0,0,0>, <-0.7071,0,0.7071>, <-0.9239,0,0.3827> }
		triangle { <0,0,0>, <-0.9239,0,0.3827>, <-1,0,0> }
		triangle { <0,0,0>, <-1,0,0>, <-0.9239,0,-0.3827> }
		triangle { <0,0,0>, <-0.9239,0,-0.3827>, <-0.7071,0,-0.7071> }
		triangle { <0,0,0>, <-0.7071,0,-0.7071>, <-0.3827,0,-0.9239> }
		triangle { <0,0,0>, <-0.3827,0,-0.9239>, <0,0,-1> }
		triangle { <0,0,0>, <0,0,-1>, <0.3827,0,-0.9239> }
		triangle { <0,0,0>, <0.3827,0,-0.9239>, <0.7071,0,-0.7071> }
		triangle { <0,0,0>, <0.7071,0,-0.7071>, <0.9239,0,-0.3827> }
		triangle { <0,0,0>, <0.9239,0,-0.3827>, <1,0,0> }
	}
}

#declare _104_dot_dat = #if (QUAL = 0) box { <-5,-145,-5>, <5,0,5> } #else union {
// Antenna 6H
// Name: 104.dat
// Author: Steve Bliss
// Official LCad Part 2000-01
// BFC CERTIFY CW
// 19990819 SEB Fixed CW-ness, 4-4con12.dat>>4-4con1.dat, added CMDLINE
// CATEGORY Antenna
// KEYWORDS chrome, Belville, Model Team, whip, rod
// CMDLINE -C383
	object { _4_dash_4disc_dot_dat matrix <5,0,0,0,1,0,0,0,5,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <5,0,0,0,3,0,0,0,5,0,-3,0> }
	object { _4_dash_4disc_dot_dat matrix <5,0,0,0,1,0,0,0,5,0,-3,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,29,0,0,0,4,0,-32,0> }
	object { _4_dash_4con1_dot_dat matrix <-2,0,0,0,-2,0,0,0,2,0,-32,0> }
	object { _4_dash_4cyli_dot_dat matrix <2,0,0,0,107,0,0,0,2,0,-141,0> }
	object { _8_dash_8sphe_dot_dat matrix <4,0,0,0,4,0,0,0,4,0,-141,0> }
// 
}
#end

#declare stud4a_dot_dat = union {
// Stud 4A
// Name: stud4a.dat
// Author: Chris Dee
// Official LCad update 99-05
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,0,-4,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,4,0,0,0,8,0,-4,0> }
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,-4,0> }
// 
}

#declare stud4_dot_dat = union {
// Stud 4
// Name: stud4.dat
// Author: Chris Dee
// Official LCad update 99-05
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,0,-4,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,4,0,0,0,8,0,-4,0> }
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,-4,0> }
// 
}

#declare _2_dash_4cyls_dot_dat = object {
// 2-4 Cylinder Sloped
// Official LCad update 98-10
	mesh {
		triangle { <1,0,0>, <0.9239,0,0.3827>, <0.9239,0.0761,0.3827> }
		triangle { <0.9239,0,0.3827>, <0.7071,0,0.7071>, <0.7071,0.2929,0.7071> }
		triangle { <0.7071,0.2929,0.7071>, <0.9239,0.0761,0.3827>, <0.9239,0,0.3827> }
		triangle { <0.7071,0,0.7071>, <0.3827,0,0.9239>, <0.3827,0.6173,0.9239> }
		triangle { <0.3827,0.6173,0.9239>, <0.7071,0.2929,0.7071>, <0.7071,0,0.7071> }
		triangle { <0.3827,0,0.9239>, <0,0,1>, <0,1,1> }
		triangle { <0,1,1>, <0.3827,0.6173,0.9239>, <0.3827,0,0.9239> }
		triangle { <0,0,1>, <-0.3827,0,0.9239>, <-0.3827,1.3827,0.9239> }
		triangle { <-0.3827,1.3827,0.9239>, <0,1,1>, <0,0,1> }
		triangle { <-0.3827,0,0.9239>, <-0.7071,0,0.7071>, <-0.7071,1.7071,0.7071> }
		triangle { <-0.7071,1.7071,0.7071>, <-0.3827,1.3827,0.9239>, <-0.3827,0,0.9239> }
		triangle { <-0.7071,0,0.7071>, <-0.9239,0,0.3827>, <-0.9239,1.9239,0.3827> }
		triangle { <-0.9239,1.9239,0.3827>, <-0.7071,1.7071,0.7071>, <-0.7071,0,0.7071> }
		triangle { <-0.9239,0,0.3827>, <-1,0,0>, <-1,2,0> }
		triangle { <-1,2,0>, <-0.9239,1.9239,0.3827>, <-0.9239,0,0.3827> }
	}
}

#declare stud_dot_dat = union {
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,-4,0,0,0,6,0,0,0> }
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,-4,0> }
}

#declare _30303_dot_dat = #if (QUAL = 0) box { <-60,-12,-60>, <60,8,60> } #else union {
// Plate  6 x  6 x  2/3 Cross with Dome
// Name: 30303.dat
// Author: Paul Easter, pneaster@aol.com
// Official LCad Part 2000-01
// CATEGORY Plate
// KEYWORDS: wing, cross, foot, round, circle, space, rock, raiders,
// KEYWORDS: rockraiders, underground, starwars, star, wars, sith, infiltrator
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1.25,0,0,0,1,40,3,0> }
	#end
	object { _4_dash_4disc_dot_dat matrix <6,1.5,0,1,0,0,0,0,6,40,1.5,0> }
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1.25,0,0,0,1,-40,3,0> }
	#end
	object { _4_dash_4disc_dot_dat matrix <-6,1.5,0,1,0,0,0,0,6,-40,1.5,0> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-3,0,0,0,1,0,-4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-3,0,0,0,1,0,-4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-3,0,0,0,1,0,-4,-20> }
// 
// 
// <>-- quadrant (+x,y,+z) --<>
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,-8,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,-8,10> }
// 
// bottom surface
	#end
	mesh {
		triangle { <20,8,60>, <0,8,60>, <0,8,56> }
		triangle { <0,8,56>, <16,8,56>, <20,8,60> }
		triangle { <20,8,60>, <20,8,0>, <16,8,0> }
		triangle { <16,8,0>, <16,8,56>, <20,8,60> }
		triangle { <16,8,40>, <0,8,40>, <0,8,36> }
		triangle { <0,8,36>, <16,8,36>, <16,8,40> }
		triangle { <20,8,12>, <24,8,12>, <24,8,8> }
		triangle { <24,8,8>, <20,8,8>, <20,8,12> }
		triangle { <8,8,40>, <8,8,44>, <12,8,44> }
		triangle { <12,8,44>, <12,8,40>, <8,8,40> }
		triangle { <20,8,32>, <20,8,40>, <22,8,33> }
		triangle { <22,8,33>, <20,8,40>, <26,8,35> }
		triangle { <26,8,35>, <23,8,32>, <22,8,33> }
		triangle { <28,8,16>, <28,8,24>, <32,8,24> }
		triangle { <32,8,24>, <32,8,16>, <28,8,16> }
		triangle { <52,8,18.3>, <52,8,16>, <48,8,16> }
		triangle { <48,8,16>, <48,8,19.7>, <52,8,18.3> }
		triangle { <34.5,8,24.3>, <36.8,8,27.5>, <60,8,20> }
		triangle { <60,8,20>, <56,8,16.8>, <34.5,8,24.3> }
		triangle { <56,8,16.8>, <60,8,20>, <60,8,0> }
		triangle { <60,8,0>, <56,8,0>, <56,8,16.8> }
// 
// outside surface
		triangle { <20,-8,40>, <0,-8,40>, <0,0,40> }
		triangle { <0,0,40>, <20,0,40>, <20,-8,40> }
		triangle { <20,-8,40>, <0,-8,40>, <0,-8,0> }
		triangle { <0,-8,0>, <20,-8,0>, <20,-8,40> }
		triangle { <20,8,40>, <20,-1,40>, <26,-1,35> }
		triangle { <26,-1,35>, <26,8,35>, <20,8,40> }
		triangle { <26,3,35>, <26,-1,35>, <30,-1,30> }
		triangle { <30,-1,30>, <30,3,30>, <26,3,35> }
		triangle { <30,3,30>, <30,0,30>, <36.8,0,27.5> }
		triangle { <36.8,0,27.5>, <36.8,3,27.5>, <30,3,30> }
		triangle { <36.8,8,27.5>, <36.8,0,27.5>, <60,0,20> }
		triangle { <60,0,20>, <60,8,20>, <36.8,8,27.5> }
		triangle { <60,8,20>, <60,0,20>, <60,0,0> }
		triangle { <60,0,0>, <60,8,0>, <60,8,20> }
		triangle { <60,0,20>, <30,0,30>, <36,0,20> }
		triangle { <60,0,20>, <36,0,20>, <39,0,9> }
		triangle { <60,0,20>, <39,0,9>, <40,0,0> }
		triangle { <40,0,0>, <60,0,0>, <60,0,20> }
		triangle { <30,0,30>, <30,-1,30>, <36,-1,20> }
		triangle { <36,-1,20>, <36,0,20>, <30,0,30> }
		triangle { <36,0,20>, <36,-1,20>, <39,-1,9> }
		triangle { <39,-1,9>, <39,0,9>, <36,0,20> }
		triangle { <39,0,9>, <39,-1,9>, <40,-1,0> }
		triangle { <40,-1,0>, <40,0,0>, <39,0,9> }
		triangle { <20,-1,40>, <26,-1,35>, <20,-5,29> }
		triangle { <26,-1,35>, <20,-5,29>, <20,-6,22> }
		triangle { <20,-6,22>, <30,-1,30>, <26,-1,35> }
		triangle { <30,-1,30>, <20,-6,22>, <20,-7,13> }
		triangle { <20,-7,13>, <36,-1,20>, <30,-1,30> }
		triangle { <36,-1,20>, <20,-7,13>, <20,-8,6> }
		triangle { <20,-8,6>, <39,-1,9>, <36,-1,20> }
		triangle { <39,-1,9>, <20,-8,6>, <20,-8,0> }
		triangle { <20,-8,0>, <40,-1,0>, <39,-1,9> }
		triangle { <20,-1,40>, <20,-5,29>, <20,-8,29> }
		triangle { <20,-8,29>, <20,-8,40>, <20,-1,40> }
		triangle { <20,-5,29>, <20,-6,22>, <20,-8,22> }
		triangle { <20,-8,22>, <20,-8,29>, <20,-5,29> }
		triangle { <20,-6,22>, <20,-7,13>, <20,-8,13> }
		triangle { <20,-8,13>, <20,-8,22>, <20,-6,22> }
		triangle { <20,-7,13>, <20,-8,6>, <20,-8,13> }
		triangle { <20,0,60>, <20,0,40>, <0,0,40> }
		triangle { <0,0,40>, <0,0,60>, <20,0,60> }
		triangle { <20,0,60>, <20,0,40>, <20,8,40> }
		triangle { <20,8,40>, <20,8,60>, <20,0,60> }
		triangle { <20,0,60>, <0,0,60>, <0,8,60> }
		triangle { <0,8,60>, <20,8,60>, <20,0,60> }
// 
// inside surfaces
		triangle { <16,3,56>, <0,3,56>, <0,3,44> }
		triangle { <0,3,44>, <16,3,44>, <16,3,56> }
		triangle { <16,3,44>, <12,3,44>, <12,3,40> }
		triangle { <12,3,40>, <16,3,40>, <16,3,44> }
		triangle { <8,3,44>, <0,3,44>, <0,3,40> }
		triangle { <0,3,40>, <8,3,40>, <8,3,44> }
		triangle { <16,3,56>, <0,3,56>, <0,8,56> }
		triangle { <0,8,56>, <16,8,56>, <16,3,56> }
		triangle { <16,3,56>, <16,8,56>, <16,8,40> }
		triangle { <16,8,40>, <16,3,40>, <16,3,56> }
		triangle { <16,-4,36>, <0,-4,36>, <0,-4,0> }
		triangle { <0,-4,0>, <16,-4,0>, <16,-4,36> }
		triangle { <16,-4,36>, <0,-4,36>, <0,8,36> }
		triangle { <0,8,36>, <16,8,36>, <16,-4,36> }
		triangle { <16,-4,36>, <16,8,36>, <16,8,0> }
		triangle { <16,8,0>, <16,-4,0>, <16,-4,36> }
		triangle { <12,3,40>, <12,8,40>, <12,8,44> }
		triangle { <12,8,44>, <12,3,44>, <12,3,40> }
		triangle { <8,3,40>, <8,8,40>, <8,8,44> }
		triangle { <8,8,44>, <8,3,44>, <8,3,40> }
		triangle { <8,3,44>, <12,3,44>, <12,8,44> }
		triangle { <12,8,44>, <8,8,44>, <8,3,44> }
		triangle { <8,8,40>, <0,8,40>, <0,3,40> }
		triangle { <0,3,40>, <8,3,40>, <8,8,40> }
		triangle { <16,8,40>, <12,8,40>, <12,3,40> }
		triangle { <12,3,40>, <16,3,40>, <16,8,40> }
		triangle { <56,3,0>, <56,3,16.8>, <47.391,3,3.062> }
		triangle { <47.391,3,3.062>, <48,3,0>, <56,3,0> }
		triangle { <56,3,16.8>, <45.6,3,5.7>, <47.391,3,3.062> }
		triangle { <48,3,19.7>, <34.5,3,24.3>, <40,3,8> }
		triangle { <40,3,8>, <43.062,3,7.391>, <48,3,19.7> }
		triangle { <56,3,16.8>, <52,3,16>, <43.062,3,7.391> }
		triangle { <43.062,3,7.391>, <45.6,3,5.7>, <56,3,16.8> }
		triangle { <52,3,16>, <52,3,18.3>, <56,3,16.8> }
		triangle { <52,3,16>, <43.062,3,7.391>, <48,3,16> }
		triangle { <48,3,19.7>, <43.062,3,7.391>, <48,3,16> }
		triangle { <32,3,18.5>, <35.5,3,6.8>, <40,3,8> }
		triangle { <40,3,8>, <34.5,3,24.3>, <32,3,18.5> }
		triangle { <35.5,3,6.8>, <34.343,3,5.657>, <34.343,0.5,5.657> }
		triangle { <34.343,0.5,5.657>, <35.5,1,6.8>, <35.5,3,6.8> }
		triangle { <34.343,3,5.657>, <32.609,3,3.062>, <32.609,-0.3,3.062> }
		triangle { <32.609,-0.3,3.062>, <34.343,0.5,5.657>, <34.343,3,5.657> }
		triangle { <32.609,3,3.062>, <32,3,0>, <32,-0.8,0> }
		triangle { <32,-0.8,0>, <32.609,-0.3,3.062>, <32.609,3,3.062> }
	}
	object { _2_dash_4cyls_dot_dat matrix <6,0,0,0,-1.5,0,0,0,6,40,3,0> }
	mesh {
		triangle { <32,-0.8,0>, <32.609,-0.3,3.062>, <20,-5,0> }
		triangle { <32.609,-0.3,3.062>, <20,-5,4>, <20,-5,0> }
		triangle { <34.343,0.5,5.657>, <32.609,-0.3,3.062>, <20,-5,4> }
		triangle { <34.343,0.5,5.657>, <35.5,1,6.8>, <20,-5,4> }
		triangle { <34.5,3,24.3>, <32,3,24>, <32,3,18.5> }
		triangle { <34.5,3,24.3>, <28,3,26>, <28,3,24> }
		triangle { <28,3,24>, <32,3,24>, <34.5,3,24.3> }
		triangle { <34.5,3,24.3>, <28,3,26>, <30,3,30> }
		triangle { <30,3,30>, <36.8,3,27.5>, <34.5,3,24.3> }
		triangle { <23,3,32>, <28,3,26>, <30,3,30> }
		triangle { <30,3,30>, <26,3,35>, <23,3,32> }
		triangle { <52,8,18.3>, <56,8,16.8>, <56,3,16.8> }
		triangle { <56,3,16.8>, <52,3,18.3>, <52,8,18.3> }
		triangle { <56,8,16.8>, <56,8,0>, <56,3,0> }
		triangle { <56,3,0>, <56,3,16.8>, <56,8,16.8> }
		triangle { <52,8,18.3>, <52,8,16>, <52,3,16> }
		triangle { <52,3,16>, <52,3,18.3>, <52,8,18.3> }
		triangle { <48,8,16>, <52,8,16>, <52,3,16> }
		triangle { <52,3,16>, <48,3,16>, <48,8,16> }
		triangle { <48,8,16>, <48,8,19.7>, <48,3,19.7> }
		triangle { <48,3,19.7>, <48,3,16>, <48,8,16> }
		triangle { <34.5,8,24.3>, <48,8,19.7>, <48,3,19.7> }
		triangle { <48,3,19.7>, <34.5,3,24.3>, <34.5,8,24.3> }
		triangle { <34.5,8,24.3>, <36.8,8,27.5>, <36.8,3,27.5> }
		triangle { <36.8,3,27.5>, <34.5,3,24.3>, <34.5,8,24.3> }
		triangle { <26,8,35>, <23,8,32>, <23,3,32> }
		triangle { <23,3,32>, <26,3,35>, <26,8,35> }
		triangle { <22,8,33>, <23,8,32>, <23,3,32> }
		triangle { <23,3,32>, <22,3,33>, <22,8,33> }
		triangle { <22,8,33>, <20,8,32>, <20,3,32> }
		triangle { <20,3,32>, <22,3,33>, <22,8,33> }
		triangle { <26,8,35>, <26,3,35>, <23,3,32> }
		triangle { <23,3,32>, <23,8,32>, <26,8,35> }
		triangle { <23,8,32>, <23,1,32>, <22,1,33> }
		triangle { <22,1,33>, <22,8,33>, <23,8,32> }
		triangle { <22,8,33>, <22,1,33>, <20,0,32> }
		triangle { <20,0,32>, <20,8,32>, <22,8,33> }
		triangle { <23,3,32>, <23,1,32>, <28,1,26> }
		triangle { <28,1,26>, <28,3,26>, <23,3,32> }
		triangle { <32,3,18.5>, <32,1,18.5>, <35.5,1,6.8> }
		triangle { <35.5,1,6.8>, <35.5,3,6.8>, <32,3,18.5> }
		triangle { <35.5,1,6.8>, <24,-3,8>, <24,-2.5,12> }
		triangle { <24,-2.5,12>, <32,0.8,16>, <35.5,1,6.8> }
		triangle { <32,1,18.5>, <35.5,1,6.8>, <32,0.8,16> }
		triangle { <32,0.8,16>, <24,-2.5,12>, <29,-0.35,16> }
		triangle { <35.5,1,6.8>, <20,-5,4>, <20,-4.5,8> }
		triangle { <20,-4.5,8>, <24,-3,8>, <35.5,1,6.8> }
		triangle { <24,-2.5,12>, <20,-4,12>, <28,-0.7,16> }
		triangle { <28,-0.7,16>, <29,-0.35,16>, <24,-2.5,12> }
		triangle { <20,-4,13>, <20,-4,12>, <28,-0.7,16> }
		triangle { <28,-0.7,16>, <28,-0.5,17>, <20,-4,13> }
		triangle { <20,-4,13>, <28,-0.5,17>, <28,1,26> }
		triangle { <28,1,26>, <20,-3,20.5>, <20,-4,13> }
		triangle { <28,1,26>, <20,-3,20.5>, <20,0,29> }
		triangle { <20,0,29>, <23,1,32>, <28,1,26> }
		triangle { <20,0,29>, <23,1,32>, <22,1,33> }
		triangle { <22,1,33>, <20,0,32>, <20,0,29> }
		triangle { <20,0,32>, <20,0,29>, <20,8,29> }
		triangle { <20,8,29>, <20,8,32>, <20,0,32> }
		triangle { <20,0,29>, <20,-3,20.5>, <20,8,20.5> }
		triangle { <20,8,20.5>, <20,8,29>, <20,0,29> }
		triangle { <20,-3,20.5>, <20,-4,13>, <20,8,13> }
		triangle { <20,8,13>, <20,8,20.5>, <20,-3,20.5> }
		triangle { <20,-4,13>, <20,-4,12>, <20,8,12> }
		triangle { <20,8,12>, <20,8,13>, <20,-4,13> }
		triangle { <20,-4.5,8>, <20,-5,4>, <20,8,4> }
		triangle { <20,8,4>, <20,8,8>, <20,-4.5,8> }
		triangle { <20,-5,4>, <20,-5,0>, <20,8,0> }
		triangle { <20,8,0>, <20,8,4>, <20,-5,4> }
		triangle { <28,8,24>, <28,0.65,24>, <28,-0.7,16> }
		triangle { <28,-0.7,16>, <28,8,16>, <28,8,24> }
		triangle { <28,8,16>, <28,-0.7,16>, <32,0.8,16> }
		triangle { <32,0.8,16>, <32,8,16>, <28,8,16> }
		triangle { <32,8,16>, <32,3,16>, <32,3,24> }
		triangle { <32,3,24>, <32,8,24>, <32,8,16> }
		triangle { <32,0.8,16>, <32,3,16>, <32,3,18.5> }
		triangle { <32,3,18.5>, <32,1,18.5>, <32,0.8,16> }
		triangle { <32,8,24>, <32,3,24>, <28,3,24> }
		triangle { <28,3,24>, <28,8,24>, <32,8,24> }
		triangle { <28,3,24>, <28,0.65,24>, <28,1,26> }
		triangle { <28,1,26>, <28,3,26>, <28,3,24> }
		triangle { <24,-2.5,12>, <24,8,12>, <24,8,8> }
		triangle { <24,8,8>, <24,-3,8>, <24,-2.5,12> }
		triangle { <24,-3,8>, <20,-4.5,8>, <20,8,8> }
		triangle { <20,8,8>, <24,8,8>, <24,-3,8> }
		triangle { <24,8,12>, <20,8,12>, <20,-4,12> }
		triangle { <20,-4,12>, <24,-2.5,12>, <24,8,12> }
// 
// 
// <>-- quadrant (+x,y,+z) --<>
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,-1,10,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,-1,10,-8,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,-1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,-1,10,-8,-10> }
// 
// bottom surface
	#end
	mesh {
		triangle { <20,8,-60>, <0,8,-60>, <0,8,-56> }
		triangle { <0,8,-56>, <16,8,-56>, <20,8,-60> }
		triangle { <20,8,-60>, <20,8,0>, <16,8,0> }
		triangle { <16,8,0>, <16,8,-56>, <20,8,-60> }
		triangle { <16,8,-40>, <0,8,-40>, <0,8,-36> }
		triangle { <0,8,-36>, <16,8,-36>, <16,8,-40> }
		triangle { <20,8,-12>, <24,8,-12>, <24,8,-8> }
		triangle { <24,8,-8>, <20,8,-8>, <20,8,-12> }
		triangle { <8,8,-40>, <8,8,-44>, <12,8,-44> }
		triangle { <12,8,-44>, <12,8,-40>, <8,8,-40> }
		triangle { <20,8,-32>, <20,8,-40>, <22,8,-33> }
		triangle { <22,8,-33>, <20,8,-40>, <26,8,-35> }
		triangle { <26,8,-35>, <23,8,-32>, <22,8,-33> }
		triangle { <28,8,-16>, <28,8,-24>, <32,8,-24> }
		triangle { <32,8,-24>, <32,8,-16>, <28,8,-16> }
		triangle { <52,8,-18.3>, <52,8,-16>, <48,8,-16> }
		triangle { <48,8,-16>, <48,8,-19.7>, <52,8,-18.3> }
		triangle { <34.5,8,-24.3>, <36.8,8,-27.5>, <60,8,-20> }
		triangle { <60,8,-20>, <56,8,-16.8>, <34.5,8,-24.3> }
		triangle { <56,8,-16.8>, <60,8,-20>, <60,8,0> }
		triangle { <60,8,0>, <56,8,0>, <56,8,-16.8> }
// 
// outside surface
		triangle { <20,-8,-40>, <0,-8,-40>, <0,0,-40> }
		triangle { <0,0,-40>, <20,0,-40>, <20,-8,-40> }
		triangle { <20,-8,-40>, <0,-8,-40>, <0,-8,0> }
		triangle { <0,-8,0>, <20,-8,0>, <20,-8,-40> }
		triangle { <20,8,-40>, <20,-1,-40>, <26,-1,-35> }
		triangle { <26,-1,-35>, <26,8,-35>, <20,8,-40> }
		triangle { <26,3,-35>, <26,-1,-35>, <30,-1,-30> }
		triangle { <30,-1,-30>, <30,3,-30>, <26,3,-35> }
		triangle { <30,3,-30>, <30,0,-30>, <36.8,0,-27.5> }
		triangle { <36.8,0,-27.5>, <36.8,3,-27.5>, <30,3,-30> }
		triangle { <36.8,8,-27.5>, <36.8,0,-27.5>, <60,0,-20> }
		triangle { <60,0,-20>, <60,8,-20>, <36.8,8,-27.5> }
		triangle { <60,8,-20>, <60,0,-20>, <60,0,0> }
		triangle { <60,0,0>, <60,8,0>, <60,8,-20> }
		triangle { <60,0,-20>, <30,0,-30>, <36,0,-20> }
		triangle { <60,0,-20>, <36,0,-20>, <39,0,-9> }
		triangle { <60,0,-20>, <39,0,-9>, <40,0,0> }
		triangle { <40,0,0>, <60,0,0>, <60,0,-20> }
		triangle { <30,0,-30>, <30,-1,-30>, <36,-1,-20> }
		triangle { <36,-1,-20>, <36,0,-20>, <30,0,-30> }
		triangle { <36,0,-20>, <36,-1,-20>, <39,-1,-9> }
		triangle { <39,-1,-9>, <39,0,-9>, <36,0,-20> }
		triangle { <39,0,-9>, <39,-1,-9>, <40,-1,0> }
		triangle { <40,-1,0>, <40,0,0>, <39,0,-9> }
		triangle { <20,-1,-40>, <26,-1,-35>, <20,-5,-29> }
		triangle { <26,-1,-35>, <20,-5,-29>, <20,-6,-22> }
		triangle { <20,-6,-22>, <30,-1,-30>, <26,-1,-35> }
		triangle { <30,-1,-30>, <20,-6,-22>, <20,-7,-13> }
		triangle { <20,-7,-13>, <36,-1,-20>, <30,-1,-30> }
		triangle { <36,-1,-20>, <20,-7,-13>, <20,-8,-6> }
		triangle { <20,-8,-6>, <39,-1,-9>, <36,-1,-20> }
		triangle { <39,-1,-9>, <20,-8,-6>, <20,-8,0> }
		triangle { <20,-8,0>, <40,-1,0>, <39,-1,-9> }
		triangle { <20,-1,-40>, <20,-5,-29>, <20,-8,-29> }
		triangle { <20,-8,-29>, <20,-8,-40>, <20,-1,-40> }
		triangle { <20,-5,-29>, <20,-6,-22>, <20,-8,-22> }
		triangle { <20,-8,-22>, <20,-8,-29>, <20,-5,-29> }
		triangle { <20,-6,-22>, <20,-7,-13>, <20,-8,-13> }
		triangle { <20,-8,-13>, <20,-8,-22>, <20,-6,-22> }
		triangle { <20,-7,-13>, <20,-8,-6>, <20,-8,-13> }
		triangle { <20,0,-60>, <20,0,-40>, <0,0,-40> }
		triangle { <0,0,-40>, <0,0,-60>, <20,0,-60> }
		triangle { <20,0,-60>, <20,0,-40>, <20,8,-40> }
		triangle { <20,8,-40>, <20,8,-60>, <20,0,-60> }
		triangle { <20,0,-60>, <0,0,-60>, <0,8,-60> }
		triangle { <0,8,-60>, <20,8,-60>, <20,0,-60> }
// 
// inside surfaces
		triangle { <16,3,-56>, <0,3,-56>, <0,3,-44> }
		triangle { <0,3,-44>, <16,3,-44>, <16,3,-56> }
		triangle { <16,3,-44>, <12,3,-44>, <12,3,-40> }
		triangle { <12,3,-40>, <16,3,-40>, <16,3,-44> }
		triangle { <8,3,-44>, <0,3,-44>, <0,3,-40> }
		triangle { <0,3,-40>, <8,3,-40>, <8,3,-44> }
		triangle { <16,3,-56>, <0,3,-56>, <0,8,-56> }
		triangle { <0,8,-56>, <16,8,-56>, <16,3,-56> }
		triangle { <16,3,-56>, <16,8,-56>, <16,8,-40> }
		triangle { <16,8,-40>, <16,3,-40>, <16,3,-56> }
		triangle { <16,-4,-36>, <0,-4,-36>, <0,-4,0> }
		triangle { <0,-4,0>, <16,-4,0>, <16,-4,-36> }
		triangle { <16,-4,-36>, <0,-4,-36>, <0,8,-36> }
		triangle { <0,8,-36>, <16,8,-36>, <16,-4,-36> }
		triangle { <16,-4,-36>, <16,8,-36>, <16,8,0> }
		triangle { <16,8,0>, <16,-4,0>, <16,-4,-36> }
		triangle { <12,3,-40>, <12,8,-40>, <12,8,-44> }
		triangle { <12,8,-44>, <12,3,-44>, <12,3,-40> }
		triangle { <8,3,-40>, <8,8,-40>, <8,8,-44> }
		triangle { <8,8,-44>, <8,3,-44>, <8,3,-40> }
		triangle { <8,3,-44>, <12,3,-44>, <12,8,-44> }
		triangle { <12,8,-44>, <8,8,-44>, <8,3,-44> }
		triangle { <8,8,-40>, <0,8,-40>, <0,3,-40> }
		triangle { <0,3,-40>, <8,3,-40>, <8,8,-40> }
		triangle { <16,8,-40>, <12,8,-40>, <12,3,-40> }
		triangle { <12,3,-40>, <16,3,-40>, <16,8,-40> }
		triangle { <56,3,0>, <56,3,-16.8>, <47.391,3,-3.062> }
		triangle { <47.391,3,-3.062>, <48,3,0>, <56,3,0> }
		triangle { <56,3,-16.8>, <45.6,3,-5.7>, <47.391,3,-3.062> }
		triangle { <48,3,-19.7>, <34.5,3,-24.3>, <40,3,-8> }
		triangle { <40,3,-8>, <43.062,3,-7.391>, <48,3,-19.7> }
		triangle { <56,3,-16.8>, <52,3,-16>, <43.062,3,-7.391> }
		triangle { <43.062,3,-7.391>, <45.6,3,-5.7>, <56,3,-16.8> }
		triangle { <52,3,-16>, <52,3,-18.3>, <56,3,-16.8> }
		triangle { <52,3,-16>, <43.062,3,-7.391>, <48,3,-16> }
		triangle { <48,3,-19.7>, <43.062,3,-7.391>, <48,3,-16> }
		triangle { <32,3,-18.5>, <35.5,3,-6.8>, <40,3,-8> }
		triangle { <40,3,-8>, <34.5,3,-24.3>, <32,3,-18.5> }
		triangle { <35.5,3,-6.8>, <34.343,3,-5.657>, <34.343,0.5,-5.657> }
		triangle { <34.343,0.5,-5.657>, <35.5,1,-6.8>, <35.5,3,-6.8> }
		triangle { <34.343,3,-5.657>, <32.609,3,-3.062>, <32.609,-0.3,-3.062> }
		triangle { <32.609,-0.3,-3.062>, <34.343,0.5,-5.657>, <34.343,3,-5.657> }
		triangle { <32.609,3,-3.062>, <32,3,0>, <32,-0.8,0> }
		triangle { <32,-0.8,0>, <32.609,-0.3,-3.062>, <32.609,3,-3.062> }
	}
	object { _2_dash_4cyls_dot_dat matrix <6,0,0,0,-1.5,0,0,0,-6,40,3,0> }
	mesh {
		triangle { <32,-0.8,0>, <32.609,-0.3,-3.062>, <20,-5,0> }
		triangle { <32.609,-0.3,-3.062>, <20,-5,-4>, <20,-5,0> }
		triangle { <34.343,0.5,-5.657>, <32.609,-0.3,-3.062>, <20,-5,-4> }
		triangle { <34.343,0.5,-5.657>, <35.5,1,-6.8>, <20,-5,-4> }
		triangle { <34.5,3,-24.3>, <32,3,-24>, <32,3,-18.5> }
		triangle { <34.5,3,-24.3>, <28,3,-26>, <28,3,-24> }
		triangle { <28,3,-24>, <32,3,-24>, <34.5,3,-24.3> }
		triangle { <34.5,3,-24.3>, <28,3,-26>, <30,3,-30> }
		triangle { <30,3,-30>, <36.8,3,-27.5>, <34.5,3,-24.3> }
		triangle { <23,3,-32>, <28,3,-26>, <30,3,-30> }
		triangle { <30,3,-30>, <26,3,-35>, <23,3,-32> }
		triangle { <52,8,-18.3>, <56,8,-16.8>, <56,3,-16.8> }
		triangle { <56,3,-16.8>, <52,3,-18.3>, <52,8,-18.3> }
		triangle { <56,8,-16.8>, <56,8,0>, <56,3,0> }
		triangle { <56,3,0>, <56,3,-16.8>, <56,8,-16.8> }
		triangle { <52,8,-18.3>, <52,8,-16>, <52,3,-16> }
		triangle { <52,3,-16>, <52,3,-18.3>, <52,8,-18.3> }
		triangle { <48,8,-16>, <52,8,-16>, <52,3,-16> }
		triangle { <52,3,-16>, <48,3,-16>, <48,8,-16> }
		triangle { <48,8,-16>, <48,8,-19.7>, <48,3,-19.7> }
		triangle { <48,3,-19.7>, <48,3,-16>, <48,8,-16> }
		triangle { <34.5,8,-24.3>, <48,8,-19.7>, <48,3,-19.7> }
		triangle { <48,3,-19.7>, <34.5,3,-24.3>, <34.5,8,-24.3> }
		triangle { <34.5,8,-24.3>, <36.8,8,-27.5>, <36.8,3,-27.5> }
		triangle { <36.8,3,-27.5>, <34.5,3,-24.3>, <34.5,8,-24.3> }
		triangle { <26,8,-35>, <23,8,-32>, <23,3,-32> }
		triangle { <23,3,-32>, <26,3,-35>, <26,8,-35> }
		triangle { <22,8,-33>, <23,8,-32>, <23,3,-32> }
		triangle { <23,3,-32>, <22,3,-33>, <22,8,-33> }
		triangle { <22,8,-33>, <20,8,-32>, <20,3,-32> }
		triangle { <20,3,-32>, <22,3,-33>, <22,8,-33> }
		triangle { <26,8,-35>, <26,3,-35>, <23,3,-32> }
		triangle { <23,3,-32>, <23,8,-32>, <26,8,-35> }
		triangle { <23,8,-32>, <23,1,-32>, <22,1,-33> }
		triangle { <22,1,-33>, <22,8,-33>, <23,8,-32> }
		triangle { <22,8,-33>, <22,1,-33>, <20,0,-32> }
		triangle { <20,0,-32>, <20,8,-32>, <22,8,-33> }
		triangle { <23,3,-32>, <23,1,-32>, <28,1,-26> }
		triangle { <28,1,-26>, <28,3,-26>, <23,3,-32> }
		triangle { <32,3,-18.5>, <32,1,-18.5>, <35.5,1,-6.8> }
		triangle { <35.5,1,-6.8>, <35.5,3,-6.8>, <32,3,-18.5> }
		triangle { <35.5,1,-6.8>, <24,-3,-8>, <24,-2.5,-12> }
		triangle { <24,-2.5,-12>, <32,0.8,-16>, <35.5,1,-6.8> }
		triangle { <32,1,-18.5>, <35.5,1,-6.8>, <32,0.8,-16> }
		triangle { <32,0.8,-16>, <24,-2.5,-12>, <29,-0.35,-16> }
		triangle { <35.5,1,-6.8>, <20,-5,-4>, <20,-4.5,-8> }
		triangle { <20,-4.5,-8>, <24,-3,-8>, <35.5,1,-6.8> }
		triangle { <24,-2.5,-12>, <20,-4,-12>, <28,-0.7,-16> }
		triangle { <28,-0.7,-16>, <29,-0.35,-16>, <24,-2.5,-12> }
		triangle { <20,-4,-13>, <20,-4,-12>, <28,-0.7,-16> }
		triangle { <28,-0.7,-16>, <28,-0.5,-17>, <20,-4,-13> }
		triangle { <20,-4,-13>, <28,-0.5,-17>, <28,1,-26> }
		triangle { <28,1,-26>, <20,-3,-20.5>, <20,-4,-13> }
		triangle { <28,1,-26>, <20,-3,-20.5>, <20,0,-29> }
		triangle { <20,0,-29>, <23,1,-32>, <28,1,-26> }
		triangle { <20,0,-29>, <23,1,-32>, <22,1,-33> }
		triangle { <22,1,-33>, <20,0,-32>, <20,0,-29> }
		triangle { <20,0,-32>, <20,0,-29>, <20,8,-29> }
		triangle { <20,8,-29>, <20,8,-32>, <20,0,-32> }
		triangle { <20,0,-29>, <20,-3,-20.5>, <20,8,-20.5> }
		triangle { <20,8,-20.5>, <20,8,-29>, <20,0,-29> }
		triangle { <20,-3,-20.5>, <20,-4,-13>, <20,8,-13> }
		triangle { <20,8,-13>, <20,8,-20.5>, <20,-3,-20.5> }
		triangle { <20,-4,-13>, <20,-4,-12>, <20,8,-12> }
		triangle { <20,8,-12>, <20,8,-13>, <20,-4,-13> }
		triangle { <20,-4.5,-8>, <20,-5,-4>, <20,8,-4> }
		triangle { <20,8,-4>, <20,8,-8>, <20,-4.5,-8> }
		triangle { <20,-5,-4>, <20,-5,0>, <20,8,0> }
		triangle { <20,8,0>, <20,8,-4>, <20,-5,-4> }
		triangle { <28,8,-24>, <28,0.65,-24>, <28,-0.7,-16> }
		triangle { <28,-0.7,-16>, <28,8,-16>, <28,8,-24> }
		triangle { <28,8,-16>, <28,-0.7,-16>, <32,0.8,-16> }
		triangle { <32,0.8,-16>, <32,8,-16>, <28,8,-16> }
		triangle { <32,8,-16>, <32,3,-16>, <32,3,-24> }
		triangle { <32,3,-24>, <32,8,-24>, <32,8,-16> }
		triangle { <32,0.8,-16>, <32,3,-16>, <32,3,-18.5> }
		triangle { <32,3,-18.5>, <32,1,-18.5>, <32,0.8,-16> }
		triangle { <32,8,-24>, <32,3,-24>, <28,3,-24> }
		triangle { <28,3,-24>, <28,8,-24>, <32,8,-24> }
		triangle { <28,3,-24>, <28,0.65,-24>, <28,1,-26> }
		triangle { <28,1,-26>, <28,3,-26>, <28,3,-24> }
		triangle { <24,-2.5,-12>, <24,8,-12>, <24,8,-8> }
		triangle { <24,8,-8>, <24,-3,-8>, <24,-2.5,-12> }
		triangle { <24,-3,-8>, <20,-4.5,-8>, <20,8,-8> }
		triangle { <20,8,-8>, <24,8,-8>, <24,-3,-8> }
		triangle { <24,8,-12>, <20,8,-12>, <20,-4,-12> }
		triangle { <20,-4,-12>, <24,-2.5,-12>, <24,8,-12> }
// 
// 
// <>-- quadrant (+x,y,+z) --<>
	}
	#if (STUDS)
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,-10,0,-50> }
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,-10,-8,-30> }
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,-50,0,-10> }
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,-10,-8,-10> }
// 
// bottom surface
	#end
	mesh {
		triangle { <-20,8,-60>, <0,8,-60>, <0,8,-56> }
		triangle { <0,8,-56>, <-16,8,-56>, <-20,8,-60> }
		triangle { <-20,8,-60>, <-20,8,0>, <-16,8,0> }
		triangle { <-16,8,0>, <-16,8,-56>, <-20,8,-60> }
		triangle { <-16,8,-40>, <0,8,-40>, <0,8,-36> }
		triangle { <0,8,-36>, <-16,8,-36>, <-16,8,-40> }
		triangle { <-20,8,-12>, <-24,8,-12>, <-24,8,-8> }
		triangle { <-24,8,-8>, <-20,8,-8>, <-20,8,-12> }
		triangle { <-8,8,-40>, <-8,8,-44>, <-12,8,-44> }
		triangle { <-12,8,-44>, <-12,8,-40>, <-8,8,-40> }
		triangle { <-20,8,-32>, <-20,8,-40>, <-22,8,-33> }
		triangle { <-22,8,-33>, <-20,8,-40>, <-26,8,-35> }
		triangle { <-26,8,-35>, <-23,8,-32>, <-22,8,-33> }
		triangle { <-28,8,-16>, <-28,8,-24>, <-32,8,-24> }
		triangle { <-32,8,-24>, <-32,8,-16>, <-28,8,-16> }
		triangle { <-52,8,-18.3>, <-52,8,-16>, <-48,8,-16> }
		triangle { <-48,8,-16>, <-48,8,-19.7>, <-52,8,-18.3> }
		triangle { <-34.5,8,-24.3>, <-36.8,8,-27.5>, <-60,8,-20> }
		triangle { <-60,8,-20>, <-56,8,-16.8>, <-34.5,8,-24.3> }
		triangle { <-56,8,-16.8>, <-60,8,-20>, <-60,8,0> }
		triangle { <-60,8,0>, <-56,8,0>, <-56,8,-16.8> }
// 
// outside surface
		triangle { <-20,-8,-40>, <0,-8,-40>, <0,0,-40> }
		triangle { <0,0,-40>, <-20,0,-40>, <-20,-8,-40> }
		triangle { <-20,-8,-40>, <0,-8,-40>, <0,-8,0> }
		triangle { <0,-8,0>, <-20,-8,0>, <-20,-8,-40> }
		triangle { <-20,8,-40>, <-20,-1,-40>, <-26,-1,-35> }
		triangle { <-26,-1,-35>, <-26,8,-35>, <-20,8,-40> }
		triangle { <-26,3,-35>, <-26,-1,-35>, <-30,-1,-30> }
		triangle { <-30,-1,-30>, <-30,3,-30>, <-26,3,-35> }
		triangle { <-30,3,-30>, <-30,0,-30>, <-36.8,0,-27.5> }
		triangle { <-36.8,0,-27.5>, <-36.8,3,-27.5>, <-30,3,-30> }
		triangle { <-36.8,8,-27.5>, <-36.8,0,-27.5>, <-60,0,-20> }
		triangle { <-60,0,-20>, <-60,8,-20>, <-36.8,8,-27.5> }
		triangle { <-60,8,-20>, <-60,0,-20>, <-60,0,0> }
		triangle { <-60,0,0>, <-60,8,0>, <-60,8,-20> }
		triangle { <-60,0,-20>, <-30,0,-30>, <-36,0,-20> }
		triangle { <-60,0,-20>, <-36,0,-20>, <-39,0,-9> }
		triangle { <-60,0,-20>, <-39,0,-9>, <-40,0,0> }
		triangle { <-40,0,0>, <-60,0,0>, <-60,0,-20> }
		triangle { <-30,0,-30>, <-30,-1,-30>, <-36,-1,-20> }
		triangle { <-36,-1,-20>, <-36,0,-20>, <-30,0,-30> }
		triangle { <-36,0,-20>, <-36,-1,-20>, <-39,-1,-9> }
		triangle { <-39,-1,-9>, <-39,0,-9>, <-36,0,-20> }
		triangle { <-39,0,-9>, <-39,-1,-9>, <-40,-1,0> }
		triangle { <-40,-1,0>, <-40,0,0>, <-39,0,-9> }
		triangle { <-20,-1,-40>, <-26,-1,-35>, <-20,-5,-29> }
		triangle { <-26,-1,-35>, <-20,-5,-29>, <-20,-6,-22> }
		triangle { <-20,-6,-22>, <-30,-1,-30>, <-26,-1,-35> }
		triangle { <-30,-1,-30>, <-20,-6,-22>, <-20,-7,-13> }
		triangle { <-20,-7,-13>, <-36,-1,-20>, <-30,-1,-30> }
		triangle { <-36,-1,-20>, <-20,-7,-13>, <-20,-8,-6> }
		triangle { <-20,-8,-6>, <-39,-1,-9>, <-36,-1,-20> }
		triangle { <-39,-1,-9>, <-20,-8,-6>, <-20,-8,0> }
		triangle { <-20,-8,0>, <-40,-1,0>, <-39,-1,-9> }
		triangle { <-20,-1,-40>, <-20,-5,-29>, <-20,-8,-29> }
		triangle { <-20,-8,-29>, <-20,-8,-40>, <-20,-1,-40> }
		triangle { <-20,-5,-29>, <-20,-6,-22>, <-20,-8,-22> }
		triangle { <-20,-8,-22>, <-20,-8,-29>, <-20,-5,-29> }
		triangle { <-20,-6,-22>, <-20,-7,-13>, <-20,-8,-13> }
		triangle { <-20,-8,-13>, <-20,-8,-22>, <-20,-6,-22> }
		triangle { <-20,-7,-13>, <-20,-8,-6>, <-20,-8,-13> }
		triangle { <-20,0,-60>, <-20,0,-40>, <0,0,-40> }
		triangle { <0,0,-40>, <0,0,-60>, <-20,0,-60> }
		triangle { <-20,0,-60>, <-20,0,-40>, <-20,8,-40> }
		triangle { <-20,8,-40>, <-20,8,-60>, <-20,0,-60> }
		triangle { <-20,0,-60>, <0,0,-60>, <0,8,-60> }
		triangle { <0,8,-60>, <-20,8,-60>, <-20,0,-60> }
// 
// inside surfaces
		triangle { <-16,3,-56>, <0,3,-56>, <0,3,-44> }
		triangle { <0,3,-44>, <-16,3,-44>, <-16,3,-56> }
		triangle { <-16,3,-44>, <-12,3,-44>, <-12,3,-40> }
		triangle { <-12,3,-40>, <-16,3,-40>, <-16,3,-44> }
		triangle { <-8,3,-44>, <0,3,-44>, <0,3,-40> }
		triangle { <0,3,-40>, <-8,3,-40>, <-8,3,-44> }
		triangle { <-16,3,-56>, <0,3,-56>, <0,8,-56> }
		triangle { <0,8,-56>, <-16,8,-56>, <-16,3,-56> }
		triangle { <-16,3,-56>, <-16,8,-56>, <-16,8,-40> }
		triangle { <-16,8,-40>, <-16,3,-40>, <-16,3,-56> }
		triangle { <-16,-4,-36>, <0,-4,-36>, <0,-4,0> }
		triangle { <0,-4,0>, <-16,-4,0>, <-16,-4,-36> }
		triangle { <-16,-4,-36>, <0,-4,-36>, <0,8,-36> }
		triangle { <0,8,-36>, <-16,8,-36>, <-16,-4,-36> }
		triangle { <-16,-4,-36>, <-16,8,-36>, <-16,8,0> }
		triangle { <-16,8,0>, <-16,-4,0>, <-16,-4,-36> }
		triangle { <-12,3,-40>, <-12,8,-40>, <-12,8,-44> }
		triangle { <-12,8,-44>, <-12,3,-44>, <-12,3,-40> }
		triangle { <-8,3,-40>, <-8,8,-40>, <-8,8,-44> }
		triangle { <-8,8,-44>, <-8,3,-44>, <-8,3,-40> }
		triangle { <-8,3,-44>, <-12,3,-44>, <-12,8,-44> }
		triangle { <-12,8,-44>, <-8,8,-44>, <-8,3,-44> }
		triangle { <-8,8,-40>, <0,8,-40>, <0,3,-40> }
		triangle { <0,3,-40>, <-8,3,-40>, <-8,8,-40> }
		triangle { <-16,8,-40>, <-12,8,-40>, <-12,3,-40> }
		triangle { <-12,3,-40>, <-16,3,-40>, <-16,8,-40> }
		triangle { <-56,3,0>, <-56,3,-16.8>, <-47.391,3,-3.062> }
		triangle { <-47.391,3,-3.062>, <-48,3,0>, <-56,3,0> }
		triangle { <-56,3,-16.8>, <-45.6,3,-5.7>, <-47.391,3,-3.062> }
		triangle { <-48,3,-19.7>, <-34.5,3,-24.3>, <-40,3,-8> }
		triangle { <-40,3,-8>, <-43.062,3,-7.391>, <-48,3,-19.7> }
		triangle { <-56,3,-16.8>, <-52,3,-16>, <-43.062,3,-7.391> }
		triangle { <-43.062,3,-7.391>, <-45.6,3,-5.7>, <-56,3,-16.8> }
		triangle { <-52,3,-16>, <-52,3,-18.3>, <-56,3,-16.8> }
		triangle { <-52,3,-16>, <-43.062,3,-7.391>, <-48,3,-16> }
		triangle { <-48,3,-19.7>, <-43.062,3,-7.391>, <-48,3,-16> }
		triangle { <-32,3,-18.5>, <-35.5,3,-6.8>, <-40,3,-8> }
		triangle { <-40,3,-8>, <-34.5,3,-24.3>, <-32,3,-18.5> }
		triangle { <-35.5,3,-6.8>, <-34.343,3,-5.657>, <-34.343,0.5,-5.657> }
		triangle { <-34.343,0.5,-5.657>, <-35.5,1,-6.8>, <-35.5,3,-6.8> }
		triangle { <-34.343,3,-5.657>, <-32.609,3,-3.062>, <-32.609,-0.3,-3.062> }
		triangle { <-32.609,-0.3,-3.062>, <-34.343,0.5,-5.657>, <-34.343,3,-5.657> }
		triangle { <-32.609,3,-3.062>, <-32,3,0>, <-32,-0.8,0> }
		triangle { <-32,-0.8,0>, <-32.609,-0.3,-3.062>, <-32.609,3,-3.062> }
	}
	object { _2_dash_4cyls_dot_dat matrix <-6,0,0,0,-1.5,0,0,0,-6,-40,3,0> }
	mesh {
		triangle { <-32,-0.8,0>, <-32.609,-0.3,-3.062>, <-20,-5,0> }
		triangle { <-32.609,-0.3,-3.062>, <-20,-5,-4>, <-20,-5,0> }
		triangle { <-34.343,0.5,-5.657>, <-32.609,-0.3,-3.062>, <-20,-5,-4> }
		triangle { <-34.343,0.5,-5.657>, <-35.5,1,-6.8>, <-20,-5,-4> }
		triangle { <-34.5,3,-24.3>, <-32,3,-24>, <-32,3,-18.5> }
		triangle { <-34.5,3,-24.3>, <-28,3,-26>, <-28,3,-24> }
		triangle { <-28,3,-24>, <-32,3,-24>, <-34.5,3,-24.3> }
		triangle { <-34.5,3,-24.3>, <-28,3,-26>, <-30,3,-30> }
		triangle { <-30,3,-30>, <-36.8,3,-27.5>, <-34.5,3,-24.3> }
		triangle { <-23,3,-32>, <-28,3,-26>, <-30,3,-30> }
		triangle { <-30,3,-30>, <-26,3,-35>, <-23,3,-32> }
		triangle { <-52,8,-18.3>, <-56,8,-16.8>, <-56,3,-16.8> }
		triangle { <-56,3,-16.8>, <-52,3,-18.3>, <-52,8,-18.3> }
		triangle { <-56,8,-16.8>, <-56,8,0>, <-56,3,0> }
		triangle { <-56,3,0>, <-56,3,-16.8>, <-56,8,-16.8> }
		triangle { <-52,8,-18.3>, <-52,8,-16>, <-52,3,-16> }
		triangle { <-52,3,-16>, <-52,3,-18.3>, <-52,8,-18.3> }
		triangle { <-48,8,-16>, <-52,8,-16>, <-52,3,-16> }
		triangle { <-52,3,-16>, <-48,3,-16>, <-48,8,-16> }
		triangle { <-48,8,-16>, <-48,8,-19.7>, <-48,3,-19.7> }
		triangle { <-48,3,-19.7>, <-48,3,-16>, <-48,8,-16> }
		triangle { <-34.5,8,-24.3>, <-48,8,-19.7>, <-48,3,-19.7> }
		triangle { <-48,3,-19.7>, <-34.5,3,-24.3>, <-34.5,8,-24.3> }
		triangle { <-34.5,8,-24.3>, <-36.8,8,-27.5>, <-36.8,3,-27.5> }
		triangle { <-36.8,3,-27.5>, <-34.5,3,-24.3>, <-34.5,8,-24.3> }
		triangle { <-26,8,-35>, <-23,8,-32>, <-23,3,-32> }
		triangle { <-23,3,-32>, <-26,3,-35>, <-26,8,-35> }
		triangle { <-22,8,-33>, <-23,8,-32>, <-23,3,-32> }
		triangle { <-23,3,-32>, <-22,3,-33>, <-22,8,-33> }
		triangle { <-22,8,-33>, <-20,8,-32>, <-20,3,-32> }
		triangle { <-20,3,-32>, <-22,3,-33>, <-22,8,-33> }
		triangle { <-26,8,-35>, <-26,3,-35>, <-23,3,-32> }
		triangle { <-23,3,-32>, <-23,8,-32>, <-26,8,-35> }
		triangle { <-23,8,-32>, <-23,1,-32>, <-22,1,-33> }
		triangle { <-22,1,-33>, <-22,8,-33>, <-23,8,-32> }
		triangle { <-22,8,-33>, <-22,1,-33>, <-20,0,-32> }
		triangle { <-20,0,-32>, <-20,8,-32>, <-22,8,-33> }
		triangle { <-23,3,-32>, <-23,1,-32>, <-28,1,-26> }
		triangle { <-28,1,-26>, <-28,3,-26>, <-23,3,-32> }
		triangle { <-32,3,-18.5>, <-32,1,-18.5>, <-35.5,1,-6.8> }
		triangle { <-35.5,1,-6.8>, <-35.5,3,-6.8>, <-32,3,-18.5> }
		triangle { <-35.5,1,-6.8>, <-24,-3,-8>, <-24,-2.5,-12> }
		triangle { <-24,-2.5,-12>, <-32,0.8,-16>, <-35.5,1,-6.8> }
		triangle { <-32,1,-18.5>, <-35.5,1,-6.8>, <-32,0.8,-16> }
		triangle { <-32,0.8,-16>, <-24,-2.5,-12>, <-29,-0.35,-16> }
		triangle { <-35.5,1,-6.8>, <-20,-5,-4>, <-20,-4.5,-8> }
		triangle { <-20,-4.5,-8>, <-24,-3,-8>, <-35.5,1,-6.8> }
		triangle { <-24,-2.5,-12>, <-20,-4,-12>, <-28,-0.7,-16> }
		triangle { <-28,-0.7,-16>, <-29,-0.35,-16>, <-24,-2.5,-12> }
		triangle { <-20,-4,-13>, <-20,-4,-12>, <-28,-0.7,-16> }
		triangle { <-28,-0.7,-16>, <-28,-0.5,-17>, <-20,-4,-13> }
		triangle { <-20,-4,-13>, <-28,-0.5,-17>, <-28,1,-26> }
		triangle { <-28,1,-26>, <-20,-3,-20.5>, <-20,-4,-13> }
		triangle { <-28,1,-26>, <-20,-3,-20.5>, <-20,0,-29> }
		triangle { <-20,0,-29>, <-23,1,-32>, <-28,1,-26> }
		triangle { <-20,0,-29>, <-23,1,-32>, <-22,1,-33> }
		triangle { <-22,1,-33>, <-20,0,-32>, <-20,0,-29> }
		triangle { <-20,0,-32>, <-20,0,-29>, <-20,8,-29> }
		triangle { <-20,8,-29>, <-20,8,-32>, <-20,0,-32> }
		triangle { <-20,0,-29>, <-20,-3,-20.5>, <-20,8,-20.5> }
		triangle { <-20,8,-20.5>, <-20,8,-29>, <-20,0,-29> }
		triangle { <-20,-3,-20.5>, <-20,-4,-13>, <-20,8,-13> }
		triangle { <-20,8,-13>, <-20,8,-20.5>, <-20,-3,-20.5> }
		triangle { <-20,-4,-13>, <-20,-4,-12>, <-20,8,-12> }
		triangle { <-20,8,-12>, <-20,8,-13>, <-20,-4,-13> }
		triangle { <-20,-4.5,-8>, <-20,-5,-4>, <-20,8,-4> }
		triangle { <-20,8,-4>, <-20,8,-8>, <-20,-4.5,-8> }
		triangle { <-20,-5,-4>, <-20,-5,0>, <-20,8,0> }
		triangle { <-20,8,0>, <-20,8,-4>, <-20,-5,-4> }
		triangle { <-28,8,-24>, <-28,0.65,-24>, <-28,-0.7,-16> }
		triangle { <-28,-0.7,-16>, <-28,8,-16>, <-28,8,-24> }
		triangle { <-28,8,-16>, <-28,-0.7,-16>, <-32,0.8,-16> }
		triangle { <-32,0.8,-16>, <-32,8,-16>, <-28,8,-16> }
		triangle { <-32,8,-16>, <-32,3,-16>, <-32,3,-24> }
		triangle { <-32,3,-24>, <-32,8,-24>, <-32,8,-16> }
		triangle { <-32,0.8,-16>, <-32,3,-16>, <-32,3,-18.5> }
		triangle { <-32,3,-18.5>, <-32,1,-18.5>, <-32,0.8,-16> }
		triangle { <-32,8,-24>, <-32,3,-24>, <-28,3,-24> }
		triangle { <-28,3,-24>, <-28,8,-24>, <-32,8,-24> }
		triangle { <-28,3,-24>, <-28,0.65,-24>, <-28,1,-26> }
		triangle { <-28,1,-26>, <-28,3,-26>, <-28,3,-24> }
		triangle { <-24,-2.5,-12>, <-24,8,-12>, <-24,8,-8> }
		triangle { <-24,8,-8>, <-24,-3,-8>, <-24,-2.5,-12> }
		triangle { <-24,-3,-8>, <-20,-4.5,-8>, <-20,8,-8> }
		triangle { <-20,8,-8>, <-24,8,-8>, <-24,-3,-8> }
		triangle { <-24,8,-12>, <-20,8,-12>, <-20,-4,-12> }
		triangle { <-20,-4,-12>, <-24,-2.5,-12>, <-24,8,-12> }
// 
// 
// <>-- quadrant (+x,y,+z) --<>
	}
	#if (STUDS)
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,1,-10,0,50> }
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,1,-10,-8,30> }
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <-1,0,0,0,1,0,0,0,1,-10,-8,10> }
// 
// bottom surface
	#end
	mesh {
		triangle { <-20,8,60>, <0,8,60>, <0,8,56> }
		triangle { <0,8,56>, <-16,8,56>, <-20,8,60> }
		triangle { <-20,8,60>, <-20,8,0>, <-16,8,0> }
		triangle { <-16,8,0>, <-16,8,56>, <-20,8,60> }
		triangle { <-16,8,40>, <0,8,40>, <0,8,36> }
		triangle { <0,8,36>, <-16,8,36>, <-16,8,40> }
		triangle { <-20,8,12>, <-24,8,12>, <-24,8,8> }
		triangle { <-24,8,8>, <-20,8,8>, <-20,8,12> }
		triangle { <-8,8,40>, <-8,8,44>, <-12,8,44> }
		triangle { <-12,8,44>, <-12,8,40>, <-8,8,40> }
		triangle { <-20,8,32>, <-20,8,40>, <-22,8,33> }
		triangle { <-22,8,33>, <-20,8,40>, <-26,8,35> }
		triangle { <-26,8,35>, <-23,8,32>, <-22,8,33> }
		triangle { <-28,8,16>, <-28,8,24>, <-32,8,24> }
		triangle { <-32,8,24>, <-32,8,16>, <-28,8,16> }
		triangle { <-52,8,18.3>, <-52,8,16>, <-48,8,16> }
		triangle { <-48,8,16>, <-48,8,19.7>, <-52,8,18.3> }
		triangle { <-34.5,8,24.3>, <-36.8,8,27.5>, <-60,8,20> }
		triangle { <-60,8,20>, <-56,8,16.8>, <-34.5,8,24.3> }
		triangle { <-56,8,16.8>, <-60,8,20>, <-60,8,0> }
		triangle { <-60,8,0>, <-56,8,0>, <-56,8,16.8> }
// 
// outside surface
		triangle { <-20,-8,40>, <0,-8,40>, <0,0,40> }
		triangle { <0,0,40>, <-20,0,40>, <-20,-8,40> }
		triangle { <-20,-8,40>, <0,-8,40>, <0,-8,0> }
		triangle { <0,-8,0>, <-20,-8,0>, <-20,-8,40> }
		triangle { <-20,8,40>, <-20,-1,40>, <-26,-1,35> }
		triangle { <-26,-1,35>, <-26,8,35>, <-20,8,40> }
		triangle { <-26,3,35>, <-26,-1,35>, <-30,-1,30> }
		triangle { <-30,-1,30>, <-30,3,30>, <-26,3,35> }
		triangle { <-30,3,30>, <-30,0,30>, <-36.8,0,27.5> }
		triangle { <-36.8,0,27.5>, <-36.8,3,27.5>, <-30,3,30> }
		triangle { <-36.8,8,27.5>, <-36.8,0,27.5>, <-60,0,20> }
		triangle { <-60,0,20>, <-60,8,20>, <-36.8,8,27.5> }
		triangle { <-60,8,20>, <-60,0,20>, <-60,0,0> }
		triangle { <-60,0,0>, <-60,8,0>, <-60,8,20> }
		triangle { <-60,0,20>, <-30,0,30>, <-36,0,20> }
		triangle { <-60,0,20>, <-36,0,20>, <-39,0,9> }
		triangle { <-60,0,20>, <-39,0,9>, <-40,0,0> }
		triangle { <-40,0,0>, <-60,0,0>, <-60,0,20> }
		triangle { <-30,0,30>, <-30,-1,30>, <-36,-1,20> }
		triangle { <-36,-1,20>, <-36,0,20>, <-30,0,30> }
		triangle { <-36,0,20>, <-36,-1,20>, <-39,-1,9> }
		triangle { <-39,-1,9>, <-39,0,9>, <-36,0,20> }
		triangle { <-39,0,9>, <-39,-1,9>, <-40,-1,0> }
		triangle { <-40,-1,0>, <-40,0,0>, <-39,0,9> }
		triangle { <-20,-1,40>, <-26,-1,35>, <-20,-5,29> }
		triangle { <-26,-1,35>, <-20,-5,29>, <-20,-6,22> }
		triangle { <-20,-6,22>, <-30,-1,30>, <-26,-1,35> }
		triangle { <-30,-1,30>, <-20,-6,22>, <-20,-7,13> }
		triangle { <-20,-7,13>, <-36,-1,20>, <-30,-1,30> }
		triangle { <-36,-1,20>, <-20,-7,13>, <-20,-8,6> }
		triangle { <-20,-8,6>, <-39,-1,9>, <-36,-1,20> }
		triangle { <-39,-1,9>, <-20,-8,6>, <-20,-8,0> }
		triangle { <-20,-8,0>, <-40,-1,0>, <-39,-1,9> }
		triangle { <-20,-1,40>, <-20,-5,29>, <-20,-8,29> }
		triangle { <-20,-8,29>, <-20,-8,40>, <-20,-1,40> }
		triangle { <-20,-5,29>, <-20,-6,22>, <-20,-8,22> }
		triangle { <-20,-8,22>, <-20,-8,29>, <-20,-5,29> }
		triangle { <-20,-6,22>, <-20,-7,13>, <-20,-8,13> }
		triangle { <-20,-8,13>, <-20,-8,22>, <-20,-6,22> }
		triangle { <-20,-7,13>, <-20,-8,6>, <-20,-8,13> }
		triangle { <-20,0,60>, <-20,0,40>, <0,0,40> }
		triangle { <0,0,40>, <0,0,60>, <-20,0,60> }
		triangle { <-20,0,60>, <-20,0,40>, <-20,8,40> }
		triangle { <-20,8,40>, <-20,8,60>, <-20,0,60> }
		triangle { <-20,0,60>, <0,0,60>, <0,8,60> }
		triangle { <0,8,60>, <-20,8,60>, <-20,0,60> }
// 
// inside surfaces
		triangle { <-16,3,56>, <0,3,56>, <0,3,44> }
		triangle { <0,3,44>, <-16,3,44>, <-16,3,56> }
		triangle { <-16,3,44>, <-12,3,44>, <-12,3,40> }
		triangle { <-12,3,40>, <-16,3,40>, <-16,3,44> }
		triangle { <-8,3,44>, <0,3,44>, <0,3,40> }
		triangle { <0,3,40>, <-8,3,40>, <-8,3,44> }
		triangle { <-16,3,56>, <0,3,56>, <0,8,56> }
		triangle { <0,8,56>, <-16,8,56>, <-16,3,56> }
		triangle { <-16,3,56>, <-16,8,56>, <-16,8,40> }
		triangle { <-16,8,40>, <-16,3,40>, <-16,3,56> }
		triangle { <-16,-4,36>, <0,-4,36>, <0,-4,0> }
		triangle { <0,-4,0>, <-16,-4,0>, <-16,-4,36> }
		triangle { <-16,-4,36>, <0,-4,36>, <0,8,36> }
		triangle { <0,8,36>, <-16,8,36>, <-16,-4,36> }
		triangle { <-16,-4,36>, <-16,8,36>, <-16,8,0> }
		triangle { <-16,8,0>, <-16,-4,0>, <-16,-4,36> }
		triangle { <-12,3,40>, <-12,8,40>, <-12,8,44> }
		triangle { <-12,8,44>, <-12,3,44>, <-12,3,40> }
		triangle { <-8,3,40>, <-8,8,40>, <-8,8,44> }
		triangle { <-8,8,44>, <-8,3,44>, <-8,3,40> }
		triangle { <-8,3,44>, <-12,3,44>, <-12,8,44> }
		triangle { <-12,8,44>, <-8,8,44>, <-8,3,44> }
		triangle { <-8,8,40>, <0,8,40>, <0,3,40> }
		triangle { <0,3,40>, <-8,3,40>, <-8,8,40> }
		triangle { <-16,8,40>, <-12,8,40>, <-12,3,40> }
		triangle { <-12,3,40>, <-16,3,40>, <-16,8,40> }
		triangle { <-56,3,0>, <-56,3,16.8>, <-47.391,3,3.062> }
		triangle { <-47.391,3,3.062>, <-48,3,0>, <-56,3,0> }
		triangle { <-56,3,16.8>, <-45.6,3,5.7>, <-47.391,3,3.062> }
		triangle { <-48,3,19.7>, <-34.5,3,24.3>, <-40,3,8> }
		triangle { <-40,3,8>, <-43.062,3,7.391>, <-48,3,19.7> }
		triangle { <-56,3,16.8>, <-52,3,16>, <-43.062,3,7.391> }
		triangle { <-43.062,3,7.391>, <-45.6,3,5.7>, <-56,3,16.8> }
		triangle { <-52,3,16>, <-52,3,18.3>, <-56,3,16.8> }
		triangle { <-52,3,16>, <-43.062,3,7.391>, <-48,3,16> }
		triangle { <-48,3,19.7>, <-43.062,3,7.391>, <-48,3,16> }
		triangle { <-32,3,18.5>, <-35.5,3,6.8>, <-40,3,8> }
		triangle { <-40,3,8>, <-34.5,3,24.3>, <-32,3,18.5> }
		triangle { <-35.5,3,6.8>, <-34.343,3,5.657>, <-34.343,0.5,5.657> }
		triangle { <-34.343,0.5,5.657>, <-35.5,1,6.8>, <-35.5,3,6.8> }
		triangle { <-34.343,3,5.657>, <-32.609,3,3.062>, <-32.609,-0.3,3.062> }
		triangle { <-32.609,-0.3,3.062>, <-34.343,0.5,5.657>, <-34.343,3,5.657> }
		triangle { <-32.609,3,3.062>, <-32,3,0>, <-32,-0.8,0> }
		triangle { <-32,-0.8,0>, <-32.609,-0.3,3.062>, <-32.609,3,3.062> }
	}
	object { _2_dash_4cyls_dot_dat matrix <-6,0,0,0,-1.5,0,0,0,6,-40,3,0> }
	mesh {
		triangle { <-32,-0.8,0>, <-32.609,-0.3,3.062>, <-20,-5,0> }
		triangle { <-32.609,-0.3,3.062>, <-20,-5,4>, <-20,-5,0> }
		triangle { <-34.343,0.5,5.657>, <-32.609,-0.3,3.062>, <-20,-5,4> }
		triangle { <-34.343,0.5,5.657>, <-35.5,1,6.8>, <-20,-5,4> }
		triangle { <-34.5,3,24.3>, <-32,3,24>, <-32,3,18.5> }
		triangle { <-34.5,3,24.3>, <-28,3,26>, <-28,3,24> }
		triangle { <-28,3,24>, <-32,3,24>, <-34.5,3,24.3> }
		triangle { <-34.5,3,24.3>, <-28,3,26>, <-30,3,30> }
		triangle { <-30,3,30>, <-36.8,3,27.5>, <-34.5,3,24.3> }
		triangle { <-23,3,32>, <-28,3,26>, <-30,3,30> }
		triangle { <-30,3,30>, <-26,3,35>, <-23,3,32> }
		triangle { <-52,8,18.3>, <-56,8,16.8>, <-56,3,16.8> }
		triangle { <-56,3,16.8>, <-52,3,18.3>, <-52,8,18.3> }
		triangle { <-56,8,16.8>, <-56,8,0>, <-56,3,0> }
		triangle { <-56,3,0>, <-56,3,16.8>, <-56,8,16.8> }
		triangle { <-52,8,18.3>, <-52,8,16>, <-52,3,16> }
		triangle { <-52,3,16>, <-52,3,18.3>, <-52,8,18.3> }
		triangle { <-48,8,16>, <-52,8,16>, <-52,3,16> }
		triangle { <-52,3,16>, <-48,3,16>, <-48,8,16> }
		triangle { <-48,8,16>, <-48,8,19.7>, <-48,3,19.7> }
		triangle { <-48,3,19.7>, <-48,3,16>, <-48,8,16> }
		triangle { <-34.5,8,24.3>, <-48,8,19.7>, <-48,3,19.7> }
		triangle { <-48,3,19.7>, <-34.5,3,24.3>, <-34.5,8,24.3> }
		triangle { <-34.5,8,24.3>, <-36.8,8,27.5>, <-36.8,3,27.5> }
		triangle { <-36.8,3,27.5>, <-34.5,3,24.3>, <-34.5,8,24.3> }
		triangle { <-26,8,35>, <-23,8,32>, <-23,3,32> }
		triangle { <-23,3,32>, <-26,3,35>, <-26,8,35> }
		triangle { <-22,8,33>, <-23,8,32>, <-23,3,32> }
		triangle { <-23,3,32>, <-22,3,33>, <-22,8,33> }
		triangle { <-22,8,33>, <-20,8,32>, <-20,3,32> }
		triangle { <-20,3,32>, <-22,3,33>, <-22,8,33> }
		triangle { <-26,8,35>, <-26,3,35>, <-23,3,32> }
		triangle { <-23,3,32>, <-23,8,32>, <-26,8,35> }
		triangle { <-23,8,32>, <-23,1,32>, <-22,1,33> }
		triangle { <-22,1,33>, <-22,8,33>, <-23,8,32> }
		triangle { <-22,8,33>, <-22,1,33>, <-20,0,32> }
		triangle { <-20,0,32>, <-20,8,32>, <-22,8,33> }
		triangle { <-23,3,32>, <-23,1,32>, <-28,1,26> }
		triangle { <-28,1,26>, <-28,3,26>, <-23,3,32> }
		triangle { <-32,3,18.5>, <-32,1,18.5>, <-35.5,1,6.8> }
		triangle { <-35.5,1,6.8>, <-35.5,3,6.8>, <-32,3,18.5> }
		triangle { <-35.5,1,6.8>, <-24,-3,8>, <-24,-2.5,12> }
		triangle { <-24,-2.5,12>, <-32,0.8,16>, <-35.5,1,6.8> }
		triangle { <-32,1,18.5>, <-35.5,1,6.8>, <-32,0.8,16> }
		triangle { <-32,0.8,16>, <-24,-2.5,12>, <-29,-0.35,16> }
		triangle { <-35.5,1,6.8>, <-20,-5,4>, <-20,-4.5,8> }
		triangle { <-20,-4.5,8>, <-24,-3,8>, <-35.5,1,6.8> }
		triangle { <-24,-2.5,12>, <-20,-4,12>, <-28,-0.7,16> }
		triangle { <-28,-0.7,16>, <-29,-0.35,16>, <-24,-2.5,12> }
		triangle { <-20,-4,13>, <-20,-4,12>, <-28,-0.7,16> }
		triangle { <-28,-0.7,16>, <-28,-0.5,17>, <-20,-4,13> }
		triangle { <-20,-4,13>, <-28,-0.5,17>, <-28,1,26> }
		triangle { <-28,1,26>, <-20,-3,20.5>, <-20,-4,13> }
		triangle { <-28,1,26>, <-20,-3,20.5>, <-20,0,29> }
		triangle { <-20,0,29>, <-23,1,32>, <-28,1,26> }
		triangle { <-20,0,29>, <-23,1,32>, <-22,1,33> }
		triangle { <-22,1,33>, <-20,0,32>, <-20,0,29> }
		triangle { <-20,0,32>, <-20,0,29>, <-20,8,29> }
		triangle { <-20,8,29>, <-20,8,32>, <-20,0,32> }
		triangle { <-20,0,29>, <-20,-3,20.5>, <-20,8,20.5> }
		triangle { <-20,8,20.5>, <-20,8,29>, <-20,0,29> }
		triangle { <-20,-3,20.5>, <-20,-4,13>, <-20,8,13> }
		triangle { <-20,8,13>, <-20,8,20.5>, <-20,-3,20.5> }
		triangle { <-20,-4,13>, <-20,-4,12>, <-20,8,12> }
		triangle { <-20,8,12>, <-20,8,13>, <-20,-4,13> }
		triangle { <-20,-4.5,8>, <-20,-5,4>, <-20,8,4> }
		triangle { <-20,8,4>, <-20,8,8>, <-20,-4.5,8> }
		triangle { <-20,-5,4>, <-20,-5,0>, <-20,8,0> }
		triangle { <-20,8,0>, <-20,8,4>, <-20,-5,4> }
		triangle { <-28,8,24>, <-28,0.65,24>, <-28,-0.7,16> }
		triangle { <-28,-0.7,16>, <-28,8,16>, <-28,8,24> }
		triangle { <-28,8,16>, <-28,-0.7,16>, <-32,0.8,16> }
		triangle { <-32,0.8,16>, <-32,8,16>, <-28,8,16> }
		triangle { <-32,8,16>, <-32,3,16>, <-32,3,24> }
		triangle { <-32,3,24>, <-32,8,24>, <-32,8,16> }
		triangle { <-32,0.8,16>, <-32,3,16>, <-32,3,18.5> }
		triangle { <-32,3,18.5>, <-32,1,18.5>, <-32,0.8,16> }
		triangle { <-32,8,24>, <-32,3,24>, <-28,3,24> }
		triangle { <-28,3,24>, <-28,8,24>, <-32,8,24> }
		triangle { <-28,3,24>, <-28,0.65,24>, <-28,1,26> }
		triangle { <-28,1,26>, <-28,3,26>, <-28,3,24> }
		triangle { <-24,-2.5,12>, <-24,8,12>, <-24,8,8> }
		triangle { <-24,8,8>, <-24,-3,8>, <-24,-2.5,12> }
		triangle { <-24,-3,8>, <-20,-4.5,8>, <-20,8,8> }
		triangle { <-20,8,8>, <-24,8,8>, <-24,-3,8> }
		triangle { <-24,8,12>, <-20,8,12>, <-20,-4,12> }
		triangle { <-20,-4,12>, <-24,-2.5,12>, <-24,8,12> }
// 
	}
}
#end

#ifndef (Color1)
#declare Color1 = #if (version >= 3.1) material { #end texture {
	lg_blue
} #if (version >= 3.1) } #end
#declare Color1_slope = #if (version >= 3.1) material { #end texture {
	lg_blue
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare box4_dash_1_dot_dat = object {
// Box, 4 faces drawn, 1 edge left out
// Name: box4-1.dat
// Author: Tore Eriksson 1998
// Official LCad Update 98-07
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
	}
}

#declare box5_dot_dat = object {
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <-1,1,-1>, <-1,0,-1>, <1,0,-1> }
		triangle { <1,0,-1>, <1,1,-1>, <-1,1,-1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
	}
}

#declare _3005_dash_3_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else union {
// Brick  1 x  1 with Blue "3" Pattern
// Name: 3005-3.dat
// Author: Tore Eriksson 1998
// Official LCad update 98-10
	mesh {
		triangle { <-5.4,6.5,-10>, <-4,6.05,-10>, <-3,7.35,-10> }
		triangle { <-3,7.35,-10>, <-4.2,8.6,-10>, <-5.4,6.5,-10> }
		triangle { <-4,6.05,-10>, <-0.6,5,-10>, <-0.8,6.9,-10> }
		triangle { <-0.8,6.9,-10>, <-3,7.35,-10>, <-4,6.05,-10> }
		triangle { <-0.6,5,-10>, <2,5,-10>, <1.6,6.9,-10> }
		triangle { <1.6,6.9,-10>, <-0.8,6.9,-10>, <-0.6,5,-10> }
		triangle { <2,5,-10>, <4.4,6.05,-10>, <2.8,7.55,-10> }
		triangle { <2.8,7.55,-10>, <1.6,6.9,-10>, <2,5,-10> }
		triangle { <4.4,6.05,-10>, <5.6,7.55,-10>, <3.4,8.85,-10> }
		triangle { <3.4,8.85,-10>, <2.8,7.55,-10>, <4.4,6.05,-10> }
		triangle { <5.6,7.55,-10>, <5.8,9.45,-10>, <3.4,9.9,-10> }
		triangle { <3.4,9.9,-10>, <3.4,8.85,-10>, <5.6,7.55,-10> }
		triangle { <5.8,9.45,-10>, <4.8,11.4,-10>, <2.8,10.55,-10> }
		triangle { <2.8,10.55,-10>, <3.4,9.9,-10>, <5.8,9.45,-10> }
		triangle { <4.8,11.4,-10>, <3.4,12.25,-10>, <2.8,10.55,-10> }
		triangle { <3.4,12.25,-10>, <1.6,12.85,-10>, <1.6,11.15,-10> }
		triangle { <1.6,11.15,-10>, <2.8,10.55,-10>, <3.4,12.25,-10> }
		triangle { <1.6,12.85,-10>, <-1.2,12.85,-10>, <-0.6,11.4,-10> }
		triangle { <-0.6,11.4,-10>, <1.6,11.15,-10>, <1.6,12.85,-10> }
		triangle { <-1.2,12.85,-10>, <-1.2,11.6,-10>, <-0.6,11.4,-10> }
		triangle { <3.4,12.25,-10>, <4.4,12.85,-10>, <3,13.7,-10> }
		triangle { <3,13.7,-10>, <1.6,12.85,-10>, <3.4,12.25,-10> }
		triangle { <4.4,12.85,-10>, <5.4,13.7,-10>, <3.6,15,-10> }
		triangle { <3.6,15,-10>, <3,13.7,-10>, <4.4,12.85,-10> }
		triangle { <5.4,13.7,-10>, <6.2,15.65,-10>, <3.6,15,-10> }
		triangle { <6.2,15.65,-10>, <5.6,17.55,-10>, <3.6,16.5,-10> }
		triangle { <3.6,16.5,-10>, <3.6,15,-10>, <6.2,15.65,-10> }
		triangle { <5.6,17.55,-10>, <4.4,18.4,-10>, <3,17,-10> }
		triangle { <3,17,-10>, <3.6,16.5,-10>, <5.6,17.55,-10> }
		triangle { <4.4,18.4,-10>, <2.8,19.05,-10>, <2,17.35,-10> }
		triangle { <2,17.35,-10>, <3,17,-10>, <4.4,18.4,-10> }
		triangle { <2.8,19.05,-10>, <-0.4,19.05,-10>, <0,17.35,-10> }
		triangle { <0,17.35,-10>, <2,17.35,-10>, <2.8,19.05,-10> }
		triangle { <-0.4,19.05,-10>, <-2.8,18.85,-10>, <-2.6,17.1,-10> }
		triangle { <-2.6,17.1,-10>, <0,17.35,-10>, <-0.4,19.05,-10> }
		triangle { <-2.8,18.85,-10>, <-4.4,18.2,-10>, <-3.8,16.7,-10> }
		triangle { <-3.8,16.7,-10>, <-2.6,17.1,-10>, <-2.8,18.85,-10> }
		triangle { <-4.4,18.2,-10>, <-6,18,-10>, <-4.8,15.65,-10> }
		triangle { <-4.8,15.65,-10>, <-3.8,16.7,-10>, <-4.4,18.2,-10> }
		#if (version >= 3.1) material #else texture #end { Color1 }
	}
	mesh {
		triangle { <-10,0,-10>, <-5.4,6.5,-10>, <-4,6.05,-10> }
		triangle { <-4,6.05,-10>, <0,0,-10>, <-10,0,-10> }
		triangle { <0,0,-10>, <-4,6.05,-10>, <-0.6,5,-10> }
		triangle { <0,0,-10>, <-0.6,5,-10>, <2,5,-10> }
		triangle { <10,0,-10>, <0,0,-10>, <2,5,-10> }
		triangle { <2,5,-10>, <4.4,6.05,-10>, <10,0,-10> }
		triangle { <10,0,-10>, <4.4,6.05,-10>, <5.6,7.55,-10> }
		triangle { <10,0,-10>, <5.6,7.55,-10>, <5.8,9.45,-10> }
		triangle { <5.8,9.45,-10>, <10,12,-10>, <10,0,-10> }
		triangle { <10,12,-10>, <5.8,9.45,-10>, <4.8,11.4,-10> }
		triangle { <10,12,-10>, <4.8,11.4,-10>, <3.4,12.25,-10> }
		triangle { <3.4,12.25,-10>, <4.4,12.85,-10>, <10,12,-10> }
		triangle { <10,12,-10>, <4.4,12.85,-10>, <5.4,13.7,-10> }
		triangle { <10,12,-10>, <5.4,13.7,-10>, <6.2,15.65,-10> }
		triangle { <6.2,15.65,-10>, <10,24,-10>, <10,12,-10> }
		triangle { <10,24,-10>, <6.2,15.65,-10>, <5.6,17.55,-10> }
		triangle { <10,24,-10>, <5.6,17.55,-10>, <4.4,18.4,-10> }
		triangle { <10,24,-10>, <4.4,18.4,-10>, <2.8,19.05,-10> }
		triangle { <2.8,19.05,-10>, <0,24,-10>, <10,24,-10> }
		triangle { <0,24,-10>, <2.8,19.05,-10>, <-0.4,19.05,-10> }
		triangle { <0,24,-10>, <-0.4,19.05,-10>, <-2.8,18.85,-10> }
		triangle { <0,24,-10>, <-2.8,18.85,-10>, <-4.4,18.2,-10> }
		triangle { <-4.4,18.2,-10>, <-10,24,-10>, <0,24,-10> }
		triangle { <-10,24,-10>, <-2.8,18.85,-10>, <-4.4,18.2,-10> }
		triangle { <-4.4,18.2,-10>, <-6,18,-10>, <-10,24,-10> }
		triangle { <-10,24,-10>, <-6,18,-10>, <-10,12,-10> }
		triangle { <-10,12,-10>, <-6,18,-10>, <-4.8,15.65,-10> }
		triangle { <-10,12,-10>, <-4.8,15.65,-10>, <-1.2,12.85,-10> }
		triangle { <-1.2,12.85,-10>, <-1.2,11.6,-10>, <-10,12,-10> }
		triangle { <-10,12,-10>, <-1.2,11.6,-10>, <-4.2,8.6,-10> }
		triangle { <-10,12,-10>, <-4.2,8.6,-10>, <-5.4,6.5,-10> }
		triangle { <-10,12,-10>, <-5.4,6.5,-10>, <-10,0,-10> }
		triangle { <-1.2,12.85,-10>, <-4.8,15.65,-10>, <-3.8,16.7,-10> }
		triangle { <-3.8,16.7,-10>, <-2.6,17.1,-10>, <-1.2,12.85,-10> }
		triangle { <-1.2,12.85,-10>, <1.6,12.85,-10>, <0,17.35,-10> }
		triangle { <0,17.35,-10>, <-2.6,17.1,-10>, <-1.2,12.85,-10> }
		triangle { <0,17.35,-10>, <2,17.35,-10>, <3,13.7,-10> }
		triangle { <3,13.7,-10>, <1.6,12.85,-10>, <0,17.35,-10> }
		triangle { <3,13.7,-10>, <3.6,15,-10>, <2,17.35,-10> }
		triangle { <2,17.35,-10>, <3,17,-10>, <3.6,16.5,-10> }
		triangle { <3.6,16.5,-10>, <3.6,15,-10>, <2,17.35,-10> }
		triangle { <-1.2,11.6,-10>, <-0.6,11.4,-10>, <-3,7.35,-10> }
		triangle { <-3,7.35,-10>, <-4.2,8.6,-10>, <-1.2,11.6,-10> }
		triangle { <-0.6,11.4,-10>, <1.6,11.15,-10>, <-0.8,6.9,-10> }
		triangle { <-0.8,6.9,-10>, <-3,7.35,-10>, <-0.6,11.4,-10> }
		triangle { <1.6,11.15,-10>, <2.8,10.55,-10>, <1.6,6.9,-10> }
		triangle { <1.6,6.9,-10>, <-0.8,6.9,-10>, <1.6,11.15,-10> }
		triangle { <2.8,10.55,-10>, <3.4,9.9,-10>, <2.8,7.55,-10> }
		triangle { <2.8,7.55,-10>, <1.6,6.9,-10>, <2.8,10.55,-10> }
		triangle { <3.4,9.9,-10>, <3.4,8.85,-10>, <2.8,7.55,-10> }
	}
	object { box5_dot_dat matrix <6,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <10,24,10>, <6,24,6>, <-6,24,6> }
		triangle { <-6,24,6>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,24,6>, <-6,24,-6> }
		triangle { <-6,24,-6>, <-10,24,-10>, <-10,24,10> }
		triangle { <-10,24,-10>, <-6,24,-6>, <6,24,-6> }
		triangle { <6,24,-6>, <10,24,-10>, <-10,24,-10> }
		triangle { <10,24,-10>, <6,24,-6>, <6,24,6> }
		triangle { <6,24,6>, <10,24,10>, <10,24,-10> }
	}
	object { box4_dash_1_dot_dat matrix <10,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
// 
	#end
}
#end

#declare _3005_dash_5_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else union {
// Brick  1 x  1 with Blue "5" Pattern
// Name: 3005-5.dat
// Author: Tore Eriksson 1998
// Official LCad update 98-10
	object { box5_dot_dat matrix <6,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <10,24,10>, <6,24,6>, <-6,24,6> }
		triangle { <-6,24,6>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,24,6>, <-6,24,-6> }
		triangle { <-6,24,-6>, <-10,24,-10>, <-10,24,10> }
		triangle { <-10,24,-10>, <-6,24,-6>, <6,24,-6> }
		triangle { <6,24,-6>, <10,24,-10>, <-10,24,-10> }
		triangle { <10,24,-10>, <6,24,-6>, <6,24,6> }
		triangle { <6,24,6>, <10,24,10>, <10,24,-10> }
	}
	object { box4_dash_1_dot_dat matrix <10,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
	mesh {
		triangle { <3.95,6.3,-10>, <-4.25,6.3,-10>, <-2.6,7.75,-10> }
		triangle { <-2.6,7.75,-10>, <3.9,7.95,-10>, <3.95,6.3,-10> }
		triangle { <-4.25,6.3,-10>, <-4.25,9.95,-10>, <-2.75,10.2,-10> }
		triangle { <-2.75,10.2,-10>, <-2.6,7.75,-10>, <-4.25,6.3,-10> }
		triangle { <-4.25,9.95,-10>, <-3.45,12.3,-10>, <1.8,11.8,-10> }
		triangle { <1.8,11.8,-10>, <-2.75,10.2,-10>, <-4.25,9.95,-10> }
		triangle { <-4.8,10.6,-10>, <-4.25,9.95,-10>, <-3.45,12.3,-10> }
		triangle { <1.8,11.8,-10>, <-0.7,11.65,-10>, <-2.75,10.2,-10> }
		triangle { <-2.75,10.2,-10>, <-1.1,10,-10>, <1.8,11.8,-10> }
		triangle { <-0.7,11.65,-10>, <1.15,11.95,-10>, <1.6,10.1,-10> }
		triangle { <1.6,10.1,-10>, <-1.1,10,-10>, <-0.7,11.65,-10> }
		triangle { <1.15,11.95,-10>, <1.95,12.5,-10>, <3.55,11.35,-10> }
		triangle { <3.55,11.35,-10>, <1.6,10.1,-10>, <1.15,11.95,-10> }
		triangle { <1.95,12.5,-10>, <2.35,13.2,-10>, <4.2,13,-10> }
		triangle { <4.2,13,-10>, <3.55,11.35,-10>, <1.95,12.5,-10> }
		triangle { <2.35,13.2,-10>, <1.75,14.7,-10>, <4.1,15.15,-10> }
		triangle { <4.1,15.15,-10>, <4.2,13,-10>, <2.35,13.2,-10> }
		triangle { <1.75,14.7,-10>, <1.1,15.2,-10>, <2.4,16.5,-10> }
		triangle { <2.4,16.5,-10>, <4.1,15.15,-10>, <1.75,14.7,-10> }
		triangle { <1.1,15.2,-10>, <-0.7,15.55,-10>, <0.7,16.85,-10> }
		triangle { <0.7,16.85,-10>, <2.4,16.5,-10>, <1.1,15.2,-10> }
		triangle { <-0.7,15.55,-10>, <-2.1,15.35,-10>, <-2,16.85,-10> }
		triangle { <-2,16.85,-10>, <0.7,16.85,-10>, <-0.7,15.55,-10> }
		triangle { <-2.1,15.35,-10>, <-3.4,15,-10>, <-3.5,16.55,-10> }
		triangle { <-3.5,16.55,-10>, <-2,16.85,-10>, <-2.1,15.35,-10> }
		triangle { <-3.4,15,-10>, <-4.2,14.35,-10>, <-5.35,15.9,-10> }
		triangle { <-5.35,15.9,-10>, <-3.5,16.55,-10>, <-3.4,15,-10> }
		#if (version >= 3.1) material #else texture #end { Color1 }
	}
	mesh {
		triangle { <-4.8,10.6,-10>, <-3.45,12.3,-10>, <-4.2,14.35,-10> }
		triangle { <-4.2,14.35,-10>, <-5.35,15.9,-10>, <-4.8,10.6,-10> }
		triangle { <-3.45,12.3,-10>, <1.8,11.8,-10>, <-3.4,15,-10> }
		triangle { <-3.4,15,-10>, <-4.2,14.35,-10>, <-3.45,12.3,-10> }
		triangle { <1.8,11.8,-10>, <-0.7,11.65,-10>, <-3.4,15,-10> }
		triangle { <-3.4,15,-10>, <-2.1,15.35,-10>, <1.8,11.8,-10> }
		triangle { <-0.7,11.65,-10>, <1.15,11.95,-10>, <-0.7,15.55,-10> }
		triangle { <-0.7,15.55,-10>, <-2.1,15.35,-10>, <-0.7,11.65,-10> }
		triangle { <1.15,11.95,-10>, <1.95,12.5,-10>, <1.1,15.2,-10> }
		triangle { <1.1,15.2,-10>, <-0.7,15.55,-10>, <1.15,11.95,-10> }
		triangle { <1.95,12.5,-10>, <2.35,13.2,-10>, <1.75,14.7,-10> }
		triangle { <1.75,14.7,-10>, <1.1,15.2,-10>, <1.95,12.5,-10> }
		triangle { <4.2,13,-10>, <3.55,11.35,-10>, <3.9,7.95,-10> }
		triangle { <3.55,11.35,-10>, <1.6,10.1,-10>, <3.9,7.95,-10> }
		triangle { <1.6,10.1,-10>, <-1.1,10,-10>, <-2.6,7.75,-10> }
		triangle { <-2.6,7.75,-10>, <3.9,7.95,-10>, <1.6,10.1,-10> }
		triangle { <-1.1,10,-10>, <-2.75,10.2,-10>, <-2.6,7.75,-10> }
		triangle { <10,0,-10>, <3.95,6.3,-10>, <-4.25,6.3,-10> }
		triangle { <-4.25,6.3,-10>, <-10,0,-10>, <10,0,-10> }
		triangle { <-10,0,-10>, <-4.25,6.3,-10>, <-4.25,9.95,-10> }
		triangle { <-4.25,9.95,-10>, <-4.8,10.6,-10>, <-10,0,-10> }
		triangle { <-10,0,-10>, <-4.8,10.6,-10>, <-5.35,15.9,-10> }
		triangle { <-5.35,15.9,-10>, <-10,24,-10>, <-10,0,-10> }
		triangle { <-10,24,-10>, <-5.35,15.9,-10>, <-3.5,16.55,-10> }
		triangle { <-10,24,-10>, <-3.5,16.55,-10>, <-2,16.85,-10> }
		triangle { <-10,24,-10>, <-2,16.85,-10>, <0.7,16.85,-10> }
		triangle { <0.7,16.85,-10>, <10,24,-10>, <-10,24,-10> }
		triangle { <10,24,-10>, <0.7,16.85,-10>, <2.4,16.5,-10> }
		triangle { <10,24,-10>, <2.4,16.5,-10>, <4.1,15.15,-10> }
		triangle { <10,24,-10>, <4.1,15.15,-10>, <4.2,13,-10> }
		triangle { <4.2,13,-10>, <10,0,-10>, <10,24,-10> }
		triangle { <10,0,-10>, <4.2,13,-10>, <3.9,7.95,-10> }
		triangle { <10,0,-10>, <3.9,7.95,-10>, <3.95,6.3,-10> }
// 
	}
}
#end

#declare stud3_dot_dat = union {
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,0,-4,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,0,-4,0> }
}

#declare _3004p06_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else union {
// Brick  1 x  2 with Black Grille Pattern
// Name: 3004p06.dat
// Author: James Jessiman
// Author: Pattern - Lars C. Hassing lch@cci.dk 19980726
// Official LCad update 99-02
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { box4_dash_1_dot_dat matrix <20,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
	mesh {
		triangle { <-20,0,-10>, <20,0,-10>, <20,2.75,-10> }
		triangle { <20,2.75,-10>, <-20,2.75,-10>, <-20,0,-10> }
		triangle { <-20,21.25,-10>, <-20,2.75,-10>, <-16.25,2.75,-10> }
		triangle { <-16.25,2.75,-10>, <-16.25,21.25,-10>, <-20,21.25,-10> }
	}
	mesh {
		triangle { <-16.25,21.25,-10>, <-16.25,2.75,-10>, <-13.75,2.75,-10> }
		triangle { <-13.75,2.75,-10>, <-13.75,21.25,-10>, <-16.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-13.75,21.25,-10>, <-13.75,2.75,-10>, <-11.25,2.75,-10> }
		triangle { <-11.25,2.75,-10>, <-11.25,21.25,-10>, <-13.75,21.25,-10> }
	}
	mesh {
		triangle { <-11.25,21.25,-10>, <-11.25,2.75,-10>, <-8.75,2.75,-10> }
		triangle { <-8.75,2.75,-10>, <-8.75,21.25,-10>, <-11.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-8.75,21.25,-10>, <-8.75,2.75,-10>, <-6.25,2.75,-10> }
		triangle { <-6.25,2.75,-10>, <-6.25,21.25,-10>, <-8.75,21.25,-10> }
	}
	mesh {
		triangle { <-6.25,21.25,-10>, <-6.25,2.75,-10>, <-3.75,2.75,-10> }
		triangle { <-3.75,2.75,-10>, <-3.75,21.25,-10>, <-6.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-3.75,21.25,-10>, <-3.75,2.75,-10>, <-1.25,2.75,-10> }
		triangle { <-1.25,2.75,-10>, <-1.25,21.25,-10>, <-3.75,21.25,-10> }
	}
	mesh {
		triangle { <-1.25,21.25,-10>, <-1.25,2.75,-10>, <1.25,2.75,-10> }
		triangle { <1.25,2.75,-10>, <1.25,21.25,-10>, <-1.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <1.25,21.25,-10>, <1.25,2.75,-10>, <3.75,2.75,-10> }
		triangle { <3.75,2.75,-10>, <3.75,21.25,-10>, <1.25,21.25,-10> }
	}
	mesh {
		triangle { <3.75,21.25,-10>, <3.75,2.75,-10>, <6.25,2.75,-10> }
		triangle { <6.25,2.75,-10>, <6.25,21.25,-10>, <3.75,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <6.25,21.25,-10>, <6.25,2.75,-10>, <8.75,2.75,-10> }
		triangle { <8.75,2.75,-10>, <8.75,21.25,-10>, <6.25,21.25,-10> }
	}
	mesh {
		triangle { <8.75,21.25,-10>, <8.75,2.75,-10>, <11.25,2.75,-10> }
		triangle { <11.25,2.75,-10>, <11.25,21.25,-10>, <8.75,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <11.25,21.25,-10>, <11.25,2.75,-10>, <13.75,2.75,-10> }
		triangle { <13.75,2.75,-10>, <13.75,21.25,-10>, <11.25,21.25,-10> }
	}
	mesh {
		triangle { <13.75,21.25,-10>, <13.75,2.75,-10>, <16.25,2.75,-10> }
		triangle { <16.25,2.75,-10>, <16.25,21.25,-10>, <13.75,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <16.25,21.25,-10>, <16.25,2.75,-10>, <20,2.75,-10> }
		triangle { <20,2.75,-10>, <20,21.25,-10>, <16.25,21.25,-10> }
		triangle { <-20,21.25,-10>, <20,21.25,-10>, <20,24,-10> }
		triangle { <20,24,-10>, <-20,24,-10>, <-20,21.25,-10> }
// 
	}
}
#end

#ifndef (Color14)
#declare Color14 = #if (version >= 3.1) material { #end texture {
	lg_yellow
} #if (version >= 3.1) } #end
#declare Color14_slope = #if (version >= 3.1) material { #end texture {
	lg_yellow
	#if (QUAL > 1) normal { bumps 0.3 scale 25*0.02 } #end
} #if (version >= 3.1) } #end
#end

#declare _3004p05_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else union {
// Brick  1 x  2 with Yellow Grille Pattern
// Name: 3004p05.dat
// Author: James Jessiman
// Author: 1999-06-19 KevinB  Changed Grill Color to Yellow
// Official LCad update 99-06
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { box4_dash_1_dot_dat matrix <20,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
	mesh {
		triangle { <-20,0,-10>, <20,0,-10>, <20,2.75,-10> }
		triangle { <20,2.75,-10>, <-20,2.75,-10>, <-20,0,-10> }
		triangle { <-20,21.25,-10>, <-20,2.75,-10>, <-16.25,2.75,-10> }
		triangle { <-16.25,2.75,-10>, <-16.25,21.25,-10>, <-20,21.25,-10> }
	}
	mesh {
		triangle { <-16.25,21.25,-10>, <-16.25,2.75,-10>, <-13.75,2.75,-10> }
		triangle { <-13.75,2.75,-10>, <-13.75,21.25,-10>, <-16.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-13.75,21.25,-10>, <-13.75,2.75,-10>, <-11.25,2.75,-10> }
		triangle { <-11.25,2.75,-10>, <-11.25,21.25,-10>, <-13.75,21.25,-10> }
	}
	mesh {
		triangle { <-11.25,21.25,-10>, <-11.25,2.75,-10>, <-8.75,2.75,-10> }
		triangle { <-8.75,2.75,-10>, <-8.75,21.25,-10>, <-11.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-8.75,21.25,-10>, <-8.75,2.75,-10>, <-6.25,2.75,-10> }
		triangle { <-6.25,2.75,-10>, <-6.25,21.25,-10>, <-8.75,21.25,-10> }
	}
	mesh {
		triangle { <-6.25,21.25,-10>, <-6.25,2.75,-10>, <-3.75,2.75,-10> }
		triangle { <-3.75,2.75,-10>, <-3.75,21.25,-10>, <-6.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-3.75,21.25,-10>, <-3.75,2.75,-10>, <-1.25,2.75,-10> }
		triangle { <-1.25,2.75,-10>, <-1.25,21.25,-10>, <-3.75,21.25,-10> }
	}
	mesh {
		triangle { <-1.25,21.25,-10>, <-1.25,2.75,-10>, <1.25,2.75,-10> }
		triangle { <1.25,2.75,-10>, <1.25,21.25,-10>, <-1.25,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <1.25,21.25,-10>, <1.25,2.75,-10>, <3.75,2.75,-10> }
		triangle { <3.75,2.75,-10>, <3.75,21.25,-10>, <1.25,21.25,-10> }
	}
	mesh {
		triangle { <3.75,21.25,-10>, <3.75,2.75,-10>, <6.25,2.75,-10> }
		triangle { <6.25,2.75,-10>, <6.25,21.25,-10>, <3.75,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <6.25,21.25,-10>, <6.25,2.75,-10>, <8.75,2.75,-10> }
		triangle { <8.75,2.75,-10>, <8.75,21.25,-10>, <6.25,21.25,-10> }
	}
	mesh {
		triangle { <8.75,21.25,-10>, <8.75,2.75,-10>, <11.25,2.75,-10> }
		triangle { <11.25,2.75,-10>, <11.25,21.25,-10>, <8.75,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <11.25,21.25,-10>, <11.25,2.75,-10>, <13.75,2.75,-10> }
		triangle { <13.75,2.75,-10>, <13.75,21.25,-10>, <11.25,21.25,-10> }
	}
	mesh {
		triangle { <13.75,21.25,-10>, <13.75,2.75,-10>, <16.25,2.75,-10> }
		triangle { <16.25,2.75,-10>, <16.25,21.25,-10>, <13.75,21.25,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <16.25,21.25,-10>, <16.25,2.75,-10>, <20,2.75,-10> }
		triangle { <20,2.75,-10>, <20,21.25,-10>, <16.25,21.25,-10> }
		triangle { <-20,21.25,-10>, <20,21.25,-10>, <20,24,-10> }
		triangle { <20,24,-10>, <-20,24,-10>, <-20,21.25,-10> }
// 
	}
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3022)
		#include "lg_3022.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3022_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else object {
// Plate  2 x  2
	lg_3022
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3022_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else object {
// Plate  2 x  2
	lg_3022_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4032)
		#include "lg_4032.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4032_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else object {
// Plate  2 x  2 Round
	lg_4032
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4032_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else object {
// Plate  2 x  2 Round
	lg_4032_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3176)
		#include "lg_3176.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3176_dot_dat = #if (QUAL = 0) box { <-20,-4,-40>, <20,8,20> } #else object {
// Plate  3 x  2 with Hole
	lg_3176
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3176_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-40>, <20,8,20> } #else object {
// Plate  3 x  2 with Hole
	lg_3176_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _1_dash_4ccyli_dot_dat = object {
	mesh {
		triangle { <0,0,3.5>, <0,-0.38,3.42>, <1.31,-0.38,3.16> }
		triangle { <1.31,-0.38,3.16>, <1.34,0,3.23>, <0,0,3.5> }
		triangle { <1.34,0,3.23>, <1.31,-0.38,3.16>, <2.43,-0.38,2.43> }
		triangle { <2.43,-0.38,2.43>, <2.48,0,2.48>, <1.34,0,3.23> }
		triangle { <2.48,0,2.48>, <2.43,-0.38,2.43>, <3.16,-0.38,1.31> }
		triangle { <3.16,-0.38,1.31>, <3.23,0,1.34>, <2.48,0,2.48> }
		triangle { <3.23,0,1.34>, <3.16,-0.38,1.31>, <3.42,-0.38,0> }
		triangle { <3.42,-0.38,0>, <3.5,0,0>, <3.23,0,1.34> }
		triangle { <0,-0.38,3.42>, <0,-0.71,3.21>, <1.23,-0.71,2.96> }
		triangle { <1.23,-0.71,2.96>, <1.31,-0.38,3.16>, <0,-0.38,3.42> }
		triangle { <1.31,-0.38,3.16>, <1.23,-0.71,2.96>, <2.27,-0.71,2.27> }
		triangle { <2.27,-0.71,2.27>, <2.43,-0.38,2.43>, <1.31,-0.38,3.16> }
		triangle { <2.43,-0.38,2.43>, <2.27,-0.71,2.27>, <2.96,-0.71,1.23> }
		triangle { <2.96,-0.71,1.23>, <3.16,-0.38,1.31>, <2.43,-0.38,2.43> }
		triangle { <3.16,-0.38,1.31>, <2.96,-0.71,1.23>, <3.21,-0.71,0> }
		triangle { <3.21,-0.71,0>, <3.42,-0.38,0>, <3.16,-0.38,1.31> }
		triangle { <0,-0.71,3.21>, <0,-0.92,2.88>, <1.11,-0.92,2.66> }
		triangle { <1.11,-0.92,2.66>, <1.23,-0.71,2.96>, <0,-0.71,3.21> }
		triangle { <1.23,-0.71,2.96>, <1.11,-0.92,2.66>, <2.04,-0.92,2.04> }
		triangle { <2.04,-0.92,2.04>, <2.27,-0.71,2.27>, <1.23,-0.71,2.96> }
		triangle { <2.27,-0.71,2.27>, <2.04,-0.92,2.04>, <2.66,-0.92,1.11> }
		triangle { <2.66,-0.92,1.11>, <2.96,-0.71,1.23>, <2.27,-0.71,2.27> }
		triangle { <2.96,-0.71,1.23>, <2.66,-0.92,1.11>, <2.88,-0.92,0> }
		triangle { <2.88,-0.92,0>, <3.21,-0.71,0>, <2.96,-0.71,1.23> }
		triangle { <0,-0.92,2.88>, <0,-1,2.5>, <0.96,-1,2.31> }
		triangle { <0.96,-1,2.31>, <1.11,-0.92,2.66>, <0,-0.92,2.88> }
		triangle { <1.11,-0.92,2.66>, <0.96,-1,2.31>, <1.77,-1,1.77> }
		triangle { <1.77,-1,1.77>, <2.04,-0.92,2.04>, <1.11,-0.92,2.66> }
		triangle { <2.04,-0.92,2.04>, <1.77,-1,1.77>, <2.31,-1,0.96> }
		triangle { <2.31,-1,0.96>, <2.66,-0.92,1.11>, <2.04,-0.92,2.04> }
		triangle { <2.66,-0.92,1.11>, <2.31,-1,0.96>, <2.5,-1,0> }
		triangle { <2.5,-1,0>, <2.88,-0.92,0>, <2.66,-0.92,1.11> }
		triangle { <0,-1,2.5>, <0,-0.92,2.12>, <0.81,-0.92,1.96> }
		triangle { <0.81,-0.92,1.96>, <0.96,-1,2.31>, <0,-1,2.5> }
		triangle { <0.96,-1,2.31>, <0.81,-0.92,1.96>, <1.5,-0.92,1.5> }
		triangle { <1.5,-0.92,1.5>, <1.77,-1,1.77>, <0.96,-1,2.31> }
		triangle { <1.77,-1,1.77>, <1.5,-0.92,1.5>, <1.96,-0.92,0.81> }
		triangle { <1.96,-0.92,0.81>, <2.31,-1,0.96>, <1.77,-1,1.77> }
		triangle { <2.31,-1,0.96>, <1.96,-0.92,0.81>, <2.12,-0.92,0> }
		triangle { <2.12,-0.92,0>, <2.5,-1,0>, <2.31,-1,0.96> }
		triangle { <0,-0.92,2.12>, <0,-0.71,1.79>, <0.69,-0.71,1.66> }
		triangle { <0.69,-0.71,1.66>, <0.81,-0.92,1.96>, <0,-0.92,2.12> }
		triangle { <0.81,-0.92,1.96>, <0.69,-0.71,1.66>, <1.27,-0.71,1.27> }
		triangle { <1.27,-0.71,1.27>, <1.5,-0.92,1.5>, <0.81,-0.92,1.96> }
		triangle { <1.5,-0.92,1.5>, <1.27,-0.71,1.27>, <1.66,-0.71,0.69> }
		triangle { <1.66,-0.71,0.69>, <1.96,-0.92,0.81>, <1.5,-0.92,1.5> }
		triangle { <1.96,-0.92,0.81>, <1.66,-0.71,0.69>, <1.79,-0.71,0> }
		triangle { <1.79,-0.71,0>, <2.12,-0.92,0>, <1.96,-0.92,0.81> }
		triangle { <0,-0.71,1.79>, <0,-0.38,1.58>, <0.61,-0.38,1.46> }
		triangle { <0.61,-0.38,1.46>, <0.69,-0.71,1.66>, <0,-0.71,1.79> }
		triangle { <0.69,-0.71,1.66>, <0.61,-0.38,1.46>, <1.11,-0.38,1.11> }
		triangle { <1.11,-0.38,1.11>, <1.27,-0.71,1.27>, <0.69,-0.71,1.66> }
		triangle { <1.27,-0.71,1.27>, <1.11,-0.38,1.11>, <1.46,-0.38,0.61> }
		triangle { <1.46,-0.38,0.61>, <1.66,-0.71,0.69>, <1.27,-0.71,1.27> }
		triangle { <1.66,-0.71,0.69>, <1.46,-0.38,0.61>, <1.58,-0.38,0> }
		triangle { <1.58,-0.38,0>, <1.79,-0.71,0>, <1.66,-0.71,0.69> }
		triangle { <0,-0.38,1.58>, <0,0,1.5>, <0.58,0,1.39> }
		triangle { <0.58,0,1.39>, <0.61,-0.38,1.46>, <0,-0.38,1.58> }
		triangle { <0.61,-0.38,1.46>, <0.58,0,1.39>, <1.06,0,1.06> }
		triangle { <1.06,0,1.06>, <1.11,-0.38,1.11>, <0.61,-0.38,1.46> }
		triangle { <1.11,-0.38,1.11>, <1.06,0,1.06>, <1.39,0,0.58> }
		triangle { <1.39,0,0.58>, <1.46,-0.38,0.61>, <1.11,-0.38,1.11> }
		triangle { <1.46,-0.38,0.61>, <1.39,0,0.58>, <1.5,0,0> }
		triangle { <1.5,0,0>, <1.58,-0.38,0>, <1.46,-0.38,0.61> }
		triangle { <0,0,1.5>, <0,0.38,1.58>, <0.61,0.38,1.46> }
		triangle { <0.61,0.38,1.46>, <0.58,0,1.39>, <0,0,1.5> }
		triangle { <0.58,0,1.39>, <0.61,0.38,1.46>, <1.11,0.38,1.11> }
		triangle { <1.11,0.38,1.11>, <1.06,0,1.06>, <0.58,0,1.39> }
		triangle { <1.06,0,1.06>, <1.11,0.38,1.11>, <1.46,0.38,0.61> }
		triangle { <1.46,0.38,0.61>, <1.39,0,0.58>, <1.06,0,1.06> }
		triangle { <1.39,0,0.58>, <1.46,0.38,0.61>, <1.58,0.38,0> }
		triangle { <1.58,0.38,0>, <1.5,0,0>, <1.39,0,0.58> }
		triangle { <0,0.38,1.58>, <0,0.71,1.79>, <0.69,0.71,1.66> }
		triangle { <0.69,0.71,1.66>, <0.61,0.38,1.46>, <0,0.38,1.58> }
		triangle { <0.61,0.38,1.46>, <0.69,0.71,1.66>, <1.27,0.71,1.27> }
		triangle { <1.27,0.71,1.27>, <1.11,0.38,1.11>, <0.61,0.38,1.46> }
		triangle { <1.11,0.38,1.11>, <1.27,0.71,1.27>, <1.66,0.71,0.69> }
		triangle { <1.66,0.71,0.69>, <1.46,0.38,0.61>, <1.11,0.38,1.11> }
		triangle { <1.46,0.38,0.61>, <1.66,0.71,0.69>, <1.79,0.71,0> }
		triangle { <1.79,0.71,0>, <1.58,0.38,0>, <1.46,0.38,0.61> }
		triangle { <0,0.71,1.79>, <0,0.92,2.12>, <0.81,0.92,1.96> }
		triangle { <0.81,0.92,1.96>, <0.69,0.71,1.66>, <0,0.71,1.79> }
		triangle { <0.69,0.71,1.66>, <0.81,0.92,1.96>, <1.5,0.92,1.5> }
		triangle { <1.5,0.92,1.5>, <1.27,0.71,1.27>, <0.69,0.71,1.66> }
		triangle { <1.27,0.71,1.27>, <1.5,0.92,1.5>, <1.96,0.92,0.81> }
		triangle { <1.96,0.92,0.81>, <1.66,0.71,0.69>, <1.27,0.71,1.27> }
		triangle { <1.66,0.71,0.69>, <1.96,0.92,0.81>, <2.12,0.92,0> }
		triangle { <2.12,0.92,0>, <1.79,0.71,0>, <1.66,0.71,0.69> }
		triangle { <0,0.92,2.12>, <0,1,2.5>, <0.96,1,2.31> }
		triangle { <0.96,1,2.31>, <0.81,0.92,1.96>, <0,0.92,2.12> }
		triangle { <0.81,0.92,1.96>, <0.96,1,2.31>, <1.77,1,1.77> }
		triangle { <1.77,1,1.77>, <1.5,0.92,1.5>, <0.81,0.92,1.96> }
		triangle { <1.5,0.92,1.5>, <1.77,1,1.77>, <2.31,1,0.96> }
		triangle { <2.31,1,0.96>, <1.96,0.92,0.81>, <1.5,0.92,1.5> }
		triangle { <1.96,0.92,0.81>, <2.31,1,0.96>, <2.5,1,0> }
		triangle { <2.5,1,0>, <2.12,0.92,0>, <1.96,0.92,0.81> }
		triangle { <0,1,2.5>, <0,0.92,2.88>, <1.11,0.92,2.66> }
		triangle { <1.11,0.92,2.66>, <0.96,1,2.31>, <0,1,2.5> }
		triangle { <0.96,1,2.31>, <1.11,0.92,2.66>, <2.04,0.92,2.04> }
		triangle { <2.04,0.92,2.04>, <1.77,1,1.77>, <0.96,1,2.31> }
		triangle { <1.77,1,1.77>, <2.04,0.92,2.04>, <2.66,0.92,1.11> }
		triangle { <2.66,0.92,1.11>, <2.31,1,0.96>, <1.77,1,1.77> }
		triangle { <2.31,1,0.96>, <2.66,0.92,1.11>, <2.88,0.92,0> }
		triangle { <2.88,0.92,0>, <2.5,1,0>, <2.31,1,0.96> }
		triangle { <0,0.92,2.88>, <0,0.71,3.21>, <1.23,0.71,2.96> }
		triangle { <1.23,0.71,2.96>, <1.11,0.92,2.66>, <0,0.92,2.88> }
		triangle { <1.11,0.92,2.66>, <1.23,0.71,2.96>, <2.27,0.71,2.27> }
		triangle { <2.27,0.71,2.27>, <2.04,0.92,2.04>, <1.11,0.92,2.66> }
		triangle { <2.04,0.92,2.04>, <2.27,0.71,2.27>, <2.96,0.71,1.23> }
		triangle { <2.96,0.71,1.23>, <2.66,0.92,1.11>, <2.04,0.92,2.04> }
		triangle { <2.66,0.92,1.11>, <2.96,0.71,1.23>, <3.21,0.71,0> }
		triangle { <3.21,0.71,0>, <2.88,0.92,0>, <2.66,0.92,1.11> }
		triangle { <0,0.71,3.21>, <0,0.38,3.42>, <1.31,0.38,3.16> }
		triangle { <1.31,0.38,3.16>, <1.23,0.71,2.96>, <0,0.71,3.21> }
		triangle { <1.23,0.71,2.96>, <1.31,0.38,3.16>, <2.43,0.38,2.43> }
		triangle { <2.43,0.38,2.43>, <2.27,0.71,2.27>, <1.23,0.71,2.96> }
		triangle { <2.27,0.71,2.27>, <2.43,0.38,2.43>, <3.16,0.38,1.31> }
		triangle { <3.16,0.38,1.31>, <2.96,0.71,1.23>, <2.27,0.71,2.27> }
		triangle { <2.96,0.71,1.23>, <3.16,0.38,1.31>, <3.42,0.38,0> }
		triangle { <3.42,0.38,0>, <3.21,0.71,0>, <2.96,0.71,1.23> }
		triangle { <0,0.38,3.42>, <0,0,3.5>, <1.34,0,3.23> }
		triangle { <1.34,0,3.23>, <1.31,0.38,3.16>, <0,0.38,3.42> }
		triangle { <1.31,0.38,3.16>, <1.34,0,3.23>, <2.48,0,2.48> }
		triangle { <2.48,0,2.48>, <2.43,0.38,2.43>, <1.31,0.38,3.16> }
		triangle { <2.43,0.38,2.43>, <2.48,0,2.48>, <3.23,0,1.34> }
		triangle { <3.23,0,1.34>, <3.16,0.38,1.31>, <2.43,0.38,2.43> }
		triangle { <3.16,0.38,1.31>, <3.23,0,1.34>, <3.5,0,0> }
		triangle { <3.5,0,0>, <3.42,0.38,0>, <3.16,0.38,1.31> }
	}
}

#declare _71137_dot_dat = #if (QUAL = 0) box { <-9,-128,-30>, <9,4,9> } #else union {
// Exhaust Pipe
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,0,1,0,4,0,0,0,-30> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,0,-20,0,4,0,0,0,-10> }
	object { _1_dash_4ccyli_dot_dat matrix <0,4,0,4,0,0,0,0,4,0,-10,-10> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,16,0,0,0,4,0,-26,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-26,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,6,0,0,0,9,0,-32,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-32,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-34,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-34,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-36,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-36,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-38,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-38,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-40,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-40,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-42,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-42,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-44,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-44,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-46,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-46,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-48,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-48,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-50,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-50,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-52,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-52,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-54,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-54,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-56,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-56,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-58,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-58,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-60,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-60,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-62,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-62,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-64,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-64,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-66,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-66,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-68,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-68,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-70,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-70,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-72,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-72,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-74,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-74,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-76,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-76,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-78,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-78,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-80,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-80,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-82,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-82,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-84,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-84,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-86,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-86,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,2,0,0,0,9,0,-88,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-88,0> }
	object { _4_dash_4cyli_dot_dat matrix <7,0,0,0,2,0,0,0,7,0,-90,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-90,0> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,6,0,0,0,9,0,-96,0> }
	object { _4_dash_4disc_dot_dat matrix <9,0,0,0,1,0,0,0,9,0,-96,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,24,0,0,0,4,0,-120,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,8,0,0,4,4,0,-124,0> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,1,1,0,0,4,4,0,-124,0> }
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4595)
		#include "lg_4595.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4595_dot_dat = #if (QUAL = 0) box { <-14,-4,-36>, <14,18,24> } #else object {
// Brick  1 x  2 x  2/3 with Studs on Sides
	lg_4595
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4595_dot_dat_clear = #if (QUAL = 0) box { <-14,-4,-36>, <14,18,24> } #else object {
// Brick  1 x  2 x  2/3 with Studs on Sides
	lg_4595_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3581)
		#include "lg_3581.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3581_dot_dat = #if (QUAL = 0) box { <-10,-4,-16>, <10,48,10> } #else object {
// Brick  1 x  1 x  2 with Shutter Holder
	lg_3581
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3581_dot_dat_clear = #if (QUAL = 0) box { <-10,-4,-16>, <10,48,10> } #else object {
// Brick  1 x  1 x  2 with Shutter Holder
	lg_3581_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _3004p03_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else union {
// Brick  1 x  2 with Yellow Down Arrow and Black Border Pattern
// Name: 3004p03.dat
// Author: Kevin M Bane  6/14/99
// Official LCad update 99-06
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,0,10>, <20,24,10>, <-20,24,10> }
		triangle { <-20,24,10>, <-20,0,10>, <20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <-20,24,-10> }
		triangle { <-20,24,-10>, <-20,0,-10>, <-20,0,10> }
		triangle { <20,0,-10>, <20,24,-10>, <20,24,10> }
		triangle { <20,24,10>, <20,0,10>, <20,0,-10> }
		triangle { <-20,0,-10>, <-20,2,-10>, <20,2,-10> }
		triangle { <20,2,-10>, <20,0,-10>, <-20,0,-10> }
		triangle { <4,0,-10>, <4,13,-10>, <20,13,-10> }
		triangle { <20,13,-10>, <20,0,-10>, <4,0,-10> }
		triangle { <-4,0,-10>, <-4,13,-10>, <-20,13,-10> }
		triangle { <-20,13,-10>, <-20,0,-10>, <-4,0,-10> }
		triangle { <10.5,12,-10>, <-1,23.5,-10>, <20,23.5,-10> }
		triangle { <20,23.5,-10>, <20,12,-10>, <10.5,12,-10> }
		triangle { <-10.5,12,-10>, <1,23.5,-10>, <-20,23.5,-10> }
		triangle { <-20,23.5,-10>, <-20,12,-10>, <-10.5,12,-10> }
		triangle { <-20,22.5,-10>, <-20,24,-10>, <20,24,-10> }
		triangle { <20,24,-10>, <20,22.5,-10>, <-20,22.5,-10> }
	}
	mesh {
		triangle { <-3,3,-10>, <-3,15,-10>, <3,15,-10> }
		triangle { <3,15,-10>, <3,3,-10>, <-3,3,-10> }
		triangle { <-7,14,-10>, <0,21,-10>, <7,14,-10> }
		#if (version >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-4,2,-10>, <-4,3,-10>, <4,3,-10> }
		triangle { <4,3,-10>, <4,2,-10>, <-4,2,-10> }
		triangle { <3,3,-10>, <3,14,-10>, <4,14,-10> }
		triangle { <4,14,-10>, <4,2,-10>, <3,3,-10> }
		triangle { <3,13,-10>, <3,14,-10>, <8.5,14,-10> }
		triangle { <8.5,14,-10>, <9.5,13,-10>, <3,13,-10> }
		triangle { <0,21,-10>, <0,22.5,-10>, <9.5,13,-10> }
		triangle { <9.5,13,-10>, <8,13,-10>, <0,21,-10> }
		triangle { <-3,3,-10>, <-3,14,-10>, <-4,14,-10> }
		triangle { <-4,14,-10>, <-4,2,-10>, <-3,3,-10> }
		triangle { <-3,13,-10>, <-3,14,-10>, <-8.5,14,-10> }
		triangle { <-8.5,14,-10>, <-9.5,13,-10>, <-3,13,-10> }
		triangle { <0,21,-10>, <0,22.5,-10>, <-9.5,13,-10> }
		triangle { <-9.5,13,-10>, <-8,13,-10>, <0,21,-10> }
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
// 
	#end
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_2877)
		#include "lg_2877.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _2877_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else object {
// Brick  1 x  2 with Grille
	lg_2877
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _2877_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else object {
// Brick  1 x  2 with Grille
	lg_2877_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_3023)
		#include "lg_3023.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _3023_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,8,10> } #else object {
// Plate  1 x  2
	lg_3023
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _3023_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-10>, <20,8,10> } #else object {
// Plate  1 x  2
	lg_3023_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_2450)
		#include "lg_2450.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _2450_dot_dat = #if (QUAL = 0) box { <-30,-4,-30>, <30,8,30> } #else object {
// Plate  3 x  3 without Corner
	lg_2450
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _2450_dot_dat_clear = #if (QUAL = 0) box { <-30,-4,-30>, <30,8,30> } #else object {
// Plate  3 x  3 without Corner
	lg_2450_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _1_dash_4ring1_dot_dat = object {
// 1/4 Ring Radius 1:2
// Name: 1-4ring1.dat
// Author: Chris Dee (chris_w_dee@hotmail.com)
// Official LCad Primitive 2000-01
	mesh {
		triangle { <1,0,0>, <0.9239,0,0.3827>, <1.8478,0,0.7654> }
		triangle { <1.8478,0,0.7654>, <2,0,0>, <1,0,0> }
		triangle { <0.9239,0,0.3827>, <0.7071,0,0.7071>, <1.4142,0,1.4142> }
		triangle { <1.4142,0,1.4142>, <1.8478,0,0.7654>, <0.9239,0,0.3827> }
		triangle { <0.7071,0,0.7071>, <0.3827,0,0.9239>, <0.7654,0,1.8478> }
		triangle { <0.7654,0,1.8478>, <1.4142,0,1.4142>, <0.7071,0,0.7071> }
		triangle { <0.3827,0,0.9239>, <0,0,1>, <0,0,2> }
		triangle { <0,0,2>, <0.7654,0,1.8478>, <0.3827,0,0.9239> }
// 
	}
}

#declare _1_dash_4ndis_dot_dat = object {
// 1-4 Not Disc
	mesh {
		triangle { <1,0,1>, <1,0,0>, <0.9239,0,0.3827> }
		triangle { <1,0,1>, <0.9239,0,0.3827>, <0.7071,0,0.7071> }
		triangle { <1,0,1>, <0.7071,0,0.7071>, <0.3827,0,0.9239> }
		triangle { <1,0,1>, <0.3827,0,0.9239>, <0,0,1> }
	}
}

#declare _1_dash_4disc_dot_dat = object {
// 1-4 Disc
	mesh {
		triangle { <0,0,0>, <1,0,0>, <0.9239,0,0.3827> }
		triangle { <0,0,0>, <0.9239,0,0.3827>, <0.7071,0,0.7071> }
		triangle { <0,0,0>, <0.7071,0,0.7071>, <0.3827,0,0.9239> }
		triangle { <0,0,0>, <0.3827,0,0.9239>, <0,0,1> }
	}
}

#declare _772p01_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,48,10> } #else union {
// Brick  1 x  2 x  2 without Centre Studs with Window Pattern
// Name: 772p01.dat
// Author: Chris Dee (chris_w_dee@hotmail.com)
// Official LCad Part 2000-01
	mesh {
		triangle { <15,2,-10>, <15,5,-10>, <-15,5,-10> }
		triangle { <-15,5,-10>, <-15,2,-10>, <15,2,-10> }
		triangle { <16,23,-10>, <16,26,-10>, <-16,26,-10> }
		triangle { <-16,26,-10>, <-16,23,-10>, <16,23,-10> }
		triangle { <15,44,-10>, <15,47,-10>, <-15,47,-10> }
		triangle { <-15,47,-10>, <-15,44,-10>, <15,44,-10> }
		triangle { <16,6,-10>, <19,6,-10>, <19,43,-10> }
		triangle { <19,43,-10>, <16,43,-10>, <16,6,-10> }
		triangle { <-16,6,-10>, <-19,6,-10>, <-19,43,-10> }
		triangle { <-19,43,-10>, <-16,43,-10>, <-16,6,-10> }
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object { _1_dash_4ring1_dot_dat matrix <0,-1,0,0,0,1,1,0,0,15,6,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	object { _1_dash_4ring1_dot_dat matrix <0,-1,0,0,0,1,-1,0,0,-15,6,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	object { _1_dash_4ring1_dot_dat matrix <0,1,0,0,0,1,1,0,0,15,43,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	object { _1_dash_4ring1_dot_dat matrix <0,1,0,0,0,1,-1,0,0,-15,43,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	object { _1_dash_4ring1_dot_dat matrix <0,-2,0,0,0,1,2,0,0,15,6,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	object { _1_dash_4ring1_dot_dat matrix <0,-2,0,0,0,1,-2,0,0,-15,6,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	object { _1_dash_4ring1_dot_dat matrix <0,2,0,0,0,1,2,0,0,15,43,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	object { _1_dash_4ring1_dot_dat matrix <0,2,0,0,0,1,-2,0,0,-15,43,-10> #if (version >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <19,2,-10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-19,2,-10>, <19,2,-10> }
		triangle { <-19,2,-10>, <-20,0,-10>, <-20,48,-10> }
		triangle { <-20,48,-10>, <-19,47,-10>, <-19,2,-10> }
		triangle { <-19,47,-10>, <-20,48,-10>, <20,48,-10> }
		triangle { <20,48,-10>, <19,47,-10>, <-19,47,-10> }
		triangle { <19,47,-10>, <20,48,-10>, <20,0,-10> }
		triangle { <20,0,-10>, <19,2,-10>, <19,47,-10> }
	}
	object { _1_dash_4ndis_dot_dat matrix <0,-4,0,0,0,1,4,0,0,15,6,-10> }
	object { _1_dash_4ndis_dot_dat matrix <0,-4,0,0,0,1,-4,0,0,-15,6,-10> }
	object { _1_dash_4ndis_dot_dat matrix <0,4,0,0,0,1,4,0,0,15,43,-10> }
	object { _1_dash_4ndis_dot_dat matrix <0,4,0,0,0,1,-4,0,0,-15,43,-10> }
	object { _1_dash_4disc_dot_dat matrix <0,-1,0,0,0,1,1,0,0,15,6,-10> }
	object { _1_dash_4disc_dot_dat matrix <0,-1,0,0,0,1,-1,0,0,-15,6,-10> }
	object { _1_dash_4disc_dot_dat matrix <0,1,0,0,0,1,1,0,0,15,43,-10> }
	object { _1_dash_4disc_dot_dat matrix <0,1,0,0,0,1,-1,0,0,-15,43,-10> }
	mesh {
		triangle { <15,5,-10>, <15,6,-10>, <-15,6,-10> }
		triangle { <-15,6,-10>, <-15,5,-10>, <15,5,-10> }
		triangle { <16,6,-10>, <16,23,-10>, <-16,23,-10> }
		triangle { <-16,23,-10>, <-16,6,-10>, <16,6,-10> }
		triangle { <16,26,-10>, <16,43,-10>, <-16,43,-10> }
		triangle { <-16,43,-10>, <-16,26,-10>, <16,26,-10> }
		triangle { <15,43,-10>, <15,44,-10>, <-15,44,-10> }
		triangle { <-15,44,-10>, <-15,43,-10>, <15,43,-10> }
	}
	object { box5_dot_dat matrix <16,0,0,0,-44,0,0,0,6,0,48,0> }
	mesh {
		triangle { <20,48,10>, <16,48,6>, <-16,48,6> }
		triangle { <-16,48,6>, <-20,48,10>, <20,48,10> }
		triangle { <-20,48,10>, <-16,48,6>, <-16,48,-6> }
		triangle { <-16,48,-6>, <-20,48,-10>, <-20,48,10> }
		triangle { <-20,48,-10>, <-16,48,-6>, <16,48,-6> }
		triangle { <16,48,-6>, <20,48,-10>, <-20,48,-10> }
		triangle { <20,48,-10>, <16,48,-6>, <16,48,6> }
		triangle { <16,48,6>, <20,48,10>, <20,48,-10> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,0,10>, <20,48,10>, <-20,48,10> }
		triangle { <-20,48,10>, <-20,0,10>, <20,0,10> }
		triangle { <-20,0,10>, <-20,48,10>, <-20,48,-10> }
		triangle { <-20,48,-10>, <-20,0,-10>, <-20,0,10> }
		triangle { <20,0,-10>, <20,48,-10>, <20,48,10> }
		triangle { <20,48,10>, <20,0,10>, <20,0,-10> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
// 
	#end
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_4175)
		#include "lg_4175.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _4175_dot_dat = #if (QUAL = 0) box { <-20,-4,-18>, <20,48,10> } #else object {
// Plate  1 x  2 with Ladder
	lg_4175
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _4175_dot_dat_clear = #if (QUAL = 0) box { <-20,-4,-18>, <20,48,10> } #else object {
// Plate  1 x  2 with Ladder
	lg_4175_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare _3839_dot_dat = #if (QUAL = 0) box { <-30,-4,-30>, <30,10,10> } #else union {
// Plate  1 x  2 with Handles
// Name: 3839.dat
// Author: James Jessiman
// Official L-Cad update 99-03
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <20,8,10>, <16,8,6>, <-16,8,6> }
		triangle { <-16,8,6>, <-20,8,10>, <20,8,10> }
		triangle { <-20,8,10>, <-16,8,6>, <-16,8,-6> }
		triangle { <-16,8,-6>, <-20,8,-10>, <-20,8,10> }
		triangle { <-20,8,-10>, <-16,8,-6>, <16,8,-6> }
		triangle { <16,8,-6>, <20,8,-10>, <-20,8,-10> }
		triangle { <20,8,-10>, <16,8,-6>, <16,8,6> }
		triangle { <16,8,6>, <20,8,10>, <20,8,-10> }
		triangle { <20,8,10>, <20,7,10>, <20,7,-10> }
		triangle { <20,7,-10>, <20,8,-10>, <20,8,10> }
		triangle { <-20,8,10>, <-20,7,10>, <-20,7,-10> }
		triangle { <-20,7,-10>, <-20,8,-10>, <-20,8,10> }
		triangle { <20,7,10>, <22,7,10>, <22,7,-10> }
		triangle { <22,7,-10>, <20,7,-10>, <20,7,10> }
		triangle { <-20,7,10>, <-22,7,10>, <-22,7,-10> }
		triangle { <-22,7,-10>, <-20,7,-10>, <-20,7,10> }
		triangle { <20,5,10>, <22,5,10>, <22,5,-10> }
		triangle { <22,5,-10>, <20,5,-10>, <20,5,10> }
		triangle { <-20,5,10>, <-22,5,10>, <-22,5,-10> }
		triangle { <-22,5,-10>, <-20,5,-10>, <-20,5,10> }
		triangle { <20,5,10>, <20,0,10>, <20,0,-10> }
		triangle { <20,0,-10>, <20,5,-10>, <20,5,10> }
		triangle { <-20,5,10>, <-20,0,10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,5,-10>, <-20,5,10> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,8,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,8,10>, <20,8,10> }
		triangle { <20,8,-10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,8,-10>, <20,8,-10> }
		triangle { <20,7,10>, <20,5,10>, <22,5,10> }
		triangle { <22,5,10>, <22,7,10>, <20,7,10> }
		triangle { <-20,7,10>, <-20,5,10>, <-22,5,10> }
		triangle { <-22,5,10>, <-22,7,10>, <-20,7,10> }
		triangle { <20,7,-10>, <20,5,-10>, <22,5,-10> }
		triangle { <22,5,-10>, <22,7,-10>, <20,7,-10> }
		triangle { <-20,7,-10>, <-20,5,-10>, <-22,5,-10> }
		triangle { <-22,5,-10>, <-22,7,-10>, <-20,7,-10> }
	}
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,0,1,0,4,0,26,6,10> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,0,1,0,4,0,-26,6,10> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,0,1,0,4,0,26,6,-30> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,0,1,0,4,0,-26,6,-30> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,0,-40,0,4,0,26,6,10> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,0,-40,0,4,0,-26,6,10> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
// 
	#end
}
#end

#if (version >= 3.1) #local L3_Temp_Vers = version; #version 3.0; #end // Avoid most warnings from LGEO
#if (QUAL > 0)
	#ifndef (lg_2376)
		#include "lg_2376.inc"
	#end
#end
#ifdef (L3_Temp_Vers) #version L3_Temp_Vers; #undef L3_Temp_Vers #end
#declare _2376_dot_dat = #if (QUAL = 0) box { <-20,-24,-20>, <20,8,20> } #else object {
// Tile  2 x  2 Round with Lifting Ring
	lg_2376
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end
#declare _2376_dot_dat_clear = #if (QUAL = 0) box { <-20,-24,-20>, <20,8,20> } #else object {
// Tile  2 x  2 Round with Lifting Ring
	lg_2376_clear
	matrix <0,0,-20/LG_BRICK_WIDTH, -20/LG_BRICK_WIDTH,0,0, 0,-24/LG_BRICK_HEIGHT,0, 0,0,0>
}
#end

#declare fant1 = union {
// Untitled
// Name: fant1.dat
// Author: mArtial
// Unofficial Model
// ROTATION CENTER 8 -13 15 1 "Custom"
// ROTATION CONFIG 1 1
// STEP
// MLCAD BTG Group booster1
	object {
		_6039_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/44,0,0,0,1-SW/40,0,SW/2.44444,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-45,-40,9>
		#if (version >= 3.1) material #else texture #end { Color40 }
	}
// MLCAD BTG Group booster1
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-45,-28,9>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
// MLCAD BTG Group booster1
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-46,-59,10>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster1
	object {
		_2921_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-47,-81,9>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster1
	object {
		_2921_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-47,-105,9>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster1
	object {
		_2921_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-47,-129,9>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// GROUP 6 Group booster1
// MLCAD BTG Group booster2
	object {
		_6039_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/44,0,0,0,1-SW/40,0,SW/2.44444,0>
		matrix <0,0,-1,0,1,0,1,0,0,4,-36,67>
		#if (version >= 3.1) material #else texture #end { Color40 }
	}
// MLCAD BTG Group booster2
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,4,-24,67>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
// MLCAD BTG Group booster2
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,3,-55,66>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster2
	object {
		_2921_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,4,-77,65>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster2
	object {
		_2921_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,4,-101,65>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster2
	object {
		_2921_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,4,-125,65>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// STEP
// GROUP 6 Group booster2
// MLCAD BTG Group booster3
	object {
		_6039_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/44,0,0,0,1-SW/40,0,SW/2.44444,0>
		matrix <1,0,0,0,1,0,0,0,1,-39,-40,101>
		#if (version >= 3.1) material #else texture #end { Color40 }
	}
// MLCAD BTG Group booster3
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-39,-28,101>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
// MLCAD BTG Group booster3
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-38,-59,100>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster3
	object {
		_2921_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,-37,-81,101>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster3
	object {
		_2921_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,-37,-105,101>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster3
	object {
		_2921_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,-37,-129,101>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// STEP
// GROUP 6 Group booster3
// STEP
// MLCAD BTG Group booster4
	object {
		_6039_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/44,0,0,0,1-SW/40,0,SW/2.44444,0>
		matrix <0,0,1,0,1,0,-1,0,0,-82,-40,58>
		#if (version >= 3.1) material #else texture #end { Color40 }
	}
// MLCAD BTG Group booster4
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,-82,-28,58>
		#if (version >= 3.1) material #else texture #end { Color4 }
	}
// MLCAD BTG Group booster4
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-81,-59,59>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster4
	object {
		_2921_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-82,-81,60>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster4
	object {
		_2921_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-82,-105,60>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// MLCAD BTG Group booster4
	object {
		_2921_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-82,-129,60>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// GROUP 6 Group booster4
	object {
		_104_dot_dat
		matrix <1-SW/10,0,0,0,1-SW/145,0,0,0,1-SW/10,0,SW/-2,0>
		matrix <-1,0,0,0,1,0,0,0,-1,10,-135,68>
		#if (version >= 3.1) material #else texture #end { Color42 }
	}
// STEP
// STEP
	object {
		_30303_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/20,0,0,0,1-SW/120,0,SW/-10,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-41,-133,60>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
// STEP
// STEP
	object {
		_3005_dash_3_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-30,-164,50>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3005_dash_5_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-30,-164,70>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3004p06_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-50,-164,60>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3004p05_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-50,-188,60>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3022_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-40,-196,77>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_4032_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-40,-200,79>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_4032_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-40,-208,80>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3176_dot_dat
		matrix <-1,0,0,0,1,0,0,0,-1,-40,-205,80>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3004p05_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-30,-188,60>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_71137_dot_dat
		matrix <1-SW/18,0,0,0,1-SW/132,0,0,0,1-SW/39,0,SW/-2.12903,SW/-3.71429>
		matrix <0,0,1,0,1,0,-1,0,0,-87,-198,48>
		#if (version >= 3.1) material #else texture #end { texture {T_Chrome_5C} }
	}
	object {
		_4595_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-40,-208,48>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3581_dot_dat
		matrix <0,0,-1,0,1,0,1,0,0,-51,-190,90>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3581_dot_dat
		matrix <0,0,1,0,1,0,-1,0,0,-30,-191,90>
		#if (version >= 3.1) material #else texture #end { Color15 }
	}
	object {
		_3004p03_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-40,-164,28>
		#if (version >= 3.1) material #else texture #end { Color21 }
	}
	object {
		_2877_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-38,-189,27>
		#if (version >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3023_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-41,-142,9>
		#if (version >= 3.1) material #else texture #end { Color10 }
	}
	object {
		_3023_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-41,-142,108>
		#if (version >= 3.1) material #else texture #end { Color12 }
	}
	object {
		_2450_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-29,-218,66>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_772p01_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/20,0,SW/2.36364,0>
		matrix <1,0,0,0,1,0,0,0,1,-40,-262,85>
		#if (version >= 3.1) material #else texture #end { Color42 }
	}
	object {
		_772p01_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/20,0,SW/2.36364,0>
		matrix <1,0,0,0,1,0,0,0,1,-40,-262,65>
		#if (version >= 3.1) material #else texture #end { Color42 }
	}
	object {
		_4175_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-40,-269,65>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3839_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/14,0,0,0,1-SW/40,0,SW/4.66667,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-40,-268,85>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3022_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,-40,-276,75>
		#if (version >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_2376_dot_dat_clear
		matrix <1-0.01/40,0,0,0,1-0.01/32,0,0,0,1-0.01/40,0,0.01/-4,0>
		matrix <1,0,0,0,1,0,0,0,1,-40,-284,75>
		#if (version >= 3.1) material #else texture #end { Color42 }
	}
// 
}


object { fant1 #if (version >= 3.1) material #else texture #end { Color7 } }
//--------------------------------------------------------------------------
// Number of processed parts: 59
// From PARTS: 23
// LGEO parts: 11 (47%)
// stud.dat: 32
// BoundingBox: <-106,-326,-15> <28,4,125>
// Center: <-39,-161,55>
// Size: <134,330,140>
//===========================================================================

// Extra_Scene
// Floor:
// gforge Commandline : gforge -m 1000 -dim 2.2 -pow 1.8 -craters 1 2 -type tga
#declare HF= height_field {tga "output" smooth  scale < 1, .2 , 1 >  translate <-.5, 0, -.5>}
object{  HF  
         texture {pigment {rgb .2} 
         finish {phong 0.1 ambient 0.2} 
         }  
         scale <4,1,4>*1500
        translate <-50,0,1000>
         hollow
}

// Camera (Latitude,Longitude,Radius = 30,45,0)
camera {
	#declare PCT = 10; // Percentage further away
	#declare STEREO = 0; // Normal view
	//#declare STEREO =  degrees(atan2(1,12))/2; // Left view
	//#declare STEREO = -degrees(atan2(1,12))/2; // Right view
	location vaxis_rotate(<167.791,-345.596,-140.905> + PCT/100.0*<207.532,-169.449,-207.532>,
	                      <-35166.1,-86139,35166.1>,STEREO)
	sky      -y
	right    -4/3*x
	look_at  <-39.7408,-176.147,66.6264> // calculated
	angle    67.3801
	rotate   <0,1e-5,0> // Prevent gap between adjecent quads
}

//=================================================================
// Media declaration
// Media 1
#declare Media1=
media { 
   samples 5,5 
   intervals 15
  emission White*.02
     density { spherical  
      scale .5      
      density_map { 
                 [0 Black ]
                 [.8  bozo color_map   {[0 Black] [0.1 White][.8 Black] }scale .3 ]
                 [1. leopard color_map {[0 Black][0.3 White][.6 Black]} scale .2]
           }         
           turbulence .8
    }
  method 3 
}
// Media 2
#declare Media2=
media { 
   samples 5,5 
   intervals 15
  emission White*.02
 density {  spherical
           density_map {
                 [0 Black]
                 [.8  spiral2 20color_map {[0 Orange][1 Black ] } scale 0.5 rotate x*90]
                 [1. leopard color_map {[0 Blue ][1 Black ]} scale 2]
           }         
           turbulence .2
    }
  method 3 //jitter 5
   }


// Fumee_
sphere{ 0,1 pigment {rgbt <1,0,0,1>}
interior {media{Media1}}
hollow
scale 100
translate <-87,-320,48>
no_shadow
}

// Feux_
sphere{ 0,1 pigment {rgbt <1,0,0,1>}
interior {media{Media2}}
hollow
scale 300
translate <-39,75,75>
no_shadow
 }

// Lights...
light_source {
	<640,-827,-175>
	color rgb <1,1,0>   
	spotlight radius 5 falloff 20 point_at <-39,-161,55>
}
light_source {
	<-560,-827,-185>
	color rgb <0,1,1>
	spotlight radius 5 falloff 20 point_at <-39,-161,55>
}

//sous le vaiseaux
light_source {
	<-40,-80,60>
	color rgb <0.65098,0.94902,1>*2
	shadowless
}

//=END_OF_FILE=============================================