//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 7 materials and 69 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 08/30/2001    (30.08.2001)
//



/* // Scene Comment



*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.000,       4.000,     120.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.00000,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         47.50000    // Vertical      47.500
  look_at   <      0.000,       5.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.800, 0.400>
  fade_distance  10.0
  fade_power 1.0
  translate  <55.0, 25.0, 10.0>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.800, 0.400>
  fade_distance  10.0
  fade_power 1.0
  translate  <-55.0, 25.0, 10.0>
}

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <0.950, 0.900, 0.800>
  fade_distance  20.0
  fade_power 1.0
  translate  <15.0, 15.0, 50.0>
}


//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "js_door.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cube013 = object {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*z
    translate  -1.0*x
    scale <20.0, 0.125, 2.5>
    translate  <0.0, 18.0, -2.0>
  }
}


#declare Cube005 = object {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.125, 45.0, 1.25>
    translate  3.5*x
  }
}
#declare Sphere002 = object {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <2.0, 0.0, 1.125>
  }
}
#declare Sphere001 = object {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <-2.0, 0.0, 1.125>
  }
}




//
// ********  OBJECTS  *******
//

#declare CSG002 = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 75.0, 1.0>
    translate  -0.15*z
  }
  material {
    MortarTexture
  }
}
#declare CSG001 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 75.0, 1.0>
  }
  material {
    BrickTexture
  }
}
#declare CSG010 = union {
  object { CSG002 }
  object { CSG001 }
  translate  -1.0*z
}
#declare CSG008 = union {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 30.25, 2.25>
    translate  <0.0, -12.25, -2.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <24.0, 24.0, -4.5>
    translate  <0.0, 18.0, 0.25>
  }
}
difference { // Wall
  object { CSG010 }
  object { CSG008 }
  material {
    StoneTexture
  }
}


plane { // Plane001
  z,0
  material {
    FloorTexture
  }
  scale <5.0, 5.0, 1.0>
  rotate <-90.0, -0.0, 0.0>
  translate  -42.0*y
}


#declare CSG009 = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <35.849998, 30.0, 1.85>
    translate  <0.0, -12.0, -2.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <35.849998, 36.0, -3.7>
    translate  <0.0, 18.0, -0.15>
  }
}
#declare CSG011 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <24.15, 30.25, 2.25>
    translate  <0.0, -12.25, -2.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <24.15, 24.15, -4.5>
    translate  <0.0, 18.0, 0.25>
  }
}
#declare ArchMortar = difference {
  object { CSG009 }
  object { CSG011 }
  material {
    MortarTexture
  }
}
#declare CSG005 = union {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <36.0, 30.0, 2.0>
    translate  <0.0, -12.0, -2.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <36.0, 36.0, -4.0>
    translate  18.0*y
  }
}
#declare CSG006 = union {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 30.25, 2.25>
    translate  <0.0, -12.25, -2.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <24.0, 24.0, -4.5>
    translate  <0.0, 18.0, 0.25>
  }
}
#declare ArchBricks = difference {
  object { CSG005 }
  object { CSG006 }
  object { Cube013 }
  object { // Cube014 -> Cube013
    Cube013
    rotate -36.0*z
    translate  <-10.580135, 3.437694, 0.0>
  }
  object { // Cube015 -> Cube013
    Cube013
    rotate -72.0*z
    translate  <-17.119017, 12.437694, 0.0>
  }
  object { // Cube016 -> Cube013
    Cube013
    rotate -108.0*z
    translate  <-17.119017, 23.562306, 0.0>
  }
  object { // Cube017 -> Cube013
    Cube013
    rotate -144.0*z
    translate  <-10.580135, 32.562306, 0.0>
  }
  object { // Cube018 -> Cube013
    Cube013
    rotate 180.0*z
    translate  <0.0, 36.0, 0.0>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 0.125, 2.5>
    translate  <0.0, -22.0, -2.0>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 0.125, 2.5>
    translate  <0.0, -2.0, -2.0>
  }
  material {
    StoneTexture
  }
}
union { // Arch
  object { ArchMortar }
  object { ArchBricks }
  translate  1.0*z
}


#declare CSG003 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 30.0, 1.0>
    translate  -12.0*y
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <24.0, 24.0, 1.0>
    translate  18.0*y
  }
}
#declare DoorPlanks = difference {
  object { CSG003 }
  object { Cube005 }
  object { // Cube006 -> Cube005
    Cube005
    translate  -7.0*x
  }
  object { // Cube007 -> Cube005
    Cube005
    translate  -14.0*x
  }
  object { // Cube008 -> Cube005
    Cube005
    translate  -21.0*x
  }
  object { // Cube009 -> Cube005
    Cube005
    translate  7.0*x
  }
  object { // Cube010 -> Cube005
    Cube005
    translate  14.0*x
  }
  material {
    DisplayTexture
    scale <20.0, 5.0, 35.0>
    rotate <-90.0, 0.0, 0.25>
    translate <35.000000, 0.000000, 0.000000>
  }
}
#declare UpperBar = union {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 0.75, 0.125>
    translate  1.0*z
  }
  sphere { // Sphere015
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <-2.0, 0.0, 1.125>
  }
  sphere { // Sphere016
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <2.0, 0.0, 1.125>
  }
  object { // Sphere017 -> Sphere002
    Sphere002
    translate  7.0*x
  }
  object { // Sphere018 -> Sphere002
    Sphere002
    translate  14.0*x
  }
  object { // Sphere019 -> Sphere002
    Sphere002
    translate  21.0*x
  }
  object { // Sphere020 -> Sphere002
    Sphere002
    translate  -7.0*x
  }
  object { // Sphere021 -> Sphere002
    Sphere002
    translate  -14.0*x
  }
  object { // Sphere022 -> Sphere002
    Sphere002
    translate  -21.0*x
  }
  object { // Sphere023 -> Sphere001
    Sphere001
    translate  -7.0*x
  }
  object { // Sphere024 -> Sphere001
    Sphere001
    translate  -14.0*x
  }
  object { // Sphere025 -> Sphere001
    Sphere001
    translate  -21.0*x
  }
  object { // Sphere026 -> Sphere001
    Sphere001
    translate  7.0*x
  }
  object { // Sphere027 -> Sphere001
    Sphere001
    translate  14.0*x
  }
  object { // Sphere028 -> Sphere001
    Sphere001
    translate  21.0*x
  }
  material {
    LightRustTexture
  }
  translate  12.0*y
}
#declare Handle = union {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 0.125>
    translate  <17.5, -6.0, 1.0>
  }
  sphere { // Sphere029
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <15.0, -3.5, 1.125>
  }
  sphere { // Sphere030
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <20.0, -3.5, 1.125>
  }
  sphere { // Sphere031
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <20.0, -8.5, 1.125>
  }
  sphere { // Sphere032
    <0,0,0>,1
    material {
      DarkRustTexture
    }
    scale <0.25, 0.25, 0.05>
    translate  <15.0, -8.5, 1.125>
  }
  torus { // Torus001
    1.0, 0.5  rotate -x*90
    rotate -90.0*y
    translate  <17.5, -6.0, 1.125>
  }
  torus { // Torus002
    2.75, 0.25  rotate -x*90
    scale <0.75, 1.25, 1.0>
    translate  <17.5, -9.4375, 1.375>
  }
  material {
    LightRustTexture
  }
}
#declare LowerBar = union {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 0.75, 0.125>
    translate  1.0*z
  }
  object { Sphere001 }
  object { Sphere002 }
  object { // Sphere003 -> Sphere002
    Sphere002
    translate  7.0*x
  }
  object { // Sphere004 -> Sphere002
    Sphere002
    translate  14.0*x
  }
  object { // Sphere005 -> Sphere002
    Sphere002
    translate  21.0*x
  }
  object { // Sphere006 -> Sphere002
    Sphere002
    translate  -7.0*x
  }
  object { // Sphere007 -> Sphere002
    Sphere002
    translate  -14.0*x
  }
  object { // Sphere008 -> Sphere002
    Sphere002
    translate  -21.0*x
  }
  object { // Sphere009 -> Sphere001
    Sphere001
    translate  -7.0*x
  }
  object { // Sphere010 -> Sphere001
    Sphere001
    translate  -14.0*x
  }
  object { // Sphere011 -> Sphere001
    Sphere001
    translate  -21.0*x
  }
  object { // Sphere012 -> Sphere001
    Sphere001
    translate  7.0*x
  }
  object { // Sphere013 -> Sphere001
    Sphere001
    translate  14.0*x
  }
  object { // Sphere014 -> Sphere001
    Sphere001
    translate  21.0*x
  }
  material {
    LightRustTexture
  }
  translate  -30.0*y
}
union { // Door
  object { DoorPlanks }
  object { UpperBar }
  object { Handle }
  object { LowerBar }
  translate  -0.75*z
}








