// Persistence Of Vision raytracer version 3.1 sample scene by Chris Young.
//
// This scene shows the effect of multiple density statements.
//

#include "colors.inc"
 #declare couleur=0.9
 #declare TRS=50000
 #declare MG=8
 #declare M_EC=3
 #declare num_stars=40000
 #declare stars_type=1
 #declare latitude=60
 #declare longitude=90         
#include "colors.inc"
#include "textures.inc"
#include "xstars.inc"
camera {location  <0, 0, -100>}


light_source{<-2,0,0> color rgb<1.7,1.1,1.1>

}

 

#declare Density1=
  density {
    spherical
   ramp_wave
    color_map {
      [0.0 color rgb <0.0, 0.0, 0.0>]
      [1.0 color rgb <1, 0.3, 0.11>]
      [1.0 color rgb <0.1, 1.0, 0.1>]
    } 
  }

/* light_source { <3,0.1,0> color White}  

cylinder {<0,0,0>,<5,0,0>,1
        texture{ pigment {color Red}}
        no_shadow
        }  
 light_source { <0.1,3,0> color White}  
cylinder {<0,0,0>,<0,5,0>,1
        texture{ pigment {color Blue}}no_shadow}
 light_source { <0,0.1,3> color White}  
cylinder {<0,0,0>,<0,0,5>,1
        texture{ pigment {color Green}} no_shadow}                
        
  */
// Sphere on the left contains 2 density but one media
// Results are the colors multiply
sphere { 0,1.5 
  pigment{ color rgbf<1, 1, 1,1>}
  finish { ambient 0.0 diffuse 0.0 }
  interior { 
    media {
      emission 0.1
      intervals 50
      samples 1, 40
      confidence 0.9999
      variance 1/1000
      density {
        Density1
       translate -y/3
      }
     
     
    } 
  }
  translate -2*x
  
  scale 20
  hollow
}
 sphere {<-60,-10,50>,19 
          texture {pigment{color Black}}}
 sphere { <3,2,2>,5
        texture {
                 pigment {
                 image_map{ sys "plu2.bmp"
                                map_type 1
                                interpolate 2}
                 
                 }
                 
                 
                }
               no_shadow
               rotate 10*x
       }      
 
 sphere { <-30,-75,-2>,40
        texture {
                 pigment {
                 image_map{ sys "plu.bmp"
                                map_type 1
                                interpolate 2
                                 }
                        
                 }
                 
                 
                }
        no_shadow      
       }      
 
 
 
 
 
 
 
 
 
 
 sphere { 0,1.5 
  pigment{ color rgbf<1, 1, 1,1>}
  finish { ambient 0.0 diffuse 0.0 }
  interior { 
    media {
      
      intervals 10
      samples 1, 5
      confidence 0.9999
      variance 1/1000
      emission 0.008
      density 
        { dents
                   scale 0.2 
                   color_map {[0 Black][0.8 rgb<1,0,0.7>][1 rgb<1,0,0.0>]}
                  } 
         
      
     
     
    } 
  }
 
  no_shadow
  scale 80
  hollow
}

 sphere { <-27,-10,-2>,6.5
        texture {
                 pigment {
                 image_map{ sys "mars.bmp"
                                map_type 1
                                interpolate 2
                                 }
                     
                 }
                 
              finish {ambient 0.0 diffuse 0.0}      
                }
        no_shadow      
       }      
       
        sphere { <70,-20,10>,35
        texture {
                 pigment {
                 image_map{ sys "jup.bmp"
                                map_type 1
                                interpolate 1
                                 }
                        
                 }
                 
                 
                }
        no_shadow      
       }           