#version unofficial megapov .7;

// Sky & Atmosphere
background{color rgb <.2,.2,.6>*1.5}
sphere
{
	0,1 
	no_shadow 
	hollow
	texture
	{       
		pigment
		{
			wrinkles
			scale .25
			color_map
			{
				[0.00 color rgb 0.00 transmit 1]
				[0.30 color rgb 0.00 transmit 1]
				[0.60 color rgb 1.00 transmit .1]
				[1.00 color rgb 0.00 transmit 0]			
			}
			
			turbulence .5
                        scale .2
		}

		finish
		{
			ambient 1
			diffuse 0
		}
	}
	texture
	{       
		pigment
		{
			gradient y
			color_map
			{
				[0.0   color rgb <1,.9,.6>*.8 transmit 0]
				[0.99 color rgb <1,.95,.8>*.8 transmit .1]
				[1.00  color rgb <1,.7,.5>*.8 transmit 1]			
			}
		}

 
		finish
		{
			ambient 1
			diffuse 0
		}
	}
	scale 20000
	translate -y*(20000-1000)

}

// Dust, Haze etc
#if(nebel)
box
{
	<-100,0,-100>,<100,3,100>
	
	hollow
	no_shadow
	pigment{color rgbt 1}
	interior
	{
		media
		{
			// scattering{2, color rgb 1}
			// emission <.94,.9,.6>*.5
			absorption (1-<.94,.9,.6>)*2
			intervals 10
			samples 1,10
			
			density
			{
				gradient y
				color_map
				{
					[0.0 color rgb 0]
					[0.75 color rgb 1]
					[1.0 color rgb .5]
				}
				scale 3
			}
			
			density
			{
				spherical
				scale 50
			}
			
			density
			{
				granite scale 5
				color_map
				{
					[0.0 color rgb 0]
					[1.0 color rgb 1]
				}
			}
		}
		media
		{
			emission <.94,.9,.6>*.1
			intervals 10
			samples 1,10
			
			density
			{
				gradient y
				color_map
				{
					[0.0 color rgb 0]
					[0.75 color rgb 1]
					[1.0 color rgb .5]
				}
				scale 3
			}
			
			density
			{
				spherical
				scale 50
			}
			
			density
			{
				granite scale 5
				color_map
				{
					[0.0 color rgb 0]
					[1.0 color rgb 1]
				}
			}
		}

	}
}
#end

#declare medclouds = sphere
{
	0,1
	// no_shadow 
	hollow
	#local scl = <500,100,450>;
	scale scl
	pigment
	{
		color rgbt <1,1,1,1>
	} 
	
	interior
	{
		media
		{
			scattering{1,color rgb .01}
			method 1
			// samples 2,10
			intervals 17
			
			density
			{
				spherical
				color_map
				{
					[0.0 color rgb 0]
					[0.2 color rgb 1]
					[1.0 color rgb 1]
				}
				scale scl
			}
			
			density
			{
				spherical
				color_map
				{
					[0.0 color rgb 0]
					[0.3 color rgb .1]
					[0.5 color rgb .9]
					[1.0 color rgb 1]
				}
				scale scl
				scale <1,200,1>
			}

			density
			{       
				

				wrinkles
				color_map
				{
					[0.0 color rgb 0]
					[0.43 color rgb 0]
					[0.5 color rgb 1]
					[1.0 color rgb 1]
				}
				scale <1,1,1>
				translate <1,0,1>
				scale 75
			}
			
			/*density
			{
				granite
				scale 20
				color_map
				{
					[0.0 color rgb 0]
					[0.1 color rgb 0]
					[0.1 color rgb 1]
					[1.0 color rgb 1]
				}
			} */
			
		}
	}
} 

#if(clouds)
object
{
	medclouds
	translate vrotate(vnormalize(<2*near,3,0>-<-5*near,1.6,-10*near>)*1000,y*-20) 
	
	light_group "!inside"
	translate y*350
}
#end


