#version unofficial megapov .7;

/*
Plattform (superellipsoids) -----------------------------------------
*/

#declare sockel=union
{
	#local Steps = 3;
	#local plattness = .3;
	#local Xmax=10;
	#local Ymax=10;
	#local Threshold = .001;
	#local hRand=0.02;
	
	#local S = seed(1);
       
        #local st=0;
        #while(st<Steps)

		union
		{                 
	                #local Xmax=Xmax-1;
	                #local Ymax=Ymax-1;
	                
	                #if(st+1=Steps)
				#local Hollow = false;
	                #else
				#local Hollow = true;
			#end
			
			#local X=0;
			#while(X<Xmax)
				#local Y=0;
				#while(Y<Ymax)
				
					#if(Hollow & X>0 & X+1<Xmax & Y>0)
						#local Y=Ymax-1;
						#local hiRand=hRand;
					#else
						#local hiRand=hRand*2;
					#end
					superellipsoid
					{
						<.05,.05/plattness>
						rotate x*90
						translate <1,1,1>
						scale <1+Threshold,(1+Threshold)*plattness,1+Threshold>
						
						translate <2*X+rand(S)*hiRand,2*st*plattness+rand(S)*hiRand,2*Y+rand(S)*hiRand>
					}
				#local Y=Y+1;
				#end
			#local X=X+1;
			#end
			translate <-Xmax,0,-Ymax>
		}
	#local st=st+1;
	#end
	
	scale .5
}

/*
sulen ----------------------------------
*/

#macro saeule(N)
#local H=2;
#local T=.2;
#local BB=.5;
#local HD=.5;
union
{
	#local is=0;
	#local ismax=N;
	#while(is<=ismax)
		union
		{       
			#local B=BB;
			#if(is/ismax>1-HD)
				#local B=(is/ismax-(1-HD))*1/HD;
				#local B=sqrt(1-B*B)*BB;
			#end
			sphere
			{
				<0,0,0>,T
				translate x*B
			}
			sphere
			{
				<0,0,0>,T
				translate x*B
				rotate y*360*1/3
			}
			sphere
			{
				<0,0,0>,T
				translate x*B
				rotate y*360*2/3
			}
			rotate y*is/ismax*360*1/T*H*1/3/2
			translate y*is/ismax*H
		}
	#local is=is+1;
	#end
}
#end


#macro saeule3(N)
#local H=3;
#local T=.2;
#local BB=.25;
#local HD=.3;
union
{
	#local is=0;
	#local ismax=N;

	#local rConst = 360*1/T*H*1/3/2;
	#local ry=0;
	
	#while(is<=ismax)
		#local X=is/ismax;
		union
		{       
			#if(X<HD)
				#local Xd=(1-X/HD);
				#local ry=ry+rConst/ismax*(1-Xd);
				#local B=BB+(sin(Xd*pi-pi/2)*0.5+.5)*BB;
			#else #if(X>1-HD)
				#local Xd=(X-1+HD)/HD;
				#local ry=ry+rConst/ismax*(1-Xd);
				#local B=BB+(sin(Xd*pi-pi/2)*0.5+.5)*BB;
			#else
				#local ry=ry+rConst/ismax;
				#local B=BB;
			#end #end

			sphere
			{
				<0,0,0>,T
				translate x*B
			}
			sphere
			{
				<0,0,0>,T
				translate x*B
				rotate y*360*1/3
			}
			sphere
			{
				<0,0,0>,T
				translate x*B
				rotate y*360*2/3
			}
			rotate y*ry
			translate y*X*H
		}
	#local is=is+1;
	#end
        
        union
        {       
        	#local seP = <1,.4>;
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*B
		}
	
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*B
			rotate y*360*1/3
		}
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*B
			rotate y*360*2/3
		}
		clipped_by{plane{y,0 inverse}}
		rotate y*ry
		translate y*H
	}	

        union
        {       
        	#local seP = <1,.4>;
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*B
		}
	
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*B
			rotate y*360*1/3
		}
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*B
			rotate y*360*2/3
		}
		clipped_by{plane{y,0}}
	}	
	translate y*T
}
#end 


#macro saeule4(N)
#local H=1;
#local T=.075;
#local BB=.2;
#local SBB = .5;
#local SBB2 = .2;
#local HD=.45;
union
{
	#local is=0;
	#local ismax=N;

	#local rConst = 360*1/T*H*1/3/2;
	#local ry=0;
	
	#while(is<=ismax)
		#local X=is/ismax;
		union
		{       
			#if(X<HD)
				#local Xd=(1-X/HD);
				#local ry=ry+rConst/ismax*(1-Xd);
				#local B=BB+(sin(Xd*pi-pi/2)*0.5+.5)*SBB;
				#local Tt = T;
			#else #if(X>1-HD)
				#local Xd=(X-1+HD)/HD;
				#local ry=ry+rConst/ismax*(1-Xd);
				#local B=BB+(sin(Xd*pi-pi/2)*0.5+.5)*SBB2;
				#local Tt = (1-Xd)^.5*T;
			#else
				#local ry=ry+rConst/ismax;
				#local B=BB;
				#local Tt = T;
			#end #end

			sphere
			{
				<0,0,0>,Tt
				translate x*B
			}
			sphere
			{
				<0,0,0>,Tt
				translate x*B
				rotate y*360*1/3
			}
			sphere
			{
				<0,0,0>,Tt
				translate x*B
				rotate y*360*2/3
			}
			rotate y*ry
			translate y*X*H
		}
	#local is=is+1;
	#end
        

        union
        {       
        	#local seP = <1,.4>;
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*(SBB+B/2)
		}
	
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*(SBB+B/2)
			rotate y*360*1/3
		}
		superellipsoid
		{
			seP
			scale T
			rotate x*90
			translate x*(SBB+B/2)
			rotate y*360*2/3
		}
		clipped_by{plane{y,0}}
	}
	translate y*T
}
#end


/*
Steinplatte ----------------------------------------------
*/
#declare platenorm=function{pigment{granite scale 2}}

#declare plate = isosurface
{       
	#local a=4;
	#local b=4;
	#local c=4;
	#local ra = 1/1.1;
	#local rb = 1/.15;
	#local rc = 1/1.1;
	
	function
	{
		sqrt((x*ra)^a+(y*rb-0.3*platenorm(x*3,0,z*3))^b+(z*rc)^c) - 1
		+ 2*0.15*platenorm(x,y,z)	
	}
	contained_by { box {<-1.2,-.2*3,-1.2>,<1.2,.2,1.2>}} 
        
        // max_gradient = 1 
	method 2 
	eval

}

#declare fastplate = superellipsoid
{       
	<1/4,1/4>
	scale <1.1,.125,1.1>
}


