#version unofficial megapov .7;

// 1 unit = 1m

global_settings
{
	radiosity
	{
	    pretrace_start 0.08
	    pretrace_end   0.04
	    count 35             // CHANGE range from 20 to 150
	
	    nearest_count 5      // CHANGE range from 3 to 10
	    error_bound 1.8      // CHANGE - range from 1 to 3
	    recursion_limit 3    // CHANGE
	    
	    low_error_factor .5  // leave this
	    gray_threshold 0.0   // leave this
	    minimum_reuse 0.015  // leave this
	    brightness .25         // leave this
	    
	    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object

	}
	//ambient_light 0
	
	//post_process{depth {500, 1000}}

}

// #macro lightbulb(COLOR), radius is .5
#include "lightbulb.inc"
#include "mtextures.inc"

#local isostone=true;
#local isoscape=true;
#local alight=true;
#local saeulen=true;
#local nebel=true;
#local stones=true;
#local clouds = false;

#local alltrue=true;
#if(alltrue)
	#local isostone=true;
	#local isoscape=true;
	#local alight=true;
	#local saeulen=true;
	#local nebel=true;
	#local stones=true;
	#local clouds = true;
#end

camera
{      
	#local near = .92;
	angle 75
	location <-5*near,1.6,-10*near>
	look_at <2*near,3,0>
}

// The Sun
light_source
{
	<500,1000,-500>
	color rgb 1
	#if(alight) area_light x*200,z*200,10,10 adaptive 1 orient #end

}

// test fill light
/*light_source
{
	<-5,1,-10>
	color rgb .7
} */

// Athmosphere, haze etc
#include "athmosphere.inc"


// Landscape
#include "landscape.inc"


// Tempel
#include "geometry.inc"
union
{       
	// Sockel
	object{sockel}
        
      	// sonstiges
	union
	{	
		// tragende sulen
		#if(saeulen)
		object
		{
			saeule3(250)
			
			translate <1.5,0,1.5>
		}
		object
		{
			saeule3(250)
			translate <1.5,0,1.5>
			rotate y*360/4
		}
		object
		{
			saeule3(250)
			translate <1.5,0,1.5>
			rotate y*360*2/4
		}
		object
		{
			saeule3(250)
			translate <1.5,0,1.5>
			rotate y*360*3/4
		}
		#end
		
		// Deckplatte
	        #if(isostone)
		object
		{
			plate
			scale <2.5,2.5,2.5>
			translate y*(3+.4+.25)
			texture
			{
				pigment{color rgb 1}
				finish
				{
					specular .1
					roughness .05
				}
			}
		}
		#else
		object
		{
			fastplate
			scale <2.5,2.5,2.5>
			translate y*(3+.4+.25)
		}
		#end
		
			
		union
		{
			object
			{
				saeule4(350)
			}
			object
			{
				lightbulb(<0,1,.75>*.1) 
				translate y*(1.5-.2)
			}
		}
			
		translate y*.3*3
	}
		
	texture{stdtex}
}


/*
2. Tempel in  den Bergen erstellen
*/

#local norm=<0,0,0>;
#local temple2pos=vrotate(vnormalize(<2*near,3,0>-<-5*near,1.6,-10*near>)*650,y*22);

// 1: vrotate(vnormalize(<2*near,3,0>-<-5*near,1.6,-10*near>)*940,y*13);

#local temple2pos=trace(land,temple2pos+y*1000,-y,norm);

#debug "\n" 
#debug "temple 2 is on altitude " 
#debug str(temple2pos.y,0,2)
#debug " m above zero\n"
#debug "\n" 

glow
{
	location temple2pos+y*2
	color rgb (<0,1,.75>+.3*<1,0,.25>)*2
}

union
{
	superellipsoid{<1/10,1/10> scale 10 translate -y*10}
	union
	{       
		// Sockel
		object{sockel}
	        
	      	// sonstiges
		union
		{	
			// tragende sulen
			#if(saeulen)
			object
			{
				saeule3(100)
				
				translate <1.5,0,1.5>
			}
			object
			{
				saeule3(100)
				translate <1.5,0,1.5>
				rotate y*360/4
			}
			object
			{
				saeule3(100)
				translate <1.5,0,1.5>
				rotate y*360*2/4
			}
			object
			{
				saeule3(100)
				translate <1.5,0,1.5>
				rotate y*360*3/4
			}
			#end
			
			// Deckplatte
		        #if(isostone)
			object
			{
				plate
				scale <2.5,2.5,2.5>
				translate y*(3+.4+.25)
				texture
				{
					pigment{color rgb 1}
					finish
					{
						specular .1
						roughness .05
					}
				}
			}
			#else
			object
			{
				fastplate
				scale <2.5,2.5,2.5>
				translate y*(3+.4+.25)
			}
			#end
			
			/*object // Lichtkugel
			{
				lightbulb(<0,1,.75>*.1)
				// translate y*1.4
				translate y*.5
			} */
			translate y*.3*3
		}
		scale 2
		// translate y*1
	}
	texture{stdtex}
	rotate y*20
	translate temple2pos 
}

//wegrand sulen erstellen

addPathPillars() 

