
// Persistence of Vision Ray Tracer Scene Description File
// File: magus.inc
// Vers: 3.1
// Desc: Archivo de soporte de mg_magus.pov
// Date: Agosto 24 2001
// Auth: Marjorie Graterol

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


//Paleta Bsica - Basic Palette
#declare agua=color red 0.423529412 green 0.623529412 blue 0.623529412;
#declare agua2=color red 0.180392157 green 0.411764706 blue 0.51372549;
#declare ArenaGold= rgb<1.00,0.706,0.125>;
#declare AzulMarino=color rgb <0.129,0.165,0.459>;
#declare BlancoArena= rgb<1.00,0.914,0.749>;
#declare Cadmio=color rgb <0.925,0.780,0.071>;
#declare Malva=color rgbf <0.690,0.588,0.471,0.500>;
#declare Marron= color rgb <0.416,0.310,0.118>;
#declare Ocre= color rgb <0.702,0.580,0.000>; 
#declare VerdeOliva=color rgb <0.404,0.443,0.125>;
#declare VinoTinto=color rgb <0.459,0.200,0.129>;





//Luces- Lights
#declare luz_01=

light_source
{
  0*x 
  color ArenaGold 
  translate <-13, 12, -1> 
  fade_power 2
  fade_distance 9
  
  
}

#declare luz_02=
light_source
{
  0*x 
  color DarkSlateGray   
  translate <-1, 5, 6>
  fade_power 2
  fade_distance 15
  
  
} 
//mago//luz de la cara
#declare luz_03=
light_source
{
  0*x                     
  color DarkTan
  spotlight               
  translate <2.2,8,-20> 
  point_at <0.90,5,40>       
  radius .75               
  tightness 15           
  falloff 30               
  fade_power 2
  fade_distance 25
  

}       
//luz plantas
#declare luz_03a=
light_source
{
  0*x                     
  color DarkTan
  spotlight               
  translate <2.2,0,-20> 
  point_at <0.90,-6,-5>       
  radius 0.75                
  tightness 10            
  falloff 30               
  fade_power 2
  fade_distance 15
  

}       
#declare luz_04=

light_source
{
  0*x                     
  color Malva+Gray30
  spotlight               
  translate <10,60,150> 
  point_at <-10,20,100>      
  radius 230               
  tightness 20            
  falloff 30               
  fade_power 1
  fade_distance 300
  media_attenuation on
  

}




#declare luz_05=

light_source
{
  0*x                     
  color DarkSlateGray
  spotlight               
  translate <-50,60,150> 
  point_at <-10,5,35>     
  radius 250               
  tightness 20            
  falloff 30               
fade_power 2
 fade_distance 250
  //media_interaction on
  media_attenuation on
  

}



#declare luz_06=

light_source
{
  0*x                     
  color MediumTurquoise filter 0.5 
  translate <-15,15,17>
   fade_distance 25
  
  

}


#declare luz_07=

light_source
{
  0*x                     
  color BlancoArena
  spotlight               
  translate <4.8,10,3.5>  
  point_at <6.8,-7,4.5>     
  radius 10                
  tightness 20            
  falloff 15              
fade_power 2
 fade_distance 8
  
  media_attenuation on
  

}


#declare luz_08=

light_source
{
  0*x                     
  color DarkSlateGray
  spotlight               
  translate <4.8,10,-18>  
  point_at<5,-7,1.5>     
  radius 275                
  tightness 20           
  falloff 15              
fade_power 1
 fade_distance 25
  
  media_attenuation on
  

}


#declare luz_09=

light_source
{
  0*x                     
  color Gray50 
  spotlight               
  translate <10,17,-20>
  point_at <-20,-7,20>     
  radius 50               
  tightness 20            
  falloff 15               
fade_power 1
 fade_distance 25
  
  

}


//Resaltadores

#declare luz_10=

light_source
{
  0*x                     
  color Gray20
  spotlight               
  translate <-9,25,2>  
  point_at<0,-8,1>     
  radius 10               
  tightness 10            
  falloff 15              
fade_power 1
 fade_distance 25
  
  media_attenuation on
  
} 




#declare luz_12=

light_source
{
  0*x                     
  color ArenaGold
  spotlight               
  translate <-10,25,6>  
  point_at<-16,15,55>     
  radius 10               
  tightness 20            
  falloff 15               
fade_power 1
 fade_distance 25
  
  media_attenuation on
  
} 



#declare iluminacion=

union{

///*LUCES*///
object{luz_01} //Gold+Wheat
object{luz_02} //DarkSlateGray
object{luz_03} //Copper +Gold //cara
object{luz_03a} //matas
object{luz_04} // Brown+Gold
object{luz_05}  //MediumTurquoise

object{luz_07}  //Gold+Brown
object{luz_08}//DarkSlateGray
object{luz_09}
object{luz_10}
object{luz_12}
}




#declare cielo_04=
//texture{Starfield  scale 75}//120

texture{
pigment{
        bozo
        turbulence 0.2
        color_map { 
                    [0.0 color Black filter 0.5]
                    [0.050 color VinoTinto]
                    [0.100    color VinoTinto filter 0.5]
                    [0.150  color Black filter 0.5]
                    [0.700 color Cadmio ]
                    [1.0     color Cadmio  filter 0.5]
                    
                }
    
    }
    finish{ambient 0.6//1 0.6
    
    diffuse 0.8}
    rotate 15*y
      
}

texture{
pigment{wrinkles//bozo 
    frequency 0.90
    turbulence 0.3
    octaves 4
    omega 0.8
    lambda  00.5//0.6
    color_map { [0.0 color Gray05 filter 0.5]
                [0.7 color rgbf 1]}
     
    
    }
  finish{ambient 0.6//0.5 1 
  diffuse 0.5}
  
  translate -0.0007*y
}                    




#declare rj9 = color red 0.909803922 green 0.501960784 blue 0.070588235;
#declare Oro = texture {
  pigment {
    rj9
  }
  finish {
    ambient 0.3
    brilliance 6
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/120
    reflection 1.0//0.8
  }
}



#declare pared_1=
texture {
        pigment{
        
        image_map
                {
                tga "pared1.tga"
                map_type 0 
                interpolate 4 
                } 
        }   
 
 
        normal{
                bump_map
                        { 
                        tga "bricks.tga" 
                        map_type 0 
                        interpolate 4 
                        bump_size 3
                        } 
                }

                scale <5,5,2>
                } 
                




#declare vitral_gen2=
texture{
pigment {
   wood
   turbulence 0.05
    color_map {
      [0 .3 color rgbf <0.486,0.573,0.588,1.000>  color rgbf <0.309804, 0.184314, 0.309804, 1>]
      [.8 1 color rgbf <0.639,0.914,0.890,1.000> color rgbf <.9, .85, .8, 1>]
    }
  }


finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
    phong 0.3
        phong_size 60
    
  } scale <5,7,5>
}



//rio
#declare rio= 
texture {
           pigment {color rgbf <0.9882,0.9020,0.7882,0>}
           normal {bumps 0.5 
           frequency 2  
           phase 0.2  
           turbulence 0.3  
           scale 1.5  
           rotate 72*y}

           finish {
           
           phong 0.5  
           ambient 0.4   
           diffuse 0.4 
           reflection 0.75
           metallic}
           
           }
           
//from povlab.inc
#declare Old_Wood = texture {
  pigment {
    bozo
    turbulence 0.97
    color_map {
      [ 0.00 0.25 color rgb <0.138039, 0.104902, 0.05>
      color rgb <0.203539, 0.114902, 0.02> ]
      [ 0.25 0.50 color rgb <0.203539, 0.114902, 0.02>
      color rgb <0.203549, 0.100000, 0.05> ]
      [ 0.50 0.75 color rgb <0.203549, 0.100000, 0.05>
      color rgb <0.118139, 0.124902, 0.01> ]
      [ 0.75 1.00 color rgb <0.118039, 0.124932, 0.01>
      color rgb <0.138039, 0.104902, 0.05> ]
    }
  }
  normal {
    bumps 0.3
    scale <0.001,2,1>
  }
  finish {
    phong 0.4 
  }
}



#declare skin1=
texture{
  pigment{
    crackle
    
    color_map{
    [0.5 Flesh]
    [1.0 NewTan]
        
     }
  
  
  }
  normal{
    crackle 0.02
    
    scale 0.05
  }
  finish{
    Dull//Dull
    
  
  
  }


}
//lino
#declare lino=
texture{

        pigment{
        
                gradient x 
                frequency 50
                color_map{
                         [0.29 Clear]
                        [0.3 White]
                        [0.4 Clear]
                        [1.0 White       ]
                                }
        
                }
        normal {bumps 0.9}        
        finish{ambient 0.3 diffuse 0.4 }        
        }
                                         