
 // Persistence of Vision Ray Tracer Scene Description File
// File: mg_magus.pov
// Vers: 3.1g
// Desc: Tarot's Arcane- I The Magician
// Date: August 24, 2001
// Auth: Marjorie Graterol




// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "magus.inc"

global_settings{
	adc_bailout 0.0039
	ambient_light color Gray50
	assumed_gamma 2.20//
	irid_wavelength rgb <0.25,0.18,0.14>
	max_intersections 64                 
	max_trace_level 10
	number_of_waves 10
	radiosity{
	          brightness 3.33
	          count 300
	          distance_maximum  150.0
	          error_bound 0.3
	          gray_threshold  0.5
	}

}

camera
{
   location  < 9, 6, -17 >
   right     1.5/2*x
   look_at < -0.75, -0.5, 3.367 >    
   angle 40
 
}







//plano 

plane { y, -7.74
   texture {
           pigment {agua transmit .5} 
           normal {waves 0.5
           frequency 2.5//5
           phase 0.2
           turbulence 0.6
           scale 3.5
           rotate 72*y}

           finish {phong .8
           ambient 0.2
           diffuse 0.2
           
           reflection .25
           metallic}
           }
           hollow
           interior{
            ior 1.33 
            
           
           }
   } 
   
   
   
   
// Dearest One
#include "mg_mag04.inc" object {mago scale 0.50 } 



//Luces- Lights
object{iluminacion}



//scene- escena 



sphere{0, 10000 
  hollow  no_shadow
texture {cielo_04 
    scale <8000,9000,8000>}

}


//height_field
height_field
{
  tga "Erosion 3.tga"     

smooth        
water_level 0.05
scale <200,10,200> //<150,8,150>
//rotate -25*y 
translate <-100,-8.95,55> //-5*x <11,-8,35><11,-1,35>
texture{
        pigment{
        image_map
                {
                tga "pared1b.tga" 
                map_type 1 
                interpolate 2 
  
                } 
        }

normal{        
        
bump_map
{ 
  tga "pared1b.tga" 
  map_type 0 
  interpolate 2 
  bump_size 2 
} 

}
finish {crand 0.25 brilliance 0.6}                
}
}





//mesa - table
#include "mesa.inc" 
 object {mesa 
 
 scale <2,2,1.5>
 translate <1.65,-4,-3.5>//-4*y
 } 
 
 
//disc- disco (oros) 
 #include "estrella.inc"
 
 object{estrella scale 1.5 rotate 90*x translate <0,-0.10,-2>} 
 
//symbol -simbolo 
#declare infinito=

union{
torus
{
  0.8,
  0.05
  //pigment{Yellow}
  rotate 90*x 
  scale <0.50,0.20,0.50>
  translate <1,6,0.5> //0
  no_shadow
}

torus
{
  0.8,
  0.05
  //pigment{Yellow}
  rotate 90*x 
  scale <0.50,0.20,0.50>
  translate <1.8,6,0.5>  //<1.6,6.5,0>
  no_shadow
}
texture {rio}

}  


object{infinito translate <-0.50,0.25,0>}


        
        
//pared /wall

#declare wall_1=
difference{

box
{
  <-8, -8, -3>  
  < -7,  22,  15>  
   
  
}

box
{
  <-9, -4, 1>  
  < -6,  10,  5>  
  
}
box
{
  <-9, -4, 7>  
  < -6,  10,  11> 
  
}
 texture{pared_1 rotate 90*y }
 




}


object {wall_1 translate <-2,0,0>}

//texture /textura vitral

#declare vitral_gen2=
texture{
pigment {
   wood
   turbulence 0.05
    color_map {
      [0 .3 color rgbf <0.486,0.573,0.588,1.000>  color rgbf <0.309804, 0.184314, 0.309804, 1>]
      
      [.8 1 color rgbf <0.639,0.914,0.890,1.000> color rgbf <.9, .85, .8, 1>]
    }
  }


finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
    phong 0.3
    phong_size 60
    
  } scale <5,7,5>
}                     


//windows/ventana
#declare vitral=

box
{
  <-9.05, -3.50, -1>  
  < -9.10,  11,  13>  
  //interior {ior 1.5}
  texture {vitral_gen2}
  interior {ior 1.5}
  
  
} 


object {vitral} 
 


//floor/piso
cylinder
{
  -8*y,  -7.75*y, 23
 texture{
pigment{
  checker
    color rgb <0,0,0,>
    color rgb <1,1,1>
        
}scale 3
finish {phong 0.6}
} 
  
}



//cup/copa
#include "caliz.inc"

object{
        caliz
        texture{
                pigment{Gray50}
                normal {granite 0.10 
                        turbulence 0.05
                        }
                
                
                finish {
                        ambient 0.5
                        diffuse 0.6
                        reflection .75
                        metallic}
           
                } 
        scale 0.25 
        translate <3,0.25,0>
        }         

//sword/espada
 #include  "espada.inc"
 object{
        espada 
        scale 0.45 
        rotate 60*y
        translate <4,-1.05,-3>
        }
        
        


//foliage/follaje

#include "plantas07.inc" 

object{grupo_uno scale 0.055 translate <-15,-8,7>}

object{grupo_uno scale 0.045 translate <2,-8,-5> }

object{grupo_uno scale 0.045 rotate -30*y translate <2.5,-9,-3>}
       

#include "plantas08.inc" 

object{grupo_dos scale 0.085 translate <-1,-8,-5> }  

//extrema derecha frente

object{grupo_dos scale 0.085 rotate 45*y translate <6,-9,-1>}  
 



//basto/wand
#include "wand.inc"

object{wand 
        scale 1.75
        rotate -90*x  
        rotate 40*y
        translate <5.05,-0.50,0.95>
        texture{
        pigment{Marron}
        normal {granite 0.5 }
        finish {Phong_Dull ambient 0.6 diffuse 0.6}}  
}


//Tree of Life/ Arbol de la Vida 
#include "tree.inc"


light_source
{
  0*x 
  color White
  spotlight 
  translate <-25,15,105>
  
  looks_like { object{tree_01 scale 2}}
        
  radius 30               
  tightness 50   
  falloff 30
  fade_power 1
  fade_distance 10
  
}


//window decor/divisiones de las ventanas
#include "celdas.inc" 

object{plomos scale <4.35,6.5,1> rotate -90*y translate <-9.55,-2.9,3.25>} 

//repetir al fondo
object{plomos scale <4.35,6.5,1> rotate -90*y translate <-9.55,-2.9,9.25>} 

 


//vara
cylinder
{
  0*x,  2.5*x,  0.05
  texture{
                pigment{Gray70}
                
                
                
                finish {
                        ambient 0.8
                        diffuse 0.8
                        roughness .0082
                        reflection .85
                        metallic}
           
                }
               
  translate<-1.35,-0.65,0.5>
}



//frame /border
#include "borde.inc"
object{borde
texture{rio}
no_shadow
scale <1.2,1.1,0.5>
rotate 15*x
rotate -26*y
 
translate <4.7,3.15,-8.05> //<4.5,2.97,-8>

}

