//mohan01.pov
//
//Internet Ray Tracing Competition July-August 2001 / Fantasy and Mystic
//
//"MOHAN: Lord Of The River"
//
//luisvaloyes | www.luisvaloyes.uni.cc | luisvaloyes@malditasea.zzn.com 
//Bogota | Colombia
//
//Nota: el uso de tildes se ha evitado intencionalmente
//
//Note: this scene requires the file "largas.ini", included in this .zip file in order to render properly, 
//...so be sure to set your copy of POV-Ray to use that file.
//Nota: seleccione el archivo "largas.ini" en su copia de POV-Ray para que esta escena se ejecute adecuadamente.
//

//condiciones generales de la escena | general statements

camera {location <15,17,-40> up <0,1,0> right <2.2222,0,0> look_at <0,7,0>}

light_source { <-10000,10000,-10000> rgb <1,1,1>}
light_source { <10000,10000,-10000> rgb <1,1,1> shadowless}
light_source { <-9000,10000,-10000> rgb <.31,.31,.31>}
light_source { <0,10000,0> rgb <.41,.41,.41> shadowless}

sky_sphere { pigment {bozo color_map {[0.0 rgb <.4,.4,.6>][0.4 rgb <.8,.8,.8>][0.7 rgb <.5,.5,.7>]}}}

//el agua | the water

plane {y,-0.75 pigment {rgbf <.4,.4,.3,.7>} normal {agate 1 scale 3} finish {phong .75 reflection .5}}

//el trono de calaveras | the throne

#include "tronox01.inc"

object {tronox01}

//el Mohan | the main character "Mohan"

#include "mohan01.inc"

object {mohan01 translate <0,0,0>}

//la guitarra del mohan | mohan's guitar

#include "guitarra01.inc"

object {guitarra01 rotate <-62,-80,0> translate <8.65,0,-2.25>}

//el terreno | the terrain

#include "terreno1.inc"

object {terreno01 translate <0,0,255>}

//los arboles de fondo | the trees

#include "arboles1.inc"

//troncos temporales de los arboles completos para renders de prueba | temporary trunks for test renders

//object {tronco10a scale 7.5 translate <-17.5,0.5,35>}
//object {tronco10a scale 7.5 translate <17.5,0.5,35>}
//object {tronco10a scale 6 translate <-47.5,1.5,45>}
//object {tronco10a scale 7 translate <-77.5,2.5,50>}
//object {tronco10a scale 6 translate <-107.5,1.5,45>}
//object {tronco10a scale 7 translate <-137.5,2.5,50>}
//object {tronco10a scale 6 translate <47.5,1.5,45>}
//object {tronco10a scale 6 translate <-167.5,1.5,45>}
//object {tronco10a scale 7 translate <-197.5,2.5,50>}
//object {tronco10a scale 7 translate <-227.5,1.5,45>}
//object {tronco10a scale 7 translate <-257.5,2.5,50>}
//object {tronco10a scale 7 translate <-287.5,1.5,45>}

//troncos de las hileras posteriores, donde no se necesitan arboles completos | backdrop trunks 

object {tronco10a scale 8 translate <0,25,65>}
object {tronco10a scale 8 translate <35,25,65>}
object {tronco10a scale 8 translate <-35,25,65>}
object {tronco10a scale 8 translate <-125,25,65>}
object {tronco10a scale 8 translate <-65,25,65>}
object {tronco10a scale 8 translate <-155,25,65>}
object {tronco10a scale 8 translate <-185,25,65>}
object {tronco10a scale 8 translate <-215,25,65>}
object {tronco10a scale 8 translate <-95,25,65>}
object {tronco10a scale 6 translate <-47.5,45,85>}
object {tronco10a scale 7 translate <-77.5,45,90>}
object {tronco10a scale 6 translate <-107.5,45,85>}
object {tronco10a scale 7 translate <-137.5,45,90>}
object {tronco10a scale 6 translate <-167.5,45,85>}
object {tronco10a scale 7 translate <-197.5,45,90>}
object {tronco10a scale 7 translate <-227.5,45,85>}

//los arboles completos | foreground (complete) trees

object {arbolito1 scale 8.5 translate <-17.5,0.5,35>}
object {arbolito2 scale 8.5 translate <17.5,0.5,35>}
object {arbolito3 scale 6 translate <-47.5,1.5,45>}
object {arbolito4 scale 7 translate <-77.5,2.5,50>}
object {arbolito5 scale 6 translate <-107.5,1.5,45>}
object {arbolito6 scale 7 translate <-137.5,2.5,50>}
object {arbolito7 scale 6 translate <47.5,1.5,45>}
object {arbolito5 scale 6 translate <-167.5,1.5,45>}
object {arbolito3 scale 7 translate <-197.5,2.5,50>}
object {arbolito1 scale 7 translate <-227.5,1.5,45>}
object {arbolito2 scale 8 translate <-257.5,2.5,50>}
object {arbolito4 scale 7 translate <-287.5,1.5,45>}

//las piedras del borde | stones

#include "rocario01.inc"

//las de debajo del trono | stones under the throne

object {borderio01 rotate <0,0,0> scale <1.65,1,1> translate <0,-1.5,6.5>}
object {borderio01 rotate <0,0,0> scale <1.5,1,1> translate <0,-2,5>}
object {borderio01 rotate <0,180,0> scale <1.35,1,1> translate <0,-2,3.5>}
object {borderio01 rotate <0,0,0> scale <1.2,1,1> translate <0,-2,2>}
object {borderio01 rotate <0,180,0> scale <1.1,1,1> translate <0,-2,0.5>}
object {borderio01 rotate <0,0,0> scale <1,1,1> translate <0,-2,-1>}
object {borderio01 rotate <0,180,0> scale <1,1,1> translate <0,-2,-2.5>}
object {borderio01 rotate <0,0,0> scale <0.85,1,1> translate <0,-2,-4>}
object {borderio01 rotate <0,180,0> scale <0.75,1,1> translate <0,-2,-5.5>}
object {borderio01 rotate <0,0,0> scale <0.5,1,1> translate <0,-2,-7>}
object {borderio01 rotate <0,180,0> scale <0.4,1,1> translate <0,-2,-8.5>}

//las del borde general | river border

object {borderio01 rotate <0,0,0> scale <1.65,1,1> translate <40,-1.5,6.5>}
object {borderio01 rotate <0,0,0> scale <1.5,1,1> translate <40,-2,5>}
object {borderio01 rotate <0,0,0> scale <1.65,1,1> translate <-40,-1.5,6.5>}
object {borderio01 rotate <0,0,0> scale <1.5,1,1> translate <-40,-2,5>}
object {borderio01 rotate <0,0,0> scale <1.65,1,1> translate <-80,-1.5,6.5>}
object {borderio01 rotate <0,0,0> scale <1.5,1,1> translate <-80,-2,5>}
object {borderio01 rotate <0,0,0> scale <1.65,1,1> translate <-120,-1.5,6.5>}
object {borderio01 rotate <0,0,0> scale <1.5,1,1> translate <-120,-2,5>}
object {borderio01 rotate <0,0,0> scale <1.65,1,1> translate <-160,-1.5,6.5>}
object {borderio01 rotate <0,0,0> scale <1.5,1,1> translate <-160,-2,5>}

//la saliente diminuta donde se sienta una mujer | where there's a woman sitting

object {borderio01 rotate <0,180,0> scale <1,1,1> translate <-60,-2,3.5>}
object {borderio01 rotate <0,0,0> scale <0.9,1,1> translate <-60,-2,2>}
object {borderio01 rotate <0,180,0> scale <0.8,1,1> translate <-60,-2,0.5>}
object {borderio01 rotate <0,0,0> scale <0.6,1,1> translate <-60,-2,-1>}

//las piedras en el bosque | stones in the woods

object { union {
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,10,0> translate <15,0,15>}
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,-10,0> translate <-15,0,15>}
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,20,0> translate <-25,0,10>}
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,40,0> translate <-45,0,25>}
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,-20,0> translate <-75,0,22>}
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,-40,0> translate <-85,0,15>}
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,20,0> translate <-95,0,22>}
sphere { <0,0,0>,1.0 scale <4,2,2> rotate <0,-30,0> translate <-105,0,15>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,20,0> translate <-95,40,72>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,-20,0> translate <-85,40,72>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,-20,0> translate <-51.5,40,72>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,10,0> translate <-22.5,40,72>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,30,0> translate <23.5,40,72>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,-20,0> translate <-125,20,60>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,30,0> translate <-155,20,60>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,-30,0> translate <-25,20,60>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,10,0> translate <-55,20,60>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,40,0> translate <25,20,60>}
sphere { <0,0,0>,1.0 scale <6,3,8> rotate <-40,-10,0> translate <55,20,60>}
texture {rocario01}}}

//las piedras cerca de la orilla | stones in the water

object { union {
sphere { <0,0,0>,1.0 scale <2,1.2,1> rotate <0,10,0> translate <-17,-1,-6.5>}
sphere { <0,0,0>,1.0 scale <2,1.2,1> rotate <0,-10,0> translate <-20.5,-1,-8.25>}
sphere { <0,0,0>,1.0 scale <2,1.2,1> rotate <0,10,0> translate <-24,-1,-7>}
sphere { <0,0,0>,1.0 scale <2,1.2,1> rotate <0,-20,0> translate <-27,-1,-9>}
texture {rocario01}}}

//el fondo del rio | river's bottom

plane {y,-2.75 texture {rocario01}}

//los juncos | reeds

#include "juncos01.inc"

//los delgados | thin reeds

object {juncosx02 rotate <0,20,0> translate <25,-1,2>}
object {juncosx02 rotate <0,-10,0> translate <30,-1,2.5>}
object {juncosx02 rotate <0,20,0> translate <35,-1,2>}
object {juncosx02 rotate <0,-10,0> translate <40,-1,2.5>}

object {juncosx02 rotate <0,-10,0> translate <-20,-1,2.5>}
object {juncosx02 rotate <0,20,0> translate <-25,-1,2>}
object {juncosx02 rotate <0,-10,0> translate <-30,-1,2.5>}
object {juncosx02 rotate <0,20,0> translate <-35,-1,2>}
object {juncosx02 rotate <0,-10,0> translate <-40,-1,2.5>}
object {juncosx02 rotate <0,20,0> translate <-45,-1,2>}

//los de hoja ancha | spear-like reeds

object {juncosx01 rotate <0,-10,0> translate <-100,-1,2.5>}
object {juncosx01 rotate <0,20,0> translate <-95,-1,2>}
object {juncosx01 rotate <0,-10,0> translate <-90,-1,2.5>}
object {juncosx01 rotate <0,20,0> translate <-85,-1,2>}
object {juncosx01 rotate <0,-10,0> translate <-80,-1,2.5>}
object {juncosx01 rotate <0,20,0> translate <-75,-1,2>}

//las plantas | plants

#include "matas01.inc"

//la redonda de hojas tipo lanceta | small-round plants

object {matax02 translate <7.5,0,15>}
object {matax02 translate <22.5,0,10>}
object {matax02 translate <-27.5,0,15>}
object {matax02 translate <-37.5,0,10>}
object {matax02 translate <-57.5,0,17.5>}

//la de tres ramas con hojas chicas | 3 branches plants

object {matax01 rotate <0,30,0> translate <31,0,17.5>}
object {matax01 rotate <0,30,0> translate <35,0,15.5>}
object {matax01 rotate <0,30,0> translate <40,0,12.5>}
object {matax01 rotate <0,30,0> translate <47,0,15.5>}

object {matax01 rotate <0,30,0> translate <-20,0,15.5>}
object {matax01 rotate <0,30,0> translate <-40,0,35>}
object {matax01 rotate <0,30,0> translate <-48,0,32.5>}
object {matax01 rotate <0,30,0> translate <-55,0,35>}

object {matax01 rotate <0,30,0> translate <-120,0,35>}
object {matax01 rotate <0,30,0> translate <-128,0,32.5>}
object {matax01 rotate <0,30,0> translate <-135,0,35>}
object {matax01 rotate <0,30,0> translate <-140,0,35>}
object {matax01 rotate <0,30,0> translate <-147,0,32.5>}
object {matax01 rotate <0,30,0> translate <-153,0,35>}

//las mujeres | the women

#include "mujer01.inc"

//mujer sentada | woman sitting

object {mujer01 rotate <0,-21,0> translate <-59,0,-0.5>}

//mujer caminando | woman walking

object {mujer02 rotate <0,-110,0> translate <-118,0.5,15>}

//mujer de rodillas en la orilla | woman on her knees
object {mujer03 rotate <0,65,0> translate <30,0.5,5.5>}

//mujer de pie cerca del Mohan | woman standing near Mohan

object {mujer04 rotate <0,-85,0> translate <-19,0,-7.5>}

//mujer jugueteando rodeada de mariposas | woman running surounded by butterflies

object {mujer05 rotate <0,55,0> translate <15,0.5,20>}

//la canoa | canoe

#include "canoa01.inc"

object {canoa01 rotate <0,95,0> translate <45,1,-10>}

//las mariposas | butterflies

#include "bichos01.inc"

//alrededor de la mujer que corre | around the runnig woman

object {mariposax01 rotate <-60,30,0> translate <13,15,14>}
object {mariposax01 rotate <-50,10,0> translate <13,19,10>}
object {mariposax01 rotate <-20,150,0> translate <13,10,17>}
object {mariposax02 rotate <-30,-30,0> translate <13,7,11>}
object {mariposax01 rotate <-10,-70,0> translate <13,11,13>}
object {mariposax01 rotate <-30,30,0> translate <17,13,8>}
object {mariposax02 rotate <-50,70,0> translate <17,17,10>}
object {mariposax01 rotate <-40,150,0> translate <17,12,7>}
object {mariposax01 rotate <-10,-30,0> translate <17,8,9>}
object {mariposax02 rotate <-60,-70,0> translate <17,14,11>}
object {mariposax01 rotate <-30,30,0> translate <14.5,12,15>}
object {mariposax01 rotate <-10,70,0> translate <14.5,16,15>}
object {mariposax01 rotate <-50,150,0> translate <14.5,14,15>}
object {mariposax02 rotate <-60,-30,0> translate <14.5,6,15>}
object {mariposax01 rotate <-10,-70,0> translate <14.5,4,15>}

//frente a la mujer del canasto | in front of the nearest standing woman

object {mariposax02 rotate <-40,-70,0> translate <-13.5,12,-15>}
object {mariposax01 rotate <-40,-70,0> translate <-13.5,16,-14>}

//frente a la mujer del fondo | in front of the background walking woman

object {mariposax01 rotate <-70,-70,0> translate <-45,14,-15>}
object {mariposax01 rotate <-60,-70,0> translate <-42,13,-14>}

//frente a la mujer de la orilla cercana | in front of the woman who's on her knees

object {mariposax02 rotate <-60,70,0> translate <28.5,6.5,-5>}
object {mariposax01 rotate <-60,50,0> translate <28.5,8.5,-7>}

//en la zona que es solo agua | over the water

object {mariposax02 rotate <-60,-60,0> translate <-18.5,6.5,-25>}
object {mariposax01 rotate <-50,70,0> translate <-15,5,-18>}
object {mariposax02 rotate <-60,-80,0> translate <-10.5,3.5,-21>}
object {mariposax01 rotate <-70,-20,0> translate <3,6.5,-27.5>}
object {mariposax02 rotate <-60,-10,0> translate <-5,3.5,-29>}
object {mariposax01 rotate <-80,-30,0> translate <-10,5,-31>}





