// ======================================
// Example of use of the Makegrass macro
// Gilles Tran - March 1999
// --------------------------------------
// Long grass, yellowish
// --------------------------------------
#version unofficial MegaPOV 0.5;
#include "colors.inc"
//#include "mgrass.pov"

#declare PdV=<0,3,-3>;
#declare PdA=<0,0,5>;
/*camera{location PdV direction 2*z up y sky y right x*4/3  look_at PdA}

light_source{0 White translate <-200, 400, -300>}
light_source{PdA White*0.25 shadowless}*/

#declare Blanc1=rgb<0.90,0.81,0.81>;

#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------  
#include "groundtex.inc"
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
//#declare pigSpotted=pigment{Red}
//#declare pigEarth=pigment{Blue}
#declare GrassPattern=              

  pigment{
    bozo  
    quick_color rgb<.65,.68,.12>
    color_map{
      [0 color rgb<.65,.68,.12>]
      [.5 color <.65,.68,.12>]
      [1 color rgb<.21,.42,.07>]
    }
    scale .05*z
    rotate 30*y
    scale 40
  }

#declare txtGrass=
texture{
  pigment{
    gradient y
    pigment_map{
      [0 pigEarth]
      [0.25 GrassPattern]
      [1 GrassPattern]
    }
  }

  finish{ambient 0.0 diffuse 1.2}// specular 0.2 roughness 0.015}
  scale <0.001,1,0.001>
 
} 
// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=2;               // size of patch
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare nBlade=10;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 5;            // number of blade segments
#declare lBlade = 1;             // length of blade
#declare wBlade = 1/25;              // width of blade at start
#declare wBladeEnd = 0.3/25;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,-0.5,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 3;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale;
#declare stdBend = 2;            // standard deviation of blade bending;
#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass1.inc"     // name of the mesh file to create

//Create first patch and prarie
#if (dofile=true) // if the patch is already created, turn off the next line
        //MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end
        
#declare nxPrairie=25;             // number of patches for the first line
#declare addPatches=0;            // number of patches to add at each line
#declare nzPrairie=12;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

/*object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
texture{txtGrass scale 40}
translate <-45,-.62,-10>
}*/

union{
#local zCount=0;
#local nxCounttmp=nxPrairie;
#while (zCount<nzPrairie)                            
        #local xCount=0;
        
        #while (xCount<nxCounttmp)
          #declare patch_pos=<xCount-(nxCounttmp-1)*0.5,0,zCount>*lPatch;
                
                #if (doTest=true)
//                        sphere{<-nxCounttmp*0.5+xCount,0,zCount>*lPatch,lPatch*0.5 pigment{Red} scale <1,0.2,1>}
                      
                        sphere{0,lPatch*0.5 pigment{Red} scale <1,0.2,1>
                        scale eval_pattern(bozo,)*.5+.5 
                        rotate y*360*(0.5-rand(rd))*stdrotate 
                        translate <xCount-(nxCounttmp-1)*0.5,0,zCount>*lPatch}
                #else
                        object{
                          objectPatch 
                          scale <1,int(eval_pattern(bozo,patch_pos/10)*2)*.5+.5,1>
                          rotate y*360*(0.5-rand(rd))*stdrotate 
                          translate patch_pos
                        }
                #end
                #local xCount=xCount+1;
        #end
        #local nxCounttmp=nxCounttmp+addPatches;
        #local zCount=zCount+1;
#end
texture{txtGrass}
translate <-55,-.62,-10>
}



//Second patch
#declare lPatch=2;               // size of patch
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare nBlade=10;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 5;            // number of blade segments
#declare lBlade = .1;             // length of blade
#declare wBlade = 1/250;              // width of blade at start
#declare wBladeEnd = 0.3/250;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,-0.5,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 3;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale;
#declare stdBend = 2;            // standard deviation of blade bending;
#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass2.inc"     // name of the mesh file to create

// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=20;             // number of patches for the first line
#declare addPatches=0;            // number of patches to add at each line
#declare nzPrairie=12;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere
/*
// --------------------------------------
// Create second patch and prarie
// --------------------------------------
#if (dofile=true) // if the patch is already created, turn off the next line
        //MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        



#declare nxPrairie=25;             // number of patches for the first line
#declare addPatches=0;            // number of patches to add at each line
#declare nzPrairie=12;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
translate <5,-.62,-10>
texture{Grass}
}

  

//cylinder{0,y*30,5 texture{txtGrass scale 40}}
//plane{y,0 pigment{Tan*0.3}}
//background{rgb<0.5,0.7,1>*2}
*/
