#include "mgrass.pov"
#include "myprarie.pov"

   
#declare doSmooth = true;       // smooth triangles                           
#declare posBlade = <0,0,0>;    // position of blade
#declare rotBlade = 100;        // rotation of blade around y
#declare segBlade= 10;          // number of blade segments - try low values (5 for instance) for tests
#declare lBlade = .1;             // length of blade
#declare xBladeStart = 0.005;       // width of blade at start
#declare xBladeEnd = 0.0015;       // width of blade at the end
#declare zBladeStart = 0.0125;     // depth of blade fold at start
#declare startBend = <0,1,0>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <1,0,0>;      // force bending the blade (<0,1,1> = 45)
#declare pwBend = 1;           // bending power (how slowly the curve bends)
#declare dofold = false;        // true creates a fold in the blade (twice more triangles)
#declare dofile = false;        // true creates a mesh file


/*object{
  objectPatch
  translate <4,-.615772,0>
  texture{txtGrass}
  no_shadow
}*/

#declare txtGrass=texture {                  
                pigment{GrassPig translate -3*z}
                /*pigment {
                        gradient y
                        turbulence 0.2
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.3 pigGreen]
                                    [0.9 pigSpotted]
                                    [1.00 pigEarth]
                                }
                        }*/

        finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
        //scale <0.001,1,0.001>
 
} 


#declare nBlade=8;                // number of blades per line (there will be nBlade x nBlade blades)
#declare stdrotBlade=2;
#declare s1=seed(125);


#declare i=1;

#declare objectPatch=
mesh{
  #while(i<=nBlade)
    #declare rotBlade=360*i/nBlade;
    #declare rotBlade=rotBlade+(0.5-rand(s1))*stdrotBlade;
    #declare posBlade=vrotate(.02*x,rotBlade);
    MakeBlade(doSmooth,posBlade,rotBlade,segBlade,lBlade,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
    #declare i=i+1;
  #end
  #declare lBlade=.07;
  #declare i=1;
  #while(i<=nBlade)
    #declare rotBlade=360*i/nBlade;
    #declare rotBlade=rotBlade+(0.5-rand(s1))*stdrotBlade;
    #declare posBlade=vrotate(.05*x,rotBlade);
    MakeBlade(doSmooth,posBlade,rotBlade,segBlade,lBlade,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
    #declare i=i+1;
  #end
}

// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=6;             // number of patches for the first line
#declare addPatches=1;            // number of patches to add at each line
#declare nzPrairie=24;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=90;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere
#declare lPatch=.5;
#declare pos_turb=2;

object{MyPrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,pos_turb,doTest)
rotate -90*y
translate <7,-.615772,0>
texture{txtGrass scale 40}
}