// POVLAB version 4.00 SP4 - Included texture file.
// (C) 1994-1998, Denis Olivier.
// All rights reserved.
// Generated for POV-Ray (C) POV-Team, USA.
// Date=Tuesday 07-18-2000.
// Time=08:19:02.
// user_name=JOHN HAIDUCEK
// From=C:\PROGRA~1\POVLAB\TEXTURE\POVLAB.INC
// For=C:\PROGRA~1\POVLAB\SCENE\LIGHTHOU.SCN
// Textures found=6

#include "colors.inc"
#include "skies.inc"

#version unofficial MegaPOV 0.5; 

#declare Sand=
pigment{
  crackle  
  quick_color Tan 
  scallop_wave
  color_map{
    [0 color Tan*.5]
    [1 color Tan]
  }
  scale .005     //scale it small so it's grainy.
}

#declare GreenGrass=
pigment{
  granite  
  quick_color rgb<.27,.55,.10>
  color_map{
    [0 color rgb<.27,.5,.10>]
    [1 color rgb<.27,.5,.10>*.05]
  }
  scale .05*z
  rotate 30*y
}

#declare DarkGreenGrass=
pigment{
  granite  
  quick_color rgb<.31,.42,.07>
  color_map{
    [0 color rgb<.31,.42,.07>*.5]
    [1 color rgb<.31,.42,.07>*.025]
  }
  scale .05*z
  rotate 30*y
}


#declare YellowGrass=
pigment{
  granite  
  quick_color rgb<.65,.68,.12>
  color_map{
    [0 color rgb<.68,.68,.12>]
    [1 color rgb<.68,.68,.12>*.05]
  }
  scale .05*z
  rotate 30*y
}



#declare Grass=
  pigment{
    bozo
    pigment_map{
      [0.0 YellowGrass scale .2]   
      //[0.7 GreenGrass scale .2]
      [1.0 DarkGreenGrass scale .2]
    }
    scale 4
    translate <7,0,-3>
  }

#declare SparseGrass=  //weeds or clumps of grass
pigment{
  granite
  pigment_map{
    [0 Sand]
    [0.2 Sand]
    [0.4 Grass]
    [1 Grass]
  }
}       

#declare sparse_scale=.1;

#declare SparseGrass2=  //weeds or clumps of grass
pigment{
  granite
  pigment_map{
    [0 Sand scale 1/sparse_scale]
    [0.1 Sand scale 1/sparse_scale]
    [0.3 Grass scale 1/sparse_scale]
    [1 Grass scale 1/sparse_scale]
  }
  scale sparse_scale
}

#declare grasstex=
texture{pigment{SparseGrass2}}
/*texture{
  pigment{
    granite
    pigment_map{
      [0 rgbt 1]
      [0.3 rgbt 1]
      [0.5 Sand]
      [0.7 rgbt 1]
      [1 rgbt 1]
    }
    scale 5
  }
}*/

#declare GrassPig=
pigment{
  bozo
  color_map{
    [0.0  rgb<.65,.71,.12>*.8]   
    [1.0  rgb<.21,.42,.07>*.4]
  }
  scale 4
  translate 7*x
}



#declare Dirt=
pigment{
  crackle  
  quick_color Tan 
  scallop_wave
  color_map{
    [0 color Tan*.1]
    [1 color Tan*.8]
  }
  scale .005     //scale it small so it's grainy.
}


#declare Leaves= //dead leaves for under trees
pigment{
  granite
  color_map{
    [0.0 rgbf 1]
    [0.1 rgbf 1]
    [0.5 rgb <158/255,126/255,18/255>*.5 filter .1]
    [1.0 rgb <184/255,175/255,14/255>*.3 filter .1]
  }
  scale .1
  ramp_wave
  frequency 3
}


#declare Scratches_Scale=<1,1,.15>*.5;

#declare Scratches1=
pigment{
  bozo
  pigment_map{
    [0 Dirt scale 1/Scratches_Scale]
    [0.4 Dirt scale 1/Scratches_Scale]
    [0.45 Tan*.5 transmit 1]
    [1 Tan*.5 transmit 1]
  }
  scale Scratches_Scale
  //turbulence <.25,2,.25>
  //rotate 45*y
} 

#declare Scratches2=
pigment{
  bozo
  pigment_map{
    [0 Dirt scale 1/Scratches_Scale]
    [0.2 Dirt scale 1/Scratches_Scale]
    [0.25 Tan*.5 transmit 1]
    [1 Tan*.5 transmit 1]
  }
  scale Scratches_Scale
  //turbulence <.25,2,.25>
  //rotate 45*y
}

#declare FireScale=2; 


#declare Fire=
  pigment{
    cylindrical
    color_map{
      [0 rgb <1,.5,0> transmit 1]
      [.8 rgb <1,1,0> transmit 1]
      [.89 rgb <1,.5,0> transmit .5]
      [.9  rgb <1,0,0> transmit .5]
      [.91 rgb <1,.5,0> transmit .5]
      [.96 rgb <1,1,0> transmit 1]
      [.97 rgb <1,.5,0> transmit .5]
      [.98 rgb <1,.5,0> transmit .5]
      [1 rgb <1,0,0> transmit .5]
    }
    triangle_wave
    scale 7
    phase .35
    warp{turbulence 1 lambda 4 omega 1}
  }
  
#declare ash=
pigment{
  granite
  color_map{
    [0 rgb .25]
    [.5 rgb .1]
    [.75 rgb 0 transmit 1]
    [1 rgb 0 transmit 1]
  }
  scale .25
}

#declare ashring= 
  pigment{
    cylindrical
    pigment_map{
      [0 rgbt 1]
      [.6 rgb 0 transmit 1]
      [.9 ash]
      [1 ash]
    }
    triangle_wave
    scale 7
    phase .3
    warp{turbulence 1 lambda 3 omega .6}
  }


/*#declare Scratches=
pigment{
  bozo
  pigment_map{
    [0 Dirt scale 1/Scratches_Scale]
    [0.1 Dirt scale 1/Scratches_Scale]
    [0.15 rgbt 1]
    [1 rgbt 1]
  }
  scale Scratches_Scale
  //turbulence <.25,2,.25>
  //rotate 45*y
}*/

#declare ashpatch=
texture{
  pigment{
    cylindrical
    pigment_map{
      [0 rgb 0 transmit 1]
      [.5 ash]
      [1 ash]
    }
  }
  warp{turbulence .7}
  scale 4
}

#declare grass_fire=
  pigment{
    bozo
    color_map{
      //[0 rgb <1,.5,0> transmit 1]
      [0 rgb <1,1,0> transmit 1]
      [.55 rgb <1,.5,0> transmit .5]
      [.6  rgb <1,0,0> transmit .5]
      [.7 rgb <1,.5,0> transmit .5]
      [.8 rgb <1,1,0> transmit 1]
      [.85 rgb <1,.5,0> transmit .5]
      [.94 rgb <1,.5,0> transmit .5]
      [1 rgb <1,0,0> transmit .5]
    }
    triangle_wave
    scale 7
    warp{turbulence 1 lambda 4 omega 1}
    scale .05
  }

#declare fire_ring=
texture{
  pigment{
    cylindrical
    pigment_map{
      [0 rgbt <1,.5,0,1>]
      [.6 rgbt <1,.5,0,1>]
      [.73 grass_fire]
      [.75 rgbt <1,.5,0,1>]
      [1 rgbt <1,.5,0,1>]
    }
    scale 2
    warp{turbulence .7}
    scale 4
  }
  finish{diffuse 0 ambient 1}
}


#declare Fire_etc= //flat part of ground
texture{
  pigment{
    cylindrical
    pigment_map{
      [0 Tan*.5 transmit 1]
      [.3 Tan*.5 transmit 1]
      [.5 Scratches2 scale .2]
      [.7 Scratches1 scale .2]
      [1 Scratches1 scale .2] 
    }      
    warp{turbulence .2}
    scale 5
  }
}
texture{
  pigment{
    bozo
    pigment_map{
      [0 rgbt <0,0,0,1>]
      [.6 rgbt <0,0,0,1>]
      [.75 ashring scale 1/FireScale]
      [1 ashring scale 1/FireScale]
    }
    scale FireScale
  }
}
/*texture{
  pigment{
    bozo
    pigment_map{
      [0 rgbt <1,.5,0,1>]
      [.6 rgbt <1,.5,0,1>]
      [.85 Fire scale 1/FireScale]
      [1 Fire scale 1/FireScale]
    }
    scale FireScale
  }
}*/
texture{
  pigment{
    bozo
    pigment_map{
      [0 rgbt <1,.5,0,1>]
      [.6 rgbt <1,.5,0,1>]
      //[.6 Fire scale 1/FireScale]
      [.73 Fire scale 1/FireScale]
      [.75 rgbt <1,.5,0,1>]
      [1 rgbt <1,.5,0,1>]
    }
    scale FireScale
  }
  finish{diffuse 0 ambient 1}
}
texture{ //bare area around burning barn
  pigment{
    cylindrical
    pigment_map{
      [0 rgb <.65,.71,.12> transmit 1]
      [0.5 SparseGrass ]
      [0.7 SparseGrass]
      [.9 Sand]
      [1 Sand]
    }                     
    scale 5
    warp{turbulence 1}
    scale 1/5
    translate <-.05,-1,0>
    scale <50,1,25>             
    translate <-70,-.62,40>
  }  
}
texture{
  ashpatch
  translate <-35,-.62,20>
}
texture{fire_ring
  translate <-35,-.62,20>
}
texture{
  ashpatch
  translate <-15,-.62,5>
  finish{ambient .6}
}
texture{fire_ring
  translate <-15,-.62,5>
  finish{ambient .8}
}

  
/*texture{   // leaves under trees
  pigment{
    pigment_map{
      [0 transmit 1]
      [0.467 Leaves]
      [1 Leaves]
    }
    translate -.5
    scale 16     
    rotate 90*x
  }
}*/

