/*******************************************************
    POV-Ray - BlobMan People Costume Definition File
 File Name : croft.cdf
 BM_Version: 4.0
 Desciption: Costume Definition File - Lara ?
 Date      : April 2000
 Author    : Peter Houston 
 Email     : houston.graphics@iname.com 
 WWW       : http://welcome.to/HoustoGraphics 

Notes :
    This CDF only works for Female Figures.
    
    This CDF includes a hair setting.  To test render
    scenes without hair enter the following code
    after the CDF is included
    
        #decalre BM_HairStyle=0;
    
    Then just remove it when you want the hair.
    
    The Boots do not sit on y0 so if you transform
    the figure using the Foot or Toe Origins you will need 
    to add the following translation after the 
    transformation
    
        translate <0,1.0>*BM_Scale 
    
    The Toes of the Boot will bend to match the Toe Angle
    however you need to specify the Toe Angle before the 
    CDF is called, even if you are using arrays.
    
        #declare BM_Toe_Angle=<0,0,0>;
    
********************************************************/
#include "bm_hair.inc"

/********************************************************
  Image Maps & Textures
********************************************************/
#declare BM_Skin_Tex=
    texture {
        pigment{rgb <0.96,0.80,0.69>}
    }                         
#declare BM_Lip_Tex   = texture {pigment {rgb x*.75}}
//#declare BM_Nail_Tex  = texture {pigment {rgb <.2,.5,.5>} finish {phong 1}}                         
//#declare BM_Eye_Shadow= texture {pigment {rgb <.2,.5,.5>}}
#declare BM_Map_Normal = normal {wrinkles 0.15 scale <.5,10,.5>}

#include "glass.inc" 

#declare BuckleTex = texture {
  pigment {
    rgb <0.70, 0.56, 0.37> 
  }
  finish {
    metallic
    ambient 0.1
    diffuse 0.65
    specular 0.85
    roughness 0.01
    reflection 0.45
    brilliance 1.5
  }
}

#declare SockTex=
    texture {
        pigment {rgb 1}
        normal {quilted .5 scale .1}
    }

#declare BootTex= texture {
    pigment {rgb .05}
    finish {phong .5 reflection .1}
}
 
#declare SoleTex= texture {
    pigment {rgb .15 }
    normal {ripples 1 scale .5}
    
} 

#declare LaceTex=texture {pigment {rgb <0.556863, 0.137255, 0.137255>}
                          normal {quilted 1 scale .1 rotate z*45}
                 }

#declare SpecFrames = texture {
  pigment {
    rgb <0.2, 0.2, 0.2> 
  }
  finish {
    ambient 0.1
    diffuse 0.7
    brilliance 6.0
    reflection 0.2
    phong 0.8
    phong_size 120
  }
}

#declare BagTex=texture {pigment {rgb <0.35, 0.20, 0.1>}
                    normal {quilted .5 scale .05 rotate z*45}
                }    

#declare Torso_IMap      = "croft1.png"
#declare Abdomen_IMap    = "croft2.png"
#declare Thigh_R_IMap    = "wiz3.png"
#declare Thigh_L_IMap    = "wiz3.png"
#declare Calf_R_IMap     = "wiz4.png"
#declare Calf_L_IMap     = "wiz4.png"
#declare Foot_R_IMap     = "croft5.png"
#declare Foot_L_IMap     = "croft5.png"  
#declare Forearm_R_IMap  ="wiz5.png"
#declare Forearm_L_IMap  ="wiz5.png"
#declare Upperarm_L_IMap  ="wiz5.png"
#declare Upperarm_R_IMap  ="wiz5.png"

/********************************************************
  Body Part Options
********************************************************/

#declare BM_EyeCol=<.25,.25,0>
#declare BM_Hair_Col=<0.35, 0.20, 0.1>;
#declare BM_HairStyle=2;
#declare BM_Map_R_Finger=0;
#declare BM_Map_L_Finger=0;
#declare BM_TShirt=1;


/********************************************************
  Body Part Objects
********************************************************/

//#declare BM_Head_Object= object{BM_Head_Object}
//#declare BM_Neck_Object=object {BM_Neck_Object}
                                                 
/*#declare BM_Torso_Object= object{BM_Torso_Object}*/
#declare BM_Abdomen_Object=union {
                                object{BM_Abdomen_Object}
                                /*cone {<0,0,0>,5.3,<0,-2,0>5.5
                                    scale <1.1,1,.8>
                                    translate <0,-23.25,-.5>
                                    pigment { rgb <0.25, 0.10, 0.0> }
                                }
                                
                                difference {
                                    box {<-1.5,-1.5,0><1.5,1.5,.5>
                                         translate <0,-24.25,-5>
                                    texture {BuckleTex}
                                    }           
                                    box {<-1,-1,0><1,1,.25>
                                         translate <0,-24.25,-5>
                                    texture {BuckleTex
                                        finish {ambient -.15}}
                                    }          
                                }
                                box {<-.5,0,0><.5,-4,1>
                                     rotate x*-5
                                     translate <0,-24.25,-4.6>
                                }*/
                           }
//#declare BM_Upperarm_R_Object=object {BM_Upperarm_R_Object}
//#declare BM_Upperarm_L_Object=object {BM_Upperarm_L_Object}
//#declare BM_Forearm_R_Object=object {BM_Forearm_R_Object}
//#declare BM_Forearm_L_Object=object {BM_Forearm_L_Object}
//#declare BM_Hand_R_Object=object {BM_Hand_R_Object}
//#declare BM_Hand_L_Object=object {BM_Hand_L_Object}

#declare BM_Thigh_R_Object= object {BM_Thigh_R_Object}
                   
#declare BM_Thigh_L_Object= object {BM_Thigh_L_Object}
           

#declare BM_Calf_R_Object=object {BM_Calf_R_Object}
 
//declare BM_Calf_L_Object= object {BM_Calf_L_Object}

#declare BM_Calf_L_Object= object {BM_Calf_L_Object}
                            
#declare BM_Foot_R_Object=union {
                                object {BM_Foot_R_Object}
                                difference {    
                                    union { // Sole
                                        cylinder {<0,0,0><0,-.75,0> 2.2 
                                                   translate <0,-2.5,0>
                                        }
                                        cylinder {<0,0,0><0,-.75,0> 2.9 
                                                   rotate x*BM_Toe_Angle.z
                                                   translate <-.3,-2.5,-5.7> 
                                                    
                                                    clipped_by {plane {z,-5.7}}
                                        }                              
                                        prism {   linear_sweep   linear_spline 
                                            0,-0.75,5,        
                                          <-2,0>,<2,0>,<2.5,-5.7>,<-3.4,-5.7>,<-2,0>
                                          translate <0,-2.5,0>
                                        }
                                   }        
                                   box {<-4,-8,0><4,0,-8>
                                        rotate x*-14
                                        rotate y*8
                                        translate <0,-2.6,-2>
                                   }
                                   texture {SoleTex}
                               }      
                               union { //Uppers
                                    union {sphere {<0,.5,0>,2.6}
                                           cylinder {<0,.5,0><0,0,0>2.6}
                                        
                                            clipped_by {plane{y,0 inverse}}
                                            clipped_by {plane {z,0 rotate x*45}}                                            
                                            rotate x*BM_Toe_Angle.z 
                                            translate <-.3,-2.5,-5.7>
                                            
                                    }
                                    
                                    cone {<0,0,0>1.75,<0,-2.5,0>1.9}
                                    sphere {0,1.75}
                                    cone {<0,-.5,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    cone {<0,-2,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    texture {BootTex}
                               }

                            }
    
                                            
                          
#declare BM_Foot_L_Object=union {
                                object {BM_Foot_R_Object}
                                difference {    
                                    union { // Sole
                                        cylinder {<0,0,0><0,-.75,0> 2.2 
                                                   translate <0,-2.5,0>
                                        }
                                        cylinder {<0,0,0><0,-.75,0> 2.9 
                                                   rotate x*BM_Toe_Angle.z
                                                   translate <-.3,-2.5,-5.7> 
                                                    
                                                    clipped_by {plane {z,-5.7}}
                                        }                              
                                        prism {   linear_sweep   linear_spline 
                                            0,-0.75,5,        
                                          <-2,0>,<2,0>,<2.5,-5.7>,<-3.4,-5.7>,<-2,0>
                                          translate <0,-2.5,0>
                                        }
                                   }        
                                   box {<-4,-8,0><4,0,-8>
                                        rotate x*-14
                                        rotate y*8
                                        translate <0,-2.6,-2>
                                   }
                                   texture {SoleTex}
                               }      
                               union { //Uppers
                                    union {sphere {<0,.5,0>,2.6}
                                           cylinder {<0,.5,0><0,0,0>2.6}
                                        
                                            clipped_by {plane{y,0 inverse}}
                                            clipped_by {plane {z,0 rotate x*45}}                                            
                                            rotate x*BM_Toe_Angle.z 
                                            translate <-.3,-2.5,-5.7>
                                            
                                    }
                                    
                                    cone {<0,0,0>1.75,<0,-2.5,0>1.9}
                                    sphere {0,1.75}
                                    cone {<0,-.5,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    cone {<0,-2,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    texture {BootTex}
                               }
                                scale <-1,1,1>
                            }    
    
// End of Costume Definition File