#version unofficial MegaPov 0.7;

#include "colors.inc"

/*camera {
  location <0, 0, -20>
  look_at <0,0,0>
}
  
light_source { <0, 10, -100> White }
  
background {color Black}*/

#declare CrystalTexture = texture {
  pigment { White filter 1 }
  finish {
    ambient .1
    diffuse .1
    reflection .2
    specular 1
    roughness .001
  }
}

//#declare CrystalTexture = texture {pigment {Blue}}


#declare TopCrystal = prism {
    conic_sweep
    linear_spline
    0,
    1,
    7,
    <1,2>, <-1,2>, <-2,0>, <-1,-2>, <1,-2>, <2,0>, <1,2>
    rotate x*180     
    scale <1, 2, 1>
  }

#declare BottomCrystal = prism {
    linear_sweep
    linear_spline
    0,
    8,
    7,
    <1,2>, <-1,2>, <-2,0>, <-1,-2>, <1,-2>, <2,0>, <1,2>
  }
   
#declare Crystal1 = merge {
  object {TopCrystal translate y*10}
  object {BottomCrystal}
  scale .2
  texture {CrystalTexture}
  interior{
    ior 1.5
    fade_distance 5
    fade_power 1
    caustics 1
  }
}

#declare Crystal2 = merge {
  object {TopCrystal scale <.75, 1, .75> translate y*12}
  object {BottomCrystal scale <.75, 1.25, .75>}
  scale .2
  texture {CrystalTexture}
  interior{
    ior 1.5
    fade_distance 5
    fade_power 1
    caustics 1
  }
}                                           

#declare Crystal3 = merge {
  object {TopCrystal scale <.65, 1, .65> translate y*14}
  object {BottomCrystal scale <.65, 1.5, .65>}
  scale .2
  texture {CrystalTexture}
  interior{
    ior 1.5
    fade_distance 5
    fade_power 1
    caustics 1
  }
}                                

//object {Crystal1}

#declare Angle1 = 0;
#declare Angle2 = 0;
#declare PrismSeed = seed (6524);
#declare PrismSeed2 = seed (95231);
#declare Nest = torus {5, 1
  texture {CrystalTexture}
  interior{
    ior 1.5
    fade_distance 5
    fade_power 1
    caustics 1
  }
} 

#while (Angle1 < 360)
  #while (Angle2 < 360)
    #local RandPrism = int (rand (PrismSeed) * 2.999999);
    #local RandRotX = (rand (PrismSeed2) - 0.5) * 2;
    #local RandRotY = (rand (PrismSeed2) - 0.5) * 2;
    #local RandRotZ = (rand (PrismSeed2) - 0.5) * 2;
    #switch (RandPrism)
      #case (0)
        #declare Crystal = object {Crystal1}
        #declare CrystalRadius = .4;
      #break
      #case (1)
        #declare Crystal = object {Crystal2}
        #declare CrystalRadius = .3;
      #break
      #case (2)
        #declare Crystal = object {Crystal3}
        #declare CrystalRadius = .26;
      #break
    #end
    #declare Nest = union {
      object {Nest}
      object {Crystal
        rotate 60*<RandRotX, RandRotY, RandRotZ>
        translate y*1
        rotate x*Angle2
        translate z*5
        rotate y*Angle1
      }
    }    
    #local TempAngle = 2 * degrees (asin (CrystalRadius/2));    
    #declare Angle2 = Angle2 + TempAngle;
    //#warning concat("Angle2 = ", str(Angle2,0,0),"\n")
  #end
  #declare Angle2 = 0;
  #declare Angle1 = Angle1 + 15;
  //#warning concat("Angle1 = ", str(Angle1,0,0),"\n")
#end

//object {Nest }//rotate x*-90}
    
#declare Egg = union { // Egg1
  bicubic_patch {
    type 1 flatness 0.0100 u_steps 4 v_steps 4,
    <2.023314, 0.000000, 4.355987>,
    <2.023314, -0.000726, 4.355987>,
    <2.023312, -0.000726, 4.356867>,
    <2.023312, 0.000000, 4.356867>,
    <2.032037, 0.000000, 2.734598>,
    <2.032037, -1.758562, 2.734598>,
    <2.027431, -1.758562, 6.141971>,
    <2.027431, 0.000000, 6.141971>,
    <-1.045672, 0.000000, 3.281572>,
    <-1.045672, -1.758562, 3.281572>,
    <-1.050279, -1.758562, 5.414183>,
    <-1.050279, 0.000000, 5.414183>,
    <-1.044333, 0.000000, 4.341816>,
    <-1.044333, -0.002947, 4.341816>,
    <-1.044341, -0.002947, 4.345389>,
    <-1.044341, 0.000000, 4.345389>
  }
  bicubic_patch {
    type 1 flatness 0.0100 u_steps 4 v_steps 4,
    <2.023312, 0.000000, 4.356867>,
    <2.023312, 0.000726, 4.356867>,
    <2.023314, 0.000726, 4.355987>,
    <2.023314, 0.000000, 4.355987>,
    <2.027431, 0.000000, 6.141971>,
    <2.027431, 1.758562, 6.141971>,
    <2.032037, 1.758562, 2.734598>,
    <2.032037, 0.000000, 2.734598>,
    <-1.050279, 0.000000, 5.414183>,
    <-1.050279, 1.758562, 5.414183>,
    <-1.045672, 1.758562, 3.281572>,
    <-1.045672, 0.000000, 3.281572>,
    <-1.044341, 0.000000, 4.345389>,
    <-1.044341, 0.002947, 4.345389>,
    <-1.044333, 0.002947, 4.341816>,
    <-1.044333, 0.000000, 4.341816>
  }
  translate <-0.5, 0, -4.5>  // centers the egg around the origin
  rotate x*-90
  scale 2
}   

#declare PhoenixEgg = object {Egg
  pigment {
    image_map {
      png "Opal.png"
      once
      interpolate 2
    }
    translate <-.5, -.5, 0>
    scale <8.5,6.5,1>
  }
  finish {
    specular 1
    roughness .001
    ambient .8
    diffuse .1
  }
}