// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//
                                      
#version 3.1;  


#include "colors.inc"
#include "finish.inc" 
#include "metals.inc" 

global_settings{
  assumed_gamma 2.2 
  max_trace_level 60   
}

// ----------------------------------------
camera
{
  location  <-1.25,0.75,-1.05>
  direction 1*z
  right     4/3*x
  look_at   <1.12,.31,.6>
}


light_source{
  0*x // light's position (translated below)
  color White*1.75*.85
  translate <-10, 30, -10>*20000
}  


  
light_source{
  0*x // light's position (translated below)
  color White*0.25*.85
  translate <-1.25,0.75,-1.05>
  shadowless
}    

                   

   
#declare alWater=   
texture {
    pigment { color rgb <0.3,0.5,0.4>*.1 }
    finish { 
      reflection 0.6 
    }
    
    normal{bumps 0.15 scale <12,6,12>*70}
}
 

#declare trees=
 texture{
    pigment{
      bozo
      color_map{
        [0.4 color LimeGreen*.5]
        [0.8 color (LimeGreen*.45) + Yellow*.1]
      }
      scale 1000
    }       
 
    normal{
      bumps .5
      scale<1,.001,1>*3
      translate <0,0,2>
    } 
                      
  }


#declare Asteroid = texture {
  pigment {
    bozo
    turbulence 0.60
    omega 0.80
    lambda 3.00
    color_map {
      [0.00 color rgb <0.51, 0.51, 0.51>]
      [0.5 color rgb <0.51, 0.51, 0.51>]
      [1.00 color White*.25 + SemiSweetChoc]
    }
  }
  normal {
    bumps 1.00
    turbulence 0.60
    octaves 5
    omega 0.65
    lambda 3.00
    scale <0.75, 0.75, 1.00>
  }
  finish {
    ambient 0.2
    specular 0.20 
    crand .15
  } 
}
#declare Asteroid2 = texture {
  pigment {
    bozo
    turbulence 0.60
    omega 0.80
    lambda 3.00
    color_map {   
      [0.00 color rgb <0.51, 0.51, 0.51>]
      [0.3 color White*.25 + SemiSweetChoc]
      [0.9 color White*.25 + SemiSweetChoc]
      [1.0 color rgb <0.51, 0.51, 0.51>]
    }
  }
  normal {
    bumps 1.00
    turbulence 0.60
    octaves 5
    omega 0.65
    lambda 3.00
    scale <0.75, 0.75, 1.00>
  }
  finish {
    ambient 0.2
//    diffuse .5
    specular 0.20 
    crand .15
  } 
}



#declare landscape= 

union{
  height_field{
    tga  
    "fan2.tga"  
    translate<-.5,0,-.5> 
    
    texture {
      gradient y     
      texture_map {
        [0.0 trees scale .00001  ]
        [0.004 trees scale .00001]  
        
        
        [0.015 Asteroid2  scale .1 ]
        [0.10 Asteroid2  scale .1 ]
        [0.25 Asteroid  scale .2 ]
        [1.0  Asteroid scale .2  ]
      }  
    }  
    scale<1,.15,1>*5  
  }   
  box{<-.5,.25,-.5>, <.5,-.01,.5> scale<1,.1,1>*5 texture{Asteroid2}}
} 


#declare R1 = seed(6);
#declare R2 = seed(23);
#declare xx=-5;
#declare zz=-30; 
union{
#while (xx<100)
  #while (zz<100) 
  #if ((xx = 0) & (zz = 0))
  #else
      #switch (rand(R2))
        #range (0.0,0.25)
          object{landscape scale<1,.9+rand(R1),1>  rotate<0,90,0> translate<xx-1.75,-1,zz-1.5>}
        #break
        #range (0.251,0.5)
          object{landscape scale<1,.9+rand(R1),1>  rotate<0,180,0> translate<xx-1.75,-1,zz-1.5>}
        #break
        #range (0.501,0.75)
          object{landscape scale<1,.9+rand(R1),1>  rotate<0,270,0> translate<xx-1.75,-1,zz-1.5>}
        #break
        #range (0.751,1.00)
          object{landscape scale<1,.9+rand(R1),1>  translate<xx-1.75,-1,zz-1.5>}
        #break
        #else
          object{landscape scale<1,.9+rand(R1),1>  translate<xx-1.75,-1,zz-1.5>}
      #end //switch
  #end  
    #declare zz=zz+5;
  #end 
  #declare xx=xx+5;
  #declare zz=-30;
#end  
} 

   
#declare ShangriLa=
  height_field{
    tga "fan2.tga" 
    smooth 
    translate<-.5,0,-.5>
    scale<1,.35,1>*5
  }  
       
#declare ShangriLa2=         
difference{
  intersection{ 
    object{
      difference{
        box{<-.5,0,-.5>, <.5,1,.5> scale<1,.35,1>*5}
        object{ShangriLa translate<0,0,0>  
        }
      }
      inverse
    }  
    box{<-.5,0,-.5>, <.5,1,.5> scale<1,.35,1>*4.9999999 }
   }
                      
   box{<-.5,0,-.5>,<.5,.5,.5> rotate<0,20,0> scale .75 translate<.82,.41,-.67> }  
}   
   
#include "yoda3.inc"  

union{
  object{yoda 
    scale <.01,.01,.0025> rotate<5,17.5+180,0> translate <.95,1,1.487> 
  } 
       
  difference{
    object{ShangriLa}
     box{<-.5,0,-.5>,<.5,.5,.5> scale .45 translate<.8,.41,-.65> }   
  }
     
  texture {
    gradient y     
    texture_map {
        [0.0 alWater scale .00011  ]
        [0.0015 alWater scale .00011]    
        [0.0018 Asteroid2  scale .1 ]
        [0.002 Asteroid2  scale .1 ]
        [0.015 trees scale .00001]  
        [0.025 trees scale .00001]  
        [0.06 Asteroid2  scale .1 ]
        [0.2 Asteroid2  scale .1 ]
        [0.35 Asteroid  scale .2 ]
        [1.0  Asteroid scale .2  ]
    } 
   scale<1,.35,1>*5 
  }  
} 

// the clouds 
// thanks to Jaime Vives Piqueres
// www.ctav.es/jaime
#include "i_stsky.inc"
#declare dark_color= SkyBlue*.5+White*.5;
#declare light_color= White*1.6;


#declare height=8000;
#declare cloud_level=.5;
#declare planes=23; //60
#declare pdist=30;
#declare ppatt=pigment{bumps}
#declare pturb=.9 + .1;
#declare pocta=9;
#declare plamb=3.5+.5;
#declare pomeg=.55;
#declare tdist=30;
#declare sfactor=10000;
#declare dfactor=.8-.4;
#declare border=.1;
#declare fstart=.75-.1; //7
#declare fend=.95;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 5*y
}



sky_sphere{   
  pigment{  Blue*.6+White*.02}
}


fog{
  color rgbft <.6, 0.6,.7,0, 0>*1.3
  fog_type 2
  fog_alt 2.0
  fog_offset -1.5
  distance 13
}  


//  +b8192 +A0.6

#declare r1 = seed(111);
#include "weed.inc" 
#include "F:\Delphi3\Genesis\weed4.inc" 
#include "F:\Delphi3\Genesis\weed3.inc" 

   
#include "firtree.inc" 
#include "bigtree.inc" 
#include "darktree.inc" 


#include "hut.inc"

#include "F:\Delphi3\Genesis\hut2.inc"   
#include "F:\Delphi3\Genesis\bob.inc"
#include "F:\Delphi3\Genesis\leftfrt.inc"  
#include "F:\Delphi3\Genesis\weed2.inc"  
#include "F:\Delphi3\Genesis\bob2.inc"


#include "Trimap.mcr"  
#declare OBJuvPOV_Texture_flats = texture{pigment{OldGold} finish { ambient .2  specular 1 roughness 0.0001 reflection 0.13}}
#declare OBJuvPOV_Texture_step = texture{pigment{White*1.25} finish{crand .04 }}
#declare OBJuvPOV_Texture_alter = texture{pigment{White*.65 + Salmon} finish{ ambient .3 crand .045}}
#declare OBJuvPOV_Texture_roof  = texture{pigment{Salmon*2} finish{ ambient .2  crand .045}}
#declare OBJuvPOV_Texture_taperStep = texture {
                                        pigment{
                                          image_map{
                                            tga "stone2.tga" 
                                            map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                            interpolate 4 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                                            //once
                                          } // image_map
                                        }
                                        scale .9
                                      } 

  #declare theTemple =
  union{
    #include "templex.inc"  
    translate<-17.5,0,0>
    scale 1/110
  }

object{theTemple rotate<0,20,0> translate<.80,.41,-.66>} 

#include "human.inc"  
#declare r2 = seed(11);      
#declare xx=0;
#while (xx<50)      
  object{human scale<1.5,1+.3*rand(r2),1.5> rotate<0,rand(r2),0> translate<.610+ rand(r2)*.085,.41,-.84+ rand(r2)*.065>} 
  object{human scale<1.5,1+.3*rand(r2),1.5> rotate<0,rand(r2),0> translate<.750+ rand(r2)*.085,.41,-.86+ rand(r2)*.065>} 
  #declare xx=xx+1;
#end  
 
#declare r2 = seed(555);      
#declare xx=0;
#while (xx<25)      
  object{human scale<1.5,1+.3*rand(r2),1.5> rotate<0,rand(r2),0> translate<.67+  rand(r2)*.085,.41,-.88+ rand(r2)*.060>} 
  #declare xx=xx+1;
#end


sphere{<.80,.65-.1,-.66> ,.02 pigment{Red}}
#macro xClouds (P1,Rad1,Ran1,E1,F)

		#local Banana = seed(Ran1);
		#local R1 = (rand(Banana) * 360);
		#local R2 = (rand(Banana) * 360);
		#local R3 = (rand(Banana) * 360);
		sphere {<0,0,0>,3 pigment{color<1,1,1,1>}
			interior {
  	  		media {
    	  		emission E1
    			intervals 10
    			samples 2, 20
	      		confidence 0.9999
    	  		variance 1/1000
    	
      			density {
        			spherical
        			poly_wave 0.5
	        		turbulence 1.5
	        		omega .7
    	    		color_map {
        	  		[0.0 color rgb <0,0,0>*F]
          			[0.1 color rgb <0.1,0.11,0.1>*F]
					      [0.2 color rgb <0.2,0.21,0.1>*F]
					      [0.4 color rgb <0.1,0.11,0.1>*F]
					      [0.6 color rgb <0.3,0.2,0.1>*F]
          			[0.9 color rgb <0.2,0.25,0.21>*F]
					      [1.0 color rgb <0.52,0.51,0.5>*F]
    	    		}
    	    		
					    rotate <R1,R2,R3>
	      		}
    			}
  			}
			scale Rad1 / 3
			translate P1
			hollow
		}
#end   
 
#declare  xx=.8;
#declare yy=.68;
#declare zz=-.66;
#declare therad = .02;  
#declare emm = 46;
#declare reps = 0; 
#declare f=1;
                 
#while (reps < 23)   
  xClouds (<xx,yy,zz>,therad,rand(R2)*360 ,emm,f)
  #declare xx=xx*1.01;
  #declare yy=yy+.025*1.20;
  #declare zz=zz*1.005;
  #declare therad=therad+.005*2;
  #declare emm=emm-2;
  #declare f=f-.04347;
  #declare reps=reps+1;
#end  

 