#version 3.1

#include "colors.inc"
#include "snow.inc"
#include "lettresmesh.inc"  

global_settings
{
  assumed_gamma 1.0     
  //max_trace_level 6 
}

// ----------------------------------------
#declare taille_dalle = <50,10,50>;  

#declare vue_scene = 
camera
  {
  location <25, 0, 0>*taille_dalle + 170*y
  angle 40
  look_at <34, 0, 32>*taille_dalle + 170*y   
  }

#declare vue_dalles = 
camera
  {
  location <25, 0, 0>*taille_dalle + 170*y
  angle 40
  look_at <28, 0, 12>*taille_dalle   
  }

#declare vue_avion = 
camera
  {
  location  <-100.0, 6000, -9000>
  direction 1.5*z
  right     4/3*x   
  angle 18
  look_at   <1500.0, 0.0,  1100.0>
  }
 
camera {vue_scene}
 
sky_sphere { 
   pigment {
      gradient y
      color_map {
        [0 color 0.8*MidnightBlue]
        [0.5 color MidnightBlue]
        [0.525 color 0.1*Yellow + 0.3*White + 0.6*MidnightBlue]
        [0.55 color 0.15*Green + 0.15*White + 0.7*MidnightBlue]
        [0.60 color 0.4*Red + 0.15*White + 0.45*MidnightBlue]
        [0.625 color 0.5*Red + 0.5*MidnightBlue]
        [0.65 color 0.4*Red + 0.6*MidnightBlue]
        [0.7 color MidnightBlue]
        [1 color 0.8*MidnightBlue]
         }
      scale 2
      translate -1
      } 
   pigment {
      granite
      color_map {
            [ 0.000  color rgbt < 0, 0, 0, 1> ]
            [ 0.870  color rgbt < 0, 0, 0, 1> ]
            [ 0.870  color rgbt < 1, 1, 0.2, 0.9> ]
            [ 0.880  color rgbt < 1, 1, 0.5, 0.5> ]
            [ 0.890  color rgbt < 1, 1, 0.8, 0.2> ]
            [ 0.890  color rgbt < 0, 0, 0, 1> ]
            [ 1.000  color rgbt < 0, 0, 0, 1> ]
        } 
      scale 0.5  
      turbulence 1
      sine_wave  
      }
   rotate -20*z
   }
  
//LUMIERES  
light_source
{
 <-30000, 30000, -60000>
 color Yellow*0.4  
 area_light <500, 0, 0>, <0, 500, 0>, 3, 3
 adaptive 1
 jitter
 //media_attenuation on
} 

light_source
{
 <+60000, 90000, -30000>
 color 0.2*(White+Yellow)   
 shadowless 
 media_interaction off
} 

light_source
{
 <-30000, 30000, 60000>
 color Red*0.3
 shadowless 
 media_interaction off
}
 
light_source
{
 <+60000, 30000, -30000>
 rgb <0.8,0.8,1>*0.2
 shadowless  
 media_interaction off
} 
      
light_source
{
 <-30000, -30000, 60000>
 color Red*0.1
 shadowless
 media_interaction off
}  
     
light_source
{
 <+60000, -30000, -30000>
 rgb <0.8,0.8,1>*0.1
 shadowless 
 media_interaction off
}       
      
#declare epsilon = 0.01;
 
#macro tiled_floor(floor_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar)  
   
   #local box_item = 
      box { 0, item_size - mortar_size
         texture{T_brick}
         interior{I_brick}
         translate mortar_size/2
         }
         
   #local box_item_hole = 
      box { -epsilon, item_size - mortar_size + epsilon
         translate mortar_size/2
         }      
   union {         
      #local i=0;
      #local j=0;
      #local k=0;           
      difference {         
         box{0,floor_size*item_size - mortar_size/2*y        
            }
         #while (i<floor_size.x)
            #while (j<floor_size.y)
               #while (k<floor_size.z)
                  object { box_item_hole
                     translate <i*(item_size.x), j*(item_size.y), k*(item_size.z)>
                     }
                  #local k=k+1;
               #end  
               #local k=0;
               #local j=j+1;
            #end 
            #local j=0;
            #local i=i+1;
         #end   
         texture{T_mortar}
         interior{I_mortar}
         }   
   
      #local i=0;
      #local j=0;
      #local k=0;  
      #while (i<floor_size.x)
         #while (j<floor_size.y)
            #while (k<floor_size.z)
               object { box_item
                  translate <i*(item_size.x), j*(item_size.y), k*(item_size.z)>
                  }
               #local k=k+1;
            #end  
            #local k=0;
            #local j=j+1;
         #end 
         #local j=0;
         #local i=i+1;
      #end
   }
#end  
 
#macro diag_floor (floor_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar)
   #local cote_carre_circonscrit = max(floor_size.x,floor_size.z); //mesure en carreaux
   #local diagonale_carre_circonscrit = sqrt(2)*cote_carre_circonscrit; //mesure en carreaux
   #local cot_sol_en_diag = int(diagonale_carre_circonscrit)+1; //mesure en carreaux
   #local diag_floor_size = < cot_sol_en_diag, floor_size.y, cot_sol_en_diag>; //mesure en carreaux
   #local diag_floor_real_size = diag_floor_size*item_size; //mesure en cm 
   #local floor_real_size = floor_size*item_size; //mesure en cm  
   #local diag_floor_center =  < diag_floor_real_size.x/2,0,diag_floor_real_size.z/2>;//mesure en cm
   #local floor_center =  < floor_real_size.x/2,0,floor_real_size.z/2>; //mesure en cm
   
   intersection {
      object {
         tiled_floor(diag_floor_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar) 
         translate -diag_floor_center
         rotate 45*y
         }
      box { 0, floor_size*item_size 
         texture { T_mortar }
         interior { I_mortar } 
         translate -floor_center
         }  
      bounded_by { 
         box { 0, floor_size*item_size 
            translate -floor_center
            }
         }
      translate floor_center   
      }
#end   

#macro diag_floor_with_hole (floor_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar)
   #local cote_carre_circonscrit = max(floor_size.x,floor_size.z); //mesure en carreaux
   #local diagonale_carre_circonscrit = sqrt(2)*cote_carre_circonscrit; //mesure en carreaux
   #local cot_sol_en_diag = int(diagonale_carre_circonscrit)+1; //mesure en carreaux
   #local diag_floor_size = < cot_sol_en_diag, floor_size.y, cot_sol_en_diag>; //mesure en carreaux
   #local diag_floor_real_size = diag_floor_size*item_size; //mesure en cm 
   #local floor_real_size = floor_size*item_size; //mesure en cm  
   #local diag_floor_center =  < diag_floor_real_size.x/2,0,diag_floor_real_size.z/2>;//mesure en cm
   #local floor_center =  < floor_real_size.x/2,0,floor_real_size.z/2>; //mesure en cm
   
   intersection { 
      difference {
         object {
            tiled_floor(diag_floor_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar) 
            translate -diag_floor_center
            }                                                                 
         union {   
            box {<-9,-epsilon,6>*item_size, <-4, 1+epsilon, 12>*item_size}
            box {<-9,-epsilon,6>*item_size, <-6, 1+epsilon, 14>*item_size}
            texture { T_snow }
            }
         rotate -45*y
         }
      box { 0, floor_size*item_size 
         texture { T_mortar }
         interior { I_mortar } 
         translate -floor_center
         }  
      bounded_by { 
         box { 0, floor_size*item_size 
            translate -floor_center
            }
         }
      translate floor_center   
      }
#end   

 
#macro floor_with_frame (floor_size, frame_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar) 
   #local floor_in_size = <floor_size.x-2*frame_size, floor_size.y, floor_size.z-2*frame_size>; // en carreaux
   #local floor_real_size = floor_size*item_size; // en cm
   #local floor_in_real_size = floor_in_size*item_size; // en cm
   #local floor_center = <floor_real_size.x/2, 0, floor_real_size.z/2>; // en cm   
   #local floor_in_center = <floor_in_real_size.x/2, 0, floor_in_real_size.z/2>; // en cm   
   
   union {
      difference {
         object{ diag_floor (floor_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar)
            translate -floor_center
            }
         box { -epsilon*y, floor_in_real_size
            texture {T_mortar}
            translate -floor_in_center
            }  
         }   
      object { tiled_floor(floor_in_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar)  
         translate -floor_in_center 
         }
      translate floor_center
      }      
#end

#macro floor_with_frame_with_hole (floor_size, frame_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar) 
   #local floor_in_size = <floor_size.x-2*frame_size, floor_size.y, floor_size.z-2*frame_size>; // en carreaux
   #local floor_real_size = floor_size*item_size; // en cm
   #local floor_in_real_size = floor_in_size*item_size; // en cm
   #local floor_center = <floor_real_size.x/2, 0, floor_real_size.z/2>; // en cm   
   #local floor_in_center = <floor_in_real_size.x/2, 0, floor_in_real_size.z/2>; // en cm   
   
   union {
      difference {
         object{ diag_floor_with_hole (floor_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar)
            translate -floor_center
            }
         box { -epsilon*y, floor_in_real_size
            texture {T_mortar}
            translate -floor_in_center
            }  
         } 
      difference {
         object { tiled_floor(floor_in_size, item_size, mortar_size, T_brick, I_brick, T_mortar, I_mortar)  
            translate -floor_in_center 
            }
         union { 
            box { <-9.5-epsilon,-epsilon,-3.5>*item_size,<-4.5,1+epsilon,1.5>*item_size }
            box { <-9.5-epsilon,-epsilon,-3.5>*item_size,<-5.5,1+epsilon,2.5>*item_size }
            box { <-9.5-epsilon,-epsilon,-3.5>*item_size,<-8.5,1+epsilon,3.5+epsilon>*item_size }     
            texture { T_snow } 
            }
         }
      translate floor_center
      }      
#end

#macro boudin(h,r1)
   union {
      cylinder {
         r1*y, (h-r1)*y, r1
         }
      sphere { 0, r1   
         translate r1*y
         }
      sphere { 0, r1
         translate (h-r1)*y
         }
      }
#end

#macro colonne_fut(h,l, nb_boudins)       
   #local r_boudins = l/nb_boudins/4; 
   #local h_vierge = 3*r_boudins; 
   #local h_boudins = h-2*h_vierge;     
      difference {
         box { 0, <l, h, l>
            translate -l/2*<1,0,1>
            }              
         #local i=0;
         #while (i<nb_boudins)
            object { boudin( h_boudins, r_boudins)
               translate -l/2*<1,0,1> + h_vierge*y + i*4*r_boudins*x
               }
            object { boudin( h_boudins, r_boudins)
               translate -l/2*<1,0,-1> + h_vierge*y - i*4*r_boudins*z
               }
            object { boudin( h_boudins, r_boudins)
               translate -l/2*<-1,0,1> + h_vierge*y - i*4*r_boudins*x
               }
            object { boudin( h_boudins, r_boudins)
               translate  l/2*<1,0,1> + h_vierge*y + i*4*r_boudins*z
               } 
            #local i=i+1; 
         #end  
         } 
#end

#macro colonne (h,l,nb_boudins)
   #local r_boudins = l/nb_boudins/4;
   #local h_chapiteau = l*1.5; 
   #local h_base = l; 
   #local h_fut = h-h_chapiteau-h_base;     
   #local l_fut  =  l-4*r_boudins;
   union {                           
      //base
      difference {
         box { 0,l*<1,0,1> + h_base*y
            translate -l/2*<1,0,1>
            }
         cylinder { -l/2*x, l/2*x, r_boudins
            translate <0,h_base,l/2>
            }  
         cylinder { -l/2*x, l/2*x, r_boudins
            translate <0,h_base,-l/2>
            }  
         cylinder { -l/2*x, l/2*x, r_boudins 
            rotate 90*y
            translate <l/2,h_base,0>
            }  
         cylinder { -l/2*x, l/2*x, r_boudins
            rotate 90*y
            translate <-l/2,h_base,0>
            } 
         }  
      //chapiteau   
      difference {
         box { 0,l*<1,0,1> + h_chapiteau*y
            translate -l/2*<1,0,1>
            }
         cylinder { -l/2*x, l/2*x, r_boudins
            translate <0,0,l/2>
            }  
         cylinder { -l/2*x, l/2*x, r_boudins
            translate <0,0,-l/2>
            }  
         cylinder { -l/2*x, l/2*x, r_boudins 
            rotate 90*y
            translate <l/2,0,0>
            }  
         cylinder { -l/2*x, l/2*x, r_boudins
            rotate 90*y
            translate <-l/2,0,0>
            }  
         translate (h-h_chapiteau)*y   
         }       
      //fut
      object {colonne_fut(h_fut,l_fut, nb_boudins)   
         translate h_base*y
         }        
      translate l/2*<1,0,1>
      }           
#end 
  
#declare poutre = 
difference {
   prism {
      linear_sweep
      linear_spline
      0, // sweep the following shape from here ...
      1, // ... up through here
      7, // the number of points making up the shape ...
      <-1/2,0>, <1/2,0>, <1/2,-1/2>, <1/6,-1>, <-1/6, -1>, <-1/2,-1/2>, <-1/2,0>
      } 
          
   cylinder { -epsilon*y, (1+epsilon)*y, 1/3
      translate <-1/2, 0, -1>
      }          
   cylinder { -epsilon*y, (1+epsilon)*y, 1/3
      translate < 1/2, 0, -1>
      } 
   translate <1/2, 0, 0>   
   }                 

//PLAN NEIGE POUR l'extrieur      
#declare trans_du_trou1 = transform {
   #local floor_real_size = <29,1,17>*taille_dalle; //mesure en cm  
   rotate -45*y
   translate < floor_real_size.x/2,0,floor_real_size.z/2>   
   translate taille_dalle*<23,0,3> 
   }
#declare trans_du_trou2 = transform {
   #local floor_real_size = <29,1,17>*taille_dalle; //mesure en cm  
   translate < floor_real_size.x/2,0,floor_real_size.z/2>   
   translate taille_dalle*<23,0,3> 
   }
      
difference { 
   intersection {
      plane { y, 0 }
      plane { -y, 20 }
      } 
   union {   
      box {<-9, epsilon, 6>*taille_dalle, <-4, 0, 12>*taille_dalle - (20+epsilon)*y}
      box {<-9, epsilon, 6>*taille_dalle, <-6, 0, 14>*taille_dalle - (20+epsilon)*y}
      transform trans_du_trou1
      }
   union { 
      box { <-9.5-epsilon, epsilon, -3.5>*taille_dalle, <-4.5, 0, 1.5>*taille_dalle - (20+epsilon)*y}
      box { <-9.5-epsilon, epsilon, -3.5>*taille_dalle, <-5.5, 0, 2.5>*taille_dalle - (20+epsilon)*y}
      box { <-9.5-epsilon, epsilon, -3.5>*taille_dalle, <-8.5, 0, 3.5>*taille_dalle - (20+epsilon)*y}     
      transform trans_du_trou2
      }
   texture { T_snow}
   }        
   
// PLAN EAU 

plane { y, -epsilon 
   pigment{Clear} 
   normal { wrinkles 0.2 scale <1, 1, 0.3>*50}
   finish {
      ambient 0.2
      diffuse 0.8 
      reflection 0.8
      }   
   interior{
      ior 1.333
      fade_distance 500
      fade_power 2 
      //caustics 1
      }
   }       
// fond de l'eau
plane { y, -10000 
   pigment {DarkTurquoise}
   finish {
      ambient 0.2
      diffuse 0.8
      }   
   }

#declare floor_corner = floor_with_frame(<17,1,17>, 5, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})
#declare floor_x_edge = floor_with_frame(<29,1,17>, 5, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})
#declare floor_x_edge_perce = floor_with_frame_with_hole(<29,1,17>, 5, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})
#declare floor_z_edge = floor_with_frame(<17,1,29>, 5, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})
#declare floor_center = floor_with_frame(<29,1,29>, 5, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})


#declare floor_part1 = tiled_floor(<3,1,75>, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})
#declare floor_part2 = tiled_floor(<17,1,3>, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})
#declare floor_part3 = tiled_floor(<29,1,3>, taille_dalle, 2, texture{T_ice}, interior{I_ice}, texture{T_snow}, interior{ior 1})

//sol des pieces  

union {
   object {floor_corner 
      translate taille_dalle*<3,0,3>
      }
   object {floor_corner 
      translate taille_dalle*<55,0,3>
      }
   object {floor_corner 
      translate taille_dalle*<3,0,55>
      } 
   object {floor_corner 
      translate taille_dalle*<55,0,55>
      }
   object {floor_x_edge_perce 
      translate taille_dalle*<23,0,3>
      }
   object {floor_x_edge 
      translate taille_dalle*<23,0,55>
      }
   object {floor_z_edge 
      translate taille_dalle*<3,0,23>
      } 
   object {floor_z_edge 
      translate taille_dalle*<55,0,23>
      }
   object {floor_center 
      translate taille_dalle*<23,0,23>
      }
   }


//sol sous les colonnes
union {
   object {floor_part1 
      translate 0
      }
   object {floor_part1 
      translate taille_dalle*<20,0,0>
      }
   object {floor_part1 
      translate taille_dalle*<52,0,0>
      }
   object {floor_part1 
      translate taille_dalle*<72,0,0>
      } 
   object {floor_part2 
      translate taille_dalle*<3,0,0>
      }
   object {floor_part2 
      translate taille_dalle*<3,0,20>
      }
   object {floor_part2 
      translate taille_dalle*<3,0,52>
      }
   object {floor_part2 
      translate taille_dalle*<3,0,72>
      } 
   object {floor_part3 
      translate taille_dalle*<23,0,0>
      }
   object {floor_part3 
      translate taille_dalle*<23,0,20>
      }
   object {floor_part3 
      translate taille_dalle*<23,0,52>
      }
   object {floor_part3 
      translate taille_dalle*<23,0,72>
      } 
   object {floor_part2 
      translate taille_dalle*<55,0,0>
      }
   object {floor_part2 
      translate taille_dalle*<55,0,20>
      }
   object {floor_part2 
      translate taille_dalle*<55,0,52>
      }
   object {floor_part2 
      translate taille_dalle*<55,0,72>
      } 
   }
      

#declare colonne_neige = 
object { colonne ( 600, taille_dalle.x, 4) 
   texture { T_snow }  
   }     
   
#declare poutre_neige_z =   
object { poutre 
   rotate -90*x
   scale <50,50,-2*75*taille_dalle.z>
   texture { T_snow }  
   translate 600*y
   }   
#declare poutre_neige_x =      
object { poutre_neige_z 
   rotate 90*y
   translate <0,0,taille_dalle.z>
   }      
   
#declare alignement1 = 
union {
   object { colonne_neige   
      translate taille_dalle*<0,0,0>
      }
   object { colonne_neige   
      translate taille_dalle*<2,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<8,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<14,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<20,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<22,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<28,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<34,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<40,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<46,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<52,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<54,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<60,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<66,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<72,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<74,0,0>
      }    
   }      
   
#declare alignement2 = 
union {
   object { colonne_neige   
      translate taille_dalle*<0,0,0>
      }
   object { colonne_neige   
      translate taille_dalle*<2,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<20,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<22,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<52,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<54,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<72,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<74,0,0>
      }    
   }      

#declare alignement3 = 
union {
   object { colonne_neige   
      translate taille_dalle*<0,0,0>
      }
   object { colonne_neige   
      translate taille_dalle*<2,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<20,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<22,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<34,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<40,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<52,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<54,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<72,0,0>
      }    
   object { colonne_neige   
      translate taille_dalle*<74,0,0>
      }    
   }      
   
// toutes les colonnes 
  
union {
   object { alignement1   
      translate taille_dalle*<0,0,0>
      }
   object { alignement1   
      translate taille_dalle*<0,0,2>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,8>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,14>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,20>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,22>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,28>
      }    
   object { alignement3   
      translate taille_dalle*<0,0,34>
      }    
   object { alignement3   
      translate taille_dalle*<0,0,40>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,46>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,52>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,54>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,60>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,66>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,72>
      } 
   // mur 1   
   object { alignement1   
      translate taille_dalle*<0,0,74>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,80>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,86>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,92>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,98>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,104>
      }   
   // mur 2    
   object { alignement1   
      translate taille_dalle*<0,0,106>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,112>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,118>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,124>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,130>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,136>
      }    
   // mur 3    
   object { alignement1   
      translate taille_dalle*<0,0,138>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,144>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,150>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,156>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,162>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,168>
      }
   // mur 4          
   object { alignement1   
      translate taille_dalle*<0,0,170>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,176>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,182>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,188>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,194>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,200>
      }
   // mur 5          
   object { alignement1   
      translate taille_dalle*<0,0,202>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,208>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,214>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,220>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,226>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,232>
      }
   // mur 6          
   object { alignement1   
      translate taille_dalle*<0,0,234>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,240>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,246>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,252>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,258>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,264>
      }
   // mur 7          
   object { alignement1   
      translate taille_dalle*<0,0,266>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,272>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,278>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,284>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,290>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,296>
      }
   // mur 8          
   object { alignement1   
      translate taille_dalle*<0,0,298>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,304>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,310>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,316>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,322>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,328>
      }
   // mur 9          
   object { alignement1   
      translate taille_dalle*<0,0,330>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,336>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,342>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,348>
      }    
   object { alignement2   
      translate taille_dalle*<0,0,354>
      }    
   object { alignement1   
      translate taille_dalle*<0,0,360>
      }  
   // mur 10  
   }      

// poutres z
union {
   object { poutre_neige_z   
      translate taille_dalle*<0,0,0>
      }
   object { poutre_neige_z   
      translate taille_dalle*<2,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<8,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<14,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<20,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<22,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<28,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<34,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<40,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<46,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<52,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<54,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<60,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<66,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<72,0,0>
      }    
   object { poutre_neige_z   
      translate taille_dalle*<74,0,0>
      }    
   }      

// poutres x
union {
   object { poutre_neige_x   
      translate taille_dalle*<0,0,0>
      }
   object { poutre_neige_x   
      translate taille_dalle*<0,0,2>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,8>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,14>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,20>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,22>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,28>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,34>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,40>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,46>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,52>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,54>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,60>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,66>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,72>
      } 
   // mur 1   
   object { poutre_neige_x   
      translate taille_dalle*<0,0,74>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,80>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,86>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,92>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,98>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,104>
      }   
   // mur 2    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,106>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,112>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,118>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,124>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,130>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,136>
      }    
   // mur 3    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,138>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,144>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,150>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,156>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,162>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,168>
      }
   // mur 4          
   object { poutre_neige_x   
      translate taille_dalle*<0,0,170>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,176>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,182>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,188>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,194>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,200>
      }
   // mur 5          
   object { poutre_neige_x   
      translate taille_dalle*<0,0,202>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,208>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,214>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,220>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,226>
      }    
   object { poutre_neige_x   
      translate taille_dalle*<0,0,232>
      }
   // mur 6          
   }      
       
#declare porte =
union {
   box {-epsilon*z, <3*taille_dalle.x, 400, taille_dalle.z+epsilon>}
   cylinder {<0,0,-epsilon>, <0,0,taille_dalle.z+epsilon>, 3*taille_dalle.x/2
      translate < 3*taille_dalle.x/2, 400, 0>
      }
   }
     
#declare porte_vent = 
merge {
   box {0, <3*taille_dalle.x, 400, taille_dalle.z>}
   cylinder {<0,0,0>, <0,0,taille_dalle.z>, 3*taille_dalle.x/2
      translate < 3*taille_dalle.x/2, 400, 0>
      }
   pigment {rgbf<1,1,1,1>} 
   interior{ 
      media{
         emission 0.4   
         scattering{1, 1 /*rgb<1,1,1>*/ extinction 0.37}  
         density{granite      
            color_map{
               [0.68 rgb <0,0,0>]
               [1.0 rgb <0.9,0.9,1>]
               }        
            scale <20,1,1>  
            scale 50
            frequency 1 
            turbulence 0.8
            }
         }
      } 
   hollow on 
   }
          
#declare mur_x = 
union {
   difference {
      box { <0,0,0>, <73,0,1>*taille_dalle+600*y }
      object{porte
         translate 3*x*taille_dalle
         }
      object{porte
         translate 15*x*taille_dalle
         }
      object{porte
         translate 23*x*taille_dalle
         }
      object{porte
         translate 48*x*taille_dalle
         }
      object{porte
         translate 55*x*taille_dalle
         }
      object{porte
         translate 67*x*taille_dalle
         } 
      texture { T_snow }   
      }
   object{porte_vent
      translate 3*x*taille_dalle
      }
   object{porte_vent
      translate 15*x*taille_dalle
      }
   object{porte_vent
      translate 23*x*taille_dalle
      }
   object{porte_vent
      translate 48*x*taille_dalle
      }
   object{porte_vent
      translate 55*x*taille_dalle
      }
   object{porte_vent
      translate 67*x*taille_dalle
      } 
   } 

// mur sans  portes pour acclerer les calculs    
#declare mur_x1 = 
   difference {
      box { <0,0,0>, <73,0,1>*taille_dalle+600*y }
      object{porte
         translate 3*x*taille_dalle
         }
      object{porte
         translate 15*x*taille_dalle
         }
      object{porte
         translate 23*x*taille_dalle
         }
      object{porte
         translate 48*x*taille_dalle
         }
      object{porte
         translate 55*x*taille_dalle
         }
      object{porte
         translate 67*x*taille_dalle
         } 
      texture { T_snow }   
      }
    
#declare mur_z = 
   object { mur_x
      rotate -90*y 
      translate (taille_dalle.x)*x
      }  
      
//tous les murs
union {
   object { mur_x1 
      translate <1,0,1>*taille_dalle
      }
   object { mur_x 
      translate <1,0,73>*taille_dalle
      }
   object { mur_x1 
      translate <1,0,105>*taille_dalle
      }
   object { mur_x1 
      translate <1,0,137>*taille_dalle
      }
   object { mur_x1 
      translate <1,0,169>*taille_dalle
      }
   object { mur_x1 
      translate <1,0,201>*taille_dalle
      }        
   object { mur_x1 
      translate <1,0,233>*taille_dalle
      }
   object { mur_x1 
      translate <1,0,265>*taille_dalle
      }
   object { mur_x1 
      translate <1,0,297>*taille_dalle
      }
   object { mur_x1 
      translate <1,0,329>*taille_dalle
      }
   object { mur_x   
      translate <1,0,361>*taille_dalle
      }      
   object { mur_z 
      translate <1,0,1>*taille_dalle
      }
   object { mur_z 
      translate <73,0,1>*taille_dalle
      }  
   object { mur_x 
      translate <73,0,73>*taille_dalle
      }
   object { mur_x 
      translate <73,0,105>*taille_dalle
      }
   object { mur_z 
      translate <105,0,73>*taille_dalle
      }              
   }

#declare h_marche = 20;
// marches_trone 
merge {
   box { <1,0,0>*taille_dalle, <6,0,7>*taille_dalle+h_marche*y} 
   box { <0,0,1>*taille_dalle, <7,0,6>*taille_dalle+h_marche*y}
   box { <1,0,0.5>*taille_dalle, <6,0,6.5>*taille_dalle+2*h_marche*y} 
   box { <0.5,0,1>*taille_dalle, <6.5,0,6>*taille_dalle+2*h_marche*y}   
   box { <1,0,1>*taille_dalle, <6,0,6>*taille_dalle+3*h_marche*y}      
   box { <1.5,0,1.5>*taille_dalle, <5.5,0,5.5>*taille_dalle+4*h_marche*y}      
   box { <2,0,2>*taille_dalle, <5,0,5>*taille_dalle+5*h_marche*y}      
   texture { T_snow }
   translate <34,1,34>*taille_dalle
   }

// ETERNITY
object { eternity   
   scale taille_dalle
   translate (taille_dalle.z)*z
   rotate degrees(atan2(2/7,1))*y
   translate <24.5,-0.5,13.5>*taille_dalle
   }
      
//dalle dtache
object {icecube
   scale taille_dalle
   //texture { T_ice }
   interior { I_ice}
   translate <-5.2,-1/2,10.8>*taille_dalle
   transform trans_du_trou1
   }

      
//place du personnage  
#include "queen.inc" 
object{queen
   translate <30,1,17>*taille_dalle
   }
