/*****************************************************************************

      This is the vegetation package for the Genesis Toolkit.
    It is a Povray include file and contains the declaration of
    three different trees, a fern and Grass.    (1998 June, 20)

      To avoid problems with this objects when using fog, make
    shure that your max_trace_level setting is not below 8.
    --->  global_settings{ max_trace_level 8 }

     Object:    Height
                in POV-units:
    ----------+---------------+---------------------------------
     Grantrae   10.0            by Stig Bachmann Nielsen
     Tree1      10.0
     Tree2      10.0
     Fern        0.5
     Grass       0.5
     Corn	 1.0
     Stone	~1.0

    The Grantrae was designed by Stig Bachmann Nielsen.
      <http://www.isa.dknet.dk/~stigbn/ray/raytrace.html>
     
    The Genesis Toolkit is freeware and copyright by Joerg Schrammel
      <http://www.rhein-ruhr.de/~schrammel/index.htm>

*****************************************************************************/



/*****************************************************************************
    T R E E 1
*****************************************************************************/

#declare Trunk = object{
   cone{<0,-10,0>,0.2,<0,10,0>,0}
   texture{
    pigment{ color rgb<0.501, 0.313, 0.184>}
    normal{
     bumps
     bump_size -2
     scale< .02, .1, .02>
    }
   }
   hollow
}
#declare Tann1 = object{
 cone{<0,0,0>,1,<0,1,0>,0 open
  texture{
   pigment{
    image_map{ 
      png "tanne1.png" 
      interpolate 2.0 
      transmit 0 1.0
      filter 236 0.5 
      filter 239 0.5 
    }
    rotate<90,0,0>translate<0.5,0.5,0.5>scale<2,2,2>
   }
  }
 }
 hollow
}

#declare Tree1 = object{
 union{
  object{Trunk scale<1,0.9,1>}
  object{Tann1 scale<1.5,1,1.5>rotate<0,90,0>translate<0,4.5,0>}
  object{Tann1 scale<2,2,2>rotate<0,0,0>translate<0,5,0>}
  object{Tann1 scale<2,2,2>rotate<0,120,0>translate<0,6,0>}
  object{Tann1 scale<2,2,2>rotate<0,180,0>translate<0,7,0>}
  object{Tann1 scale<1.5,1,1.5> rotate<0,90,0>translate<0,8,0>}
 }
}


/*****************************************************************************
    T R E E 2
*****************************************************************************/

#declare Tann2 = object{
  cone{
   <0,0,0>,1,<0,1,0>,0 open
   texture{
    pigment{
     image_map{
      png "tanne2.png"
      map_type 2
      interpolate 2.0
      filter  0 1.0     filter  1 0.9     filter  2 0.8     filter  3 0.7
      filter  4 0.6     filter  5 0.5     filter  6 0.4     filter  7 0.3
      filter  8 0.3     filter  9 0.3     filter 10 0.2     filter 11 0.2
      filter 12 0.2     filter 13 0.1     filter 14 0.1     filter 15 0.0
     }
     scale<1,1,1>
    }
   }
  }
}

#declare Tree2 = union{
 object{Trunk scale<1,0.9,1>}
 object{Tann2 scale<1,7,1>translate<0,2.0,0>}
}



/*****************************************************************************
    F E R N
*****************************************************************************/

#declare FB = triangle{ <-0.125,0,0>,<0,0.5,0>,<0.125,0,0>
 texture{
  pigment{
     image_map{
       png "fern.png"
       interpolate 2.0
       filter 0 1.0
       filter 3 0.5
       filter 8 0.5
     }
     translate<0.5,0,0>
     scale<0.2,0.5,0.5>
  }
 }
 hollow
}

#declare Fern = union{
 object{FB rotate<20,0,0>rotate<0,70,0>}
 object{FB rotate<20,0,0>rotate<0,20,0>}
 object{FB rotate<20,0,0>rotate<0,-50,0>}
 object{FB rotate<50,0,0>rotate<0,170,0>}
 object{FB rotate<50,0,0>rotate<0,120,0>}
 object{FB rotate<50,0,0>rotate<0,-150,0>}
}



/*****************************************************************************
    G R A S S
*****************************************************************************/

#declare Grass = union{
 cone{
   <0,0,0>,0.05,<0,0.5,0>,0.125
   open
   pigment{
     image_map{ png "grass.png" map_type 2 filter 0 1.0 }
      scale<.5,.5,.5>
   }
   hollow
   rotate<0,0,20>
   rotate<0,0,0>
 }
 cone{
   <0,0,0>,0.05,<0,0.5,0>,0.125
   open
   pigment{
     image_map{ png "grass.png" map_type 2 filter 0 1.0 }
      scale<.5,.5,.5>
   }
   hollow
   rotate<0,0,20>
   rotate<0,120,0>
 }
 cone{
   <0,0,0>,0.05,<0,0.5,0>,0.125
   open
   pigment{
     image_map{ png "grass.png" map_type 2 filter 0 1.0 }
      scale<.5,.5,.5>
   }
   hollow
   rotate<0,0,20>
   rotate<0,240,0>
 }
}


/*****************************************************************************
    C O R N
*****************************************************************************/

#declare Corn = cone{
  <0,0,0>,0.1,<0,1,0>,0.25
  open
  pigment{
    image_map{ png "corn.png" map_type 2 filter 0 1.0 }
    scale<1,1,1>
  }
  hollow
}

/*****************************************************************************
    G R A N T R A E  designed by Stig Bachmann Nielsen
*****************************************************************************/

#declare Gran = object{
 cone{<0,0,0>,1,<0,1,0>,0 open
  texture{
   pigment{
    image_map{ png "gran2.png" interpolate 2.0 transmit 0 1.0 }
    rotate<90,0,0>translate<0.5,0.5,0.5>scale<2,2,2>
   }
  }
 }
 hollow
}

#declare Trunk = object{
   cone{<0,-10,0>,0.2,<0,10,0>,0}
   texture{
    pigment{ color rgb<0.501, 0.313, 0.184>}
    normal{
     bumps
     bump_size -2
     scale< .02, .1, .02>
    }
   }
}

#declare Grantrae = object{
 union{
  object{Trunk scale<1,1.03,1>}
  object{Gran scale<2,1.7,2>     rotate<0,120,0> translate <0,1.9,0>}
  object{Gran scale<3.1,2.9,3.1> rotate<0,90,0>  translate <0,2.5,0>}
  object{Gran scale<2.5,2.4,2.5> rotate<0,0,0>   translate <0,4,0>}
  object{Gran scale<2.1,1.9,2.1> rotate<0,120,0> translate <0,5.3  ,0>}
  object{Gran scale<1.7,1.5,1.7> rotate<0,180,0> translate <0,6.5,0>}
  object{Gran scale<1.3,1,1.3>   rotate<0,90,0>  translate <0,8  ,0>}
 }
}



/*****************************************************************************
    S T O N E
*****************************************************************************/

#declare Stone = blob {
  threshold 0.6
  cylinder{<-0.25,0,0.3>,<0.2,0.3,-0.2>,0.42, 0.75}
  cylinder{<-0.25,-0.2,0>,<0.2,0.3,0.2>,0.32, 0.95}
  cylinder{<-0.25,0,0>,<0.25,0,0>,0.4, 0.75}
  texture{
    pigment{color rgb<0.8, 0.8, 0.8>}
    normal{
      bozo
      turbulence 2
      slope_map {
        [0   <0, 1>]
        [0.4 <1, 1>]
        [0.45 <0,0>]
        [0.5 <-1,1>]
        [1   <0,-1>]
      }
      scale<0.7,0.7,0.7>
    }
  }
}

