
global_settings{ max_trace_level 10 }

#version unofficial MegaPov 0.5;

#include "colors.inc"


// ******* Schlafsack ****************************************************
#declare Cloth_Pigment =
pigment {
  marble
  color_map {
        [ 0.00 color rgb < .90 , .68 , .40 > ]
        [ 0.30 color rgb < .90 , .50 , .50 > ]
        [ 0.30 color rgbf < 1.0 , 1.0 , 1.0 , 1.0 > ]
        [ 1.00 color rgbf < 1.0 , 1.0 , 1.0 , 1.0 > ]
  }
  turbulence .6
  
  scale < .2 , .2 , 3 >
}

#declare Cloth_Text = 
texture {
 pigment { color rgbf < .20 , .60 , .20 ,0.7> }
 normal {
   bumps .6
   scale .05
 }
}
texture {
 pigment { Cloth_Pigment rotate < 45 , 0 , 0 > }
 normal {
   bumps .6
   scale .05
 }
}
texture {
  pigment { Cloth_Pigment rotate < -45 , 0 , 0 > turbulence 0.5 }
  normal {
   bumps .6
   scale .05
  }
}


#declare Cloth_Text_II = 
texture {
 pigment { color rgbf < .60 , .20 , .20,0.7 > }
 normal {
   bumps .6
   scale .05
 }
 rotate <0,10,0>
}
texture {
 pigment { Cloth_Pigment rotate < 45 , 0 , 0 > }
 normal {
   bumps .6
   scale .05
 }
}
texture {
  pigment { Cloth_Pigment rotate < -45 , 0 , 0 > }
  normal {
   bumps .6
   scale .05
  }
}
#declare SCHLAFSACK = union {

blob { threshold .65
       cylinder { <-.5,0,0>, <.5,0,0>, .5, 1 
       texture {Cloth_Text scale 0.3}}
       cylinder { <-.5,0,0.2>, <.5,0,0.2>, .5, 1 
       texture {Cloth_Text scale 0.3}}
       cylinder { <-.5,0,-0.2>, <.5,0,-0.2>, .5, 1 
       texture {Cloth_Text scale 0.3}}
       sphere   { <-0.2,0,0> 0.5,1
       texture {Cloth_Text scale 0.5}}
       }
blob { threshold .65
       cylinder { <-0.5,0.2,0.15>, <-0.48,0.2,-0.15>, .5, 1 
       texture {Cloth_Text_II scale 0.3}}
       cylinder { <-0.5,0.2,0.15>, <-0.48,0.2,-0.15>, .5, 1 
       texture {Cloth_Text_II scale 0.3}}
       }
      
}      


// ******* Komplett *******************
#declare GLASS_TEXTURE =
texture
{
  pigment
  {
    color rgbt<0.2,0.6,0.5,0.9>
  }
  finish
  {
    specular 0.25
    phong_size 100
    phong 0.3
    reflection 0.35
  }
}

#declare FLASCHE_AUSSEN=
merge
{
  difference
  {
    cylinder{<0,1.3,0>,<0,2,0>,0.4}
    torus{1.2,1.0 scale <1,1,1> translate y*1.9 }
  }
  difference
  {
    cylinder{<0,0,0>,<0,1,0>,0.5}
    sphere{<0,0,0>,0.2 scale <1,0.9,1>}
  }
  torus{0.2,0.05 scale <1,2,1> translate y*2.0 sturm}
  torus{0.35,0.15 scale <1,1,1> sturm}
  sphere{<0,1,0>,0.5 scale <1,1,1>}
  translate y*0.15
}

#declare FLASCHE_INNEN=
merge
{
  difference
  {
    cylinder{<0,1.3,0>,<0,2,0>,0.4}
    torus{1.2,1.0 scale <1,1,1> translate y*1.9 }
  }
  difference
  {
    cylinder{<0,0,0>,<0,1,0>,0.5}
    sphere{<0,0,0>,0.3 scale <1,0.5,1>}
  }
  cylinder{<0,1,0>,<0,2.5,0>,0.2}
  torus{0.4,0.1 scale <1,0.5,1> sturm}
  sphere{<0,1,0>,0.5 scale <1,1,1>}
  translate y*0.05
}

#declare FLASCHE=
difference
{ 
  object {FLASCHE_AUSSEN}
  object {FLASCHE_INNEN scale<0.6,0.8,0.6>translate y*0.25}
  interior{caustics 0.2 ior 1.45}
  texture{GLASS_TEXTURE}
  scale<0.5,0.75,0.5>
}

// ******* Schuhe   *******************
#declare LEATHER = texture { pigment {
           bozo
           turbulence 0.8
         color_map
         {
             [0.00 color rgb <0.22, 0.1, 0.04> * 5]
             [1.00 color rgb <0.35, 0.1, 0.05> * 5]
         }
       scale .1
     }
       normal {  crackle 0.2
               slope_map {
	        [0 <0,1>]
	        [.05 <1,0>]
	        [.95 <1,0>]
	        [1  <0,-1>]
	     }

            turbulence .2  scale .05 }
            finish { specular 0.45 }
        }

#declare SHOES = union {


cone {<0,0,-0.2> 0.09
      <0,0.3,-0.2> 0.1
      open
      texture {LEATHER}
     }
     
cone {<0,0,0.2> 0.09
      <0,0.3,0.2> 0.1
      open
      texture {LEATHER}
     }

torus {0.1, 0.01
      texture { pigment{Black}
               finish {specular 1 roughness 0.001}}
      translate <0,0.3,-0.2>
      }

torus {0.1, 0.01
      texture { pigment{Black}
               finish {specular 1 roughness 0.001}}
     translate <0,0.3,0.2>}
}
// ******* Komplett *******************

#declare CLOTHING = union {

object {SCHLAFSACK scale <1,0.4,1>}
// object {FLASCHE    scale 0.2 rotate <0,0,10> translate <0.4,0,-0.6>}
object {SHOES scale <0.9,0.9,0.4> translate <0,0,0.5>}


}

// ******* TestRender *******************
/*
camera
{
	location  <0, 1, -2>
	look_at   <0, 0,  0>
}

light_source { <2,20,-20> color red 1  green 1  blue 1}
              

#declare sonnenuntergang1 =
  pigment {
    gradient y
    cubic_wave 
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }


sky_sphere {
  pigment { sonnenuntergang1 }
  translate -0.15*y
}

object {CLOTHING}
*/