#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "13_col.inc"
#include "woods.inc"
#include "sword.inc"
#include "metals.inc"
#include "leafdefs.inc"
#include "splinetree.inc"
#include "glass.inc"  
#include "shapes.inc"

camera{
	location < 0.000, 5.000, -20.000 >
	look_at < 0.000, 0.000, 0.000 >
	angle 40.000
}

#version unofficial MegaPov 0.7;

light_source{<0, 34,-100> rgb .375}

global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	motion_blur 5,0.0500
	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}
}

//patch_obj_00
#declare shield1 =
union{
	bezier_patch {
		4,4
		accuracy 0.01
		<-2.000, 0.977, 0.000> <-1.995, 1.814, -0.211> <-0.838, 0.974, -1.002> <0.024, 0.974, -1.002> 
		<-2.000, 0.977, 0.000> <-2.052, 1.814, -1.353> <-0.865, 0.974, -1.534> <-0.002, 0.974, -1.534> 
		<-2.000, 0.977, 0.000> <-2.052, 1.814, -1.353> <-1.140, 0.517, -2.130> <0.003, 0.517, -2.130> 
		<-2.000, 0.977, 0.000> <-2.057, 0.977, -1.142> <-1.143, 0.000, -2.000> <0.000, 0.000, -2.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-2.000, 0.977, 0.000> <-1.995, 1.814, -0.211> <-0.838, 0.974, -1.002> <0.024, 0.974, -1.002> 
		<-2.000, 0.977, 0.000> <-1.947, 1.814, 0.740> <-0.820, 0.974, -0.630> <0.043, 0.974, -0.630> 
		<-2.000, 0.977, 0.000> <-1.947, 1.814, 0.740> <-0.901, 0.361, -1.120> <0.051, 0.361, -1.120> 
		<-2.000, 0.977, 0.000> <-1.952, 0.977, 0.951> <-0.903, 0.000, -1.029> <0.049, 0.000, -1.029> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, 0.974, -1.002> <0.862, 0.974, -1.002> <1.981, 1.790, -0.205> <1.976, 0.977, 0.000> 
		<0.024, 0.974, -1.002> <0.881, 0.974, -0.630> <2.027, 1.790, 0.708> <2.022, 0.977, 0.913> 
		<0.024, 0.974, -1.002> <0.881, 0.974, -0.630> <0.965, 0.361, -1.120> <0.963, 0.000, -1.029> 
		<0.024, 0.974, -1.002> <0.043, 0.974, -0.630> <0.051, 0.361, -1.120> <0.049, 0.000, -1.029> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, 0.974, -1.002> <0.862, 0.974, -1.002> <1.981, 1.790, -0.205> <1.976, 0.977, 0.000> 
		<0.024, 0.974, -1.002> <0.836, 0.974, -1.534> <1.923, 1.790, -1.340> <1.918, 0.977, -1.136> 
		<0.024, 0.974, -1.002> <0.836, 0.974, -1.534> <1.140, 0.517, -2.130> <1.137, 0.000, -2.000> 
		<0.024, 0.974, -1.002> <-0.002, 0.974, -1.534> <0.003, 0.517, -2.130> <0.000, 0.000, -2.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.976, 0.977, 0.000> <1.965, -0.668, 0.415> <1.697, -3.002, 0.000> <0.000, -3.002, 0.000> 
		<1.976, 0.977, 0.000> <2.011, -0.668, 1.328> <1.758, -3.002, 1.211> <0.061, -3.002, 1.211> 
		<1.976, 0.977, 0.000> <2.011, -0.668, 1.328> <0.956, -1.176, -0.733> <0.042, -1.176, -0.733> 
		<1.976, 0.977, 0.000> <2.022, 0.977, 0.913> <0.963, 0.000, -1.029> <0.049, 0.000, -1.029> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.976, 0.977, 0.000> <1.965, -0.668, 0.415> <1.697, -3.002, 0.000> <0.000, -3.002, 0.000> 
		<1.976, 0.977, 0.000> <1.908, -0.668, -0.721> <1.628, -3.002, -1.376> <-0.069, -3.002, -1.376> 
		<1.976, 0.977, 0.000> <1.908, -0.668, -0.721> <1.129, -1.336, -1.663> <-0.008, -1.336, -1.663> 
		<1.976, 0.977, 0.000> <1.918, 0.977, -1.136> <1.137, 0.000, -2.000> <0.000, 0.000, -2.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, -3.002, 0.000> <-1.701, -3.002, 0.000> <-2.010, -0.673, 0.416> <-2.000, 0.977, 0.000> 
		<0.000, -3.002, 0.000> <-1.770, -3.002, -1.376> <-2.068, -0.673, -0.726> <-2.057, 0.977, -1.142> 
		<0.000, -3.002, 0.000> <-1.770, -3.002, -1.376> <-1.151, -1.336, -1.663> <-1.143, 0.000, -2.000> 
		<0.000, -3.002, 0.000> <-0.069, -3.002, -1.376> <-0.008, -1.336, -1.663> <0.000, 0.000, -2.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, -3.002, 0.000> <-1.701, -3.002, 0.000> <-2.010, -0.673, 0.416> <-2.000, 0.977, 0.000> 
		<0.000, -3.002, 0.000> <-1.640, -3.002, 1.211> <-1.962, -0.673, 1.366> <-1.952, 0.977, 0.951> 
		<0.000, -3.002, 0.000> <-1.640, -3.002, 1.211> <-0.910, -1.176, -0.733> <-0.903, 0.000, -1.029> 
		<0.000, -3.002, 0.000> <0.061, -3.002, 1.211> <0.042, -1.176, -0.733> <0.049, 0.000, -1.029> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-2.000, 0.977, 0.000> <-1.995, 1.814, -0.211> <-0.838, 0.974, -1.002> <0.024, 0.974, -1.002> 
		<-2.021, 0.977, -0.897> <-2.015, 1.814, -1.108> <-0.838, 0.974, -1.432> <0.024, 0.974, -1.432> 
		<-0.719, 0.240, -1.520> <-1.299, 1.107, -1.237> <-0.026, 1.570, -1.080> <0.000, 1.570, 0.000> 
		<-0.000, 0.000, -2.000> <-0.579, 0.867, -1.717> <-0.026, 2.000, -1.080> <0.000, 2.000, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, 0.974, -1.002> <0.862, 0.974, -1.002> <1.981, 1.790, -0.205> <1.976, 0.977, 0.000> 
		<0.024, 0.974, -1.432> <0.862, 0.974, -1.432> <1.998, 1.790, 0.513> <1.993, 0.977, 0.717> 
		<0.000, 1.570, 0.000> <0.020, 1.570, 0.851> <0.143, 0.873, -0.372> <0.599, 0.190, -0.595> 
		<0.000, 2.000, 0.000> <0.020, 2.000, 0.851> <-0.432, 0.683, -0.758> <0.024, 0.000, -0.980> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.976, 0.977, 0.000> <1.965, -0.668, 0.415> <1.697, -3.002, 0.000> <0.000, -3.002, 0.000> 
		<1.993, 0.977, 0.717> <1.983, -0.668, 1.132> <2.596, -2.990, 0.000> <0.899, -2.990, 0.000> 
		<0.599, 0.190, -0.595> <1.053, -0.489, -0.816> <2.014, -1.808, 0.260> <1.993, -1.808, -0.587> 
		<0.024, 0.000, -0.980> <0.478, -0.680, -1.202> <2.023, -0.998, -0.131> <2.003, -0.998, -0.977> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, -3.002, 0.000> <-1.701, -3.002, 0.000> <-2.010, -0.673, 0.416> <-2.000, 0.977, 0.000> 
		<0.899, -2.990, 0.000> <-0.802, -2.990, 0.000> <-2.031, -0.673, -0.482> <-2.021, 0.977, -0.897> 
		<1.993, -1.808, -0.587> <1.971, -1.808, -1.527> <-0.215, -0.514, -1.765> <-0.719, 0.240, -1.520>
		<2.003, -0.998, -0.977> <1.981, -0.998, -1.917> <0.504, -0.755, -2.246> <-0.000, 0.000, -2.000>                                                                      
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, 0.000, -0.931> <0.469, 0.685, -0.706> <0.019, 2.000, 0.871> <0.000, 2.000, 0.024> 
		<-0.560, 0.195, -0.541> <-0.116, 0.880, -0.316> <0.019, 1.565, 0.871> <0.000, 1.565, 0.024> 
		<-1.983, 0.977, 0.730> <-1.978, 1.814, 0.519> <-0.838, 0.974, -0.566> <0.024, 0.974, -0.566> 
		<-2.000, 0.977, 0.000> <-1.995, 1.814, -0.211> <-0.838, 0.974, -1.002> <0.024, 0.974, -1.002> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, 2.000, 0.024> <-0.025, 2.000, -1.062> <0.571, 0.879, -1.711> <-0.000, 0.000, -2.000> 
		<0.000, 1.565, 0.024> <-0.025, 1.565, -1.062> <1.286, 1.116, -1.232> <0.715, 0.237, -1.520> 
		<0.024, 0.974, -0.566> <0.862, 0.974, -0.566> <1.959, 1.790, -1.097> <1.954, 0.977, -0.893> 
		<0.024, 0.974, -1.002> <0.862, 0.974, -1.002> <1.981, 1.790, -0.205> <1.976, 0.977, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.000, 0.000, -2.000> <-0.494, -0.760, -2.250> <-2.000, -1.047, -1.917> <-1.979, -1.047, -0.977> 
		<0.715, 0.237, -1.520> <0.221, -0.523, -1.770> <-2.010, -1.844, -1.533> <-1.988, -1.844, -0.593> 
		<1.954, 0.977, -0.893> <1.944, -0.668, -0.478> <0.813, -3.012, 0.000> <-0.884, -3.012, 0.000> 
		<1.976, 0.977, 0.000> <1.965, -0.668, 0.415> <1.697, -3.002, 0.000> <0.000, -3.002, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.979, -1.047, -0.977> <-1.959, -1.047, -0.114> <-0.429, -0.698, -1.161> <0.024, 0.000, -0.931> 
		<-1.988, -1.844, -0.593> <-1.968, -1.844, 0.270> <-1.014, -0.503, -0.770> <-0.560, 0.195, -0.541> 
		<-0.884, -3.012, 0.000> <-2.585, -3.012, 0.000> <-1.993, -0.673, 1.145> <-1.983, 0.977, 0.730> 
		<0.000, -3.002, 0.000> <-1.701, -3.002, 0.000> <-2.010, -0.673, 0.416> <-2.000, 0.977, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.998, -0.024, -2.003> <0.998, 0.915, -2.011> <0.964, 1.988, -1.013> <0.024, 2.000, -1.002> 
		<1.008, -0.024, -1.569> <1.008, 0.915, -1.576> <0.964, 1.988, -0.705> <0.024, 2.000, -0.694> 
		<0.373, -0.116, -1.164> <0.817, 0.568, -0.939> <0.019, 2.308, 0.871> <0.000, 2.308, 0.024> 
		<0.024, 0.000, -0.931> <0.469, 0.685, -0.706> <0.019, 2.000, 0.871> <0.000, 2.000, 0.024> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, 2.000, -1.002> <-0.907, 2.012, -0.990> <-0.974, 0.932, -1.986> <-0.974, 0.000, -1.979> 
		<0.024, 2.000, -0.694> <-0.907, 2.012, -0.682> <-0.981, 0.932, -2.278> <-0.981, 0.000, -2.271> 
		<0.000, 2.308, 0.024> <-0.025, 2.308, -1.062> <0.337, 0.802, -1.868> <-0.234, -0.078, -2.157> 
		<0.000, 2.000, 0.024> <-0.025, 2.000, -1.062> <0.571, 0.879, -1.711> <-0.000, 0.000, -2.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.974, 0.000, -1.979> <-0.974, -0.656, -1.973> <-0.631, -0.966, -0.969> <0.024, -0.974, -0.977> 
		<-0.981, 0.000, -2.271> <-0.981, -0.656, -2.265> <-1.233, -0.973, -0.969> <-0.577, -0.981, -0.977> 
		<-0.234, -0.078, -2.157> <-0.728, -0.838, -2.407> <-1.994, -0.506, -2.178> <-1.972, -0.506, -1.238> 
		<-0.000, 0.000, -2.000> <-0.494, -0.760, -2.250> <-2.000, -1.047, -1.917> <-1.979, -1.047, -0.977> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, -0.974, -0.977> <0.675, -0.982, -0.985> <0.998, -0.675, -1.998> <0.998, -0.024, -2.003> 
		<-0.577, -0.981, -0.977> <0.074, -0.989, -0.985> <1.008, -0.675, -1.563> <1.008, -0.024, -1.569> 
		<-1.972, -0.506, -1.238> <-1.952, -0.506, -0.375> <-0.081, -0.815, -1.393> <0.373, -0.116, -1.164> 
		<-1.979, -1.047, -0.977> <-1.959, -1.047, -0.114> <-0.429, -0.698, -1.161> <0.024, 0.000, -0.931> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.000, 0.000, -2.000> <-0.579, 0.867, -1.717> <-0.026, 2.000, -1.080> <0.000, 2.000, 0.000> 
		<0.240, -0.080, -2.160> <-0.339, 0.787, -1.878> <-0.026, 2.301, -1.080> <0.000, 2.301, -0.000> 
		<0.992, -0.024, -2.303> <0.992, 0.915, -2.310> <0.964, 1.988, -1.314> <0.024, 2.000, -1.302> 
		<0.998, -0.024, -2.003> <0.998, 0.915, -2.011> <0.964, 1.988, -1.013> <0.024, 2.000, -1.002> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, 2.000, 0.000> <0.020, 2.000, 0.851> <-0.432, 0.683, -0.758> <0.024, 0.000, -0.980> 
		<0.000, 2.301, -0.000> <0.020, 2.301, 0.851> <-0.771, 0.571, -0.985> <-0.315, -0.112, -1.208> 
		<0.024, 2.000, -1.302> <-0.907, 2.012, -1.291> <-0.964, 0.932, -1.563> <-0.964, 0.000, -1.555> 
		<0.024, 2.000, -1.002> <-0.907, 2.012, -0.990> <-0.974, 0.932, -1.986> <-0.974, 0.000, -1.979> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, 0.000, -0.980> <0.478, -0.680, -1.202> <2.023, -0.998, -0.131> <2.003, -0.998, -0.977> 
		<-0.315, -0.112, -1.208> <0.139, -0.792, -1.429> <2.030, -0.464, -0.388> <2.010, -0.464, -1.235> 
		<-0.964, 0.000, -1.555> <-0.964, -0.656, -1.550> <-0.038, -0.959, -0.969> <0.618, -0.967, -0.977> 
		<-0.974, 0.000, -1.979> <-0.974, -0.656, -1.973> <-0.631, -0.966, -0.969> <0.024, -0.974, -0.977> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<2.003, -0.998, -0.977> <1.981, -0.998, -1.917> <0.504, -0.755, -2.246> <-0.000, 0.000, -2.000> 
		<2.010, -0.464, -1.235> <1.987, -0.464, -2.175> <0.744, -0.835, -2.406> <0.240, -0.080, -2.160> 
		<0.618, -0.967, -0.977> <1.269, -0.975, -0.985> <0.992, -0.675, -2.297> <0.992, -0.024, -2.303> 
		<0.024, -0.974, -0.977> <0.675, -0.982, -0.985> <0.998, -0.675, -1.998> <0.998, -0.024, -2.003> 
	}
	pigment{rgb <192/255, 192/255, 192/255>}
	finish{phong 1}

}

//patch_obj_01
#declare shield2 =
union{
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.520, 0.513, -1.759> <-1.527, 0.750, -1.759> <-1.194, 0.378, -1.924> <-1.002, 0.250, -1.979> 
		<-1.520, 0.513, -1.759> <-1.527, 0.750, -2.090> <-1.194, 0.378, -2.059> <-1.002, 0.250, -2.114> 
		<-1.520, 0.513, -1.759> <-1.527, 0.750, -2.090> <-1.273, 0.314, -2.152> <-1.005, 0.135, -2.229> 
		<-1.520, 0.513, -1.759> <-1.520, 0.513, -2.090> <-1.270, 0.179, -2.152> <-1.002, 0.000, -2.229> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.520, 0.513, -1.759> <-1.527, 0.750, -1.759> <-1.194, 0.378, -1.924> <-1.002, 0.250, -1.979> 
		<-1.520, 0.513, -1.759> <-1.527, 0.750, -1.480> <-1.194, 0.378, -1.789> <-1.002, 0.250, -1.844> 
		<-1.520, 0.513, -1.759> <-1.527, 0.750, -1.480> <-1.231, 0.286, -1.664> <-1.005, 0.135, -1.729> 
		<-1.520, 0.513, -1.759> <-1.520, 0.513, -1.480> <-1.227, 0.151, -1.664> <-1.002, 0.000, -1.729> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.002, 0.250, -1.979> <-0.892, 0.177, -2.010> <-0.755, 0.135, -1.979> <-0.752, 0.000, -1.979> 
		<-1.002, 0.250, -1.979> <-0.892, 0.177, -1.875> <-0.755, 0.135, -1.844> <-0.752, 0.000, -1.844> 
		<-1.002, 0.250, -1.979> <-0.892, 0.177, -1.875> <-0.896, 0.062, -1.760> <-0.892, -0.073, -1.760> 
		<-1.002, 0.250, -1.979> <-1.002, 0.250, -1.844> <-1.005, 0.135, -1.729> <-1.002, 0.000, -1.729> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.002, 0.250, -1.979> <-0.892, 0.177, -2.010> <-0.755, 0.135, -1.979> <-0.752, 0.000, -1.979> 
		<-1.002, 0.250, -1.979> <-0.892, 0.177, -2.145> <-0.755, 0.135, -2.114> <-0.752, 0.000, -2.114> 
		<-1.002, 0.250, -1.979> <-0.892, 0.177, -2.145> <-0.896, 0.062, -2.260> <-0.892, -0.073, -2.260> 
		<-1.002, 0.250, -1.979> <-1.002, 0.250, -2.114> <-1.005, 0.135, -2.229> <-1.002, 0.000, -2.229> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.752, 0.000, -1.979> <-0.744, -0.259, -1.979> <-0.767, -0.781, -2.039> <-0.977, -0.641, -1.979> 
		<-0.752, 0.000, -1.979> <-0.744, -0.259, -1.844> <-0.767, -0.781, -1.776> <-0.977, -0.641, -1.716> 
		<-0.752, 0.000, -1.979> <-0.744, -0.259, -1.844> <-0.885, -0.336, -1.760> <-0.994, -0.263, -1.729> 
		<-0.752, 0.000, -1.979> <-0.752, 0.000, -1.844> <-0.892, -0.073, -1.760> <-1.002, 0.000, -1.729> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.752, 0.000, -1.979> <-0.744, -0.259, -1.979> <-0.767, -0.781, -2.039> <-0.977, -0.641, -1.979> 
		<-0.752, 0.000, -1.979> <-0.744, -0.259, -2.114> <-0.767, -0.781, -2.302> <-0.977, -0.641, -2.242> 
		<-0.752, 0.000, -1.979> <-0.744, -0.259, -2.114> <-0.885, -0.336, -2.260> <-0.994, -0.263, -2.229> 
		<-0.752, 0.000, -1.979> <-0.752, 0.000, -2.114> <-0.892, -0.073, -2.260> <-1.002, 0.000, -2.229> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.977, -0.641, -1.979> <-1.377, -0.374, -1.864> <-1.507, 0.019, -1.759> <-1.520, 0.513, -1.759> 
		<-0.977, -0.641, -1.979> <-1.377, -0.374, -2.127> <-1.507, 0.019, -2.090> <-1.520, 0.513, -2.090> 
		<-0.977, -0.641, -1.979> <-1.377, -0.374, -2.127> <-1.263, -0.084, -2.152> <-1.270, 0.179, -2.152> 
		<-0.977, -0.641, -1.979> <-0.977, -0.641, -2.242> <-0.994, -0.263, -2.229> <-1.002, 0.000, -2.229> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.977, -0.641, -1.979> <-1.377, -0.374, -1.864> <-1.507, 0.019, -1.759> <-1.520, 0.513, -1.759> 
		<-0.977, -0.641, -1.979> <-1.377, -0.374, -1.601> <-1.507, 0.019, -1.480> <-1.520, 0.513, -1.480> 
		<-0.977, -0.641, -1.979> <-1.377, -0.374, -1.601> <-1.220, -0.112, -1.664> <-1.227, 0.151, -1.664> 
		<-0.977, -0.641, -1.979> <-0.977, -0.641, -1.716> <-0.994, -0.263, -1.729> <-1.002, 0.000, -1.729> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.752, 0.000, -2.003> <0.748, 0.136, -2.007> <0.860, 0.215, -2.065> <0.977, 0.274, -2.027> 
		<0.752, 0.000, -2.003> <0.748, 0.136, -2.135> <0.860, 0.215, -2.200> <0.977, 0.274, -2.163> 
		<0.752, 0.000, -2.003> <0.748, 0.136, -2.135> <0.863, 0.080, -2.292> <0.973, 0.136, -2.257> 
		<0.752, 0.000, -2.003> <0.752, 0.000, -2.132> <0.867, -0.056, -2.288> <0.977, 0.000, -2.253> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.752, 0.000, -2.003> <0.748, 0.136, -2.007> <0.860, 0.215, -2.065> <0.977, 0.274, -2.027> 
		<0.752, 0.000, -2.003> <0.748, 0.136, -1.878> <0.860, 0.215, -1.916> <0.977, 0.274, -1.879> 
		<0.752, 0.000, -2.003> <0.748, 0.136, -1.878> <0.863, 0.092, -1.792> <0.973, 0.148, -1.757> 
		<0.752, 0.000, -2.003> <0.752, 0.000, -1.874> <0.867, -0.056, -1.788> <0.977, 0.000, -1.753> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.977, 0.274, -2.027> <1.179, 0.377, -1.963> <1.514, 0.626, -1.765> <1.520, 0.391, -1.759> 
		<0.977, 0.274, -2.027> <1.179, 0.377, -1.815> <1.514, 0.626, -1.509> <1.520, 0.391, -1.503> 
		<0.977, 0.274, -2.027> <1.179, 0.377, -1.815> <1.192, 0.260, -1.687> <1.196, 0.111, -1.683> 
		<0.977, 0.274, -2.027> <0.977, 0.274, -1.879> <0.973, 0.148, -1.757> <0.977, 0.000, -1.753> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.977, 0.274, -2.027> <1.179, 0.377, -1.963> <1.514, 0.626, -1.765> <1.520, 0.391, -1.759> 
		<0.977, 0.274, -2.027> <1.179, 0.377, -2.099> <1.514, 0.626, -2.083> <1.520, 0.391, -2.077> 
		<0.977, 0.274, -2.027> <1.179, 0.377, -2.099> <1.246, 0.274, -2.170> <1.250, 0.139, -2.166> 
		<0.977, 0.274, -2.027> <0.977, 0.274, -2.163> <0.973, 0.136, -2.257> <0.977, 0.000, -2.253> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.520, 0.391, -1.759> <1.532, -0.060, -1.747> <1.388, -0.444, -1.880> <1.002, -0.641, -2.003> 
		<1.520, 0.391, -1.759> <1.532, -0.060, -1.491> <1.388, -0.444, -1.617> <1.002, -0.641, -1.740> 
		<1.520, 0.391, -1.759> <1.532, -0.060, -1.491> <1.203, -0.151, -1.676> <0.984, -0.263, -1.746> 
		<1.520, 0.391, -1.759> <1.520, 0.391, -1.503> <1.196, 0.111, -1.683> <0.977, 0.000, -1.753> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.520, 0.391, -1.759> <1.532, -0.060, -1.747> <1.388, -0.444, -1.880> <1.002, -0.641, -2.003> 
		<1.520, 0.391, -1.759> <1.532, -0.060, -2.065> <1.388, -0.444, -2.143> <1.002, -0.641, -2.266> 
		<1.520, 0.391, -1.759> <1.532, -0.060, -2.065> <1.257, -0.124, -2.159> <0.984, -0.263, -2.246> 
		<1.520, 0.391, -1.759> <1.520, 0.391, -2.077> <1.250, 0.139, -2.166> <0.977, 0.000, -2.253> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.002, -0.641, -2.003> <0.776, -0.755, -2.075> <0.759, -0.263, -1.996> <0.752, 0.000, -2.003> 
		<1.002, -0.641, -2.003> <0.776, -0.755, -2.338> <0.759, -0.263, -2.125> <0.752, 0.000, -2.132> 
		<1.002, -0.641, -2.003> <0.776, -0.755, -2.338> <0.874, -0.319, -2.281> <0.867, -0.056, -2.288> 
		<1.002, -0.641, -2.003> <1.002, -0.641, -2.266> <0.984, -0.263, -2.246> <0.977, 0.000, -2.253> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.002, -0.641, -2.003> <0.776, -0.755, -2.075> <0.759, -0.263, -1.996> <0.752, 0.000, -2.003> 
		<1.002, -0.641, -2.003> <0.776, -0.755, -1.812> <0.759, -0.263, -1.867> <0.752, 0.000, -1.874> 
		<1.002, -0.641, -2.003> <0.776, -0.755, -1.812> <0.874, -0.319, -1.781> <0.867, -0.056, -1.788> 
		<1.002, -0.641, -2.003> <1.002, -0.641, -1.740> <0.984, -0.263, -1.746> <0.977, 0.000, -1.753> 
	}
	pigment{rgb <3/255, 33/255, 187/255>}
	finish{phong 1}

}

//patch_obj_02
#declare shield3 =
union{
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.976, -1.000, -1.026> <-0.980, -0.517, -0.835> <-0.544, -0.047, -0.996> <-0.024, -0.047, -1.003> 
		<-0.976, -1.000, -1.026> <-0.973, -1.248, -1.124> <-0.537, -0.787, -1.289> <-0.017, -0.787, -1.295> 
		<-0.976, -1.000, -1.026> <-0.973, -1.248, -1.124> <-0.793, -1.774, -1.675> <-0.007, -1.774, -1.685> 
		<-0.976, -1.000, -1.026> <-0.968, -1.731, -1.315> <-0.786, -2.515, -1.967> <0.000, -2.515, -1.977> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.024, -0.047, -1.003> <0.495, -0.047, -1.010> <0.922, -0.516, -0.859> <0.927, -1.000, -1.050> 
		<-0.024, -0.047, -1.003> <0.503, -0.787, -1.302> <0.929, -1.235, -1.143> <0.934, -1.719, -1.334> 
		<-0.024, -0.047, -1.003> <0.503, -0.787, -1.302> <0.766, -1.774, -1.695> <0.773, -2.515, -1.987> 
		<-0.024, -0.047, -1.003> <-0.017, -0.787, -1.295> <-0.007, -1.774, -1.685> <0.000, -2.515, -1.977> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.024, -0.047, -1.003> <0.495, -0.047, -1.010> <0.922, -0.516, -0.859> <0.927, -1.000, -1.050> 
		<-0.017, -0.026, -1.303> <0.503, -0.026, -1.310> <0.644, -0.210, -1.145> <0.649, -0.693, -1.336> 
		<-0.007, 0.002, -1.703> <-0.007, 0.002, -1.703> <0.278, -0.284, -1.717> <0.278, -0.284, -1.717> 
		<0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.927, -1.000, -1.050> <0.934, -1.719, -1.334> <0.773, -2.515, -1.987> <0.000, -2.515, -1.977> 
		<0.649, -0.693, -1.336> <0.656, -1.412, -1.620> <0.773, -1.753, -1.995> <0.000, -1.753, -1.985> 
		<0.278, -0.284, -1.717> <0.278, -0.284, -1.717> <0.000, -0.738, -1.995> <0.000, -0.738, -1.995> 
		<0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, -2.515, -1.977> <-0.786, -2.515, -1.967> <-0.968, -1.731, -1.315> <-0.976, -1.000, -1.026> 
		<0.000, -1.753, -1.985> <-0.786, -1.753, -1.975> <-0.676, -1.424, -1.608> <-0.683, -0.693, -1.319> 
		<0.000, -0.738, -1.995> <0.000, -0.738, -1.995> <-0.293, -0.284, -1.710> <-0.293, -0.284, -1.710> 
		<0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> <0.000, 0.023, -2.003> 
		<-0.293, -0.284, -1.710> <-0.293, -0.284, -1.710> <-0.007, 0.002, -1.703> <-0.007, 0.002, -1.703> 
		<-0.683, -0.693, -1.319> <-0.688, -0.210, -1.128> <-0.537, -0.026, -1.296> <-0.017, -0.026, -1.303> 
		<-0.976, -1.000, -1.026> <-0.980, -0.517, -0.835> <-0.544, -0.047, -0.996> <-0.024, -0.047, -1.003> 
	}
	pigment{rgb <255/255, 255/255, 0/255>}
	finish{phong 1}

}

//patch_obj_03
#declare shield4 =
union{
	bezier_patch {
		4,4
		accuracy 0.01
		<1.000, 0.776, -0.757> <0.832, 0.781, -0.644> <1.049, 1.092, -0.697> <1.049, 1.295, -0.697> 
		<1.000, 0.776, -0.757> <1.192, 0.770, -0.887> <1.298, 1.085, -0.865> <1.298, 1.287, -0.865> 
		<1.000, 0.776, -0.757> <1.192, 0.770, -0.887> <1.630, 0.843, -1.089> <1.630, 1.278, -1.089> 
		<1.000, 0.776, -0.757> <1.360, 0.765, -1.000> <1.879, 0.836, -1.257> <1.879, 1.270, -1.257> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.049, 1.295, -0.697> <1.049, 1.325, -0.697> <0.974, 1.277, -0.740> <1.000, 1.276, -0.757> 
		<1.049, 1.295, -0.697> <1.298, 1.318, -0.865> <1.298, 1.267, -0.958> <1.324, 1.266, -0.976> 
		<1.049, 1.295, -0.697> <1.298, 1.318, -0.865> <1.630, 1.668, -1.089> <1.879, 1.661, -1.257> 
		<1.049, 1.295, -0.697> <1.298, 1.287, -0.865> <1.630, 1.278, -1.089> <1.879, 1.270, -1.257> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.000, 0.776, -0.757> <-0.835, 0.771, -0.644> <-1.000, 1.094, -0.721> <-1.000, 1.295, -0.721> 
		<-1.000, 0.776, -0.757> <-1.177, 0.781, -0.878> <-1.235, 1.101, -0.882> <-1.235, 1.302, -0.882> 
		<-1.000, 0.776, -0.757> <-1.177, 0.781, -0.878> <-1.547, 0.897, -1.096> <-1.547, 1.312, -1.096> 
		<-1.000, 0.776, -0.757> <-1.342, 0.787, -0.992> <-1.782, 0.904, -1.257> <-1.782, 1.319, -1.257> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.000, 1.295, -0.721> <-1.000, 1.310, -0.721> <-0.987, 1.276, -0.748> <-1.000, 1.276, -0.757> 
		<-1.000, 1.295, -0.721> <-1.235, 1.318, -0.882> <-1.283, 1.285, -0.951> <-1.296, 1.285, -0.960> 
		<-1.000, 1.295, -0.721> <-1.235, 1.318, -0.882> <-1.547, 1.670, -1.096> <-1.782, 1.678, -1.257> 
		<-1.000, 1.295, -0.721> <-1.235, 1.302, -0.882> <-1.547, 1.312, -1.096> <-1.782, 1.319, -1.257> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.049, 1.295, -0.697> <1.049, 1.325, -0.697> <0.974, 1.277, -0.740> <1.000, 1.276, -0.757> 
		<0.434, 1.295, -0.704> <0.434, 1.325, -0.704> <0.374, 1.277, -0.740> <0.400, 1.276, -0.757> 
		<-0.385, 1.295, -0.714> <-0.385, 1.310, -0.714> <-0.387, 1.276, -0.748> <-0.400, 1.276, -0.757> 
		<-1.000, 1.295, -0.721> <-1.000, 1.310, -0.721> <-0.987, 1.276, -0.748> <-1.000, 1.276, -0.757> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.000, 1.276, -0.757> <1.324, 1.266, -0.976> <1.879, 1.661, -1.257> <1.879, 1.270, -1.257> 
		<0.400, 1.276, -0.757> <0.724, 1.266, -0.976> <0.781, 1.675, -1.257> <0.781, 1.285, -1.257> 
		<-0.400, 1.276, -0.757> <-0.696, 1.285, -0.960> <-0.683, 1.663, -1.257> <-0.683, 1.304, -1.257> 
		<-1.000, 1.276, -0.757> <-1.296, 1.285, -0.960> <-1.782, 1.678, -1.257> <-1.782, 1.319, -1.257> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.879, 1.270, -1.257> <1.879, 0.836, -1.257> <1.360, 0.765, -1.000> <1.000, 0.776, -0.757> 
		<0.781, 1.285, -1.257> <0.781, 0.850, -1.257> <0.760, 0.765, -1.000> <0.400, 0.776, -0.757> 
		<-0.683, 1.304, -1.257> <-0.683, 0.889, -1.257> <-0.742, 0.787, -0.992> <-0.400, 0.776, -0.757> 
		<-1.782, 1.319, -1.257> <-1.782, 0.904, -1.257> <-1.342, 0.787, -0.992> <-1.000, 0.776, -0.757> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.000, 0.776, -0.757> <-0.835, 0.771, -0.644> <-1.000, 1.094, -0.721> <-1.000, 1.295, -0.721> 
		<-0.400, 0.776, -0.757> <-0.235, 0.771, -0.644> <-0.385, 1.094, -0.714> <-0.385, 1.295, -0.714> 
		<0.400, 0.776, -0.757> <0.232, 0.781, -0.644> <0.434, 1.092, -0.704> <0.434, 1.295, -0.704> 
		<1.000, 0.776, -0.757> <0.832, 0.781, -0.644> <1.049, 1.092, -0.697> <1.049, 1.295, -0.697> 
	}
	pigment{rgb <255/255, 0/255, 128/255>}
	finish{phong 1}

}

//patch_obj_04
#declare shield5 =
union{
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.718, -3.063, -1.485> <-1.735, -3.205, -1.350> <-1.756, -3.395, -1.170> <-1.773, -3.537, -1.036> 
		<-1.780, -3.078, -1.508> <-1.797, -3.220, -1.374> <-1.819, -3.410, -1.194> <-1.835, -3.553, -1.059> 
		<-1.809, -3.128, -1.564> <-1.826, -3.270, -1.430> <-1.847, -3.460, -1.250> <-1.864, -3.602, -1.115> 
		<-1.782, -3.172, -1.608> <-1.798, -3.315, -1.473> <-1.820, -3.505, -1.294> <-1.836, -3.647, -1.159> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.554, -3.117, -1.522> <-1.570, -3.259, -1.387> <-1.592, -3.449, -1.208> <-1.608, -3.591, -1.073> 
		<-1.581, -3.072, -1.478> <-1.598, -3.215, -1.343> <-1.619, -3.404, -1.164> <-1.636, -3.547, -1.029> 
		<-1.656, -3.048, -1.461> <-1.672, -3.190, -1.327> <-1.694, -3.380, -1.147> <-1.710, -3.522, -1.012> 
		<-1.718, -3.063, -1.485> <-1.735, -3.205, -1.350> <-1.756, -3.395, -1.170> <-1.773, -3.537, -1.036> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.618, -3.226, -1.645> <-1.634, -3.369, -1.510> <-1.656, -3.558, -1.331> <-1.672, -3.701, -1.196> 
		<-1.556, -3.211, -1.622> <-1.572, -3.354, -1.487> <-1.594, -3.543, -1.307> <-1.610, -3.686, -1.173> 
		<-1.527, -3.162, -1.566> <-1.543, -3.304, -1.431> <-1.565, -3.494, -1.251> <-1.581, -3.636, -1.117> 
		<-1.554, -3.117, -1.522> <-1.570, -3.259, -1.387> <-1.592, -3.449, -1.208> <-1.608, -3.591, -1.073> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.782, -3.172, -1.608> <-1.798, -3.315, -1.473> <-1.820, -3.505, -1.294> <-1.836, -3.647, -1.159> 
		<-1.755, -3.217, -1.652> <-1.771, -3.359, -1.517> <-1.793, -3.549, -1.337> <-1.809, -3.691, -1.203> 
		<-1.680, -3.242, -1.669> <-1.696, -3.384, -1.534> <-1.718, -3.574, -1.354> <-1.734, -3.716, -1.220> 
		<-1.618, -3.226, -1.645> <-1.634, -3.369, -1.510> <-1.656, -3.558, -1.331> <-1.672, -3.701, -1.196> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.065, -2.455, -0.569> <-1.274, -2.629, -0.862> <-1.554, -2.861, -1.253> <-1.763, -3.034, -1.547> 
		<-1.031, -2.418, -0.615> <-1.240, -2.592, -0.908> <-1.520, -2.824, -1.299> <-1.729, -2.997, -1.593> 
		<-0.963, -2.428, -0.657> <-1.173, -2.602, -0.950> <-1.452, -2.834, -1.342> <-1.662, -3.007, -1.635> 
		<-0.916, -2.477, -0.662> <-1.126, -2.651, -0.955> <-1.405, -2.883, -1.346> <-1.614, -3.057, -1.640> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.041, -2.613, -0.492> <-1.250, -2.787, -0.786> <-1.530, -3.018, -1.177> <-1.739, -3.192, -1.470> 
		<-1.088, -2.564, -0.488> <-1.297, -2.738, -0.781> <-1.577, -2.969, -1.172> <-1.786, -3.143, -1.466> 
		<-1.099, -2.492, -0.522> <-1.308, -2.666, -0.816> <-1.588, -2.898, -1.207> <-1.797, -3.071, -1.500> 
		<-1.065, -2.455, -0.569> <-1.274, -2.629, -0.862> <-1.554, -2.861, -1.253> <-1.763, -3.034, -1.547> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.892, -2.635, -0.585> <-1.102, -2.809, -0.879> <-1.381, -3.040, -1.270> <-1.590, -3.214, -1.563> 
		<-0.926, -2.672, -0.539> <-1.136, -2.846, -0.833> <-1.415, -3.077, -1.224> <-1.624, -3.251, -1.517> 
		<-0.994, -2.662, -0.497> <-1.203, -2.836, -0.790> <-1.482, -3.067, -1.182> <-1.692, -3.241, -1.475> 
		<-1.041, -2.613, -0.492> <-1.250, -2.787, -0.786> <-1.530, -3.018, -1.177> <-1.739, -3.192, -1.470> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.916, -2.477, -0.662> <-1.126, -2.651, -0.955> <-1.405, -2.883, -1.346> <-1.614, -3.057, -1.640> 
		<-0.869, -2.527, -0.666> <-1.078, -2.700, -0.960> <-1.358, -2.932, -1.351> <-1.567, -3.106, -1.644> 
		<-0.858, -2.598, -0.632> <-1.068, -2.772, -0.925> <-1.347, -3.004, -1.316> <-1.556, -3.177, -1.610> 
		<-0.892, -2.635, -0.585> <-1.102, -2.809, -0.879> <-1.381, -3.040, -1.270> <-1.590, -3.214, -1.563> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.286, -3.675, -0.951> <1.013, -3.609, -0.934> <0.648, -3.520, -0.912> <0.374, -3.454, -0.896> 
		<1.282, -3.675, -1.019> <1.009, -3.609, -1.002> <0.644, -3.520, -0.980> <0.370, -3.454, -0.964> 
		<1.265, -3.730, -1.075> <0.992, -3.664, -1.058> <0.627, -3.575, -1.036> <0.354, -3.509, -1.020> 
		<1.249, -3.796, -1.074> <0.976, -3.730, -1.057> <0.611, -3.642, -1.035> <0.338, -3.575, -1.019> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.264, -3.796, -0.824> <0.991, -3.730, -0.808> <0.626, -3.642, -0.786> <0.353, -3.575, -0.769> 
		<1.281, -3.730, -0.825> <1.007, -3.664, -0.809> <0.642, -3.575, -0.787> <0.369, -3.509, -0.770> 
		<1.290, -3.675, -0.883> <1.017, -3.609, -0.866> <0.652, -3.520, -0.844> <0.379, -3.454, -0.827> 
		<1.286, -3.675, -0.951> <1.013, -3.609, -0.934> <0.648, -3.520, -0.912> <0.374, -3.454, -0.896> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.228, -3.918, -0.947> <0.954, -3.851, -0.931> <0.589, -3.763, -0.909> <0.316, -3.697, -0.892> 
		<1.232, -3.918, -0.879> <0.958, -3.851, -0.863> <0.593, -3.763, -0.841> <0.320, -3.697, -0.824> 
		<1.248, -3.863, -0.823> <0.975, -3.796, -0.807> <0.610, -3.708, -0.785> <0.337, -3.642, -0.768> 
		<1.264, -3.796, -0.824> <0.991, -3.730, -0.808> <0.626, -3.642, -0.786> <0.353, -3.575, -0.769> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.249, -3.796, -1.074> <0.976, -3.730, -1.057> <0.611, -3.642, -1.035> <0.338, -3.575, -1.019> 
		<1.233, -3.863, -1.073> <0.960, -3.796, -1.056> <0.595, -3.708, -1.034> <0.322, -3.642, -1.018> 
		<1.223, -3.918, -1.015> <0.950, -3.851, -0.999> <0.585, -3.763, -0.977> <0.312, -3.697, -0.960> 
		<1.228, -3.918, -0.947> <0.954, -3.851, -0.931> <0.589, -3.763, -0.909> <0.316, -3.697, -0.892> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.037, -2.382, -0.698> <0.077, -2.655, -0.937> <0.229, -3.019, -1.255> <0.343, -3.292, -1.494> 
		<0.024, -2.382, -0.669> <0.138, -2.655, -0.908> <0.290, -3.019, -1.226> <0.404, -3.292, -1.464> 
		<0.058, -2.422, -0.608> <0.172, -2.695, -0.846> <0.324, -3.059, -1.164> <0.438, -3.332, -1.403> 
		<0.037, -2.469, -0.563> <0.151, -2.742, -0.802> <0.303, -3.106, -1.120> <0.417, -3.379, -1.359> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.189, -2.469, -0.671> <-0.075, -2.742, -0.910> <0.077, -3.106, -1.228> <0.191, -3.379, -1.467> 
		<-0.168, -2.422, -0.715> <-0.054, -2.695, -0.954> <0.098, -3.059, -1.272> <0.212, -3.332, -1.511> 
		<-0.099, -2.382, -0.728> <0.015, -2.655, -0.966> <0.167, -3.019, -1.285> <0.281, -3.292, -1.523> 
		<-0.037, -2.382, -0.698> <0.077, -2.655, -0.937> <0.229, -3.019, -1.255> <0.343, -3.292, -1.494> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.115, -2.556, -0.536> <-0.001, -2.829, -0.775> <0.151, -3.193, -1.093> <0.265, -3.466, -1.332> 
		<-0.176, -2.556, -0.566> <-0.062, -2.829, -0.804> <0.090, -3.193, -1.123> <0.204, -3.466, -1.361> 
		<-0.210, -2.517, -0.627> <-0.096, -2.790, -0.866> <0.056, -3.154, -1.184> <0.170, -3.427, -1.422> 
		<-0.189, -2.469, -0.671> <-0.075, -2.742, -0.910> <0.077, -3.106, -1.228> <0.191, -3.379, -1.467> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.037, -2.469, -0.563> <0.151, -2.742, -0.802> <0.303, -3.106, -1.120> <0.417, -3.379, -1.359> 
		<0.016, -2.517, -0.519> <0.130, -2.790, -0.758> <0.282, -3.154, -1.076> <0.396, -3.427, -1.315> 
		<-0.053, -2.556, -0.507> <0.061, -2.829, -0.746> <0.213, -3.193, -1.064> <0.327, -3.466, -1.302> 
		<-0.115, -2.556, -0.536> <-0.001, -2.829, -0.775> <0.151, -3.193, -1.093> <0.265, -3.466, -1.332> 
	}
	pigment{rgb <128/255, 64/255, 0/255>}
	finish{phong 1}

}

#declare shield = union { 
  object { shield1 }
  object { shield2 }
  object { shield3 }
  object { shield4 }
  object { shield5 }
}

#declare column_flute_alt = on

object { column_composite
scale <3.5, 3.5, 3.5>
translate <-5, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <0, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <5, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <10, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <-10, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <-15, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <15, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <20, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <-20, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <-25, -5, 49>
}

object { column_composite
scale <3.5, 3.5, 3.5>
translate <25, -5, 49>
}

#declare beam = cylinder { <0,0,0><0,5,0>, 1}

object { beam
  texture { T_Wood19 
    finish { 
      ambient .37
      diffuse .48
      roughness .73
      phong .273
      specular .536
    }
  }
  scale <1, 10, 1>
  rotate z*90
  translate <25, 6,  49>
}

#declare doorway = box { <0, 0, 0>, <5, 10, 2>  }

object { doorway
  texture {
    pigment { image_map { png "Logo.png" } scale <5, 10, 1>  }
  finish {
    ambient .813
    diffuse .973
    }
  }
  scale <1, 1, 1>
  translate <5, -5, 49>
}

#declare pic1 = union {
  object { doorway
    scale <.5, .5, 1>
    rotate z*90  
    texture {
      pigment { image_map { png "painting.png" } scale <5, 3, 1>}
      finish {
        ambient .313
        diffuse .973
      }
    }
    translate <-.25, .75, 0>
  }
  object { doorway
    texture { T_Wood7
      finish {
        ambient .37
        diffuse .48
        roughness .73
        phong .273
        specular .536
      }
    }
    scale <.75, .75, 1>
    translate <0, 0, .25>
    rotate z*90
    scale <.75, 1, 1>
  }
}

object { pic1
  scale <.75, .75, 1>
  translate <-15.5, -2, 49.5>
}

#declare table = union {
  object { doorway 
    rotate x*90
    rotate y*90
  }
  object { beam 
    scale <.5, 1.5, .5>
    translate <1, -6, -1>
  }
  object { beam 
    scale <.5, 1.5, .5>
    translate <1, -6, -4>
  }
  object { beam 
    scale <.5, 1.5, .5>
    translate <9, -6, -1>
  }
  object { beam 
    scale <.5, 1.5, .5>
    translate <9, -6, -4>
  }
}

object  { table 
  texture { T_Wood3 
    finish {
      ambient .37
      diffuse .48
      roughness .73
      phong .273
      specular .536
    }
  }
  scale .5
  translate <5, -2.5, 10>
}

plane { y, -5  
  hollow on
  texture {
  pigment {granite color_map {[0 rgb <.7, .5, .3>] [1 rgb <.9, .7, .4>]}}
  normal  {granite -.6}
  scale 3}
  texture {
  pigment {checker rgbt 1, rgbt <.5, .3, .1, .6>}
  finish {reflection .6}
   scale 4 rotate y * -30}}

plane { z, 50
  hollow on
  texture { PinkAlabaster }
  finish {
    ambient .43
    diffuse .76
  }
}

object { shield
  scale <1, 1, 1>
  rotate x*30
  rotate y*10
  translate <4.5, -2.5, 8>
}

object { Sword
  rotate y*180
  rotate z*-2 
  scale .5
  translate <0, -5, 1>
}

plane { y, 55
  hollow on
  texture { PinkAlabaster
   finish {
      ambient 0.2
      diffuse 0.8
      roughness .473
      phong .127
      specular .786 
      reflection .473
      metallic
    }
  }
}

#declare recursionmax = 6; // Defines the complexity of the tree
#declare divisions = array[6] {6,5,4,3,2,2}
init_rand (48,25,157)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.4, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.35, 0.003, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <0,-0.1,-0.2>;

// Variables for leaves
#declare leafarray = array[4] {maple1,maple2,maple3,pinkflower}
#declare leafprob = array[4] {0.1,0.1,0.1,0.3}
#declare leafscale = array[4] {0.2,0.2,0.2,0.2}
#declare leafnoise = array[4] {1,1,1,0.5}

// Assign the branch texture
#declare branchtexture = texture { light_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <.5,.5,.5>
	rotate <0,0,0>
	translate <-3, -5, 1>
}

// Provide feedback in the first 2 recursion levels
#declare feedback = 2;

// Call the macro
splinetree(0,0)

#declare shape1 =
lathe {
  cubic_spline
  12,
  <0.000000, 0.000000>,
  <0.000000, 0.000000>,
  <0.277027, 0.000000>,
  <0.277027, 0.000000>,
  <0.064189, 0.081081>,
  <0.057432, 0.256757>,
  <0.260135, 0.422297>,
  <0.152027, 1.000000>,
  <0.128378, 0.996622>,
  <0.222973, 0.452703>,
  <0.000000, 0.307432>,
  <0.023649, 0.523649>

  scale <1.5, 1.5, 1.5>
}

object { shape1
  texture { T_Stone23
    finish {
      ambient .37
      diffuse .48
      roughness .73
      phong .273
      specular .536
    }
  }
  translate <-3, -6, 1>
}

#declare ball = sphere { <0, 0, 0> 1 }

object { ball
  hollow on
  interior { I_Glass }
  texture { Red_Marble
    finish {
      ambient .37
      diffuse .48
      roughness .73
      phong .273
      specular .536
      reflection .736
      metallic
    }
  }
  scale 1.5
  translate <-7, -3, 5>
}

object { ball
  hollow on
  interior { I_Glass }
  texture { Blood_Marble
    finish {
      ambient .37
      diffuse .48
      roughness .73
      phong .273
      specular .536
      reflection .736
      metallic
    }
  }
  scale 1
  translate <-6.5, -4, 4.75>
}

object { ball 
  hollow on
  interior { I_Glass }
  texture { Jade
    finish {
      ambient .37
      diffuse .48
      roughness .73
      phong .273
      specular .536
      reflection .736
      metallic
    }
  }
  scale .5
  translate <-7.5, -4, 4.5>
}

// torch interior (flame)
#declare ExplosionInterior =
interior{
  media{
    emission rgb <2.0,2.0,2.0>  //high emission to make flame non-transparent
    density{
      spherical
      scale 1.4 //scale up the spherical pattern ...
      turbulence 1.0
      translate <0, -1.0, 0>  // ... so that when it is translated down
                              // (to make hot near bottom), it will still reach near the
                              // top of the containing sphere
      density_map{ // a density map rather than a color map, since a color map applied
                    // to spherical pattern is never very solid

        [0.0 Black] // clear outer layer
        [0.4 Red * 2]
        [0.6 OrangeRed * 2]
        [0.8 Yellow * 2]
        [1.0 color rgb<2,2,1>] // bright inner core
      }
    }
  }
}

// create a sphere shape to contain explosion
#declare ExplosionSphere =
object{
  sphere
  {
    <0, 0, 0>
    1.0
    pigment {color rgbf <1, 1, 1, 1>}
    hollow on
    interior{ExplosionInterior}
  }
}

// glowing torch - works as light source
#declare Torch =
object{
  union{

    light_source{
      <0,0.8,0>
      color rgb<0.4, 0.1, 0.0>
      fade_distance 2
      fade_power 2
      looks_like {ExplosionSphere}
      scale <0.75, 3.0, 0.75> // stretch it in the vertical to give more height than
                              // width
    }

    cylinder // pretty crappy torch stick, fix me!
    {
      -8.0 * y,  0.0 * y,  0.15
      pigment{Brown}
      rotate <0,0,55>
      no_shadow // not ideal, but does weird things otherwise
    }
  }
}

object{
  Torch  
  scale 1.25
  rotate y*-90
  translate <17.5, 0, 48>
}

object{
  Torch
  scale 1.25 
  rotate y*-90
  translate <-2.5, 0, 48>
}

// By Bradley Gawthrop-Like the inner walls of some kinds of
// geods really nice, PLAY WITH THE TURBULENCE you'd be amazed
// what neat new effects can be gained by doing so.
#declare Geod = texture {
  pigment {
    onion
    turbulence 0.80  //was 0.60
    color_map {
      [0.00 color rgb <0.00, 0.00, 0.00>]
      [0.10 color rgb <0.83, 0.79, 1.00>]
      [0.20 color rgb <0.63, 0.62, 0.83>]
      [0.30 color rgbf <0.46, 0.44, 0.65, 1.00>]
      [0.40 color rgb <0.29, 0.27, 0.48>]
      [0.50 color rgbf <0.11, 0.11, 0.30, 1.00>]
      [0.60 color rgb <0.25, 0.24, 0.38>]
      [0.70 color rgbf <0.41, 0.37, 0.46, 1.00>]
      [0.80 color rgb <0.57, 0.49, 0.54>]
      [0.90 color rgbf <0.73, 0.62, 0.62, 1.00>]
      [1.00 color rgb <0.89, 0.75, 0.70>]
    }
  }
  finish {
    specular 0.20
  }
}

/* This is a good asteroid texture. It is from povlab.inc. I do not know who is the
author.
*/
#declare Asteroid = texture {
  pigment {
    bozo
    turbulence 0.60
    omega 0.80
    lambda 3.00
    color_map {
      [0.00 color rgb <0.51, 0.51, 0.51>]
      [1.00 color rgb <1.00, 1.00, 1.00>]
    }
  }
  normal {
    bumps 1.00
    turbulence 0.60
    octaves 5
    omega 0.65
    lambda 3.00
    scale <0.75, 0.75, 1.00>
  }
  finish {
    ambient 0.15
    specular 0.20
  }
}

/*
A note on dimensions:
        1 unit = .333 inches for the mortar.
        I am basing this on a mortar I own that is 3" tall and 4" wide.
*/
#declare Mortar = object { 
difference {
        union {
                difference {                          //whack off bottom of sphere.
                        sphere { <0,9,0>,6 }
                        cylinder { <0,0,0>,<0,4,0>,6 }
                        }
                difference {                             //add base
                        cylinder { <0,1,0>,<0,5,0>,4 }
                        union {
                                torus { 4.5,.75 translate <0,2,0> }
                                torus { 4.5,.75 translate <0,3.5,0> }
                                }
                        }
                }
        union {
                union {
                        union {
                                sphere { <0,9,0>,5 }
                                cylinder { <0,10,0>,<0,16,0>,5.7}
                                texture { Geod
                                        scale .8
                                        rotate <0,45,0>
                                        finish { phong 1 ambient .5 reflection .05 }}
                                }
                        cylinder { <0,10,0>,<0,16,0>,6} 
                        }
                cylinder { <0,9,0>,<0,14,0>,3.8
                        }
                sphere { <0,12,2.5>,2 }
                }                        
} 
texture { Asteroid
        scale .8
        finish { phong 1 ambient .5 reflection .05 }}
}//End Mortar

#declare Pestle = object {
        union {
                sphere { <0,6,0>,2 }
                cone { <0,6,0>,2,<0,14,0>,.75 }
                rotate <0,0,38.5>
                translate <3,2,0>
                }//End Union
        texture { Geod finish { phong 1 ambient .5 reflection .05 }}
                } //End Pestle
       
#declare Rx = union {       
        object { Mortar }
        object { Pestle }
}

object { Rx 
  scale .125
  translate <7, -2, 7>
}

#declare Candle =
union{
lathe{
linear_spline 27,
<0.0000000000,0.0000000000>,
<7.240741E-02,3.003827E-02>,
<8.423334E-02,0.0392000000>,
<9.441235E-02,5.047037E-02>,
<0.1028877000,6.362963E-02>,
<0.1096667000,0.0783000000>,
<0.1147864000,9.422963E-02>,
<0.1184025000,0.1116704000>,
<0.1207000000,0.1310000000>,
<0.1218333000,0.1525333000>,
<0.1218333000,0.1763333000>,
<0.1207000000,0.2024000000>,
<0.1182444000,0.2312370000>,
<0.1135222000,0.2653630000>,
<0.1054000000,0.3078000000>,
<9.324814E-02,0.3600605000>,
<7.845185E-02 0.4176173000>,
<0.0629000000,0.4744333000>,
<4.822963E-02,0.5254210000>,
<3.507037E-02,0.5692901000>,
<0.0238000000,0.6057000000>,
<1.473333E-02,0.6344136000>,
<7.933334E-03,0.6556087000>,
<0.0034000000,0.6695666000>,
<1.007407E-03,0.6769086000>,
<1.259259E-04,0.6796135000>,
<0.0000000000,0.6799999000>
 texture{
  pigment{rgbt 1
 }
}
 interior{
 media{
 emission 1 
 scattering{1,.01}
 intervals 10 
 samples 1, 15
 confidence 0.9999 
 variance 1/1000 
 density {
 radial 
 turbulence .35
 color_map{
 [ 0 rgb<1.0,1.0,0.0>]
 [.1 rgb<1.0,.50,0.0>]
 [.5 rgb<1.0,.75,.25>]
 [.7 rgb<0.7,.45,0.0>]
 [ 1 rgb<1.0,.65,0.0>]
   }
  }
 }
}
 hollow
  scale<1.25,2,1.25>*3 
   translate y*1.25
}

intersection{
cone{y*-8,.75,y*1,.5 
 pigment{rgb<1,1,.97>}
  finish{ambient .5 diffuse .23}
}
sphere{<.05,1,0>,.5 inverse
 pigment{rgb 1}
  finish{ambient .5 diffuse .23}
 }
}

cylinder{y*.8,y*1.5,.1 
 pigment{rgb 0}
 }
}

object { Candle
  scale .25
  translate <8, 0, 6.5>
}

#declare Seiten=
   prism{linear_sweep
          linear_spline
          0, 13,
          16,
          <0, 1>,
          <0.5, 1.3>,
          <1, 1.4>,
          <1.5, 1.6>,
          <2.5, 2.0>,
          <4.5, 2.5>,
          <6.5, 2.8>,
          <9, 3>,
          <9.3, 2>,
          <9.4, 1>,
          <9.5, 0>,
          <1, 0>,
          <1, 0.2>,
          <0.8, 0.5>,
          <0.5, 0.8>,
          <0, 1>
          rotate -90*x
          texture{pigment{color White}}
          texture{pigment{image_map{tga "seiten.tga"
                                        interpolate 2}}
                                        scale <9,3,1>}
          rotate -90*x
          translate 13*y}

#declare Seite1=
   object{Seiten
          texture{pigment{image_map{tga "seite1.tga"
                                        interpolate 2
                                        once}}
                                        scale <7,12,1>
                                        translate <1,0.5,0>}}

#declare Seite2=
   object{Seiten
          texture{pigment{image_map{tga "seite2.tga"
                                        interpolate 2
                                        once}}
                                        scale <7,12,1>
                                        translate <1,0.5,0>}
          rotate 180*z
          translate 13*y}

#declare Einband=
  difference{
     union{
        box{<-10,-0.5,-0.5>, <0,0,13.5> rotate  10*z}
        box{<10,-.5,-0.5>, <0,0,13.5>  rotate -10*z}
        cylinder{<0,0.5,-0.5>, <0,0.5,13.5>, 2}}
     cylinder{<0,0.5,-3>, <0,0.5,21>, 1.5}
     box{<-10,0.001,-2>, <0,20,17> rotate  10*z}
     box{<10,0.001,-2>, <0,20,17>  rotate -10*z}
     box{<-10,0,-2>, <10,20,20>}

     texture{pigment{color Red}}}

#declare Book=
union{
  object{Seite1 rotate -10*y translate -0.25*x}
  object{Seite2 rotate  10*y translate 0.25*x}
  object{Einband rotate-90*x}

}

object { Book 
  scale .125
  rotate x*15
  rotate y*-30
  translate <-2.5, -1.5, 8>
}

object { beam
  scale <.25, .5, .25>
  texture { T_Wood9
    finish { 
      ambient .37
      diffuse .48
      roughness .73
      phong .273
      specular .536
    }
  } 
  translate <-2.75, -3, 8.5>
}  