// CaravelI.inc
// Definitions for a medieval style caravel ship.
// Robert J Becraft (castlewrks@aol.com)
// August, 2001
// (c) Copyright 2001, All Rights Reserved.
// This file expects "ships.inc" to have been included previously.
//

#declare TrimColor=texture{pigment{color Burlywood}}

#declare Hulla=intersection{
  union{
    sphere{<0,0,0> 4 scale <2,1,1> texture{ShipSide  scale .5}}
    
    cylinder{<0,-.2,0><0,-.1,0> 4.1 scale <2,1,1> texture{TrimColor}}
    cylinder{<0,-.3,0><0,-.35,0> 4.1 scale <2,1,1> texture{TrimColor}}
    cylinder{<0,-.45,0><0,-.48,0> 4.1 scale <2,1,1> texture{pigment{color Red}}}
    
    cylinder{<0,0,-.2><0,0,.2> 4+.35/2 scale <2,1,1> texture{T_Wood2 rotate<0,0,90>}}
  }
  box{<-13,-2.1,-4.1><13,0,4.1> texture{Decking scale 1}}
}
#declare FHull=intersection{
  union{
    sphere{<0,0,0> 4 scale <2,1,1> texture{ShipSide  scale .5}}
    cylinder{<0,0,-.2><0,0,.2> 4+.35/2 scale <2,1,1> texture{T_Wood2 rotate<0,0,90>}}
  }
  box{<4,-.5,-4.1><13,0,4.1> texture{Decking scale 1}}
}            

#declare MainDeckRail=difference{
  intersection{
    sphere{<0,0,0> 4 scale <2.2,1.2,1> texture{ShipSide  scale .5}}
    box{<-4,-1,-4.1><3,0,4.1> texture{ShipSide scale .5}}
  } // intersection
  sphere{<0,0,0> 3.9 scale <2.2,1.2,1> texture{ShipSide scale .5}}
 } // difference  
      
#declare MainDeckRailTop=difference{
  intersection{
    sphere{<0,0,0> 4 scale <2.2,1.2,1> }
    box{<-4,-.1,-4.1><3,0,4.1> }
  }
  sphere{<0,0,0> 3.9 scale <2.2,1.2,1> }
  texture{TrimColor}
}              
#declare FrontDeckRail=difference{
  intersection{
    sphere{<0,0,0> 4 scale <2,1.2,1> texture{ShipSide  scale .5}}
    box{<4,-1,-4.1><13,0,4.1> texture{ShipSide scale .5}}
  }
  sphere{<0,0,0> 3.9 scale <2,1.2,1> texture{ShipSide scale .5}}
  box{<4,-1,-.5><13,1,.5>}
}     
#declare FrontDeckRailTop=difference{
  intersection{
    sphere{<0,0,0> 4 scale <2,1.2,1> }
    box{<4,-.1,-4.1><13,0,4.1> }
  }
  sphere{<0,0,0> 3.9 scale <2,1.2,1> }
  box{<4,-1,-.5><13,1,.5>}
  texture{TrimColor}
}
#declare MShipsRibs=intersection{
   union{
     #declare R1=0;
     #while (R1<180)
       difference{
          cylinder{<-.07,0,0><.07,0,0> 3.9 }
          cylinder{<-.08,0,0><.08,0,0> 3.8 }
         rotate<0,R1,0>
        }
       #declare R1=R1+10;
     #end
     scale <2.2,1.2,1>
    }
    box{<-4,-1,-4.1><3,.15,4.1>}
  texture{T_Wood1 rotate<90,0,0> scale .25}  
}                        
#declare FShipsRibs=intersection{
   union{
     #declare R1=0;
     #while (R1<180)
       difference{
          cylinder{<-.065,0,0><.065,0,0> 3.9 }
          cylinder{<-.08,0,0><.08,0,0> 3.8 }
         rotate<0,R1,0>
        }
       #declare R1=R1+12;
     #end
     scale <2,1.2,1>
    }
    box{<4,-1,-4.1><8,.15,4.1>}
  texture{T_Wood1 rotate<90,0,0> scale .25}  
}         
#declare Windowa=union{
  box{<-.2,0,-.05><-.18,.75,.05>}
  box{<.2,0,-.05><.18,.75,.05>}
  box{<-.02,0,-.05><.02,.75,.05>}
  box{<-.2,.36,-.05><.2,.38,.05>}
  box{<-.2,0,-.05><.2,.05,.05>}
  box{<-.2,.70,-.05><.2,.75,.05>}
 texture{TrimColor}
}
#declare Window=union{

  union{  
    box{<-.05,0,-.65><.05,.75,.65>}
    box{<-.09,.3,-.35><.09,.45,.35>}
    box{<-.1,.75,-.65><.1,.85,.65>} // bottom of window
    box{<-.1,1.60,-.65><.1,1.70,.65>}
    box{<-.1,.85,-.26><.1,1.60,-.24>}
    box{<-.1,.85,.24><.1,1.6,.26>}
   texture{pigment{color Red}}
  }
  box{<-.07,.2,-.45><.07,.55,.45>} 
 
  object{Windowa rotate<0,90,0> translate<0,.85,-.4>}
  object{Windowa rotate<0,90,0> translate<0,.85,0>}
  object{Windowa rotate<0,90,0> translate<0,.85,.4>}
  
  texture{TrimColor}
}
#declare CWindow=union{
  box{<-.1,0,-2.70><.35,1.78,-2.60>}
  box{<-.1,0,2.60><.35,1.78,2.70>}
  box{<-.1,0,-.05><.1,1.78,.05>}   
  box{<-.1,0,-1.35><.1,1.78,-1.25>}
  box{<-.1,0,1.35><.1,1.78,1.25>}
  
  object{Window translate<0,0,-1.975>}
  object{Window translate<0,0,-.65>}
  object{Window translate<0,0,.65>}
  object{Window translate<0,0,1.975>}
      
 texture{T_Wood2 scale .25}
}
#declare CWall1=union{
  box{<-.1,0,-3.85><.15,1.78,-3.80>}
  box{<-.1,0,3.85><.15,1.78,3.80>}  
 texture{T_Wood2 rotate<90,0,0> scale .25}
}
#declare CWall2=union{
  box{<-.1,0,-3.45><.15,1.78,-3.40>}
  box{<-.1,0,3.45><.15,1.78,3.40>}  
 texture{T_Wood2 rotate<90,0,0> scale .25}
}  
#declare CDecking=union{ 
  #declare R1=-8.5;
  #declare SS=(3.9-2.75)/(abs(8.5-4)/.05);
  #declare Sf=0;
  #while (R1<-4)
    box{<R1,0,-2.75-SS*Sf><R1+.5,.025,2.75+SS*Sf>}
    #declare R1=R1+.05;
    #declare Sf=Sf+1;
  #end
//    box{<-8.5,0,-2.75><-7.5,.01,2.75>}  
//    box{<-7.5,0,-3><-7,.01,3>} 
//    box{<-7,0,-3.5><-6,.01,3.5>}     
//    box{<-6,0,-3.9><-4,.01,3.9>}
  texture{Decking scale .5}
}
#declare CrailBal=union{
  sphere{<0,0,0> .05}
  cylinder{<0,-.25,0><0,.25,0> .02}
  cone{<0,-.25,0>.02<0,-.1,0> .04}
  cone{<0,.1,0> .04 <0,.25,0> .02}
  texture{T_Wood8 rotate<90,0,0>}
}
#declare CPost=union{
  box{<-.065,-.1,-.065><.065,1.,.065>}
  sphere{<0,1.05,0> .065}
  texture{T_Wood8 scale .1 rotate<90,0,0>}
}
#declare Crail=union{
  object{CPost translate<0,0,-2.75>}
  object{CPost translate<0,0,2.75>}        
  object{CPost translate<0,0,-1.325>}
  object{CPost translate<0,0,1.325>}  
  object{CPost translate<0,0,0>}

  union{
    box{<-.05,.075,-2.75><.05,.1,2.75>}  // bottom
    box{<-.05,.6,-2.75><.05,.65,2.75>} // top
    #declare R1=-2.70;
    #while (R1<=2.70)
      object{CrailBal translate<0,.35,R1>}
      #declare R1=R1+.15;
    #end
    translate<0,.25,0>
  }  
}                   
#declare Crail2=union{
//  object{CPost translate<0,0,-2.75>}
//  object{CPost translate<0,0,2.75>}        
  object{CPost translate<0,0,-1.325>}
  object{CPost translate<0,0,1.325>}  
  object{CPost translate<0,0,0>}

  union{
    box{<-.05,.075,-1.325><.05,.1,1.325>}  // bottom
    box{<-.05,.6,-1.325><.05,.65,1.325>} // top
    #declare R1=-1.35;
    #while (R1<=1.35)
      object{CrailBal translate<0,.35,R1>}
      #declare R1=R1+.15;
    #end
   translate<0,.25,0>
  }
} 
#declare CHouse=  union{
  #declare R1=-8.5;
  #declare SS=(3.9-2.75)/(abs(8.5-4)/.25);
  #declare Sf=0;
  #while (R1<-4)
    box{<R1,0,-2.75-SS*Sf><R1+.5,.25,2.75+SS*Sf>}
    #declare R1=R1+.25;
    #declare Sf=Sf+1;
  #end
//    box{<-8.5,0,-2.75><-7.5,.25,2.75>}  
//    box{<-7.5,0,-3><-7,.25,3>} 
//    box{<-7,0,-3.5><-6,.25,3.5>}     
//    box{<-6,0,-3.9><-4,.25,3.9>}
 // texture{pigment{color White}}
  texture{T_Wood2 rotate<90,0,90> scale .25}
}
#declare CWallP=union{
  box{<-.065,0,-.065><.065,1.75,.065>}
} 
#declare CWallP2=union{
  box{<-.5,0,-.03><.5,1.75,.03>}
  box{<-.34,.3,-.05><.4,1.45,.05>}
 // texture{pigment{color White}}
  texture{T_Wood2 rotate<90,0,0> scale .25}
}
#declare CWall=union{
  object{CWallP translate<-1,0,0>}
  object{CWallP2 translate<-.5,0,0>}
  object{CWallP translate<1,0,0>}
  object{CWallP2 translate<.5,0,0>}
  object{CWallP translate<0,0,0>}
 //texture{pigment{color White}} 
 texture{T_Wood2 rotate<90,0,0> scale .1}
}
#declare CC=union{
  box{<-1,0,-.075><1,.25,.075>}
  box{<-1,.25,-.05><-.75,.5,.05>}
  box{<.75,.25,-.05><1,.5,.05>}
  box{<-1,.5,-.075><1,.75,.075>}
 //texture{pigment{color White}}
 texture{T_Wood2 rotate<90,0,0> scale .1}
}

#declare SW=.5;
#declare Stair_Tread=union{
   box{<-.15,0,-SW><.15,.03,SW> } 
   cylinder{<-.15,.015,-SW><-.15,.015,SW> .015 }
   
//   box{<-.05,.03,SW-.05><.35,.25,SW-.02> texture{T_Wood13 rotate<45,0,90>}}
//   box{<-.05,.03,-SW+.02><.35,.25,-SW+.05> texture{T_Wood13 rotate<45,0,90>}}

  texture{T_Wood13 scale .1 rotate<0,0,3>}
}
#declare Stair_Run=union{
   intersection{
     union{
       box{<-2.5,-.15,-SW+.02><.25,.15,-SW+.05> rotate<0,0,45> translate<0,0,0>} // sides
       box{<-2.5,-.15,SW-.05><.25,.15,SW-.02> rotate<0,0,45> translate<0,0,0>}
     }
     box{<-1.75,-1.75,-SW-.01><0,0,SW+.01>}  
     texture{T_Wood2 scale .25 rotate<0,90,0> rotate<0,0,56>}
   }
   
   #declare R1=-1.5;
   #while (R1<0)
      object{Stair_Tread translate<R1,R1,0>}
      #declare R1=R1+.25;
   #end
}
#declare DeckDoorFrame=union{
 difference{
   cylinder{<-.05,1.25,0><.05,1.25,0> .35}
   cylinder{<-.051,1.25,0><.051,1.25,0> .15}
   box{<-.051,.99,-.35><.051,1.25,.35>}
 }
 box{<-.05,0,-.35><.05,1.25,-.15>}
 box{<.05,0,.15><.05,1.25,.35>}
 texture{TrimColor}
}
#declare DeckDoor=union{
  box{<-.03,0,-.5><.03,1.75,.5>}
  object{DeckDoorFrame}
  texture{T_Wood2 scale .25 rotate<0,90,0>} 
}
#declare Wheel_Spoke=union{
       cylinder{<-.475,0,0><-.475,.6,0>,.03 rotate<0,0,0> texture{T_Wood13}}
       cone{<-.475,.6,0>,.03 <-.475,.8,0>,.04 rotate<0,0,0> texture{T_Wood13}}
       sphere{<-.475,.8,0>,.04 rotate<0,0,0> texture{T_Wood13}}
}
#declare Wheel=union{
    difference{
       cylinder{<-.55,1,0><-.415,1,0>.6 texture{T_Wood13}}
       cylinder{<-.551,1,0><-.4149,1,0>.52 texture{T_Wood13}}
    }
    #declare Count=0;
    #while (Count<360)
          object{Wheel_Spoke rotate<Count,0,0> translate<0,1,0>}
//        cylinder{<-.475,1,0><-.475,1.6,0>,.03 rotate<Count,0,0> texture{T_Wood13}}
//        cone{<-.475,1.6,0>,.03 <-.475,1.8,0>,.04 rotate<Count,0,0> texture{T_Wood13}}
//        sphere{<-.475,1.8,0>,.04 rotate<Count,0,0> texture{T_Wood13}}
        #declare Count=Count+45;
    #end
}
#declare Ships_Wheel=union{
    box{<-.2,0,-.3><.2,1,.3> texture{T_Wood13}}
    cylinder{<-.2,1,0><.2,1,0>,.3 texture{T_Wood13}}
    cylinder{<-.6,1,0><.3,1,0>,.05 texture{T_Wood13}}
    cylinder{<-.55,1,0><.40,1,0>,.08 texture{T_Wood13}}
    object{Wheel}
}
#declare MMast=union{
  cone{<0,-.75,0> .2 <0,14,0> .15}
  cone{<0,0,0> .205 <0,.2,0> .205 texture{Bright_Bronze}}
  cone{<0,10,0> .20 <0,10.2,0> .20 texture{Bright_Bronze}}
  cone{<0,13.8,0> .19 <0,14,0> .19 texture{Bright_Bronze}}
  cone{<0,5,0> .204 <0,5.2,0> .204 texture{Bright_Bronze}}
}
#declare TMast=union{
  cone{<0,-.75,0> .16 <0,9,0> .075}
  cone{<0,0,0> .165 <0,.2,0> .165 texture{Bright_Bronze}}
  cone{<0,8.8,0> .08 <0,9,0> .08 texture{Bright_Bronze}}
  cone{<0,5,0> .16 <0,5.2,0> .16 texture{Bright_Bronze}}
}  
#declare TIIMast=union{
  cone{<0,-.75,0> .14 <0,6,0> .075}
  cone{<0,0,0> .165 <0,.2,0> .145 texture{Bright_Bronze}}
  cone{<0,5.8,0> .08 <0,6,0> .08 texture{Bright_Bronze}}
  cone{<0,3.2,0> .135 <0,3,0> .135 texture{Bright_Bronze}}
}        
#declare BNTack=union{               
  union{
    cylinder{<0,0,-.01><0,0,.01> .02}
    cylinder{<0,0,-.01><0,0,-.015> .03}
    cylinder{<0,0,.01><0,0,.015> .03}
    cylinder{<0,0,-.032><0,0,.032> .005}
    translate<0,.02,0>
   texture{pigment{color Gray40}}
  }
  difference{
    union{
      box{<-.015,-.05,-.03><.015,.05,.03>}
      cylinder{<0,-.05,-.03><0,-.05,.03>.015}
      cylinder{<0,.05,-.03><0,.05,.03> .015}
    }
    cylinder{<-.021,.03,0><.021,.03,0> .025 } 
    box{<-.021,.01,-.025><.021,.03,.025> }
    cylinder{<-.021,.01,0><.021,.01,0> .025}      
    cylinder{<-.021,-.08,0><.021,-.08,0> .02 scale <1,.55,1.1>}    
  }
  torus{.03,.005 rotate<90,0,0> translate<0,.02,0> texture{Rope scale .025}}            // rope through pulley
  
  torus{.015,.005 rotate<90,0,0> scale<1,1.3,1> translate<0,-.065,0> texture{Rope scale .025}} // knot on pulley   
  torus{.01,.005 rotate<90,45,0> scale<1,1,1> translate<0,-.09,0> texture{Rope rotate<0,0,45> scale .025}}
  cone{<0,-.09,0> .005 <.03,-.12,.02> .005  texture{Rope rotate<0,0,45> scale .025}}
  
  texture{T_Wood1 rotate<90,0,0>scale .01}
}

#declare BNTII=union{
  object{BNTack}
  cone{<.025,.02,.01>.005 <.025,.47,.01> .005 texture{Rope rotate<0,0,45> scale .025}}     
  cone{<.025,.02,-.01>.005 <.025,.47,-.01> .005 texture{Rope rotate<0,0,45> scale .025}}           
  cone{<-.025,.02,.01>.005 <-.025,.47,.01> .005 texture{Rope rotate<0,0,45> scale .025}}   
  object{BNTack rotate<0,0,180> translate<0,.5,0>}
  scale 2
}

#declare BNTTieMM=union{
  object{BNTII}
  cone{<0,1,0> .01 <0,12.75,0> .01 texture{Rope rotate<0,0,45> scale .025}}
  cone{<0,0,0>.01<0,-1.75,0> .01 texture{Rope rotate<0,0,45> scale .025}}
  translate<0,-12.75,0> // position for rotating into position
}

#declare MMastRope=union{
  object{MMast}
  object{BNTTieMM rotate<0,10,0> rotate<15,0,5> translate<0,14,0>}
  object{BNTTieMM rotate<0,90,0> rotate<15,0,-5> translate<0,14,0>}  
  object{BNTTieMM rotate<0,50,0> rotate<-15,0,5> translate<0,14,0>}
  object{BNTTieMM rotate<0,0,0>  rotate<-15,0,-5> translate<0,14,0>}  

  object{BNTTieMM rotate<0,10,0> rotate<-15,0,2.5> translate<0,14,0>}
  object{BNTTieMM rotate<0,90,0> rotate<-15,0,-2.5> translate<0,14,0>}  
  object{BNTTieMM rotate<0,50,0> rotate<15,0,2.5> translate<0,14,0>}
  object{BNTTieMM rotate<0,0,0>  rotate<15,0,-2.5> translate<0,14,0>} 
  
  torus{.186,.01 rotate<0,0,3> translate<0,13.5,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.186,.01 rotate<0,0,-3> translate<0,13.53,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.186,.01 rotate<0,0,0> translate<0,13.49,0> texture{Rope rotate<0,0,45> scale .025}}  
  torus{.19,.01 rotate<0,0,6> translate<0,13.54,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.19,.01 rotate<0,0,-6> translate<0,13.51,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.19,.01 rotate<0,0,2> translate<0,13.45,0> texture{Rope rotate<0,0,45> scale .025}}     
}
   
#declare BNTTieTM=union{ // 2nd mast rope and tackle
  object{BNTII}
  cone{<0,1,0> .01 <0,7.5,0> .01 texture{Rope rotate<0,0,45> scale .025}}
  cone{<0,0,0>.01<0,-1.5,0> .01 texture{Rope rotate<0,0,45> scale .025}}
  translate<0,-8,0> // position for rotating into position
}

#declare TMastRope=union{
  object{TMast}
  object{BNTTieTM rotate<0,10,0> rotate<22,0,5> translate<0,9,0>}
  object{BNTTieTM rotate<0,90,0> rotate<22,0,-5> translate<0,9,0>}  
  object{BNTTieTM rotate<0,50,0> rotate<-22,0,5> translate<0,9,0>}
  object{BNTTieTM rotate<0,0,0>  rotate<-22,0,-5> translate<0,9,0>}  

  object{BNTTieTM rotate<0,10,0> rotate<-22,0,-2> translate<0,9,0>}
  object{BNTTieTM rotate<0,0,0>  rotate<22,0,-2> translate<0,9,0>} 
  
  torus{.086,.01 rotate<0,0,3> translate<0,8.5,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.086,.01 rotate<0,0,-3> translate<0,8.53,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.086,.01 rotate<0,0,0> translate<0,8.49,0> texture{Rope rotate<0,0,45> scale .025}}  
  torus{.09,.01 rotate<0,0,6> translate<0,8.54,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.09,.01 rotate<0,0,-6> translate<0,8.51,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.09,.01 rotate<0,0,2> translate<0,8.45,0> texture{Rope rotate<0,0,45> scale .025}}     
}
#declare BNTTieTMII=union{ // 2nd mast rope and tackle
  object{BNTII}
  cone{<0,1,0> .01 <0,5,0> .01 texture{Rope rotate<0,0,45> scale .025}}
  cone{<0,0,0>.01<0,-1.5,0> .01 texture{Rope rotate<0,0,45> scale .025}}
  translate<0,-5,0> // position for rotating into position
}

#declare TIIMastRope=union{
  object{TIIMast}
  object{BNTTieTMII rotate<0,10,0> rotate<25,0,2.5> translate<0,6,0>}
  object{BNTTieTMII rotate<0,90,0> rotate<25,0,-2.5> translate<0,6,0>}  
  object{BNTTieTMII rotate<0,50,0> rotate<-25,0,2.5> translate<0,6,0>}
  object{BNTTieTMII rotate<0,0,0>  rotate<-25,0,-2.5> translate<0,6,0>}  
  
  torus{.086,.01 rotate<0,0,3> translate<0,5.5,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.086,.01 rotate<0,0,-3> translate<0,5.53,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.086,.01 rotate<0,0,0> translate<0,5.49,0> texture{Rope rotate<0,0,45> scale .025}}  
  torus{.09,.01 rotate<0,0,6> translate<0,5.54,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.09,.01 rotate<0,0,-6> translate<0,5.51,0> texture{Rope rotate<0,0,45> scale .025}}
  torus{.09,.01 rotate<0,0,2> translate<0,5.45,0> texture{Rope rotate<0,0,45> scale .025}}     
}
#declare RearMast=union{
  cone{<0,0,0>.05 <-3,.23,0> .03}  
  cone{<0,-.5,0> .01 <-3,.23,0> .01 texture{Rope rotate<0,0,45> scale .025}}
}

#declare TMIIBrace=union{
  cone{<0,0,0>.05 <4,0,0>.03}
  cone{<0,0,0>.05 <-4,0,0> .03}
  #declare R1=-1.5;
  #while (R1<=1.5)
    cylinder{<R1,0,0><R1+.025,0,0> .051 texture{Bright_Bronze}}
    #declare R1=R1+.25;
  #end    
}      
#declare TMBrace=union{
  cone{<-2,0,0>.065 <6,0,0>.04}
  cone{<2,.065,0>.065 <-6,.065,0> .04}
  #declare R1=-1.7;
  #while (R1<=1.7)
    cylinder{<R1,0,0><R1+.025,0,0> .0651 texture{Bright_Bronze}}
    cylinder{<R1,.065,0><R1+.025,.065,0>.0651 texture{Bright_Bronze}}
    #declare R1=R1+.25;
  #end    
}

#declare MMBrace=union{
  cone{<-3,0,0>.075 <10,0,0>.05}
  cone{<3,.075,0>.075 <-10,.075,0> .05}
  #declare R1=-2.7;
  #while (R1<=2.7)
    cylinder{<R1,0,0><R1+.025,0,0> .0751 texture{Bright_Bronze}}
    cylinder{<R1,.075,0><R1+.025,.075,0>.0751  texture{Bright_Bronze}}
    #declare R1=R1+.25;
  #end    
}
#declare CNWeave=intersection{
  difference{
     torus{.05,.025}
     cylinder{<0,-.026,0><0,.026,0> .0255}
    translate<-.05,0,0>
  } 
//  torus{.35,.025 translate<-.35,0,0>}
  //cylinder{<-.3,-.025,0><-.3,.025,0> .3}
  box{<-.008,-.025,-.04><.058,.025,.04>}
}  
  
#declare CrowsNest=union{
  torus{.55,.05 translate<0,1.25,0>}
  #declare R1=0;
  #while (R1<360)
    #declare R2=.035;
    #while (R2<1.2)
      object{CNWeave scale<1,1,.75+(R2/1.25)/2> translate<.33+(.22*(R2/1.25)),R2-.035,0> rotate<0,R1,0>}
      object{CNWeave scale<1,1,.75+(R2/1.25)/2> translate<.34+(.22*(R2/1.25)),R2+.035,0> rotate<0,R1+6,0>}
      #declare R2=R2+.14;
    #end
    cylinder{<.35,0,0><.55,1.25,0> .015 rotate<0,R1+6,0> texture{T_Wood3 scale .25 rotate<90,0,0>}} 
    cylinder{<.35,0,0><.55,1.25,0> .015 rotate<0,R1,0> texture{T_Wood3 scale .25 rotate<90,0,0>}}
    torus{.05,.015 rotate<90,0,0> translate<.35,0,0> rotate<0,R1,0>}
    torus{.05,.015 rotate<90,0,0> translate<.35,0,0> rotate<0,R1+6,0>}  
    torus{.05,.015 rotate<90,0,0> translate<.55,1.25,0> rotate<0,R1,0>}
    torus{.05,.015 rotate<90,0,0> translate<.55,1.25,0> rotate<0,R1+6,0>}    
    #declare R1=R1+12;
  #end
//  difference{
//    cone{<0,0,0> .35 <0,1.25,0> .5}
//    cone{<0,.02,0> .03 <0,1.251,0> .45}
//  }
  torus{.35,.05}
  scale<.75,1,1>
  texture{T_Wood3 scale .25}
}

//---------------------------- put it all together...  
#declare CaravelI=union{
  object{Hulla}
  
  object{MMastRope rotate<0,0,0> translate<1,0,0>} 
  object{MMBrace rotate<0,0,-50> translate<1,10.5,.14>}
  object{CrowsNest translate<1-.35,13,0>}
  
  object{TMastRope rotate<0,0,0> translate<-5,1.75,0>}
  object{TMBrace rotate<0,0,-67> translate<-5,8.5,.12>}
    
  object{TIIMastRope rotate<0,0,0> translate<-8.5,1.75,0>}
  object{TMIIBrace rotate<0,0,-66> translate<-8.5,6.75,.12>}
  
  object{RearMast translate<-9,1.6,0>}
  
  object{FHull translate<.1,.5,0>}
  object{FHull translate<.2,1,0>}
  
  object{MainDeckRail translate<0,.8,0>}
  object{MainDeckRailTop translate<0,.9,0>}
  object{MShipsRibs translate<0,.8,0> }
    
  object{FrontDeckRail translate<.3,1.8,0>}
  object{FrontDeckRailTop translate<.3,1.9,0>} 
  object{FShipsRibs translate<.3,1.9,0>}
  
  box{<-.25,-1.5,-.15><.35,1.5,.15> rotate<0,0,-15> translate<8.2,1,0> 
 //   texture{pigment{color Red}}
    texture{T_Wood2 scale .25}
    } 
  
  object{CHouse}
  object{CWindow rotate<0,0,15> translate<-8.45,0,0>}  
  object{Window rotate<0,90,0> rotate<0,-15,0> translate<-7.9,0,2.95>}
  object{Window rotate<0,90,0> rotate<0,15,0> translate<-7.9,0,-2.95>}  
  object{CWall rotate<0,-15,0> translate<-6.25,0,3.3>}
  object{CWall rotate<0,15,0> translate<-6.25,0,-3.3>}   
  object{CWall rotate<0,-10,0> translate<-4.75,0,3.65>}
  object{CWall rotate<0,10,0> translate<-4.75,0,-3.65>}
  
  object{CWall rotate<0,90,0> translate<-4,0,-3>}
  object{DeckDoor translate<-4,0,-1.5>} 
  object{CWall rotate<0,90,0> translate<-4,0,3>}    
  object{DeckDoor translate<-4,0,1.5>}
  object{CWall rotate<0,90,0> translate<-4,0,0>}
  
  box{<-4,1.65,-2.8><-3.9,1.8,2.8> texture{T_Wood2 scale .25}}
  #declare R1=-2.65;
  #while (R1<=2.65)
     torus{.08,.025 rotate<0,0,90> translate<-3.9,1.725,R1>} // texture{pigment{color Yellow}}}
     sphere{<0,0,0>.025 translate<-3.9,1.725,R1> texture{pigment{color Red}}}
     #declare R1=R1+.2;
  #end
  
//  object{CWall1 rotate<0,0,15> translate<-4.2,0,0>} // front of poop deck cabins
//  object{CWall1 rotate<0,0,15> translate<-5.8,0,0>}
//  object{CWall2 rotate<0,0,15> translate<-6.2,0,0>}
//  object{CWall2 rotate<0,0,15> translate<-6.8,0,0>}
 
  object{Stair_Run rotate<0,180,0> translate<-4.1,1.75,3.1>}
  object{Stair_Run rotate<0,180,0> translate<-4.1,1.75,-3.1>}
  object{Stair_Run rotate<0,0,0> translate<4.1,1,0>}
    
  object{CHouse translate<-.45,1.5,0>} 
  object{CDecking translate<-.45,1.75,0>}
  object{Crail translate<-8.9,1.75,0>}    // back railing  
  object{Crail translate<-3.95,1.75,0>}    // front railing  
  object{Crail2 rotate<0,90,0> rotate<0,15,0> translate<-7,1.75,-3.2>}
  object{Crail2 rotate<0,90,0> rotate<0,-15,0> translate<-7,1.75,3.2>}  
  object{CC rotate<0,10,0> translate<-4.75,1.6,-3.78>}
  object{CC rotate<0,-10,0> translate<-4.75,1.6,3.78>}
  
  object{Ships_Wheel translate<-5.5,1.75,0>}
  
//  box{<-8,1,-3><-6,1.01,3> texture{Decking}}       
//  box{<-6,1,-4><-4,1.01,4> texture{Decking}}

  texture{TrimColor} 
}

#declare RearMastSail=union{
  #declare R1=-3.9;
  #while (R1<=3.9)
    triangle{<R1,.03,0><R1-.1,-.35,0><R1+.1,-.35,0>}
    #declare R1=R1+.2;
  #end
//  union{
  #declare R1=-.35;
  #while (R1>=-3)
    triangle{<0,R1,.01><.45,R1,.025><.45,R1+.15,.025>}
    triangle{<.45,R1,.025><0,R1+.15,.025><0,R1,.01>}
    #declare R1=R1-.2;
  #end
  triangle{<0,-.35,.01><.2,-.35,.01><0,-3,.01>}
  triangle{<.2,-.35,.01><0,-3,.01><.2,-3.1,.01>}
//  cylinder{<0,0,0><0,-3,0> .1}  
//  texture{pigment{color Red}}
//  }
  triangle{<-4,-.35,0><4,-.35,0><3.15,-5,0>}
}

#declare CaravelISail=union{
  object{CaravelI}
  object{RearMastSail rotate<0,0,-66> translate<-8.5,6.75,.12> 
         texture{  pigment{color Wheat}
                   normal{bozo .3 scale<1,1,1> turbulence .5}
                }
        }
}    