// dragonI.inc
// Definitions for a CSG Dragon.
// Robert J Becraft (castlewrks@aol.com)
// August, 2001
// (c) Copyright 2001, All Rights Reserved.
// 
//

#declare Crackle2 =
 pigment { crackle
  color_map {
             [.025 DarkGreen]
             [.085 GreenCopper]
             [.10 Copper ] //Gold] //Goldenrod]
             [.950 LightGray]
             [1.0 DarkBrown]
  }
 }

#declare Crackle_in_Crackle2 =
 texture {
  pigment { crackle
   pigment_map {
                 [.1 Crackle2          ]
                 [.1 Crackle2 scale .25]
  }
 }
} 
 
//-------------- CSGs

#declare DragonEye=difference{                    
  sphere{<0,0,0> .05 texture{pigment{color White}}}
  cylinder{<-.1,0,0><0,0,0> .02}
}     
#declare DragonNostrel=difference{
  sphere{<0,0,0> .015}
  cylinder{<-.15,-.015,0><0,0,0> .005}
  cylinder{<-.05,0,0><0,0,0> .015 scale <1,.125,1>} 
  scale<3,1,1>
}
#declare DragonEar=difference{
  cone{<0,0,0> .05 <0,.15,0> .01}
  cone{<-.01,0,0>.045 <-.1,.18,0> .025}
}
#declare DragonMoutha=union{
  intersection{
    sphere{<0,0,0>.1}
    box{<-.11,-.11,-.11><.11,0,.11>}
   scale<2,.75,1>
  }
  union{  
    #declare R1=180;
    #while (R1<=360)
       cone{<0,0,0> .0075 <0,.025,.0005> .0005 scale <.5,1,1> 
            translate<0,0,.09> rotate<0,R1,0>
            texture{pigment{color White}}
            }
       #declare R1=R1+7;
    #end
   scale <2,1,.8>      
  }
}
#declare DragonMouth=union{
   object{DragonMoutha}
   object{DragonMoutha rotate<180,0,0> rotate<0,0,-15> translate<0,.01,0>}
   rotate<0,0,20>
}
#declare DragonNeck=union{ 
   sphere{<-.3,.15,0> .15}
   cone{<-.3,.15,0> .15 <-.15,-.15,0> .18 }
   sphere{<-.15,-.15,0> .18}
   cone{<-.15,-.15,0> .18 <.25,-.4,0> .25}
//   sphere{<.25,0,0> .22}
//   cone{<.25,0,0> .22 <.45,-.2,0> .23}
//   sphere{<.45,-.2,0> .23}
//   cone{<.45,-.2,0> .23 <.50,-.4,0> .25}
   sphere{<.25,-.4,0> .25}
   cone{<.25,-.4,0> .25 <.8,-.85,0> .27}
   sphere{<.8,-.85,0> .35}
   
}
#declare DragonFinger=union{
  sphere{<0,0,0> .04}
  cone{<0,0,0> .04 <-.1,0,0> .035}
  sphere{<-.1,0,0> .035}
  cone{<-.1,0,0> .035 <-.15,0,.1> .025}
  sphere{<-.15,0,.1> .025}
}
#declare DragonLeftHand=union{
  sphere{<0,0,0> .1 scale<1.2,1,.25>}
  sphere{<-.1,0,0> .02}

  object{DragonFinger translate<-.1,0,.015>}
  object{DragonFinger  rotate<0,0,15> translate<-.1,-.05,.015>}
  object{DragonFinger  rotate<0,0,-15> translate<-.1,.05,.015>} 
  object{DragonFinger scale 1 rotate<0,0,-80> translate<0,-.025,.015>} 
} 
#declare DragonRightHand=union{
  sphere{<0,0,0> .1 scale<1.2,1,.25>}
  sphere{<-.1,0,0> .02}

  object{DragonFinger translate<-.1,0,.015>}
  object{DragonFinger  rotate<0,0,15> translate<-.1,-.05,.015>}
  object{DragonFinger  rotate<0,0,-15> translate<-.1,.05,.015>} 
  object{DragonFinger scale 1 rotate<0,0,80> translate<0,.025,.015>} 
}   

#declare DragonLeftArm=union{
  sphere{<0,0,.20> .15}
  cone{<0,0,.20> .15 <0,-.5,0> .1}
  sphere{<0,-.5,0> .1} 
  sphere{<0,-.55,0> .1}
  cone{<0,-.55,0> .1 <-.5,-.55,0> .08}
  sphere{<-.5,-.55,0> .08}

  object{DragonLeftHand rotate<80,0,0> translate<-.625,-.525,0>}  
  
}                    
#declare DragonRightArm=union{
  sphere{<0,0,-.20> .15}
  cone{<0,0,-.20> .15 <0,-.5,0> .1}
  sphere{<0,-.5,0> .1} 
  sphere{<0,-.55,0> .1}
  cone{<0,-.55,0> .1 <-.5,-.55,0> .08}
  sphere{<-.5,-.55,0> .08}

  object{DragonRightHand rotate<80,0,0> translate<-.625,-.525,0>}  
  
}
#declare DragonToe=union{
  sphere{<0,0,0> .05}
  cone{<0,0,0> .05 <-.1,0,0> .06}
  sphere{<-.1,0,0> .06}
}   
#declare DragonFoota=union{
  intersection{
    sphere{<0,0,0> .25 scale <3,.5,.5> }
    box{<-1,-.1,-.25><0,.25,.25>}
  }
  sphere{<0,0,0> .2}
  sphere{<-.75,0,0> .051} 
  
  object{DragonToe rotate<0,0,-15> translate<-.75,0,0>}
}  
  
#declare DragonFoot=union{
  union{     
    sphere{<.1,.4,0> .25}
    cone{<0,0,0> .2 <.1,.4,0> .25}
    sphere{<0,0,0> .25}
    scale<1,1,.8>
  }
  object{DragonFoota rotate<0,6,15> translate<-.2,-.06,.05>}   
  object{DragonFoota rotate<0,0,15> translate<-.2,-.05,0>}
  object{DragonFoota rotate<0,-6,15> translate<-.2,-.06,-.05>} 
  
  sphere{<0,0,0> .1 scale <2,1,1> rotate<0,0,-15> translate<.2,-.1,0>}   
}
  

#declare DragonLeg=union{
  sphere{<0,0,0> .35 scale<1,2.5,.75> rotate<0,0,45>}
  sphere{<0,0,0> .35 translate<.45,-.350,0>} 
  sphere{<0,0,0> .25 translate<-.5,.350,0>} // kneecap 
  cone{<-.5,.35,0> .25 <-.3,-.6,0> .2}
  sphere{<-.3,-.61,0> .2}
  
  object{DragonFoot translate<-.35,-.91,0>}
  
}

#declare DragonBody=union{
   sphere{<1.2,-1.05,0> .55 scale <1,1.2,1>}
   sphere{<1.3,-1.2,0> .55 scale <1,1.2,1>} // belly 
   sphere{<2,-2,0> 1 scale <.6,.8,.45> translate<.25,0,.2>}
   sphere{<2,-2,0> 1 scale <.6,.8,.45> translate<.25,0,-.2>}
   sphere{<0,0,0> .5 scale <1,.8,1.2> translate<1.8,-1.5,0>} 
   sphere{<0,0,0> .5 scale <1,.8,1.2> translate<1.9,-1.75,0>}     
   sphere{<0,0,0> .5 scale <1,.8,1.1> translate<2,-2,0>}  // begin tailbone
}

#declare DragonTailSeg=union{
  sphere{<0,0,0> .08}
  cone{<0,0,0> .08 <.2,0,0> .06}
  sphere{<.2,0,0> .06}
}
#declare DragonTailSegment=union{
  object{DragonTailSeg scale <1,2,1> rotate<0,0,30> translate<0,0,0>}
  object{DragonTailSeg scale <1,2,1> rotate<-60,0,30> translate<0,-.05,0>}
  object{DragonTailSeg scale <1,2,1> rotate<60,0,30> translate<0,-.05,0>}  
}
#declare DragonTail=union{
   object{DragonTailSegment}
   object{DragonTailSegment scale 1.00 rotate<0,0,0> translate<.25,.10,0>}
   object{DragonTailSegment scale .95  rotate<0,0,0> translate<.5,.20,0>}  
   object{DragonTailSegment scale .9  rotate<0,0,0> translate<.75,.30,0>}     
   object{DragonTailSegment scale .85  rotate<0,0,0> translate<1.,.40,0>} 
   object{DragonTailSegment scale .8  rotate<0,0,0> translate<1.2,.50,0>}        
   object{DragonTailSegment scale .75  rotate<0,0,10> translate<1.4,.60,0>}    
   object{DragonTailSegment scale .7  rotate<0,0,20> translate<1.55,.75,0>}    
   object{DragonTailSegment scale .65  rotate<0,0,30> translate<1.65,.85,0>}  
   object{DragonTailSegment scale .55  rotate<0,0,40> translate<1.75,.85,0>}       
   object{DragonTailSegment scale .5  rotate<0,0,50> translate<1.8,.9,0>}    
   object{DragonTailSegment scale .45  rotate<0,0,60> translate<1.85,1,0>}
   sphere{<1.85,1.1,0> .075}
   cone{<1.85,1.1,0> .075 <1.5,1.6,-.25> .05}
   sphere{<1.5,1.6,-.25> .05}
   cone{<1.5,1.6,-.25> .05 <1.3,1.8,.25> .03}    
   
//  sphere{<0,0,0> .25 scale<1.1,.9,.9>}
//  sphere{<0,0,0> .24 scale<1.1,.9,.9> translate<.2,.15,0>}
//  sphere{<0,0,0> .23 scale<1.1,.9,.9> translate<.4,.25,0>}
//  sphere{<0,0,0> .22 scale<1.1,.9,.9> translate<.6,.35,0>}
}
#declare DragonHead=union{
   sphere{<-.1,-.05,0> .075}
   sphere{<-.2,-.05,0> .1}  // head
   
   object{DragonEar rotate<-30,0,0> translate<-.15,.025,-.05>} // left ear
   object{DragonEar rotate<30,0,0> translate<-.15,.025,.05>} // right ear
   
   object{DragonEye translate<-.25,.028,-.05>} // left eye
   sphere{<0,0,0> .07 scale<1,.75,1> translate<-.2,.028,-.05>}
   
   object{DragonEye translate<-.25,.028,.05>}  // right eye
   sphere{<0,0,0> .07 scale<1,.75,1> translate<-.2,.028,.05>}
      
   //sphere{<-.45,-.05,0> .025} // nose
   object{DragonNostrel translate<-.42,-.05,.035>}
   object{DragonNostrel translate<-.42,-.05,-.035>}
   object{DragonMouth translate<-.25,-.06,0>} 
}    

#declare Dragon=union{

// Head
   object{DragonHead rotate<0,-30,20> translate<0,.15,0> scale 2.5}
   object{DragonNeck}
  
   object{DragonNeck}
// body begin
   object{DragonLeftArm translate<.75,-.85,-.45>}
   object{DragonRightArm translate<.75,-.85,.45>}

   object{DragonBody}
   
   object{DragonLeg rotate<0,-30,0> translate<1.65,-1.75,-.43>}
   object{DragonLeg rotate<0,30,0> translate<1.65,-1.75,.43>}  

   object{DragonTail rotate<0,0,30> translate<2.15,-2.25,0>} 

}

//object{Dragon rotate<0,-45,0> texture{Crackle_in_Crackle2 scale .05} }

//object{DragonTail rotate<0,0,0> texture{Crackle_in_Crackle2 scale .05} }