// FantPart.inc
// completed parts of fantasy.pov
//
// Textures
#declare Rusty_Aluminum =
texture{Brushed_Aluminum}
texture { 
    pigment {
        granite
        color_map {
            [0.0 rgbf <0.89, 0.51, 0.28, .2  >]
            [0.4 rgbf <0.70, 0.13, 0.00, .75 >]
            [0.5 rgbf <0.69, 0.41, 0.08, .4  >]
            [0.6 rgbf <0.49, 0.31, 0.28, .9  >]
            [1.0 rgbf <0.89, 0.51, 0.28, .4  >]
        }
    }
    finish { ambient 0.2 diffuse 0.4 }
}
#declare BlackText=texture{pigment{color Black}}
#declare FloorText=texture{T_Wood13 scale .15 rotate<0,0,1>
       normal{bozo .1 scale<.015,.015,.015> turbulence .05}    
}   
#declare WallText=texture{T_Wood10 scale .15 rotate<0,90,1>
       normal{bozo .1 scale<.015,.015,.015> turbulence .05}    
}
#declare Wood_Decking=texture{
       gradient x
       texture_map{
         [0.0 FloorText]
         [0.85 FloorText]
         [1.0 BlackText]
       }
       scale .35
       rotate<0,90,0>
       translate<0,0,-20>

}

#declare WoodSide101=texture{
       gradient y
       texture_map{
         [0.0 WallText]
         [0.85 WallText]
         [1.0 BlackText]
       }
       scale .25
       rotate<0,0,90>    
       rotate<0,45,0>
       translate<10,0,0>
}
                       
#ifndef(NoCastle)                       
// Door for tower minuret/cap
#declare Door=union{
  difference{
    box{<-.75,0,-.2><.75,3,.2>}
    cylinder{<0,2,-.21><0,2,.21> .5}
    box{<-.5,0,-.21><.5,2,.21>}
  }              
  union{
    cylinder{<0,2,-.1><0,2,.1> .5}
    box{<-.5,0,-.1><.5,2,.1>}
    texture{T_Wood18 scale .05}
  }
}
        
#declare Cap=union{
  cone{<0,-6,0> 0 <0,-1,0> 1.25}
  cylinder{<0,-1,0><0,4,0> 1.25}
  cylinder{<0,3.9,0> <0,4,0> 1.3}
  
  cone{<0,4,0> 1.30 <0,8,0> 0 texture{Bright_Bronze}}
  
  object{Door translate<0,0,-1.25>}
}                       

// Tower rim/crenalation I
#declare T1a=difference{
   union{
     cylinder{<0,-1,0><0,-.6,0> 4.4}
     cylinder{<0,-.6,0><0,-.2,0> 4.6}
     cylinder{<0,-.2,0><0,.2,0> 4.8}
     cylinder{<0,.2,0><0,.4,0> 4.9}                  
     cylinder{<0,.4,0><0,4,0> 5}
     cylinder{<0,1.5,0><0,1.75,0> 5.2}
     cylinder{<0,1.75,0><0,1.85,0> 5.3}
     cylinder{<0,1.85,0><0,2,0> 5.2}
   }
   
   cylinder{<0,-.1,0><0,4.1,0> 4}
   #declare R1=0;
   #while (R1<180)
     cylinder{<0,0,-5.1><0,0,5.1>1 rotate<0,R1,0>}
     box{<-.5,3,-5.1><.5,4.1,5.1> rotate<0,R1,0>}
     box{<-1,-1.1,-5.1><1,0,5.1> rotate<0,R1,0>}
     #declare R1=R1+30;
   #end
}

// Tower rim/crenalation II
#declare T1b=union{
  difference{
   union{
     cylinder{<0,-1,0><0,-.6,0> 5.4}
     cylinder{<0,-.6,0><0,-.2,0> 5.6}
     cylinder{<0,-.2,0><0,.2,0> 5.7}
     cylinder{<0,.2,0><0,.4,0> 5.8}                  
     cylinder{<0,.4,0><0,4,0> 6}
     cylinder{<0,1.5,0><0,1.75,0> 6.2}
     cylinder{<0,1.75,0><0,1.85,0> 6.3}
     cylinder{<0,1.85,0><0,2,0> 6.2}
   }
   
   cylinder{<0,-.1,0><0,4.1,0> 5.5}
   #declare R1=0;
   #while (R1<180)
     cylinder{<0,0,-6.1><0,0,6.1>1 rotate<0,R1,0>}
     box{<-.5,3,-6.1><.5,4.1,6.1> rotate<0,R1,0>}
     box{<-1,-1.1,-6.1><1,0,6.1> rotate<0,R1,0>}
     #declare R1=R1+30;
   #end
  }// difference
  cylinder{<0,3,0><0,3.2,0> 5} // floor 
}

#declare CapDorm=union{
  difference{
    cylinder{<0,0,0><1.2,0,0> .5}
    cylinder{<0,0,0><1.3,0,0> .45}
   texture{Bright_Bronze}
  }
  cylinder{<0,0,0><.9,0,0> .45}
}
#declare TowerFpole=union{
  torus{.5,.05}
  torus{.5,.05 translate<0,1,0>}
  cylinder{<0,-2,0><0,1,0> .05 translate<.5,0,0>}
  cylinder{<0,-2,0><0,1,0> .05 translate<-.5,0,0>}
  cylinder{<0,-2,0><0,1,0> .05 translate<0,0,.5>}
  cylinder{<0,-2,0><0,1,0> .05 translate<0,0,-.5>}
  
  cylinder{<0,0,0><0,5,0> .1}
  sphere{<0,5,0> .15}
 texture{Bright_Bronze}
}
        
#declare T2a=union{ 
  cone{<0,0,0> 4.25 <0,-5,0> .5}          
  difference{
    cone{<0,0,0>5<0,12,0> 4.5}  
    
    cylinder{<0,8,0><0,10,0> 4}
    #declare R1=0;
    #while (R1<180)
      cylinder{<0,9.5,-5.1><0,9.5,5.1>.35 rotate<0,R1,0>}
      box{<-.35,8,-5.1><.35,9.5,5.1> rotate<0,R1,0>}
      #declare R1=R1+30;
    #end
  } 
  
  cylinder{<0,10.5,0><0,10.75,0> 4.7}
  cylinder{<0,10.75,0><0,10.85,0> 4.8}
  cylinder{<0,10.85,0><0,11,0> 4.7}

  cylinder{<0,11.5,0><0,10.75,0> 4.7}
  cylinder{<0,11.75,0><0,12,0> 4.8}
  
  union{
   cone{<0,12,0>4.8 <0,19,0> 0 }
   cone{<0,12,0>3.5   <0,25,0> 0 }
   #declare R1=0;
   #while (R1<=180)
     triangle{<0,12,-4.87><0,12,4.87><0,19.07,0> rotate<0,R1,0>}
     triangle{<0,12,-3.57><0,12,3.57><0,25.07,0> rotate<0,R1,0>}    
     #declare R1=R1+22.5;
   #end 
   
   object{TowerFpole translate<0,24.5,0>}
    
   texture{Bright_Bronze}
  }
  #declare R1=0;
  #while (R1<360)
     object{CapDorm translate<2.5,14,0> rotate<0,R1,0>}
     #declare R1=R1+45;
  #end

  object{T1b translate<0,2,0>}
}

#declare T2b=union{
  cone{<0,-12,0>6 <0,20,0>4.5}
  object{T1a translate<0,19,0>}
  object{Cap translate<0,20,4.5> rotate<0,180,0> }
}

#declare T2c=union{
  cone{<0,-12,0>6 <0,20,0>4.5}
  object{T1b translate<0,19.5,0>}
  
  cylinder{<0,20,0> <0,30,0> 4}
  object{T1a translate<0,28,0>}
  
  object{Cap translate<0,29,4.5> rotate<0,0,0> }
}

#declare T3=union{
  cylinder{<0,-12,0> <0,20,0> 5}
  cone{<0,0,0>6 <0,10,0> 5.2 texture{T_GrayBrick scale .075}}      
  
  
  object{T2a translate<0,20,0>}
}

#declare TB1=union{
  
  cone{<0,-30,0>12 <0,10,0>  10}
  
  difference{
    cylinder{<0,10,0><0,12,0>10}
    cylinder{<0,10,0><0,12.1,0> 9}
  }
  object{T3}
  object{T2a translate<10,0,0> rotate<0,45,0>}
  object{T2a translate<10,0,0> rotate<0,-45,0>}
  object{T2a translate<10,0,0> rotate<0,90+45,0>}
  object{T2a translate<10,0,0> rotate<0,-90-45,0>}
}
#declare T2bb=union{
  object{T2b}
  cone{<0,0,0> 5 <0,-10,0> .5}
}        

#declare TB2=union{
  
  cone{<0,-30,0>12 <0,10,0>  15}
  
  difference{
    cylinder{<0,10,0><0,12,0>15}
    cylinder{<0,10,0><0,12.1,0> 14}
  }
 
  object{T2bb translate<15,0,0> rotate<0,45,0>}
  object{T2bb translate<15,0,0> rotate<0,-45,0>}
  object{T2bb translate<15,0,0> rotate<0,90+45,0>}
  object{T2bb translate<15,0,0> rotate<0,-90-45,0>}
}
#declare TB3=union{
  object{TB2}
  object{TB1 translate<0,30,0>}
}
#end //ifndef(NoCastle)       

//------------------------------------------  
#declare BW=4;
#declare BArch=difference{
  cylinder{<-BW-.05,0,0><BW+.05,0,0> 2.25}
  cylinder{<-BW-.06,0,0><BW+.06,0,0> 1.98}
  #declare R1=0;
  #while (R1<=180)
    box{<-BW-.06,-2.26,-.01><BW+.06,2.26,.01> rotate<R1,0,0>}
    #declare R1=R1+5;
  #end
  box{<-BW-.06,-2.26,-2.26><BW+.06,0,2.26>} // carve off bottom  
  translate<0,-2.5,0>  // move into proper position
  texture{T_Stone8}
}
//--------------- Bridge Gargoyle Spouts -------
#declare GarEye=difference{
  sphere{<0,0,0> .05}
  cylinder{<-.1,0,0><0,0,0> .02}
}
#declare GarMoutha=union{
  intersection{
    sphere{<0,0,0>.1}
    box{<-.11,-.11,-.11><.11,0,.11>}
   scale<2,.75,1>
  }
  union{  
    #declare R1=180;
    #while (R1<=360)
       cone{<0,0,0> .0075 <0,.025,.0005> .0005 scale <.5,1,1> translate<0,0,.09> rotate<0,R1,0>}
       #declare R1=R1+7;
    #end
   scale <2,1,1>      
  }
}
#declare GarMouth=union{
   object{GarMoutha}
   object{GarMoutha rotate<180,0,0> rotate<0,0,-15> translate<0,.01,0>}
   rotate<0,0,20>
}
#declare GarPipe=difference{
  cylinder{<-.38,0,0><0,0,0> .03}
  cylinder{<-.39,0,0><0,0,0> .025}
  texture{Rusty_Aluminum}
  rotate<0,0,16>
}    

#declare Gar=union{
   cylinder{<-.075,0,0><.075,0,0> .15 texture{T_Stone12}} // plate
   cone{<.1,0,0> .1 <-.2,-.05,0> .075}
   sphere{<-.2,-.05,0> .1}
   object{GarEye translate<-.25,.022,-.05>} // left eye
   object{GarEye translate<-.25,.022,.05>}  // right eye
   
   sphere{<-.35,-.05,0> .025} // nose
   object{GarMouth translate<-.15,-.06,0>}
   
   object{GarPipe}
   
   texture{T_Stone8 scale .1}  
}

//----------------------------------------------
#declare LLantern=union{
   difference{
      sphere{<0,0,0>.11}
      box{<-.12,-.12,-.12><.12,0,.12>}
   }
   torus{.11,.005}
   torus{.11,.005 translate<0,.012,0>}
   torus{.025,.005 rotate<0,0,90> translate<0,.1,0>}
   torus{.025,.005 rotate<0,0,90> rotate<0,10,0> translate<0,.145,0>}
   torus{.025,.005 rotate<0,0,90> rotate<0,-10,0> translate<0,.19,0>}
   torus{.025,.005 rotate<0,0,90> rotate<0,11,0> translate<0,.235,0>}   
      
   difference{
      cylinder{<0,0,0><0,.02,0> .1}
      cylinder{<0,-.001,0><0,.03,0> .095}
     translate<0,-.1,0>
   }   
  
   difference{
      cylinder{<0,0,0><0,.02,0> .1}
      cylinder{<0,-.001,0><0,.03,0> .095}
     translate<0,-.2,0>
   }   
   
   difference{
      cylinder{<0,0,0><0,.02,0> .1}
      cylinder{<0,.001,0><0,.03,0> .095}
     translate<0,-.3,0>
   }
   
   #declare R1=0;
   #while (R1<360)
      box{<.1,-.3,-.0035><.105,0,.0035> rotate<0,R1,0>}
      #declare R1=R1+30;
   #end 
   
   #ifdef (Lighted) 
    sphere{<0,-.1,0> .025 texture{pigment{color Yellow}} finish{ambient 5.0}}   
    light_source {  <0,-.05,0> color Orange fade_power 4 fade_distance 5 }
   #end 
}

#declare LPost=union{
   torus{.2,.02 translate<0,.01,0>}
   cylinder{<0,0,0><0,.04,0> .2}
   cylinder{<0,.04,0><0,.06,0> .18}
   torus{ .1,.02 translate<0,.07,0>}
   cone{<0,0,0> .075 <0,2,0> .06}
   
   cylinder{<0,2,0><0,2.04,0> .075}
   cylinder{<0,2.04,0><0,2.08,0> .11} 
   sphere{<0,2.08,0> .08}
   difference{
     torus{.5,.035 rotate<90,0,0>}
     box{<0,-.55,-.051><.55,.25,.051>}
    translate<0,2.58,0>
   }
   sphere{<0,0,0> .075 translate<.40,2.58+.25,0>}
   
   torus{.02,.02 rotate<0,0,90> translate<.40,2.58+.25-.05-.02,0>}
   
   object{LLantern translate<.4,2.58+.25-.05-.02-.2,0>}
  texture{Rusty_Aluminum rotate<45,45,0>}
  normal{granite .5 scale<1,1,1> turbulence .75} 
}
 
#declare Grate=union{
  box{<-.125,0,-.25><.125,.02,-.23>}
  box{<-.125,0,.23><.125,.02,.25>}
  box{<-.125,0,-.25><-.105,.02,.25>}
  box{<.105,0,-.25><.125,.02,.25>}
  #declare R1=-.20;
  #while (R1<=.20)
    cylinder{<-.125,.01,R1><.125,.01,R1> .003}
    #declare R1=R1+.05;
  #end
 texture{Rusty_Aluminum scale .5}
 //texture{pigment{color Red}}
}
  
#declare Bridge=union{
   difference{
     box{<-BW,-14,-3><BW,1,3>}
     cylinder{<-BW-.01,-2.5,0><BW+.01,-2.5,0> 2}
     box{<-BW-.01,-14,-2><BW+.51,-2.5,2>}
     box{<-BW+.5,.14,-4.1><BW-.5,1.6,4.1>}  // road deck
   }
   
  object{Grate translate<-BW+.875,.16,-1.5>}
  object{Grate translate<-BW+.875,.16,+1.5>}
  object{Grate translate<-BW+.875,.16,0>}
  object{Grate translate<BW-.875,.16,0>}          
  object{Grate translate<BW-.875,.16,-1.5>}          
  object{Grate translate<BW-.875,.16,+1.5>}             

  object{LPost translate<-BW+.25,1,-2>}
  object{LPost rotate<0,180,0> translate<BW-.25,1,-2>}  
 
  object{BArch}  
  object{Gar translate<-BW,-.2,-2>}
  object{Gar translate<-BW,-.2,2>}  
 // object{Gar rotate<0,180,0> translate<BW,-.2,-2>} // opposite side of bridge
 // object{Gar rotate<0,180,0> translate<BW,-.2,2>}  
   
  box{<-BW+1,.2,-3><BW-1,.21,3> texture{checker texture{T_Stone10},texture{T_Stone8}}
     }
  box{<-BW+.5,.2,-3><-BW+.75,.21,3> texture{checker texture{T_Stone10},texture{T_Stone8}}
     }
  box{<BW-.75,.2,-3><BW-.5,.21,3> texture{checker texture{T_Stone10},texture{T_Stone8}}
     }
             
  box{<-BW+.55,1,-3><-BW-.05,1.05,3> texture{T_Stone8}}
  box{<BW+.05,1,-3><BW-.55,1.05,3> texture{T_Stone8}} 

  union{   
    box{<-BW-.1,-14,-3><BW+.1,-5,-1.9> } // base of supports
    box{<-BW-.1,-14,1.9><BW+.1,-5,3> }
   texture{T_RedBrick scale .12}
   normal{granite .5 scale<1,1,1> turbulence .75} 
  }             
}
#declare Bridge_Ext=union{
  #declare R1=0;
  #while (R1>-120)
    object{Bridge translate<0,0,R1>}
    union{    
      box{<-BW-.1,-14,-3><BW+.1,-10,-1.95> } // base of supports
      box{<-BW-.1,-14,1.95><BW+.1,-10,3> }
      translate<0,0,R1>
      texture{T_MixBrick scale .12}
    }             
    #declare R1=R1-6;
  #end 

}

//--------------------------------------------

#declare Entrance=union{
  difference{
    box{<-4,0,-2><4,10,2>}
    cylinder{<0,5,-2.1><0,5,2.1>2}
    box{<-2,-.1,-2.1><2,5,2.1>}
  } // difference
  difference{
    box{<-4.2,10,-2.2><4.2,12,2.2>}
    #declare F1=-3;
    #while (F1<=3)
      box{<F1-.25,11,-2.21><F1+.25,12.1,2.21>}
      #if ((F1>=-1) & (F1<=1))
        box{<-4.21,11,F1-.25><4.21,12.1,F1+.25>}
      #end //if
      #declare F1=F1+1;
    #end
  } // difference 

   union{
     triangle{<-4,11.5,-2><4,11.5,-2><3,15,0>}
     triangle{<-4,11.5,-2><-3,15,0><3,15,0>}  
     triangle{<-4,11.5,2><4,11.5,2><3,15,0>}
     triangle{<-4,11.5,2><-3,15,0><3,15,0>}  
    texture{RoofText104}
   }
  
   union{
     triangle{<-4,11.5,-2><-4,11.5,2><-3,15,0>}
     triangle{<4,11.5,-2><4,11.5,2><3,15,0>}
    texture{RoofText104}
   }
} 

#declare Stair1=union{
  #declare SR=-5.75;
  #declare SR1=-5.75;
  #while (SR<=0)
    box{<SR1,-12,-3><SR1+.5,SR,3> }
    box{<SR1-.02,SR,-3><SR1+.5,SR+.02,3> texture{T_Stone8}}
    #declare SR=SR+.25;
    #declare SR1=SR1+.5;
  #end
  texture{T_WhiteBrick scale .12}
}
#declare Chainloop=union{
  intersection{  // left side
    torus{.025,.008}
    box{<-.034,-.008,-.034><0,.008,.034>}
    translate<-.022,0,0>
  }
  intersection{ // right side
    torus{.025,.008}
    box{<0,-.008,-.034><.034,.008,.034>}
    translate<+.022,0,0>
  }
  cylinder{<-.025,0,-.025><.025,0,-.025> .008}
  cylinder{<-.025,0,.025><.025,0,.025> .008}
  scale 3
  texture{Rusty_Aluminum}
}
#declare RCS=seed(99);
#declare Chains=union{
  #declare RY=0;
  #declare RZ=0;    
  #declare RYI=4.5/7*.06*3;
  #declare RLR=1;
  #while (RZ<7)
     #declare RLR=-(rand(RCS)*45+45)*(RLR/abs(RLR));
     object{Chainloop rotate<0,90,RLR> rotate<-30,0,0> translate<0,RY,RZ>}
     #declare RY=RY+RYI;
     #declare RZ=RZ+.06*3;
  #end
}
#declare DrawBridge=union{ 
   box{<-1.5,-.5,-7><-1.3,.2,9>texture{T_Wood1 scale .5 rotate<0,0,0>}} 
   box{<1.3,-.5,-7><1.5,.2,9> texture{T_Wood1 scale .5 rotate<0,0,0>}}
   
   box{<-1.6,.1,-7><-1.8,.35,9>texture{T_Wood1 scale .5 rotate<0,0,0>}} 
   box{<1.6,.1,-7><1.8,.35,9> texture{T_Wood1 scale .5 rotate<0,0,0>}}   
   
   #declare C1=-7;
   #while (C1<=9)
     box{<-2,.2,C1><2,.3,C1+.23> texture{T_Wood1 scale .5 rotate<0,90,0>}}
     #declare C1=C1+.25;
   #end
   
   box{<-.5,.3,-7><-.73,.35,9> texture{T_Wood1 scale .5}}
   box{<-.75,.3,-7><-1.0,.35,9> texture{T_Wood1 scale .5}}

   box{<.5,.3,-7><.73,.35,9> texture{T_Wood1 scale .5}}
   box{<.75,.3,-7><1.0,.35,9> texture{T_Wood1 scale .5}} 
   
   cylinder{<-5,-.4,0><5,-.4,0> .2 texture{pigment{color Gray70}}}
   
   box{<-2.8,-1,-.35><-2.6,5,.35> texture{T_Wood1 scale .5 rotate<90,0,0>}}
   box{<2.6,-1,-.35><2.8,5,.35> texture{T_Wood1 scale .5 rotate<90,0,0>}}
   box{<-3,4.6,0><3,5.3,.4> texture{T_Wood1 scale .5 rotate<0,90,0>}} 
   
   //counterweight
   box{<-2.5,-.8,-6.7><2.5,-.3,-5.5> texture{T_Wood1 scale .5}}
   box{<-1.5,-1.1,-6.9><-1.7,-.1,-5.3> texture{T_Wood1 scale .5}}
   box{<1.5,-1.1,-6.9><1.7,-.1,-5.3> texture{T_Wood1 scale .5}}

   object{Chains rotate<0,-8.5,0> translate<-1.7,.35,-6.7>}
   object{Chains rotate<0,8.5,0> translate<1.7,.35,-6.7>}
   union{     
     object{Chains rotate<0,-8.5,0> translate<-1.7,.35,-7.3>}
     object{Chains rotate<0,8.5,0> translate<1.7,.35,-7.3>}   
    rotate<0,180,0>
   }
     
}

#declare DrArch=difference{
  union{
    cylinder{<-BW-1.05,0,0><-BW+.05,0,0> 4.25}
    cylinder{<BW-.05,0,0><BW+1.05,0,0> 4.25}
  }  
  cylinder{<-BW-1.06,0,0><BW+1.06,0,0> 3.98}
  #declare R1=0;
  #while (R1<=180)
    box{<-BW-1.06,-4.26,-.01><BW+1.06,4.26,.01> rotate<R1,0,0>}
    #declare R1=R1+5;
  #end
  box{<-BW-1.06,-4.26,-4.26><BW+1.06,0,4.26>} // carve off bottom  
  translate<0,-5.5,0>  // move into proper position
  texture{T_Stone8}
}
#declare DrawBridgeStruct=difference{
  box{<-BW-1,-12,-5><BW+1,0,5>}
  box{<-BW,-10,-5.1><BW,.1,4.5>} // center carveout for drawbridge drop
  box{<-BW-1.1,-8,-4><BW+1.1,-5.5,4>} // bottom of arch
  cylinder{<-BW-1.1,-5.5,0><BW+1.1,-5.5,0> 4} // arch
 texture{T_WhiteBrick scale .12}
 normal{granite .5 scale<1,1,1> turbulence .75} 
}
#declare DrawBridgeComplex=union{
  object{DrawBridgeStruct}
  object{DrawBridge rotate<DrawBridgeAngle,0,0> rotate<0,180,0> translate<0,0,-4>}
  object{DrArch}
  box{<-BW-1,0,5><BW+1,0.1,3> texture{checker texture{T_Stone10},texture{T_Stone8}}} 
}
  
#include "../med/crane.inc"  // add crane to dock area

#declare Entrance1=union{
  object{Entrance}   
  
  object{T2b rotate<0,160,0> translate<-8,-8,0>}
  object{T2b rotate<0,-160,0> translate<8,-8,0>}
  
  box{<-6,-12,-23><8,0,32> texture{T_WhiteBrick scale .12}}
  box{<-6,0,-23><8,.01,32> texture{checker texture{T_Stone10},texture{T_Stone8}}}
  
  box{<-17.5,-12,-29.5><-6,-5.75,0> texture{T_WhiteBrick scale .12}}
  box{<-17.5,-5.75,-29.5><-6,-5.74,0> texture{checker texture{T_Stone10},texture{T_Stone8}}}

  object{Stair1 translate<-12,0,-19>  }
  
  union{
    Crane(-45,-.25)
    scale 1.5
    rotate<0,90,0>
    translate<-12,-5.5,-25.5>
  }
  
  object{Bridge translate<0,0,-26>}
  object{Bridge translate<0,0,-32>}
  object{Bridge translate<0,0,-38>} 
  object{Bridge translate<0,0,-44>}  
  object{DrawBridgeComplex translate<0,0,-52>}
  object{DrawBridgeComplex rotate<0,180,0> translate<0,0,-78.5>}

  
//  object{Stair1 rotate<0,90,0> translate<-8,0,-20>}
  
 //texture{T_Lumpy} 
}
#declare Entrance2=union{
  object{Entrance}   
  
  object{T2c rotate<0,160,0> translate<-8,0,0>}
  object{T2c rotate<0,-160,0> translate<8,0,0>}
 //texture{BrickText105} 
}
      

#declare GreatHall=union{
   box{<-10,-5,-14><10,15,10>}
   difference{
     box{<-10.2,15,-14.2><10.2,17,10.2>}
     #declare F1=-9;
     #while (F1<=9)
        box{<-10.3,16,F1-.25><10.3,17.1,F1+.25>}      
        box{<F1-.25,16,-14.3><F1+.25,17.1,14.3>}        
        #declare F1=F1+1;
     #end 
   } // difference
   
   union{
     triangle{<-10,17,-14><-10,17,10><0,23,-12>}
     triangle{<-10,17,10><0,23,8><0,23,-8>}  
     triangle{<10,17,-14><10,17,10><0,23,-12>}
     triangle{<10,17,10><0,23,8><0,23,-12>}     
    texture{RoofText104 rotate<0,90,0>}
   }
   union{
     triangle{<-10,17,-14><10,17,-14><0,23,-12>}
     triangle{<-10,17,10><10,17,10><0,23,-12>}
    texture{RoofText104}
   }
}
#declare GreatHall1=union{
   object{GreatHall}
   
   object{T3 translate<-10,0,-10>}
   object{T3 translate<-10,0,10>}
   object{T3 translate<10,0,-10>}
   object{T3 translate<10,0,10>}
   
  //texture{BrickText102}
}
#declare GreatHall2=union{
   object{GreatHall}
   
   object{T2c translate<-10,0,-10>}
   object{T2c translate<-10,0,10>}
   object{T2c translate<10,0,-10>}
   object{T2c translate<10,0,10>}
   
  //texture{BrickText102}
}
#declare WindowFrame=union{
 box{<-.05,-.05,-.35><.05,1.5,-.3>}
 box{<-.05,-.05,.3><.05,1.5,.35>}  
 
 box{<-.04,-.05,-.28><.04,1.5,-.3>}
 box{<-.04,-.05,.3><.04,1.5,.28>}   
 box{<-.04,-.05,-.10><.04,1.5,-.15>}
 box{<-.04,-.05,.10><.04,1.5,.15>}
  
 box{<-.06,-.05,-.35><.06,.05,.35>}
 box{<-.05,1.45,-.35><.05,1.55,.35>}
 
 box{<-.04,1.15,-.35><.04,1.2,.35>} 
 box{<-.04,.77,-.35><.04,.82,.35>} 
 box{<-.04,.35,-.35><.04,.4,.35>} 
}
#declare Dormer=union{
   difference{
     box{<-2,-.50,-.5><2,1.5,.5>}
     box{<1.9995,0,-.35><2.0005,1.5,.35> texture{pigment{color Black}}} // window
   }                              
   object{WindowFrame translate<1.99,0,0> texture{pigment{color White}}}
   
   triangle{<2,1.5,-.5><2,1.5,.5><2,3,0>}
   
   union{
     triangle{<-2,1.5,-.5><2,1.5,-.5><-2,3,0>}
     triangle{<2,1.5,-.5><-2,3,0><2,3,0>}      
     triangle{<-2,1.5,.5><2,1.5,.5><-2,3,0>}
     triangle{<2,1.5,.5><-2,3,0><2,3,0>}     
     texture{RoofText104}
   }  
}
 
#declare Corner_Tower=union{ 
   difference{
     box{<-2,-5,-2><2,20,2> }
     box{<-2.1,18,-.25><2.1,19,.25>}
     box{<-.25,18,-2.1><.25,19,2.1>}
   }
   box{<-2.2,0,-2.2><2.2,6,2.2>}

   union{
     triangle{<-2.1,20,-2.1><-2.1,20,2.1><0,24,0>}   
     triangle{<2.1,20,-2.1><2.1,20,2.1><0,24,0>}
    texture{RoofText104 rotate<0,90,0>}
   }
   union{
     triangle{<-2.1,20,-2.1><2.1,20,-2.1><0,24,0>}
     triangle{<-2.1,20,2.1><2.1,20,2.1><0,24,0>}         
    texture{RoofText104}
   }
   
}  

#declare A_Wall=union{
   box{<-5.3,-5,-25><5.3,5,25> texture{BrickText102}}
   box{<-5.2,5,-25><5.2,10,25>}
   difference{
     box{<-5.6,10,-25><5.6,12,25>}
     #declare F1=-24;
     #while (F1<=24)
        box{<-5.71,11,F1-.25><5.71,12.1,F1+.25>}
        #declare F1=F1+1;
     #end
   } // difference
   
   union{
     triangle{<-5.5,12,-25.1><-5.5,12,25.1><0,20,-21>}
     triangle{<-5.5,12,25.1><0,20,21><0,20,-21>}            
     triangle{<5.5,12,-25.1><5.5,12,25.1><0,20,-21>}
     triangle{<5.5,12,25.1><0,20,21><0,20,-21>}     
     texture{RoofText104 rotate<0,90,0>} 
   }
   union{
     triangle{<-5.5,12,-25.1><5.5,12,-25.1><0,20,-21>}   
     triangle{<-5.5,12,25.1><5.5,12,25.1><0,20,21>}     
    texture{RoofText104}
   }

   #declare F1=-20;
   #while (F1<=20)
      object{Dormer translate<2,15.4,F1>}
      object{Dormer rotate<0,180,0> translate<-2,15.4,F1>}
      
      #declare F1=F1+5;
   #end
   
   object{Corner_Tower translate<-5,0,-5>}
   object{Corner_Tower translate<-5,0,5>}
   object{Corner_Tower translate<5,0,-5>}
   object{Corner_Tower translate<5,0,5>}
 // texture{BrickText105}
} 


//----------------------------------------------- Scaffolding
#declare WoodTower1=union{
  box{<-.75,0,-.75><-.6,4.5,-.6>}
  box{<-.75,0,.75><-.6,4.5,.6>}
  box{<.75,0,-.75><.6,4.5,-.6>}
  box{<.75,0,.75><.6,4.5,.6>}
  
  box{<-.8,2,-.8><.8,2.2,-.75>}
  box{<-.8,2,.8><.8,2.2,.75>}
  
  box{<-.8,2,-.75><-.75,2.2,.75>}
  box{<.8,2,-.75><.75,2.2,.75>}
  
  box{<-.8,4,-.8><.8,4.2,-.75>}
  box{<-.8,4,.8><.8,4.2,.75>}
  
  box{<-.8,4,-.75><-.75,4.2,.75>}
  box{<.8,4,-.75><.75,4.2,.75>}
 texture{T_Wood13}
}
#declare WoodTowerTop=union{
  box{<-1.05,4.2,-.25><.9,4.25,0> }
  box{<-.9,4.2,.05><.92,4.25,.3> rotate<0,5,0>}
  box{<-1.,4.2,.35><.9,4.25,.5> }
 texture{T_Wood13 rotate<0,90,0>}
}
#declare WoodRampa=union{
  box{<-1.65,4.25,-.25><1.7,4.3,0> rotate<0,6,0> }
  box{<-1.6,4.25,.08><1.72,4.3,.33> rotate<0,8,0>}
 texture{T_Wood13 rotate<0,90,0>}
}
  
#declare WoodRamp=union{
  object{WoodTower1}
  object{WoodTowerTop rotate<0,-7,-.2>}
                                  
  object{WoodRampa rotate<0,176,0> translate<-2,0,0>}                                  
                                  
  object{WoodTower1 translate<-4,0,0>}
  object{WoodTowerTop rotate<0,5,0> translate<-4,0,0>}

  object{WoodRampa rotate<0,-8,0> translate<2,0,0>}
  
  object{WoodTower1 translate<4,0,0>}
  object{WoodTowerTop rotate<0,6,0> translate<4,0,0> }
}
#declare Scaffolda=union{
  object{WoodRamp}
  object{WoodRamp translate<0,4.5,0>}
  object{WoodRamp translate<0,9,0>}
}
#declare Scaffold=union{
  object{Scaffolda}
  object{Scaffolda translate<-6.25,-1.25,-.25>}
  object{Scaffolda translate<6.3,0,-.2>}
}

//Dockyards/Shanties ----------------------------------------------------
                                                                         
#ifndef(NoDocks)
#declare Post_Ladder=union{
  cylinder{<-.25,4.5,0><-.25,15,0> .035}
  cylinder{<.25,4.5,0><.25,15,0> .035}
  #declare R1=4.5;
  #while (R1<=12.75)
    cylinder{<-.25,R1,0><.25,R1,0> .03 texture{T_Wood13 scale .05} }
    #declare R1=R1+.35;
  #end
  texture{T_Wood13 rotate<90,0,0> scale .05}
  translate<0,-15,0> // put top at y=0
}

#declare Pylona=union{
  cylinder{<-2.3,-6,-2.3><-2.3,0,-2.3>.18}
  cylinder{<-2.3,-6,2.3><-2.3,0,2.3> .18}
  cylinder{<2.3,-6,-2.3><2.3,0,-2.3> .18}
  cylinder{<2.3,-6,2.3><2.3,0,2.3> .18}
  cylinder{<0,-6,-2.3><0,0,-2.3> .18}
  cylinder{<0,-6,2.3><0,0,2.3> .18}
  cylinder{<-2.3,-6,.5><-2.3,0,.5> .18}
  cylinder{<2.3,-6,-.25><2.3,0,-.25> .18}  

  box{<-2.55,-3,-2.55><-2.35,-3.35,2.55>}
  box{<2.35,-3,-2.55><2.55,-3.35,2.55>}
  box{<-2.55,-2.5,2.35><2.55,-2.15,2.55>}
  box{<-2.55,-2.5,-2.55><2.55,-2.15,-2.35>}

  box{<-2.55,-.35,-2.5><-2.35,0,2.5>}
  box{<2.35,-.35,-2.5><2.55,0,2.5>}
  box{<-2.5,-.35,2.35><2.5,0,2.55>}
  box{<-2.5,-.35,-2.55><2.5,0,-2.35>}
  
  box{<-1.5,-.14,-.07><1.5,.14,.07> rotate<0,0,50> translate<-1.35,-1.2,-2.58>} // diagonal frame
  box{<-1.5,-.14,-.07><1.5,.14,.07> rotate<0,0,-50> translate<1.35,-1.2,-2.58>} // diagonal frame
  box{<-1.5,-.14,-.07><1.5,.14,.07> rotate<0,0,50> translate<1.35,-1.2,2.58>} // diagonal frame
  box{<-1.5,-.14,-.07><1.5,.14,.07> rotate<0,0,-50> translate<-1.35,-1.2,2.58>} // diagonal frame
      
  box{<-2.6,0,-2.6><2.6,.05,2.6> texture{Wood_Decking rotate<0,-45,0>}}
  
  object{Post_Ladder translate<-1,0,-2.6>}  
//  object{Post_Ladder translate<1,0,2.6>}  
//  object{Post_Ladder rotate<0,90,0> translate<2.6,0,1>}
  object{Post_Ladder rotate<0,90,0> translate<-2.6,0,-1>}    
  
  texture{T_Wood10}
}

#declare PylonII=union{  
  
    object{Pylona rotate<0,90,0> translate<2.75,0,2.5>}
    object{Pylona rotate<0,0,0> translate<-2.5,0,2.75>}   
    object{Pylona rotate<0,-90,0> translate<2.5,0,-2.5>}
    object{Pylona rotate<0,0,0> translate<-2.5,0,-2.5>}    
}

#declare PylonI=union{  
  
    object{Pylona rotate<0,90,0> translate<2.75,0,2.5>}
    object{Pylona rotate<0,0,0> translate<-2.5,0,2.75>}   
//    object{Pylona rotate<0,-90,0> translate<2.5,0,-2.5>}
//    object{Pylona rotate<0,0,0> translate<-2.5,0,-2.5>}    
}

#declare PylonIIbase=union{  
  
    object{PylonII rotate<0,90,0> translate<5,0,5>}
    object{PylonII rotate<0,0,0> translate<-5,0,5>}   
    object{PylonII rotate<0,-90,0> translate<5,0,-5>}
    object{PylonII rotate<0,0,0> translate<-5,0,-5>}    
}
#declare Chimney1=union{
  cylinder{<0,0,0><0,2,0> .15}
  sphere{<0,2,0> .15}
  cone{<0,2,0> .14 <.5,2.5,0> .14}
  sphere{<.5,2.5,0> .14}
  cylinder{<.5,2.5,0> <.75,3,0> .14}
  cone{<.75,3,0> .25 <.75,3.25,0> 0} // cap
 texture{Rusty_Aluminum}
}
#declare Chimney2=union{
  cylinder{<0,0,0><0,2,0> .15 }
  cone{<0,2,0> .15 <0,2.25,0> .1 }  
  cylinder{<0,2.25,0><.25,3,0> .1}
  cone{<.25,3,0> .2 <.25,3.35,0> 0} // cap
  texture{Rusty_Aluminum}
}
#declare Chimney3=union{
  object{Chimney2 rotate<0,0,0> translate<.15,0,0>}
  object{Chimney2 rotate<0,180,0> translate<-.15,0,0> }
}
#declare SDoor=union{
  box{<-.375,0,-.01><.375,2,.01> texture{pigment{color Gray80}}}
  box{<-.375,.25,-.025><.375,.55,.025> texture{pigment{color Gray70}}}
  box{<-.375,1.45,-.025><.375,1.75,.025> texture{pigment{color Gray70}}}
  union{
    box{<-.55,0,-.1><-.375,2,.1> }
    box{<.375,0,-.1><.55,2,.1> }
    box{<-.55,2,-.1><.55,2.175,.1> }
   texture{pigment{color Gray80}}
  }
}
#declare SDoor2=union{
  box{<-.375,0,-.01><.375,2,.01> texture{pigment{color Tan}}}
  box{<-.375,.25,-.025><.375,.55,.025> texture{pigment{color Tan2}}}
  box{<-.375,1.45,-.025><.375,1.75,.025> texture{pigment{color Tan2}}}
  union{
    box{<-.55,0,-.1><-.375,2,.1> }
    box{<.375,0,-.1><.55,2,.1> }
    box{<-.55,2,-.1><.55,2.175,.1> }
   texture{pigment{color Tan}}
  }
}
#declare SWindow=union{
  difference{
    box{<-.4,-.15,-.1><.4,1.65,.1>}
    box{<-.25,0,-.11><.25,1.5,.11>}
  }
  box{<-.25,.70,-.075><.25,.8,.075>}
  box{<-.05,0,-.075><.05,1.5,.075>}
 texture{pigment{color Gray80}}
}
#declare Shanty1=union{  
  difference{
    box{<-1.5,0,-1.5><1.5,2.5,1.5>}
    box{<.4,0,-1.6><1.15,2,-1>}
    box{<-1.45,-.1,-1.45><1.45,2.45,1.45>}
  }
  triangle{<-1.5,2.5,-1.5><-1.5,2.5,1.5><-1.5,5,0>}
  triangle{<1.5,2.5,-1.5><1.5,2.5,1.5><1.5,5,0>}
  box{<-1.49,2.4,-1.6><1.49,2.5,1.6> texture{pigment{color Gray80}}} // overhang for roof
  
  union{
    triangle{<-1.5,2.5,-1.6><-1.5,2.5,1.6><0,5,1.6>}
    triangle{<-1.5,2.5,-1.6><0,5,1.6><0,5,-1.6>}
  
    triangle{<1.5,2.5,-1.6><1.5,2.5,1.6><0,5,1.6>}
    triangle{<1.5,2.5,-1.6><0,5,1.6><0,5,-1.6>}
    rotate<0,90,0>  
   texture{RoofText104}
  }
                    
  object{SDoor translate<.775,0,-1.5>}                    
//  object{Chimney1 translate<.5,3.4,-.25>}
  
  texture{WoodSide101 rotate<0,0,0>}
}  

#declare Shanty2Roof=union{
  triangle{<-1.75,5,-1.75><-1.75,5,1.75><-1.75,8,0>}
  triangle{<1.75,5,-1.75><1.75,5,1.75><1.75,8,0>}
  
  union{
    triangle{<-1.75,5,-1.75><-1.75,5,1.75><0,8,1.75>}
    triangle{<-1.75,5,-1.75><0,8,1.75><0,8,-1.75>}
  
    triangle{<1.75,5,-1.75><1.75,5,1.75><0,8,1.75>}
    triangle{<1.75,5,-1.75><0,8,1.75><0,8,-1.75>}
    rotate<0,90,0>  
   texture{RoofText104}
  }
  box{<-1.74,4.9,-1.85><1.74,5,1.85> texture{pigment{color Gray80}}} // overhang for roof  
//  object{Chimney3 rotate<0,45,0> translate<.5,6.5,.5> }
}
#declare Shanty2=union{  
  difference{
    box{<-1.5,0,-1.5><1.5,2.5,1.5>}
    box{<.4,0,-1.6><1.15,2,-1>}
    box{<-1.45,-.1,-1.45><1.45,2.45,1.45>}
  }
  difference{             
    box{<-1.75,2.5,-1.75><1.75,5,1.75>}
    box{<-1.7,2.6,-1.7><1.7,4.9,1.7>}
    box{<.5,3,-1.8><1,4.5,1.8>}
    box{<-1,3,-1.8><-.5,4.5,1.8>}
  } 
  
  object{Shanty2Roof}
  object{SDoor translate<.775,0,-1.5>} 
  object{SWindow translate<.75,3,-1.75>}
  object{SWindow translate<-.75,3,-1.75>}
  object{SWindow translate<.75,3,1.75>}
  object{SWindow translate<-.75,3,1.75>}  
  
  texture{WoodSide101 rotate<0,0,0>}
}

#declare Shanty3=union{
  object{Shanty2}
  object{Shanty2Roof rotate<0,90,0>}  
  
  texture{WoodSide101 rotate<0,0,90>}
}  

#declare ShantyDock1=union{ 
  object{Shanty2 rotate<0,180,0> translate<-1.25,.05,1>}   
  object{Shanty3 rotate<0,0,0> translate<.75,.05,.5>} 
  object{Chimney1 rotate<0,140,0> translate<1.5,5,-.25>}
  object{Chimney3 translate<0,6,-.75>}
  
  object{Pylona}                                          
}
#declare ShantyDock2=union{
  object{Shanty2 }   
  object{Pylona rotate<0,90,0>}           
}
#declare ShantyDock3=union{ 
  object{Shanty1 rotate<0,180,0> translate<-1.25,.05,1.15>}   
  object{Shanty2 translate<.5,.05,.25>} 
  object{Chimney1 rotate<0,140,0> translate<1.5,5,-.25>}
  object{Chimney1 translate<1.5,6,-.75>}
  object{Pylona}                                          
}
#declare ShantyDock4=union{ 
  object{Shanty2 translate<-1.25,.05,1.25>}   
  object{Shanty1 translate<.5,.05,-.5>} 
  object{Chimney1 rotate<0,40,0> translate<-.5,6,.25>}
  object{Chimney3 translate<1.5,3.5,-.25>}  
  object{Pylona rotate<0,180,0>}                                          
}
#declare ShantyDock5=union{ 
  object{Shanty2 rotate<0,180,0> translate<-1.25,.05,1.25>}   
  union{  
    object{Shanty1 rotate<0,0,0> }
    box{<-1.65,-.05,-2.2><1.65,0,1.65>  texture{Wood_Decking rotate<0,45,0>}}
    box{<-1.5,-.25,-2><1.5,-.05,1.5>  texture{T_Wood10}} // base  
    object{Chimney1 rotate<0,140,0> translate<.75,3,-.75>}  
   translate<1,-1,-1.2>
  }
  object{Chimney1 rotate<0,140,0> translate<-.55,6,.35>}  
  object{Pylona rotate<0,180,0>}                                          
}
#declare ShantyDock6=union{ 
  object{Shanty2 translate<-1.25,.05,.5>}   
  object{Shanty3 rotate<0,180,0> translate<.75,.05,1>} 
  object{Chimney1 rotate<0,140,0> translate<-1.5,5,-.25>}
  object{Chimney2 translate<0,6,.25>}
  
  object{Pylona}                                          
}  
//object{Shanty3} 
//object{Pylona} 

#declare SBlock=union{

object{ShantyDock6 translate<-5,0,2.5>}
object{ShantyDock5 translate<0,0,1.5>}
object{ShantyDock4 translate<5,0,.5>}
object{ShantyDock1 translate<-5,0,-2.5>}
object{ShantyDock2 translate<0,0,-3.5>}
object{ShantyDock3 translate<5,0,-2>}

}
#declare RS=seed(9983);
#declare Docks=union{
  #declare R1=-40;
  #while (R1<=40)
    #declare RA=rand(RS)*.5-.25;
    #declare RDR=int(rand(RS)*4)+1;
    object{Pylona rotate<0,RDR*90,0> translate<R1,RA,10>}
    #declare S1=int(rand(RS)*6)+1;
    object{
           #switch(S1)
           #case (1) ShantyDock1 #break
           #case (2) ShantyDock2 #break
           #case (3) ShantyDock3 #break
           #case (4) ShantyDock4 #break
           #case (5) ShantyDock5 rotate<0,180,0> #break
           #case (6) ShantyDock6 #break
           #end // switch
          translate<R1,RA,15>
          } 
             
    #declare R1=R1+5;
  #end
  
  #declare R1=5;
  #while (R1>=-20)
    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;
    object{Pylona rotate<0,RDR*90,0> translate<40,RA,R1>}
    
    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;        
    object{Pylona rotate<0,RDR*90,0> translate<20,RA,R1>}        

    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;    
    object{Pylona rotate<0,RDR*90,0> translate<0,RA,R1>}        

    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;    
    object{Pylona rotate<0,RDR*90,0> translate<-20,RA,R1>}        

    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;    
    object{Pylona rotate<0,RDR*90,0> translate<-40,RA,R1>}        
   
   #declare R1=R1-5;
  #end // while

  #declare R1=-15;
  #while (R1>=-30)
    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;
    object{Pylona rotate<0,RDR*90,0> translate<37.5,RA-4,R1>}
    
    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;        
    object{Pylona rotate<0,RDR*90,0> translate<22.5,RA-4,R1>}        

    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;    
    object{Pylona rotate<0,RDR*90,0> translate<2.5,RA-4,R1>}        

    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;    
    object{Pylona rotate<0,RDR*90,0> translate<-22.5,RA-4,R1>}        

    #declare RA=rand(RS)*.25-.125;
    #declare RDR=int(rand(RS)*4)+1;    
    object{Pylona rotate<0,RDR*90,0> translate<-37.5,RA-4,R1>}        
   
   #declare R1=R1-5;
  #end // while
                           
  // docks under drawbridge area
  union{MakeMan (1,1,1,2,1,1,Blue,Gray30) rotate<0,90,0> translate<40,0,-13>}
  union{MakeMan (1,1,1,3,1,1,DarkGreen,DarkBrown) rotate<0,-45,0> translate<38,0,-21>}
  union{MakeMan (1,1,1,1,2,2,Gray,DarkGreen) rotate<0,-20,0> translate<41,0,-20>}  
   
  object{BoxStack translate<36,-4,-28>}
  union{MakeMan (1,1,1,1,1,1,Wheat,DarkBrown) rotate<0,20,0> translate<36,-4,-26>}
  union{MakeMan (1,1,1,2,1,1,Wheat,DarkBrown) rotate<0,45,0> translate<37,-4,-27>}
  union{MakeMan (1,1,1,3,2,1,Gray,DarkGreen) rotate<0,20,0> translate<41,-4,-26>}
  object{BoxStack translate<35,-4,-27>}  
                            
  object{Pylona rotate<0,0,0> translate<40,-4,-25>}
  object{BoxStack translate<40,-4,-26>}
  union{MakeMan (1,1,1,1,1,1,DarkBlue,DarkBrown) rotate<0,20,0> translate<41,-4,-26>} 
  union{MakeMan (1,1,1,4,1,1,Wheat,DarkBrown) rotate<0,90,0> translate<40,-4,-25.5>}  
  
  object{Pylona rotate<0,90,0> translate<45,-4,-25>}
  object{BoxStack rotate<0,90,0> translate<45,-4,-27>}
  object{BoxStack rotate<0,0,0> translate<46,-4,-26>}
  
  object{Pylona rotate<0,-90,0> translate<50,-4,-25>}
  object{Barrel rotate<0,0,0> translate<51,-3.5,-27>}
  object{Barrel rotate<0,0,0> translate<50,-3.5,-26>}   
  object{Barrel rotate<0,0,0> translate<52,-3.5,-26.5>}
  object{Barrel rotate<0,0,0> translate<49,-3.5,-25.5>}  
  object{BoxStack translate<53,-4,-26>}   
  union{MakeMan (1,1,1,3,2,1,Gray30,Gray80) rotate<0,20,0> translate<47,-4,-23.5>}
  union{MakeMan (1,1,1,3,2,1,Wheat,DarkBrown) rotate<0,20,0> translate<54,-4,-25.5>}    
    
  object{Pylona rotate<0,180,0> translate<55,-4,-25>}
  
  object{ShantyDock3 rotate<0,0,0> translate<0,-4,-32.5>}
  object{Pylona translate<2.5,-4,-35>}
  union{MakeMan (1,1,1,3,2,2,Gray40,Gray80) rotate<0,-40,0> translate<0,-4,-35>}
  union{MakeMan (1,1,1,3,2,1,Khaki,DarkBrown) rotate<0,45,0> translate<1.2,-4,-36>}
  object{Barrel rotate<0,0,0> translate<3.2,-3.5,-34>}
  object{Barrel rotate<0,0,0> translate<3,-3.5,-33>}   
  object{Barrel rotate<0,0,0> translate<3.2,-3.5,-32>}
  object{Barrel rotate<0,0,0> translate<2.9,-3.5,-31>}     
        
  object{ShantyDock1 rotate<0,180,0> translate<20,-4,-32.5>}
  object{Pylona translate<22,-4,-35>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Gray30) rotate<0,20,0> translate<23.5,-4,-36>}
  union{MakeMan (1,1,1,3,2,1,AliceBlue,DarkBrown) rotate<0,20,0> translate<20,-4,-36>}
  union{MakeMan (1,1,1,3,2,1,Gray10,Gray80) rotate<0,20,0> translate<23,-4,-36.5>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Black) rotate<0,20,0> translate<22.5,-4,-36.5>}
  
  // upper dock above green canvas boat

  union{MakeMan (1,1,1,3,2,1,Wheat,Gray30) rotate<0,20,0> translate<21.5,0,-17>}
  union{MakeMan (1,1,1,3,2,1,AliceBlue,DarkBrown) rotate<0,20,0> translate<19.5,0,-17>}
  union{MakeMan (1,1,1,3,2,1,Gray10,Gray80) rotate<0,20,0> translate<21,0,-11.5>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Black) rotate<0,20,0> translate<20.5,0,-8.5>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Gray30) rotate<0,20,0> translate<21.5,0,-9>}
  union{MakeMan (1,1,1,3,2,1,AliceBlue,DarkBrown) rotate<0,20,0> translate<18.5,0,-8>}
  union{MakeMan (1,1,1,3,2,1,Gray10,Gray80) rotate<0,20,0> translate<21,0,-17.5>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Black) rotate<0,20,0> translate<20.5,0,-15>} 
  
  object{Barrel rotate<0,0,0> translate<21.2,.5,-14>}
  object{Barrel rotate<0,0,0> translate<22,.5,-15>}   
  object{Barrel rotate<0,0,0> translate<19.2,.5,-13>}
  object{Barrel rotate<0,0,0> translate<21,.5,-12>}       

  // center dock above purple canvas boat

  union{MakeMan (1,1,1,3,2,1,Wheat,Gray30) rotate<0,20,0> translate<-1,0,-8>}
  union{MakeMan (1,1,1,3,2,1,AliceBlue,DarkBrown) rotate<0,20,0> translate<1,0,-22>}
  union{MakeMan (1,1,1,3,2,1,Gray10,Gray80) rotate<0,20,0> translate<1,0,-18.5>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Black) rotate<0,20,0> translate<1.5,0,-16>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Gray30) rotate<0,20,0> translate<-1.5,0,-14>}
  union{MakeMan (1,1,1,3,2,1,AliceBlue,DarkBrown) rotate<0,20,0> translate<1.5,0,-10>}
  union{MakeMan (1,1,1,3,2,1,Gray10,Gray80) rotate<0,20,0> translate<1,0,-12.5>}
  union{MakeMan (1,1,1,3,2,1,Wheat,Black) rotate<0,20,0> translate<-1.5,0,-20>}          
  
  object{SBlock translate<10,0,2.5>}
  object{SBlock rotate<0,180,0> translate<30,-2,2.5>}
  object{SBlock rotate<0,90,0> translate<-7.5,-2,0>}
  object{SBlock rotate<0,-90,0> translate<-7.5,-2,-15>}
  object{SBlock rotate<0,-90,0> translate<-32.5,0,0>}

  #ifndef(NoShips)       
    #include "../med/ships.inc"

    object{Ship1 rotate<0,90,0> translate<7,-3.5,-15>}
    object{Ship2 rotate<0,-90,0> translate<28.5,-3.5,-20>}
    object{Ship3 rotate<0,90,0> translate<-30,-3.5,-25>}

    object{Bark rotate<0,-90,0> translate<-46,-3,-18>}
    
    object{RowBoat1 rotate<0,15,0> translate<-42.5,-4.5,-30.5>}
    object{RowBoat2 rotate<0,-45,0> translate<-43,-4.5,-33.75>}   
    
    object{RowBoat1 rotate<0,90,0> translate<45,-4.5,-30.5>}  // boats under drawbridge
    object{RowBoat1 rotate<0,75,0> translate<47,-4.5,-30.5>}
    object{RowBoat2 rotate<0,110,0> translate<50,-4.5,-33.75>} 
    object{RowBoat1 rotate<0,5,0> translate<53,-4.5,-30.5>}      

    object{RowBoat1 rotate<0,10,0> translate<38,-4.5,-36.25>} 
    object{RowBoat1 rotate<0,45,0> translate<35,-4.5,-36.5>}           

    object{RowBoat2 rotate<0,-60,0> translate<20.5,-4.5,-41.25>} 
    object{RowBoat2 rotate<0,45,0> translate<24,-4.5,-42.5>}    
    
    object{RowBoat2 rotate<0,95,0> translate<8,-4.5,-38.5>}    
        
  #end // ifndef(NoShips)  
  
}
#end // ifndef(NoDocks)
                                                                         
//End Dockyards /Shanties -----------------------------------------------    