//************************************************
// Space line macro Ver 0.1r010321a include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//************************************************


//**********************************************************************************
// space line functions
/*
#macro Line_function(Tp,Vp,Func_type)
 #switch(Func_type)
  #case(0) #local Px=0; #local Py=5*pi*Tp; #local Pz=40*cos(Tp); #break
  #case(1) #local Px=40*sin(Tp)*0; #local Py=0; #local Pz=40*cos(Tp)*0; #break
  #case(2) #local Px=0; #local Py=0; #local Pz=3*sin(Tp); #break
  
  #case(8) #local Px=10*Tp; #local Py=6*cos(Tp); #local Pz=Tp*0; #break
  #case(9) #local Px=40*cos(Tp); #local Py=6*Tp; #local Pz=40*sin(Tp); #break
 #end
 #local Vp=< Px,Py,Pz >;
#end
*/
//----------------------------------------------------------------------------------
// cylinder space line macro
#macro Space_line(Lw,V1,Func_type)
#local Tp=V1.x; #local Te=V1.y; #local Ta=V1.z; #local Vp=<0,0,0>; //#local Tp=Ts;
 #while(Tp<Te)
 Line_function(Tp   ,Vp,Func_type) #local P1=Vp;
 Line_function(Tp+Ta,Vp,Func_type) #local P2=Vp;
 #local D1=P1+(P2-P1)/3; #local D2=P1+(P2-P1)*2/3;
 sphere { P1, Lw } cylinder { P1, D1, Lw }
 Line_function(Tp+Ta*2,Vp,Func_type) #local P3=Vp;
 #local D3=P2+(P3-P2)/3; #local D4=P2+(P3-P2)*2/3;
 #local D5=D2+(D3-D2)/3; #local D6=D2+(D3-D2)*2/3;
 sphere { D1, Lw } cylinder { D1, D5, Lw }
 sphere { D5, Lw } cylinder { D5, D6, Lw }
 sphere { D6, Lw } cylinder { D6, D4, Lw }
 sphere { D4, Lw } cylinder { D4, P3, Lw }
 #local Tp=Tp+Ta*2; #end
#end
//----------------------------------------------------------------------------------
// sample cylinder space line object
// parameter (Lw,V1,Func_type) V1=<Ts,Te,Ta>
//union { Space_line(1,pi*< -1, 1,1/32>,1) pigment { color rgb 1 } }
//----------------------------------------------------------------------------------
// cone space line macro
#macro Cone_line(Lw,V1,V2,Func_type)
#local Sp=V2.x; #local Ep=V2.y; #local Bh=V2.z;
#local Si=V1.x; #local Ei=V1.y; #local Ai=V1.z; #local Vp=<0,0,0>;
 #while(Si<Ei)
  Line_function(Si   ,Vp,Func_type) #local P1=Vp;
  Line_function(Si+Ai,Vp,Func_type) #local P2=Vp;
  cone { <P1.x,P1.y+Bh*Si,P1.z>,abs(Lw*cos(Sp+(Ep-Sp)*Si/Ei)),<P2.x,P2.y+Bh*(Si+Ai),P2.z>,abs(Lw*cos(Sp+(Ep-Sp)*(Si+Ai)/Ei)) }
  sphere { <P2.x,P2.y+Bh*(Si+Ai),P2.z>,abs(Lw*cos(Sp+(Ep-Sp)*(Si+Ai)/Ei)) }
 #local Si=Si+Ai; #end
#end
//----------------------------------------------------------------------------------
// sample cone space line object
// parameter (Lw,V1,V2,Func_type) V1=<Si,Ei,Ai> V2=<Sp,Ep,Bh>
//union { Cone_line(2,pi*< 0, 4, 1/12 >,pi*< 0, 1/2.6, 0 >,8) pigment { color rgb 1 } }
//**********************************************************************************
