// IRTC 10-2001
// WARFARE
// tofbouf@oreka.com
//#version unofficial megapov 0.6;


#declare Rad=on;
#declare RadArea=off;
#declare Area=on;

#declare Rad_count=800;
#declare Rad_error = 0.05;
#declare Rad_rec = 1;
#declare Rad_brigth = 2.0;
#declare Rad_bo = 0.05;
#declare Rad_max_sample = 5;

#declare IsoMur=off;
#declare use_imagewall=on;

#declare Child1=on;
#declare Child2=on;
#declare Prof=on;

#declare CameraTest = off;


//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 35
	adc_bailout 0.1
#if (Rad)
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_brigth

		pretrace_start  .05
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.5
		minimum_reuse 0.02
		normal on

		max_sample Rad_max_sample
		adc_bailout Rad_bo
	}
#end
}

#if (Rad)
#default { texture { finish { ambient 0.0 diffuse 1.0 brilliance .9 } } }
#else
//#default { texture { finish { ambient .2 diffuse .8 } } }
#end


//===================================
//===================================
//	DIMENSIONS
//===================================
//===================================
#declare ClXmin = -600; // classe
#declare ClXmax =  550;
#declare ClZmax = 600;
#declare CXmin = -800; // couloir
#declare CXmax =  1000;
#declare CYmin =    0;
#declare CYmax =  300;
#declare CZmax =    0;
#declare CZmin = -300;

#declare PYmin =  CYmin;
#declare PYmax =  210;
#declare PXmax =  ClXmax-30;
#declare PXmin =  PXmax-90;

#declare FYmin =  150;
#declare FYmax =  260;
#declare FXmin =  ClXmin+30;
#declare FXmax =  PXmin-50;

#declare FYmin2 =  110;
#declare FYmax2 =  280;
#declare FXmin2 =  ClXmin+20;
#declare FXmax2 =  ClXmax-20;

#declare EpMur = 2;

#include "cbwartex.inc" 


#if (Rad)
#declare LStr = .8;
#else
#declare LStr = 1.0;
#end

#declare colLight1 = <1,.98,.92>*.6;
#declare colLight2 = <1,1,.80>*1.7;


//=========================================
//	SOL EN BAS (uniquement pour radiosite)
//=========================================
box {<-10000, -300, -10000>, <10000, -300.5, 10000> pigment { rgb <1,1,.9> }}

//===================================
//	MURS CLASSE
//===================================
box {<ClXmin, CYmin, CZmax>, <ClXmin-EpMur, CYmax, ClZmax> texture {T_MurClasse #if(use_imagewall) rotate y*90 #end}}
box {<ClXmin-1, CYmin, CZmax>, <ClXmin, CYmin+5, ClZmax> texture {T_Plinthe}}

box {<ClXmax, CYmin, CZmax>, <ClXmax+EpMur, CYmax, ClZmax> texture {T_MurClasse #if(use_imagewall) rotate y*90 #end}}
box {<ClXmax-1, CYmin, CZmax>, <ClXmax, CYmin+5, ClZmax> texture {T_Plinthe}}

union {
	difference {
		box {<ClXmin-EpMur, CYmin, ClZmax>, <CXmax+2*EpMur, CYmax, ClZmax+4*EpMur>}
		box {<FXmin2, FYmin2, ClZmax-.01>, <FXmax2, FYmax2, ClZmax+4*EpMur+.01>}
	}
	box {<FXmin2, FYmin2+(FYmax2-FYmin2)*.2, ClZmax>, <FXmax2, FYmin2+(FYmax2-FYmin2)*.25, ClZmax+4*EpMur>}
	#local nbfen=6;
	#local i=1;
	#while (i<nbfen)
		box {<FXmin2+(FXmax2-FXmin2)*i/nbfen-5, FYmin2-.1, ClZmax>, <FXmin2+(FXmax2-FXmin2)*i/nbfen+5, FYmax2+.1, ClZmax+4*EpMur>}
		#local i=i+1;
	#end
	texture {T_MurClasse}
}
box { <ClXmin+1, CYmin, ClZmax-1>, <ClXmax-1, CYmin+5, ClZmax> texture {T_Plinthe}}


//===================================
//	PLAFOND
//===================================
box {<CXmin, CYmax, CZmin>, <CXmax, CYmax+20, ClZmax+4*EpMur> texture {T_Plafond}}


//===================================
//	MURS COULOIR
//===================================
#if (IsoMur)
#else
#declare MurCouloir1 = union {
	box {<CXmin, CYmin, CZmax-EpMur>, <ClXmax, CYmax, CZmax+EpMur> texture {T_MurClasse}}
	box {<CXmin, CYmin, CZmax+EpMur>, <ClXmax, CYmin+5, CZmax+EpMur+1> texture {T_Plinthe}}
}
#end

// mur entre la classe et le couloir
union {
	difference {
		object {MurCouloir1}
		box {<FXmin+6, FYmin, CZmax-EpMur-.01>, <FXmax-6, FYmax, CZmax+EpMur+.01>}
		box {<PXmin, PYmin, CZmax-EpMur-.01>, <PXmax, PYmax, CZmax+EpMur+1.01>}
	}
	#declare nbfen=5;
	#local i=1;
	#while (i<nbfen)
		box {<FXmin+(FXmax-FXmin)*i/nbfen-6, FYmin-.1, CZmax-EpMur>, <FXmin+(FXmax-FXmin)*i/nbfen+6, FYmax+.1, CZmax+EpMur>}
		#local i=i+1;
	#end
	texture {T_MurClasse}
}

// Quarts de rond sur les fenetres entre classe et couloir
#include "quartderond.inc"
#local X1 = FXmin+6;
#local LargF = ((FXmax-FXmin)/nbfen)-12;

//#local T_Test = texture {pigment{rgb x}}
#local i=0;
#while (i<nbfen)
	QuartDeRondFenetre(<X1, FYmin, CZmax-EpMur>, <X1+LargF, FYmax, CZmax+EpMur>, 4, .5, .03, T_QdR)
	#local X1=X1+LargF+12;
	#local i=i+1;
#end
// Quart de rond pour la porte
QuartDeRondFenetre(<PXmin, CYmin-5, CZmax-EpMur>, <PXmax, PYmax, CZmax+EpMur>, 5, 1, 0, T_QdR)

// vitres
box {<FXmin, FYmin, CZmax-1>, <FXmax, FYmax, CZmax+1> texture {T_Vitre}}


// mur du fond
box {<CXmax-EpMur, CYmin, CZmin>, <CXmax+EpMur, CYmax, ClZmax> texture {T_MurCouloir}}
// mur cote camera
/*
#declare FormeFenetre = union {
	box {<-1, 0, 0>,<1, 1, -1>}
	cylinder { 0, -z, 1 scale <1,.5,1> translate y }
4}

difference {
	box {<CXmin, CYmin, CZmin>, <CXmax, CYmax, CZmin-10*EpMur>}
	object {FormeFenetre scale <50, 200/1.5, 11*EpMur> translate <CXmin+300, 70, CZmin+.5*EpMur>}
	object {FormeFenetre scale <50, 200/1.5, 11*EpMur> translate <CXmin+700, 70, CZmin+.5*EpMur>}
	object {FormeFenetre scale <50, 200/1.5, 11*EpMur> translate <CXmin+1100, 70, CZmin+.5*EpMur>}
	object {FormeFenetre scale <50, 200/1.5, 11*EpMur> translate <CXmin+1500, 70, CZmin+.5*EpMur>}
	texture {T_MurCouloir}
}
*/
#include "divers.inc"
difference {
	box {<CXmin, CYmin, CZmin>, <CXmax, CYmax, CZmin-10*EpMur>}
	object {FormeFenetre translate <CXmin+300, 70, CZmin+.5*EpMur>}
	object {FormeFenetre translate <CXmin+700, 70, CZmin+.5*EpMur>}
	object {FormeFenetre translate <CXmin+1100, 70, CZmin+.5*EpMur>}
	object {FormeFenetre translate <CXmin+1500, 70, CZmin+.5*EpMur>}
	texture {T_MurCouloir}
}
object{FenetreExt translate <CXmin+300, 70, CZmin-6*EpMur>}
object{FenetreExt translate <CXmin+700, 70, CZmin-6*EpMur>}
object{FenetreExt translate <CXmin+1100, 70, CZmin-6*EpMur>}
object{FenetreExt translate <CXmin+1500, 70, CZmin-6*EpMur>}

// mur 
box {<CXmin, CYmin, CZmin>, <CXmin-4*EpMur, CYmax, CZmax> texture {T_MurCouloir}}

//===================================
//	DOOR, SWITCH, CLOCK, NEONS
//===================================
object {Porte}
object {Interrupteur translate <PXmin-9, PYmax*.5, CZmax+EpMur>}
object {Horloge scale 1.2 rotate y*90 rotate x*1 rotate z*2 translate <ClXmax-.5, CYmax-35, CZmax+(ClZmax-CZmax)*.5+20>}
object {Neon translate <ClXmax-400, CYmax, CZmax+(ClZmax-CZmax)*.3>}
object {Neon translate <ClXmax-400, CYmax, CZmax+(ClZmax-CZmax)*.7>}

//===================================
//	SOL COULOIR + CLASSE
//===================================
// couloir
box {<CXmin, CYmin, CZmin>, <CXmax, CYmin-1, CZmax>
	texture { T_SolCouloir }
}
// classe
box {<ClXmin, CYmin-.05, CZmax>, <ClXmax, CYmin-1, ClZmax>
	texture { pigment { rgb .2 } }
}

#local St=seed(1342);
#declare lCX = (ClXmax-1-ClXmin-1)/50;
#declare lCZ = (ClZmax-1-CZmax-1-EpMur)/25;
#declare epC = .5;
#declare Carreau = box {<0,0,0>, <lCX, -1, lCZ> scale <(lCX-epC)/lCX, 1, (lCZ-epC)/lCZ> translate <epC/2,CYmin,epC/2> }
#local i=ClXmin+1;
#while (i<ClXmax-1)
	#local j=CZmax+1+EpMur;
	#while (j<ClZmax-1)
		object {
			Carreau
			translate <-1+2*rand(St), rand(St), -1+2*rand(St)>*<epC*.3, -.03, epC*.3>
			translate <i, 0, j>
			texture {T_Carreau}
		}
		#local j=j+lCZ;
	#end
	#local i=i+lCX;
#end

//===================================
//	ESTRADE
//===================================
#include "estrade.inc"
object { Estrade rotate y*90 translate <ClXmax-Elarg-.4, CYmin, ClZmax-60> }

//===================================
//	TABLEAU NOIR
//===================================
object { Tableau translate <0, 100, CZmax+(ClZmax-CZmax)*.6>}
object {Neon rotate y*90 translate <ClXmax-150, CYmax, CZmax+(ClZmax-CZmax)*.6>}

//===================================
//	TABLES, CHAISES
//===================================
#include "bordel.inc"
#include "boulettes.inc"

#declare RB=5;
#declare Boulette = object {
	BoulettePapier(RB, <-1,3,2>, 29.7/4, 21/4, 50, int(50*21/29.7), 2, on)
	uv_mapping
	texture {T_Quadrillage}
}

#declare St=seed(1342);
#local i=0;
#while (i<10)
	object {Boulette rotate <180*rand(St), 360*rand(St),0>
		translate <ClXmax-270,CYmin+RB*.85,CZmax+300>
		translate <(2*rand(St)-1)*100, 0, (2*rand(St)-1)*200>
	}
	#local i=i+1;
#end
#local i=0;
#while (i<10)
	object {Boulette rotate <180*rand(St), 360*rand(St),0>
		translate <ClXmin+650,CYmin+RB*.85,CZmax+350>
		translate <(2*rand(St)-1)*150, 0, (2*rand(St)-1)*200>
	}
	#local i=i+1;
#end
#local i=0;
#while (i<10)
	object {Boulette rotate <180*rand(St), 360*rand(St),0>
		translate <ClXmin+450,CYmin+RB*.85,CZmax+350>
		translate <(2*rand(St)-1)*150, 0, (2*rand(St)-1)*200>
	}
	#local i=i+1;
#end


//===================================
//	ENFANTS
//===================================
#if (Child2)
#include "Enfant2.inc"
object {Enfant2
	rotate y*130
	translate <ClXmax-120, CYmin+Ehaut+yBureau*100, CZmax+328>
}
#end

#if (Child1)
#include "Enfant1.inc"
object {Enfant1
	rotate -y*80
	translate <ClXmin+250, CYmin, CZmax+220>
}
#end

//===================================
//	PROF
//===================================
#if (Prof)
#include "Prof.inc"
object {Prof
	rotate -y*110
	translate <ClXmax-450, CYmin, CZmax-50>
}
#end


//===================================
//===================================
//	CAMERA, LIGHTS
//===================================
//===================================

#if (CameraTest)
camera {
	orthographic
	location 0
	direction z
	right (ClXmax-ClXmin)*x
	up (ClZmax-CZmax)*y
	rotate x*90
	translate <(ClXmin+ClXmax)/2, CYmax-5, (CZmax+ClZmax)/2>
}
#else
camera {
	location <ClXmin+.01, 100, ClZmax-.01>
	right 2.5*x
	up y
	angle 60
	look_at <375, 100, CZmax>
}
#end

#include "ciel.inc"
sky_sphere{
	pigment {
		pigment_pattern {gradient z scale 2 translate -z color_map {[0 rgb 0][1 rgb 1]}}
		pigment_map {
			[.5 P_Ciel]
			[.5 Sky2_2]
		}
	}
}

#if ((Rad=off) & (RadArea=off))
light_source {
	<ClXmin+200, CYmax-10, ClZmax/2>, rgb colLight1*LStr
	fade_distance ClXmax/2
}

light_source {
	<ClXmax-200, CYmax-10, ClZmax/2>, rgb colLight1*LStr
	fade_distance ClXmax/2
}
#end

light_source {
	y*100000, color rgb colLight2*LStr
#if (Area)
	area_light 2000*x, 2000*z, 4,4
	circular orient
	jitter adaptive 1
#end
	rotate x*65
	rotate -y*20
}

#if (RadArea)
light_source { // simul radiance
	<ClXmin+(ClXmax-ClXmin)/2,FYmin2+150/2,ClZmax+20> color rgb <.90, .95, 1>*0.6*LStr
	area_light (ClXmax-ClXmin)*x, 150*y, 6, 6
	jitter adaptive 1
	
}
#end

