//#version unofficial megapov 0.6;

#declare colMur1 = <1, .99, .92>*1.2;
#declare colMur2 = colMur1*.93;
#declare colMur3 = colMur1*.96;
#declare colMur4 = colMur1*.98;

#declare colMur5 = <.95, .99, 1>;

#declare colSol1 = <.95, .95, .97>;
#declare colSol2 = <.92, .88, 1>;
#declare colSol3 = <1, .95, .85>;
#declare colSol4 = <.88, 1, .92>;

#declare EpWr = 0.1;

#if (use_imagewall)

//==============================
// WALL TEXTURE USING IMAGE MAP
//==============================

#declare P_MurClasseBase = pigment{image_map{jpeg "images/concretetile"} translate -.5*x-.5*y scale 60}
#declare P_MurClasseSeamlessX = pigment{
	pigment_pattern{gradient x scale 60}
	pigment_map{[.4 P_MurClasseBase][.6 P_MurClasseBase translate 60*x]}
	warp{repeat x*60}
}
#declare P_MurClasseSeamlessXY = pigment{
	pigment_pattern{gradient y scale 60}
	pigment_map{[.4 P_MurClasseSeamlessX][.6 P_MurClasseSeamlessX translate 60*y]}
	warp{repeat y*60}
}
#declare P_MurClasse = pigment {
	pigment_pattern{wrinkles scale 50 color_map{[0 rgb 0][1 rgb 1]}}
	pigment_map {
		[0.00 P_MurClasseSeamlessXY]
		[0.33 P_MurClasseSeamlessXY scale <-1,1,1> translate 30*x+10*y]
		[0.66 P_MurClasseSeamlessXY scale <1,-1,1> translate 10*x+30*y]
		[1.00 P_MurClasseSeamlessXY scale <-1,-1,1> translate 30*x+40*y]
	}
}

#declare N_MurClasseBase = pigment{image_map{jpeg "images/concretebump"} scale 60}
#declare N_MurClasseSeamlessX = pigment{
	pigment_pattern{gradient x scale 60}
	pigment_map{[.4 N_MurClasseBase][.6 N_MurClasseBase translate 60*x]}
}
#declare N_MurClasseSeamlessXY = pigment{
	pigment_pattern{gradient y scale 60}
	pigment_map{[.4 N_MurClasseSeamlessX][.6 N_MurClasseSeamlessX translate 60*y]}
	warp{repeat x*60}warp{repeat y*60}
}
#declare N_MurClasse = pigment {
	pigment_pattern{wrinkles scale 50 color_map{[0 rgb 0][1 rgb 1]}}
	pigment_map {
		[0.00 N_MurClasseSeamlessXY]
		[0.33 N_MurClasseSeamlessXY scale <-1,1,1>]
		[0.66 N_MurClasseSeamlessXY scale <1,-1,1>]
		[1.00 N_MurClasseSeamlessXY scale <-1,-1,1>]
	}
}
#declare T_MurClasse = texture {
	pigment {P_MurClasse}
	normal{pigment_pattern{N_MurClasse}}
	finish { phong .3 phong_size 5 diffuse 1.7}
}

#else

//==============================
// PROCEDURAL WALL TEXTURE
//==============================
#declare T_MurClasse = texture {
	pigment { rgb colMur1 }
	normal { wrinkles scale 3 slope_map {[0.4 <0,0>][0.4 <0,EpWr>][1.0 <EpWr,0>]} }
	finish { phong .3 phong_size 5 specular .2 roughness .02 }
}
texture {
	pigment {
		pigment_pattern { wrinkles scale 100 color_map{[0 rgb 0][1 rgb 1]}}
		pigment_map {
			[0.2 rgbf 1]
			[0.6 wrinkles scale 20 color_map {[0.2 rgbf 1][1 rgb colMur2*.8 transmit .9]}]
		}
	}
}
/*
texture {
	pigment {
		pigment_pattern { wrinkles scale 60 color_map{[0 rgb 0][1 rgb 1]}}
		pigment_map {
			[0.2 rgbf 1]
			[.6 wrinkles scale 15 color_map {[0 rgbf 1][.9 rgb colMur3*.9 transmit .8]}]
		}
	}
}
texture {
	pigment {
		pigment_pattern { wrinkles scale 60 color_map{[0 rgb 0][1 rgb 1]}}
		pigment_map {
			[.2 rgbf 1]
			[.6 wrinkles scale 2 color_map {[.5 rgbf 1][.7 rgb colMur4 filter .5]}]
		}
	}
}
*/
#end

//==============================
// PLINTH TEXTURE
//==============================
#declare T_Plinthe = texture {
	pigment { rgb colMur1*1.1 }
	normal { wrinkles scale <10, .2, 10> slope_map {[0.7 <1,0>][0.7 <1,-3>][1.0 <0,-3>]} }
}

#declare T_QdR = texture {
	pigment { rgb <colMur1.x*.85, colMur1.y*.80, colMur1.z*.70> }
	normal { dents .2 scale .5 poly_wave .5 }
	finish { phong .4 phong_size 10 specular .3 roughness .02 }
}



//==============================
// DOOR TEXTURE
//==============================
#declare T_Porte = texture {
	pigment { rgb <colMur1.x*.85, colMur1.y*.80, colMur1.z*.70> }
	normal { granite .05 }
	finish { brilliance .7 }
}

#declare T_PoigneePorte = texture {
	pigment { rgb .7 }
	normal { dents .2 scale .5 }
	finish { brilliance 1.1 }
}


#declare T_Interrupteur = texture {
	pigment { rgb <colMur1.x*.85, colMur1.y*.80, colMur1.z*.80> }
	finish { brilliance .7 reflection .1}
}

#declare T_Chrome = texture {
	pigment { rgb .6 }
	finish { specular .7 roughness .01 reflection .6 brilliance 5 }
}

//==============================
// GLASS TEXTURE
//==============================
#declare T_Vitre = texture {
	pigment { rgbf 1 }
	finish { ambient 0 diffuse 0 reflection {0, .15} }
}


#declare T_Plafond = texture {pigment{rgb 1.3}normal {granite .1 scale 3}}

#declare T_IsoMurCouloir = texture {
	pigment { rgb colMur1 }
	finish { phong .3 phong_size 5 specular .2 roughness .02 }
}
texture {
	pigment {
		wrinkles
		scale 50
		color_map { [.25 rgbf 1][1 rgbf <colMur1.x*.8, colMur1.y*.7, colMur1.z*.6, .6>] }
	}
}


//==============================
// OTHER WALL TEXTURE
//==============================
#declare T_MurCouloir = texture {
	pigment { rgb colMur5 }
	normal {wrinkles  scale 10 slope_map {[0.4 <0,0>][0.4 <0,EpWr>][1.0 <EpWr,0>]}}
	finish { phong .3 phong_size 5 specular .2 roughness .02 }
}
texture {
	pigment {
		pigment_pattern { wrinkles scale 80 color_map{[0 rgb 0][1 rgb 1]}}
		pigment_map {
			[.2 rgbf 1]
			[.6 wrinkles scale 30 color_map {[0 rgbf 1][1 rgb colMur3*.8 transmit .9]}]
		}
	}
}


#declare T_SolCouloir = texture {
	pigment { bozo scale 30 color_map{[0 rgb colSol1][0.5 rgb colSol1*.95][1 rgb colSol1*1.05]}}
	normal {wrinkles .1 scale .5}
	finish {phong .4 phong_size 10}
}
texture {
	pigment { bozo scale .3 warp { turbulence .9 } scale 25/.3 color_map{[0.7 rgbf 1][0.8 rgb colSol2]}}
}
texture {
	pigment { bozo scale .2 warp { turbulence .8 } scale 28/.2 color_map{[0.7 rgbf 1][0.8 rgb colSol3]}}
}
texture {
	pigment { bozo scale .1 warp { turbulence .7 } scale 26/.1 color_map{[0.7 rgbf 1][0.8 rgb colSol4]}}
}


#macro T_Craie(Eps)
pigment{granite scale (.2+Eps) turbulence 1 color_map{[.4+Eps rgbf 1][.5+Eps rgbf<1,1,1,.1>]}}
#end
/*
#local Temp1=T_Craie(0)
#local Temp2=T_Craie(.06)
#local Temp3=T_Craie(.03)
#local Temp4=T_Craie(.02)
#declare T_TableauNoir = texture {
	pigment {
		wrinkles
		turbulence .5 octaves 2
		color_map{[0 rgb <.3, 1, .6>*.30][1 rgb <.3, 1, .6>*.35]}
	}
	finish { phong .1 phong_size 5 }
}
texture {pigment{Temp1}}
texture {pigment{Temp2}}
texture {pigment{Temp3}}
texture {pigment{Temp4}}
*/


#declare T_TableauNoir = texture {
	pigment{image_map{png"tableau01"}translate -.5*x scale <1, 426/1794,1> rotate y*90}
	finish {diffuse 1.3 /*phong .3 phong_size 5*/}
}

#local Temp1=T_Craie(0)
#local Temp2=T_Craie(.04)
#local Temp3=T_Craie(.02)
#declare T_TableauNoir2 = texture {
	pigment { rgb <.8, .6, .2>}
}
texture {pigment{Temp1}}
texture {pigment{Temp2}}
texture {pigment{Temp3}}


#undef Temp1
#undef Temp2
#undef Temp3
//#undef Temp4


#declare T_Carreau = texture {
	pigment { rgb <colMur1.x*.9, colMur1.y*.8, colMur1.z*.65> }
	normal { granite .1 scale .1 }
	finish { specular .5 roughness .05 }
}
texture {
	pigment { wrinkles scale 10 color_map{[.3 rgbf 1][.8 rgb <colMur1.x, colMur1.y*.95, colMur1.z*.85>*.8 transmit .9]}}
}
