//#version unofficial megapov 0.6;
//========================
// DOOR
//========================
#declare Porte = union {
	box { <PXmin+1.1, CYmin+.5, CZmax-EpMur>, <PXmax-1.1, PYmax-1.1, CZmax+EpMur+.3>}
	// gonds
	sphere {<PXmax-1, CYmin+(PYmax-CYmin)*.25+5, CZmax+EpMur+.5>, .5}
	cylinder {<PXmax-1, CYmin+(PYmax-CYmin)*.25+.1, CZmax+EpMur+.5>, <PXmax-1, CYmin+(PYmax-CYmin)*.25+5, CZmax+EpMur+.5>, .5 }
	cylinder {<PXmax-1, CYmin+(PYmax-CYmin)*.25-.1, CZmax+EpMur+.5>, <PXmax-1, CYmin+(PYmax-CYmin)*.25-5, CZmax+EpMur+.5>, .5 }
	sphere {<PXmax-1, CYmin+(PYmax-CYmin)*.25-5, CZmax+EpMur+.5>, .5}
	sphere {<PXmax-1, CYmin+(PYmax-CYmin)*.75+5, CZmax+EpMur+.5>, .5}
	cylinder {<PXmax-1, CYmin+(PYmax-CYmin)*.75+.1, CZmax+EpMur+.5>, <PXmax-1, CYmin+(PYmax-CYmin)*.75+5, CZmax+EpMur+.5>, .5 }
	cylinder {<PXmax-1, CYmin+(PYmax-CYmin)*.75-.1, CZmax+EpMur+.5>, <PXmax-1, CYmin+(PYmax-CYmin)*.75-5, CZmax+EpMur+.5>, .5 }
	sphere {<PXmax-1, CYmin+(PYmax-CYmin)*.75-5, CZmax+EpMur+.5>, .5}
	// poignee
	union {
		box {<PXmin+1+3, PYmax*.5-12, CZmax+EpMur+.3>, <PXmin+1+9, PYmax*.5+7, CZmax+EpMur+.4>}
		cylinder {<PXmin+1+3, PYmax*.5-12, CZmax+EpMur+.3>, <PXmin+1+3, PYmax*.5+7, CZmax+EpMur+.3>, .1}
		cylinder {<PXmin+1+3, PYmax*.5-12, CZmax+EpMur+.3>, <PXmin+1+9, PYmax*.5-12, CZmax+EpMur+.3>, .1}
		cylinder {<PXmin+1+9, PYmax*.5-12, CZmax+EpMur+.3>, <PXmin+1+9, PYmax*.5+7, CZmax+EpMur+.3>, .1}
		cylinder {<PXmin+1+3, PYmax*.5+7, CZmax+EpMur+.3>, <PXmin+1+9, PYmax*.5+7, CZmax+EpMur+.3>, .1}
		sphere {<PXmin+1+3, PYmax*.5-12, CZmax+EpMur+.3>, .1}
		sphere {<PXmin+1+3, PYmax*.5+7, CZmax+EpMur+.3>, .1}
		sphere {<PXmin+1+9, PYmax*.5-12, CZmax+EpMur+.3>, .1}
		sphere {<PXmin+1+9, PYmax*.5+7, CZmax+EpMur+.3>, .1}
		
		cylinder {<PXmin+1+7, PYmax*.5, CZmax+EpMur+.3>, <PXmin+1+7, PYmax*.5, CZmax+EpMur+3>, 1.5}
		union {
			sphere { 0, 1.5 }
			cylinder { 0, 6*x, 1.5}
			sphere {0,1.5 scale <.5,1,1> translate 6*x}
			scale <1,1,.5> translate <PXmin+1+7, PYmax*.5, CZmax+EpMur+3>
		}
		texture {T_PoigneePorte}
	}
	texture {T_Porte}
}

//========================
// LIGHT SWITCHS
//========================
#declare Interrupteur = union {
	difference {
		box{0, <5, 5, .5>}
		box {<.5,.5,0>, <4.5,4.5,.501>}
	}
	cylinder{0, 5*x, .5}
	cylinder{0, 5*y, .5}
	cylinder{5*x+5*y, 5*x, .5}
	cylinder{5*x+5*y, 5*y, .5}
	sphere{0, .5}
	sphere{5*x, .5}
	sphere{5*y, .5}
	sphere{5*x+5*y, .5}
	box {<0.6, -1.9, 0>, <2.45, 1.9, 1> rotate x*10 translate 2.5*y}
	box {<2.55, -1.9, 0>, <4.4, 1.9, 1> rotate x*10 translate 2.5*y}
	texture {T_Interrupteur}
}

//========================
// CLOCK
//========================
#declare Horloge=union {
	// interieur
	cylinder { 0, -1*z, 15
		#local EpTrait1 = 1;
		#local EpTrait2 = .7;
		#declare O_Traits = union {
			box {<-EpTrait1/2, 10, -.5>, <EpTrait1/2, 14, -1.5>}
			box {<-EpTrait1/2, 10, -.5>, <EpTrait1/2, 14, -1.5> rotate z*90}
			box {<-EpTrait1/2, 10, -.5>, <EpTrait1/2, 14, -1.5> scale <1,-1,1>}
			box {<-EpTrait1/2, 10, -.5>, <EpTrait1/2, 14, -1.5> rotate -z*90}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate z*30}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate z*60}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate z*120}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate z*150}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate -z*30}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate -z*60}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate -z*120}
			box {<-EpTrait2/2, 11, -.5>, <EpTrait2/2, 14, -1.5> rotate -z*150}
		}
		pigment{object{O_Traits color rgb 1.3 color rgb 0}}
		finish {brilliance .8}
	}
	// verre
	difference {
		union {
			cylinder {-1*z, -1.5*z, 15}
			cylinder {-1*z, -2*z, 14.5 }
			torus { 14.5, .5 rotate x*90 translate -1.5*z }
		}
		union {
			cylinder {-1*z, -1.5*z, 15}
			cylinder {-1*z, -2*z, 14.5 }
			torus { 14.5, .5 rotate x*90 translate -1.5*z }
			scale <.97, .97, 1>
			translate (15*.03)*z
		}
		no_shadow
		texture { T_Vitre }
	}
	// exterieur
	union {
		difference {
			cylinder { 2*z, -1.2*z, 15.2}
			cylinder { -.2*z, -1.21*z, 15}
		}
		torus { 15.1, .3 rotate x*90 translate -.5*z}
		texture { T_Chrome }
	}
	// aiguilles
	union {
		cylinder { -1*z, -1.5*z, .2 }
		cylinder { -1.45*z, -1.5*z, .5 }
		box { <-.75, -1, -1.2>, <.75, 9, -1.25> rotate -z*30*(4+42/60)} // 4 heures
		box { <-.35, -2, -1.3>, <.35, 13, -1.35> rotate -z*360*(42/60)} // et 42 minutes
		pigment { rgb 0}
		finish { phong .4 phong_size 40}
	}
	translate -z
}


//========================
// TABLEAU NOIR
//========================
#declare LTab = 200;
#declare HTab = 2*LTab*426/1794;

#declare Tableau = union {
	box {<ClXmax-.1, 0, -LTab/2+.1>, <ClXmax-2, HTab, LTab/2-.1> texture {T_TableauNoir scale LTab*2}}
	box {<1.9, 0, -LTab*.99>, <0, HTab, -LTab/2-.1>
		texture {T_TableauNoir scale LTab*2}
		translate z*LTab/2
		rotate y*5
		translate -z*LTab/2
		translate (ClXmax-2)*x
	}
	box {<1.9, 0, LTab*.99>, <0, HTab, LTab/2-.1>
		texture {T_TableauNoir scale LTab*2}
		translate -z*LTab/2
		rotate -y*10
		translate z*LTab/2
		translate (ClXmax-2)*x
	}
	// gonds
	union{
		sphere {<ClXmax-2.3, 5, -LTab/2>, .5}
		cylinder {<ClXmax-2.3, .1, -LTab/2>, <ClXmax-2.3, 5, -LTab/2>, .5 }
		cylinder {<ClXmax-2.3, -.1, -LTab/2>, <ClXmax-2.3, -5, -LTab/2>, .5 }
		sphere {<ClXmax-2.3, -5, -LTab/2>, .5}
		texture {T_TableauNoir scale LTab*2}
		translate HTab*y/3
	}
	union{
		sphere {<ClXmax-2.3, 5, -LTab/2>, .5}
		cylinder {<ClXmax-2.3, .1, -LTab/2>, <ClXmax-2.3, 5, -LTab/2>, .5 }
		cylinder {<ClXmax-2.3, -.1, -LTab/2>, <ClXmax-2.3, -5, -LTab/2>, .5 }
		sphere {<ClXmax-2.3, -5, -LTab/2>, .5}
		texture {T_TableauNoir scale LTab*2}
		translate 2*HTab*y/3
	}
	union {
		sphere {<ClXmax-2.3, 5, LTab/2>, .5}
		cylinder {<ClXmax-2.3, .1, LTab/2>, <ClXmax-2.3, 5, LTab/2>, .5 }
		cylinder {<ClXmax-2.3, -.1, LTab/2>, <ClXmax-2.3, -5, LTab/2>, .5 }
		sphere {<ClXmax-2.3, -5, LTab/2>, .5}
		texture {T_TableauNoir scale LTab*2}
		translate HTab*y/3
	}
	union {
		sphere {<ClXmax-2.3, 5, LTab/2>, .5}
		cylinder {<ClXmax-2.3, .1, LTab/2>, <ClXmax-2.3, 5, LTab/2>, .5 }
		cylinder {<ClXmax-2.3, -.1, LTab/2>, <ClXmax-2.3, -5, LTab/2>, .5 }
		sphere {<ClXmax-2.3, -5, LTab/2>, .5}
		texture {T_TableauNoir scale LTab*2}
		translate 2*HTab*y/3
	}
	// rebord
	difference {
		union {
			box {<ClXmax-.1, 1, -LTab/2>, <ClXmax-5, -3, LTab/2>}
			box {<ClXmax-.1, 1, -LTab/2>, <ClXmax-4, -4, LTab/2>}
			cylinder {<ClXmax-4, -3, -LTab/2>, <ClXmax-4, -3, LTab/2>, 1}
		}
		box {<ClXmax, 1.01, -LTab/2-.1>, <ClXmax-3, 0, LTab/2+.1>}
		cylinder {<ClXmax-3, 1, -LTab/2-.1>, <ClXmax-3, 1, LTab/2+.1>, 1 }
		texture{T_TableauNoir2}
	}
}


//========================
// NEON
//========================
#declare XNeon = 180;
#declare YNeon = 10;
#declare ZNeon = 40;

#declare Neon1 = union {
	cylinder {-x*XNeon/2, -x*(XNeon/2-5), YNeon/2.5}
	cylinder { x*XNeon/2,  x*(XNeon/2-5), YNeon/2.5}
	cylinder {-x*(XNeon/2-5), x*(XNeon/2-5), YNeon/2.6 texture{pigment {rgb <1,.99,.98>}finish{brilliance .5 reflection{.1}}}}
}

#declare Neon = union {
	difference {
		box{<-XNeon/2, 0, -ZNeon/2>, <XNeon/2, YNeon, ZNeon/2>}
		box{<-XNeon/2+.5, -.1, -ZNeon/2+.5>, <XNeon/2-.5, YNeon-.5, -.25>}
		box{<-XNeon/2+.5, -.1,  ZNeon/2-.5>, <XNeon/2-.5, YNeon-.5,  .25>}
	}
	object {Neon1 translate <0, YNeon*(1-1/2.5)-.6,-ZNeon/4>}
	object {Neon1 translate <0, YNeon*(1-1/2.5)-.6, ZNeon/4>}
	texture{pigment{rgb .9}finish{brilliance 2 diffuse 1.5}}
	translate -YNeon*y
}


//========================
// FENETRE COULOIR
//========================

#declare LFenExt=50;
#declare HFenExt=200;
#declare HFenExt1=HFenExt/1.5;
#declare HFenExt2=HFenExt-HFenExt1;
#declare LargM=4;
#declare EpM=2;

#declare FormeFenetre = union {
	box {<-1, 0, 0>,<1, 1, -1>}
	cylinder { 0, -z, 1 scale <1,.5,1> translate y }
	scale <LFenExt, HFenExt/1.5, 11*EpMur>
}

#declare FenetreExt = union {
	// montant central
	box{<-LargM,0,-EpM>,<LargM,HFenExt1,EpM>}
	box{<-LargM*.7,0,-EpM*1.5>,<LargM*.7,HFenExt1,EpM*1.5>}
	box{<-LargM*.7,0,-EpM>,<LargM*.7,HFenExt,EpM>}
	// montants lateraux
	box{<LFenExt,0,-EpM>,<LFenExt-LargM,HFenExt1,EpM>}
	box{<-LFenExt,0,-EpM>,<-LFenExt+LargM,HFenExt1,EpM>}
	difference {
		box{<-LFenExt,0,-EpM><LFenExt,HFenExt2,-EpM>}
		cylinder{-EpM*1.1*z, EpM*1.1*z, 1 scale <LFenExt-LargM, HFenExt2-LargM, 1>}
		translate y*HFenExt1
	}
	// montants transversaux
	box{<-LFenExt, (1/4)*HFenExt1-LargM*.4, -EpM>,<LFenExt, (1/4)*HFenExt1+LargM*.4, EpM>}
	box{<-LFenExt, (2/4)*HFenExt1-LargM*.4, -EpM>,<LFenExt, (2/4)*HFenExt1+LargM*.4, EpM>}
	box{<-LFenExt, (3/4)*HFenExt1-LargM*.4, -EpM>,<LFenExt, (3/4)*HFenExt1+LargM*.4, EpM>}
	box{<-LFenExt, (4/4)*HFenExt1-LargM*.5, -EpM>,<LFenExt, (4/4)*HFenExt1+LargM*.5, EpM>}
	texture{pigment{rgb 1}normal{wrinkles .8}}
}

