
#macro QuartDeRondFenetre(Cmin, Cmax, Larg, R, Ept, Tex)

#if (Cmax.x < Cmin.x)
	#local temp = Cmax.x;
	#local Cmax.x = Cmin.x;
	#local Cmin.x = temp;
#end
#if (Cmax.y < Cmin.y)
	#local temp = Cmax.y;
	#local Cmax.y = Cmin.y;
	#local Cmin.y = temp;
#end
#if (Cmax.z < Cmin.z)
	#local temp = Cmax.z;
	#local Cmax.z = Cmin.z;
	#local Cmin.z = temp;
#end

// bord inferieur
difference {
	union {
		cylinder{<Cmin.x-Larg, Cmin.y-Larg+R, Cmin.z>, <Cmax.x+Larg, Cmin.y-Larg+R, Cmin.z>, R}
		cylinder{<Cmin.x-Larg, Cmin.y, Cmin.z>, <Cmax.x+Larg, Cmin.y, Cmin.z>, R}
		cylinder{<Cmin.x-Larg, Cmin.y, Cmax.z>, <Cmax.x+Larg, Cmin.y, Cmax.z>, R}
		cylinder{<Cmin.x-Larg, Cmin.y-Larg+R, Cmax.z>, <Cmax.x+Larg, Cmin.y-Larg+R, Cmax.z>, R}
		box {<Cmin.x-Larg, Cmin.y-Larg+R, Cmin.z-R>, <Cmax.x+Larg, Cmin.y, Cmin.z>}
		box {<Cmin.x-Larg, Cmin.y, Cmin.z>, <Cmax.x+Larg, Cmin.y+R, Cmax.z>}
		box {<Cmin.x-Larg, Cmin.y-Larg+R, Cmax.z+R>, <Cmax.x+Larg, Cmin.y, Cmax.z>}
	}
	box { <-Larg*2, -Larg*2, Cmin.z-R-.01>, <0,2*R, Cmax.z+R+.01>
		rotate -z*45
		translate <Cmin.x+Ept/2, Cmin.y-Ept/2, 0>
	}
	box { <-Larg*2, -Larg*2, Cmin.z-R-.01>, <0,2*R, Cmax.z+R+.01>
		scale <-1,1,1>
		rotate z*45
		translate <Cmax.x-Ept/2, Cmin.y-Ept/2, 0>
	}
	texture { Tex }
}
// bord superieur
difference {
	union {
		cylinder{<Cmin.x-Larg, Cmax.y+Larg-R, Cmin.z>, <Cmax.x+Larg, Cmax.y+Larg-R, Cmin.z>, R}
		cylinder{<Cmin.x-Larg, Cmax.y, Cmin.z>, <Cmax.x+Larg, Cmax.y, Cmin.z>, R}
		cylinder{<Cmin.x-Larg, Cmax.y, Cmax.z>, <Cmax.x+Larg, Cmax.y, Cmax.z>, R}
		cylinder{<Cmin.x-Larg, Cmax.y+Larg-R, Cmax.z>, <Cmax.x+Larg, Cmax.y+Larg-R, Cmax.z>, R}
		box {<Cmin.x-Larg, Cmax.y+Larg-R, Cmin.z-R>, <Cmax.x+Larg, Cmax.y, Cmin.z>}
		box {<Cmin.x-Larg, Cmax.y, Cmin.z>, <Cmax.x+Larg, Cmax.y-R, Cmax.z>}
		box {<Cmin.x-Larg, Cmax.y+Larg-R, Cmax.z+R>, <Cmax.x+Larg, Cmax.y, Cmax.z>}
	}
	box { <-Larg*2, Larg*2, Cmin.z-R-.01>, <0,-2*R, Cmax.z+R+.01>
		rotate z*45
		translate <Cmin.x+Ept/2, Cmax.y+Ept/2, 0>
	}
	box { <-Larg*2, Larg*2, Cmin.z-R-.01>, <0,-2*R, Cmax.z+R+.01>
		scale <-1,1,1>
		rotate -z*45
		translate <Cmax.x-Ept/2, Cmax.y+Ept/2, 0>
	}
	texture { Tex }
}
// bord gauche
difference {
	union {
		cylinder{<Cmin.x-Larg+R, Cmin.y-Larg, Cmin.z>, <Cmin.x-Larg+R, Cmax.y+Larg, Cmin.z>, R}
		cylinder{<Cmin.x, Cmin.y-Larg, Cmin.z>, <Cmin.x, Cmax.y+Larg, Cmin.z>, R}
		cylinder{<Cmin.x, Cmin.y-Larg, Cmax.z>, <Cmin.x, Cmax.y+Larg, Cmax.z>, R}
		cylinder{<Cmin.x-Larg+R, Cmin.y-Larg, Cmax.z>, <Cmin.x-Larg+R, Cmax.y+Larg, Cmax.z>, R}
		box {<Cmin.x-Larg+R, Cmin.y-Larg, Cmin.z-R>, <Cmin.x, Cmax.y+Larg, Cmin.z>}
		box {<Cmin.x, Cmin.y-Larg, Cmin.z>, <Cmin.x+R, Cmax.y+Larg, Cmax.z>}
		box {<Cmin.x-Larg+R, Cmin.y-Larg, Cmax.z+R>, <Cmin.x, Cmax.y+Larg, Cmax.z>}
	}
	box { <-Larg*2, -Larg*2, Cmin.z-R-.01>, <2*R,0, Cmax.z+R+.01>
		rotate z*45
		translate <Cmin.x-Ept/2, Cmin.y+Ept/2, 0>
	}
	box { <-Larg*2, -Larg*2, Cmin.z-R-.01>, <2*R,0, Cmax.z+R+.01>
		scale <1,-1,1>
		rotate -z*45
		translate <Cmin.x-Ept/2, Cmax.y-Ept/2, 0>
	}
	texture { Tex rotate z*90 }
}
// bord droit
difference {
	union {
		cylinder{<Cmax.x+Larg-R, Cmin.y-Larg, Cmin.z>, <Cmax.x+Larg-R, Cmax.y+Larg, Cmin.z>, R}
		cylinder{<Cmax.x, Cmin.y-Larg, Cmin.z>, <Cmax.x, Cmax.y+Larg, Cmin.z>, R}
		cylinder{<Cmax.x, Cmin.y-Larg, Cmax.z>, <Cmax.x, Cmax.y+Larg, Cmax.z>, R}
		cylinder{<Cmax.x+Larg-R, Cmin.y-Larg, Cmax.z>, <Cmax.x+Larg-R, Cmax.y+Larg, Cmax.z>, R}
		box {<Cmax.x+Larg-R, Cmin.y-Larg, Cmin.z-R>, <Cmax.x, Cmax.y+Larg, Cmin.z>}
		box {<Cmax.x-R, Cmin.y-Larg, Cmin.z>, <Cmax.x, Cmax.y+Larg, Cmax.z>}
		box {<Cmax.x+Larg-R, Cmin.y-Larg, Cmax.z+R>, <Cmax.x, Cmax.y+Larg, Cmax.z>}
	}
	box { <Larg*2, -Larg*2, Cmin.z-R-.01>, <-2*R,0, Cmax.z+R+.01>
		rotate -z*45
		translate <Cmax.x+Ept/2, Cmin.y+Ept/2, 0>
	}
	box { <Larg*2, -Larg*2, Cmin.z-R-.01>, <-2*R,0, Cmax.z+R+.01>
		scale <1,-1,1>
		rotate z*45
		translate <Cmax.x+Ept/2, Cmax.y-Ept/2, 0>
	}
	texture { Tex rotate z*90 }
}

#end
