#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "szachy.inc"

camera {
  location <20, 4.4, -10>
  look_at <12, 4.4, 24>
  focal_point <16, 4.4, 12>
  aperture 0.3
  blur_samples 50
}

light_source
  { 
    <-300, 300, -300>
    color White
    spotlight
    radius 15
    falloff 20
    tightness 10
    point_at <12, 0, 8>
   }
          
fog
  { 
    distance 30    
    color rgbf <1,1,1,1> 
    turbulence 3
    turb_depth 0.5 
    fog_type 2
    fog_offset 1
    fog_alt 1
  }

object { SzachyStart }  

sky_sphere {
  pigment {
      gradient y
      color_map {
        [0 color Black]
        [1 color Red]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 1.5
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
}


