// Knots
//


#declare r = 0.3;//0.3;          
#declare r2 = r/sqrt(2);

#declare R = 0.75//0.4;
#declare R2 = R/sqrt(2);

#declare quadrant =
intersection
{
    torus{R,r rotate 90*x} 
    box{ <0,0,-R-r> <R+r,R+r,R+r> }
}  

#declare lq =
object
{
    quadrant
    rotate 135 * z
}
 
#declare rq =
object
{
    quadrant
    rotate -45 * z
}
 
#declare bq =
object
{
    quadrant
    rotate -135 * z
}

#declare tq =
object
{
    quadrant
    rotate 45 * z
}
 
#macro EP(x1,y1,x2,y2)
object
{
  union
  {
    #if (x2 > x1 )
        #declare X2 = x2 - 2*r2; 
        #declare X1 = x1 + R2; 
   #else
        #declare X2 = x2 + 2*r2;
        #declare X1 = x1 - R2; 
    #end
    #if (y2 > y1 )
        #declare Y2 = y2 - 2*r2; 
        #declare Y1 = y1 + R2;
    #else
        #declare Y2 = y2 + 2*r2;
        #declare Y1 = y1 - R2;
    #end
     
    cylinder{ <X1,Y1,0> <X2,Y2,0> r}
    sphere{ <X2,Y2,0> r }
  }  
} 
#end

#macro EE(x1,y1,x2,y2)
object
{
    #if (x2 > x1 )
        #declare X2 = x2 - R2; 
        #declare X1 = x1 + R2; 
   #else
        #declare X2 = x2 + R2;
        #declare X1 = x1 - R2; 
    #end
    #if (y2 > y1 )
        #declare Y2 = y2 - R2; 
        #declare Y1 = y1 + R2;
    #else
        #declare Y2 = y2 + R2;
        #declare Y1 = y1 - R2;
    #end
    cylinder{ <X1,Y1,0> <X2,Y2,0> r}
} 
#end

#macro PP(x1,y1,x2,y2)
object
{
  union
  {  
    #if (x2 > x1 )
        #declare X2 = x2 - 2*r2;
        #declare X1 = x1 + 2*r2;
    #else
        #declare X2 = x2 + 2*r2;
        #declare X1 = x1 - 2*r2;
    #end
    #if (y2 > y1 )
        #declare Y2 = y2 - 2*r2;
        #declare Y1 = y1 + 2*r2;
    #else
        #declare Y2 = y2 + 2*r2;
        #declare Y1 = y1 - 2*r2;
    #end
    cylinder{ <X1,Y1,0> <X2,Y2,0> r}
    sphere { <X1,Y1,0> r }
    sphere { <X2, Y2, 0> r }
  }    
} 
#end



#declare knot =
union
{  
 
    EE(3,0,4,1)
    EE(0,9,1,10)
    EE(3,10,4,9)   
    EE(0,1,1,0)
    
    EP(3,10,1,8)   
    EP(1,10,2,9) 
    EP(3,0,2,1)
    EP(1,0,3,2)

    #declare xx = 3;
    #while (xx <= 9)
      EP(0,xx,2,xx-2)
      #declare xx = xx + 2;
    #end

    #declare xx = 8;
    #while (xx >= 4)
      PP(1,xx-2,3,xx)
      #declare xx = xx - 2;
    #end
    
    #declare xx = 7;
    #while (xx >= 1)  
      EP(4,xx,2,xx+2) 
      #declare xx = xx - 2;
    #end
    
    #declare xx = 1;
    #while ( xx <=7 )   
      EP(0,xx,1,xx+1)
      #declare xx = xx + 2;
    #end
    
    #declare xx = 9;
    #while ( xx >= 3 )
        EP(4,xx,3,xx-1)
        #declare xx = xx-2;
    #end  
    
    #declare xx = 1;
    #while ( xx <=9 )
    
      object
      {
        lq
        translate<2*R2,xx,0> 
      }                      
      
      object 
      {
        rq
        translate<4-2*R2,xx,0>
      }
      
      #declare xx = xx + 2;
    #end
    
    #declare xx = 1;
    #while (xx <= 3)
    

      object
      {
        bq
        translate<xx,2*R2,0>
      }             

      object
      {
        tq
        translate<xx,10-2*R2,0>
      }             

      #declare xx = xx + 2;
    #end      
}
                     
#declare D=0.75;                     
                     
#declare curve=
difference
{
  #declare CR = 1;
  box{<0,0,0>,<R,R,-D>}
  cylinder{<R,R,-1><R,R,+1>R}
}   
 
#declare crossknot =
union
{             
  #declare H = 5;
  #declare X = 2;  
  #declare S = .42
  #declare O = .35        
  #declare CW = .3;
  
    object
    {
      curve        
      rotate 90*z
      translate<2*X,H+CW,0>
    }
    object
    {
      curve        
      rotate 180*z
      translate<2*X,H-CW,0>
    }

    object
    {
      curve        
      translate<0,H+CW,0>
    }
    object
    {
      curve        
      rotate 270*z
      translate<0,H-CW,0>
    }

    object
    {
      curve        
      translate<X+CW,0,0>
    }
    object
    {
      curve        
      rotate 90*z
      translate<X-CW,0,0>
    }


    object
    {
      curve    
      rotate 270*z    
      translate<X+CW,2*H,0>
    }
    object
    {
      curve        
      rotate 180*z
      translate<X-CW,2*H,0>
    }           
    

  object
  {
    box
    {
      <X-CW,0,0>
      <X+CW,2*H,-D>
    }
  }
  object
  {
    box
    {
      <0,H-CW,0>
      <2*X,H+CW,-D>
    }
  }
  object
  {
    curve
    translate<X+CW,H+CW,0>
  }
  object
  {
    curve
    rotate 90*z
    translate<X-CW,H+CW,0>
  }
  object
  {
    curve
    rotate 180*z
    translate<X-CW,H-CW,0>
  }
  object
  {
    curve            
    rotate 270*z
    translate<X+CW,H-CW,0>
  }
  object
  {
    knot
    scale <S,S*1.1,S>
    translate<X+O,H+O,0>
  }
  object
  {
    knot
    scale <S,S*1.1,S>
    translate<X+O,0,0>
  }
  object
  {
    knot
    scale <S,S*1.1,S>
    translate<0,H+O,0>
  }
  object
  {
    knot
    scale <S,S*1.1,S>
    translate<0,0,0>
  }     
  
  sphere{ <X,H,-D>,.5 }
}

